/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.rest.management.internal.coerce;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.xml.stream.events.Attribute;

public class Coerce {
    private Coerce() {
    }

    public static List<String> elements(JsonNode node) {
        ArrayList<String> list = new ArrayList<String>();
        if (node.isArray()) {
            Iterator itr = node.elements();
            while (itr.hasNext()) {
                list.add(((JsonNode)itr.next()).asText());
            }
        } else if (node.isValueNode()) {
            list.add(node.asText());
        }
        return list;
    }

    public static String type(String type, String name) {
        if ("service.id".equals(name) || "service.bundleid".equals(name)) {
            return "Long";
        }
        if ("service.ranking".equals(name)) {
            return "Integer";
        }
        if ("objectClass".equals(name) || "service.pid".equals(name) || "service.scope".equals(name)) {
            return "String";
        }
        if (type == null) {
            return "String";
        }
        return type;
    }

    public static String type(JsonNode node, String name) {
        if ("service.id".equals(name) || "service.bundleid".equals(name)) {
            return "Long";
        }
        if ("service.ranking".equals(name)) {
            return "Integer";
        }
        if ("objectClass".equals(name) || "service.pid".equals(name) || "service.scope".equals(name)) {
            return "String";
        }
        if (node.isArray()) {
            if (node.isEmpty()) {
                return "String";
            }
            node = node.get(0);
        }
        if (node.isBoolean()) {
            return "Boolean";
        }
        if (node.isLong()) {
            return "Long";
        }
        if (node.isInt()) {
            return "Integer";
        }
        if (node.isNumber()) {
            String nodeValue = node.asText();
            try {
                Long.parseLong(nodeValue);
                return "Long";
            }
            catch (NumberFormatException nfe1) {
                try {
                    Double.parseDouble(nodeValue);
                    return "Double";
                }
                catch (NumberFormatException nfe2) {
                    throw new IllegalArgumentException(nfe2);
                }
            }
        }
        return "String";
    }

    public static Object from(Map.Entry<String, JsonNode> entry) {
        JsonNode valueNode = entry.getValue();
        return Coerce.from(Coerce.type(valueNode, entry.getKey()), valueNode.isArray(), Coerce.elements(valueNode));
    }

    public static Object from(Attribute keyAT, Attribute typeAT, String txt, boolean array) {
        List valueParts = Optional.ofNullable(txt).map(s -> s.trim().split("\\s*\\n\\s*")).map(Arrays::asList).orElseGet(ArrayList::new);
        return Coerce.from(Coerce.type(typeAT == null ? null : typeAT.getValue(), keyAT.getValue()), array, valueParts);
    }

    public static Object from(String type, boolean array, List<String> valueParts) {
        Objects.requireNonNull(type);
        if (array) {
            if (type.equals("Long")) {
                return valueParts.stream().map(Long::parseLong).mapToLong(Long::longValue).toArray();
            }
            if (type.equals("Double")) {
                return valueParts.stream().map(Double::parseDouble).mapToDouble(Double::doubleValue).toArray();
            }
            if (type.equals("Float")) {
                float[] floats = new float[valueParts.size()];
                for (int i = 0; i < valueParts.size(); ++i) {
                    floats[i] = Float.parseFloat(valueParts.get(i));
                }
                return floats;
            }
            if (type.equals("Integer")) {
                return valueParts.stream().map(Integer::parseInt).mapToInt(Integer::intValue).toArray();
            }
            if (type.equals("Byte")) {
                byte[] bytes = new byte[valueParts.size()];
                for (int i = 0; i < valueParts.size(); ++i) {
                    bytes[i] = Byte.parseByte(valueParts.get(i));
                }
                return bytes;
            }
            if (type.equals("Character")) {
                return valueParts.stream().map(Integer::parseInt).mapToInt(Integer::intValue).toArray();
            }
            if (type.equals("Boolean")) {
                boolean[] booleans = new boolean[valueParts.size()];
                for (int i = 0; i < valueParts.size(); ++i) {
                    booleans[i] = Boolean.parseBoolean(valueParts.get(i));
                }
                return booleans;
            }
            if (type.equals("Short")) {
                short[] shorts = new short[valueParts.size()];
                for (int i = 0; i < valueParts.size(); ++i) {
                    shorts[i] = Short.parseShort(valueParts.get(i));
                }
                return shorts;
            }
            return valueParts.stream().toArray(String[]::new);
        }
        if (valueParts.isEmpty()) {
            return null;
        }
        if (type.equals("Long")) {
            return Long.parseLong(valueParts.get(0));
        }
        if (type.equals("Double")) {
            return Double.parseDouble(valueParts.get(0));
        }
        if (type.equals("Float")) {
            return Float.valueOf(Float.parseFloat(valueParts.get(0)));
        }
        if (type.equals("Integer")) {
            return Integer.parseInt(valueParts.get(0));
        }
        if (type.equals("Byte")) {
            return Byte.parseByte(valueParts.get(0));
        }
        if (type.equals("Character")) {
            return Integer.parseInt(valueParts.get(0));
        }
        if (type.equals("Boolean")) {
            return Boolean.parseBoolean(valueParts.get(0));
        }
        if (type.equals("Short")) {
            return Short.parseShort(valueParts.get(0));
        }
        return valueParts.get(0);
    }
}

