/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.aries.subsystem.core.archive.AriesSubsystemParentsHeader;
import org.apache.aries.subsystem.core.archive.DeployedContentHeader;
import org.apache.aries.subsystem.core.archive.ExportPackageHeader;
import org.apache.aries.subsystem.core.archive.GenericHeader;
import org.apache.aries.subsystem.core.archive.Header;
import org.apache.aries.subsystem.core.archive.HeaderFactory;
import org.apache.aries.subsystem.core.archive.ImportPackageHeader;
import org.apache.aries.subsystem.core.archive.ProvideCapabilityHeader;
import org.apache.aries.subsystem.core.archive.ProvisionResourceHeader;
import org.apache.aries.subsystem.core.archive.RequireBundleHeader;
import org.apache.aries.subsystem.core.archive.RequireCapabilityHeader;
import org.apache.aries.subsystem.core.archive.SubsystemExportServiceHeader;
import org.apache.aries.subsystem.core.archive.SubsystemImportServiceHeader;
import org.apache.aries.subsystem.core.archive.SubsystemManifest;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.util.manifest.ManifestProcessor;
import org.eclipse.equinox.region.Region;
import org.osgi.resource.Resource;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.subsystem.Subsystem;

public class DeploymentManifest {
    public static final String DEPLOYED_CONTENT = "Deployed-Content";
    public static final String DEPLOYMENT_MANIFESTVERSION = "Deployment-ManifestVersion";
    public static final String EXPORT_PACKAGE = "Export-Package";
    public static final String IMPORT_PACKAGE = "Import-Package";
    public static final String PROVIDE_CAPABILITY = "Provide-Capability";
    public static final String PROVISION_RESOURCE = "Provision-Resource";
    public static final String REQUIRE_BUNDLE = "Require-Bundle";
    public static final String REQUIRE_CAPABILITY = "Require-Capability";
    public static final String SUBSYSTEM_EXPORTSERVICE = "Subsystem-ExportService";
    public static final String SUBSYSTEM_IMPORTSERVICE = "Subsystem-ImportService";
    public static final String SUBSYSTEM_SYMBOLICNAME = "Subsystem-SymbolicName";
    public static final String SUBSYSTEM_VERSION = "Subsystem-Version";
    public static final String ARIESSUBSYSTEM_AUTOSTART = "AriesSubsystem-Autostart";
    public static final String ARIESSUBSYSTEM_ID = "AriesSubsystem-Id";
    public static final String ARIESSUBSYSTEM_LASTID = "AriesSubsystem-LastId";
    public static final String ARIESSUBSYSTEM_LOCATION = "AriesSubsystem-Location";
    public static final String ARIESSUBSYSTEM_PARENTS = "AriesSubsystem-Parents";
    public static final String ARIESSUBSYSTEM_REGION = "AriesSubsystem-Region";
    public static final String ARIESSUBSYSTEM_STATE = "AriesSubsystem-State";
    private final Map<String, Header<?>> headers;

    public DeploymentManifest(Manifest manifest) {
        this.headers = new HashMap();
        for (Map.Entry<Object, Object> entry : manifest.getMainAttributes().entrySet()) {
            String key = String.valueOf(entry.getKey());
            if (key.equals(SUBSYSTEM_SYMBOLICNAME)) continue;
            this.headers.put(key, HeaderFactory.createHeader(key, String.valueOf(entry.getValue())));
        }
    }

    public DeploymentManifest(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public DeploymentManifest(InputStream in) throws IOException {
        Manifest manifest = ManifestProcessor.parseManifest((InputStream)in);
        Attributes attributes = manifest.getMainAttributes();
        HashMap headers = new HashMap(attributes.size() + 4);
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            String key = String.valueOf(entry.getKey());
            headers.put(key, HeaderFactory.createHeader(key, String.valueOf(entry.getValue())));
        }
        this.headers = Collections.unmodifiableMap(headers);
    }

    public DeploymentManifest(DeploymentManifest deploymentManifest, SubsystemManifest subsystemManifest, boolean autostart, long id, long lastId, String location, boolean overwrite, boolean acceptDependencies) throws ResolutionException, IOException, URISyntaxException {
        Map<String, Header<?>> headers = deploymentManifest == null || deploymentManifest != null && overwrite ? this.computeHeaders(subsystemManifest) : new HashMap(deploymentManifest.getHeaders());
        headers.put(ARIESSUBSYSTEM_AUTOSTART, new GenericHeader(ARIESSUBSYSTEM_AUTOSTART, Boolean.toString(autostart)));
        headers.put(ARIESSUBSYSTEM_ID, new GenericHeader(ARIESSUBSYSTEM_ID, Long.toString(id)));
        headers.put(ARIESSUBSYSTEM_LOCATION, new GenericHeader(ARIESSUBSYSTEM_LOCATION, location));
        headers.put(ARIESSUBSYSTEM_LASTID, new GenericHeader(ARIESSUBSYSTEM_LASTID, Long.toString(lastId)));
        this.headers = Collections.unmodifiableMap(headers);
    }

    private DeploymentManifest(Map<String, Header<?>> headers) {
        HashMap map = new HashMap(headers);
        this.headers = Collections.unmodifiableMap(map);
    }

    public DeployedContentHeader getDeployedContentHeader() {
        return (DeployedContentHeader)this.getHeaders().get(DEPLOYED_CONTENT);
    }

    public ExportPackageHeader getExportPackageHeader() {
        return (ExportPackageHeader)this.getHeaders().get(EXPORT_PACKAGE);
    }

    public Map<String, Header<?>> getHeaders() {
        return this.headers;
    }

    public AriesSubsystemParentsHeader getAriesSubsystemParentsHeader() {
        return (AriesSubsystemParentsHeader)this.getHeaders().get(ARIESSUBSYSTEM_PARENTS);
    }

    public ImportPackageHeader getImportPackageHeader() {
        return (ImportPackageHeader)this.getHeaders().get(IMPORT_PACKAGE);
    }

    public ProvideCapabilityHeader getProvideCapabilityHeader() {
        return (ProvideCapabilityHeader)this.getHeaders().get(PROVIDE_CAPABILITY);
    }

    public ProvisionResourceHeader getProvisionResourceHeader() {
        return (ProvisionResourceHeader)this.getHeaders().get(PROVISION_RESOURCE);
    }

    public RequireBundleHeader getRequireBundleHeader() {
        return (RequireBundleHeader)this.getHeaders().get(REQUIRE_BUNDLE);
    }

    public RequireCapabilityHeader getRequireCapabilityHeader() {
        return (RequireCapabilityHeader)this.getHeaders().get(REQUIRE_CAPABILITY);
    }

    public SubsystemExportServiceHeader getSubsystemExportServiceHeader() {
        return (SubsystemExportServiceHeader)this.getHeaders().get(SUBSYSTEM_EXPORTSERVICE);
    }

    public SubsystemImportServiceHeader getSubsystemImportServiceHeader() {
        return (SubsystemImportServiceHeader)this.getHeaders().get(SUBSYSTEM_IMPORTSERVICE);
    }

    public void write(OutputStream out) throws IOException {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        for (Map.Entry<String, Header<?>> entry : this.headers.entrySet()) {
            attributes.putValue(entry.getKey(), entry.getValue().getValue());
        }
        manifest.write(out);
    }

    private Map<String, Header<?>> computeHeaders(SubsystemManifest manifest) {
        return new HashMap(manifest.getHeaders());
    }

    public static class Builder {
        private Map<String, Header<?>> headers = new HashMap();

        public DeploymentManifest build() {
            return new DeploymentManifest(this.headers);
        }

        public Builder autostart(boolean value) {
            this.header(new GenericHeader(DeploymentManifest.ARIESSUBSYSTEM_AUTOSTART, Boolean.toString(value)));
            return this;
        }

        public Builder content(Resource resource, boolean referenced) {
            DeployedContentHeader header = (DeployedContentHeader)this.headers.get(DeploymentManifest.DEPLOYED_CONTENT);
            if (header == null) {
                DeployedContentHeader.Clause clause = new DeployedContentHeader.Clause(resource, referenced);
                this.header(new DeployedContentHeader(Collections.singleton(clause)));
                return this;
            }
            DeployedContentHeader.Clause clause = header.getClause(resource);
            if (clause == null) {
                clause = new DeployedContentHeader.Clause(resource, referenced);
                ArrayList<DeployedContentHeader.Clause> clauses = new ArrayList<DeployedContentHeader.Clause>(header.getClauses().size() + 1);
                clauses.addAll(header.getClauses());
                clauses.add(clause);
                this.header(new DeployedContentHeader(clauses));
                return this;
            }
            ArrayList<DeployedContentHeader.Clause> clauses = new ArrayList<DeployedContentHeader.Clause>(header.getClauses());
            Iterator i = clauses.iterator();
            while (i.hasNext()) {
                if (!clause.equals(i.next())) continue;
                i.remove();
                break;
            }
            clauses.add(new DeployedContentHeader.Clause(resource, referenced));
            this.header(new DeployedContentHeader(clauses));
            return this;
        }

        public Builder header(Header<?> value) {
            if (value != null) {
                this.headers.put(value.getName(), value);
            }
            return this;
        }

        public Builder id(long value) {
            this.header(new GenericHeader(DeploymentManifest.ARIESSUBSYSTEM_ID, Long.toString(value)));
            return this;
        }

        public Builder lastId(long value) {
            this.header(new GenericHeader(DeploymentManifest.ARIESSUBSYSTEM_LASTID, Long.toString(value)));
            return this;
        }

        public Builder location(String value) {
            if (value != null) {
                this.header(new GenericHeader(DeploymentManifest.ARIESSUBSYSTEM_LOCATION, value));
            }
            return this;
        }

        public Builder manifest(DeploymentManifest value) {
            if (value != null) {
                for (Map.Entry<String, Header<?>> entry : value.getHeaders().entrySet()) {
                    this.header(entry.getValue());
                }
            }
            return this;
        }

        public Builder manifest(SubsystemManifest value) {
            if (value != null) {
                for (Map.Entry<String, Header<?>> entry : value.getHeaders().entrySet()) {
                    this.header(entry.getValue());
                }
            }
            return this;
        }

        public Builder parent(BasicSubsystem value, boolean referenceCount) {
            AriesSubsystemParentsHeader.Clause clause = new AriesSubsystemParentsHeader.Clause(value, referenceCount);
            AriesSubsystemParentsHeader header = (AriesSubsystemParentsHeader)this.headers.get(DeploymentManifest.ARIESSUBSYSTEM_PARENTS);
            if (header == null) {
                this.header(new AriesSubsystemParentsHeader(Collections.singleton(clause)));
            } else {
                ArrayList<AriesSubsystemParentsHeader.Clause> clauses = new ArrayList<AriesSubsystemParentsHeader.Clause>(header.getClauses().size() + 1);
                clauses.addAll(header.getClauses());
                clauses.add(clause);
                this.header(new AriesSubsystemParentsHeader(clauses));
            }
            return this;
        }

        public Builder region(String value) {
            if (value != null) {
                this.header(new GenericHeader(DeploymentManifest.ARIESSUBSYSTEM_REGION, value));
            }
            return this;
        }

        public Builder region(Region value) {
            if (value != null) {
                this.region(value.getName());
            }
            return this;
        }

        public Builder state(Subsystem.State value) {
            if (value != null) {
                this.header(new GenericHeader(DeploymentManifest.ARIESSUBSYSTEM_STATE, value.toString()));
            }
            return this;
        }
    }
}

