/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.aries.application.modelling.ModelledResourceManager;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.BundleEventHook;
import org.apache.aries.subsystem.core.internal.StopAction;
import org.apache.aries.subsystem.core.internal.SubsystemResolverHookFactory;
import org.apache.aries.subsystem.core.internal.SubsystemServiceRegistrar;
import org.apache.aries.subsystem.core.internal.Subsystems;
import org.apache.aries.subsystem.core.internal.SystemRepository;
import org.apache.aries.util.filesystem.IDirectoryFinder;
import org.eclipse.equinox.region.RegionDigraph;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.bundle.EventHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.service.coordinator.Coordinator;
import org.osgi.service.repository.Repository;
import org.osgi.service.resolver.Resolver;
import org.osgi.service.subsystem.SubsystemException;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer<Object, Object> {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private static Activator instance;
    private BundleEventHook bundleEventHook;
    private volatile BundleContext bundleContext;
    private volatile Coordinator coordinator;
    private volatile ModelledResourceManager modelledResourceManager;
    private volatile SubsystemServiceRegistrar registrar;
    private volatile RegionDigraph regionDigraph;
    private volatile Resolver resolver;
    private ServiceTracker<?, ?> serviceTracker;
    private volatile Subsystems subsystems;
    private final Collection<ServiceRegistration<?>> registrations = new HashSet();
    private final Collection<Repository> repositories = Collections.synchronizedSet(new HashSet());
    private final Collection<IDirectoryFinder> finders = Collections.synchronizedSet(new HashSet());

    public static synchronized Activator getInstance() {
        logger.debug("Method entry: {}, args {}", (Object)"getInstance");
        Activator.checkInstance();
        logger.debug("Method exit: {}, returning {}", (Object)"getInstance", (Object)instance);
        return instance;
    }

    private static synchronized void checkInstance() {
        logger.debug("Method entry: {}, args {}", (Object)"checkInstance");
        if (instance == null) {
            throw new IllegalStateException("The activator has not been initialized or has been shutdown");
        }
        logger.debug("Method exit: {}, returning {}", (Object)"checkInstance");
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public Coordinator getCoordinator() {
        return this.coordinator;
    }

    public ModelledResourceManager getModelledResourceManager() {
        return this.modelledResourceManager;
    }

    public RegionDigraph getRegionDigraph() {
        return this.regionDigraph;
    }

    public Collection<Repository> getRepositories() {
        return Collections.unmodifiableCollection(this.repositories);
    }

    public Collection<IDirectoryFinder> getIDirectoryFinders() {
        return Collections.unmodifiableCollection(this.finders);
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public Subsystems getSubsystems() {
        return this.subsystems;
    }

    public SubsystemServiceRegistrar getSubsystemServiceRegistrar() {
        logger.debug("Method entry: {}, args {}", (Object)"getSubsystemServiceRegistrar");
        SubsystemServiceRegistrar result = this.registrar;
        logger.debug("Method exit: {}, returning {}", (Object)"getSubsystemServiceRegistrar", (Object)result);
        return result;
    }

    public Repository getSystemRepository() {
        return new SystemRepository(this.getSubsystems().getRootSubsystem());
    }

    public synchronized void start(BundleContext context) throws Exception {
        logger.debug("Method entry: {}, args {}", (Object)"start", (Object)context);
        this.bundleContext = context;
        this.serviceTracker = new ServiceTracker(this.bundleContext, this.generateServiceFilter(), (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
        logger.debug("Method exit: {}, returning {}", (Object)"start");
    }

    public synchronized void stop(BundleContext context) {
        logger.debug("Method entry: {}, args {}", (Object)"stop", (Object)context);
        this.serviceTracker.close();
        this.serviceTracker = null;
        this.bundleContext = null;
        logger.debug("Method exit: {}, returning {}", (Object)"stop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activate() {
        if (this.isActive() || !this.hasRequiredServices()) {
            return;
        }
        Class<Activator> clazz = Activator.class;
        synchronized (Activator.class) {
            instance = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                this.subsystems = new Subsystems();
            }
            catch (SubsystemException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SubsystemException((Throwable)e);
            }
            this.registerBundleEventHook();
            this.registrations.add(this.bundleContext.registerService(ResolverHookFactory.class, (Object)new SubsystemResolverHookFactory(this.subsystems), null));
            this.registrar = new SubsystemServiceRegistrar(this.bundleContext);
            BasicSubsystem root = this.subsystems.getRootSubsystem();
            this.bundleEventHook.activate();
            root.start();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivate() {
        if (!this.isActive()) {
            return;
        }
        this.bundleEventHook.deactivate();
        new StopAction(this.subsystems.getRootSubsystem(), this.subsystems.getRootSubsystem(), true).run();
        for (ServiceRegistration<?> registration : this.registrations) {
            try {
                registration.unregister();
            }
            catch (IllegalStateException e) {
                logger.debug("Service had already been unregistered", (Throwable)e);
            }
        }
        this.bundleEventHook.processPendingEvents();
        Class<Activator> clazz = Activator.class;
        synchronized (Activator.class) {
            instance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private Object findAlternateServiceFor(Object service) {
        Object[] services = this.serviceTracker.getServices();
        if (services == null) {
            return null;
        }
        for (Object alternate : services) {
            if (!alternate.getClass().equals(service.getClass())) continue;
            return alternate;
        }
        return null;
    }

    private Filter generateServiceFilter() throws InvalidSyntaxException {
        return FrameworkUtil.createFilter((String)this.generateServiceFilterString());
    }

    private String generateServiceFilterString() {
        return "(|(" + "objectClass" + '=' + Coordinator.class.getName() + ")(" + "objectClass" + '=' + RegionDigraph.class.getName() + ")(" + "objectClass" + '=' + Resolver.class.getName() + ")(" + "objectClass" + '=' + Repository.class.getName() + ")(" + "objectClass" + '=' + ModelledResourceManager.class.getName() + ")(" + "objectClass" + '=' + IDirectoryFinder.class.getName() + "))";
    }

    private boolean hasRequiredServices() {
        return this.coordinator != null && this.regionDigraph != null && this.resolver != null && this.modelledResourceManager != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isActive() {
        Class<Activator> clazz = Activator.class;
        synchronized (Activator.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance != null && this.getSubsystems() != null;
        }
    }

    private void registerBundleEventHook() {
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>(1);
        ((Dictionary)properties).put("service.ranking", Integer.MAX_VALUE);
        this.bundleEventHook = new BundleEventHook();
        this.registrations.add(this.bundleContext.registerService(EventHook.class, (Object)this.bundleEventHook, properties));
    }

    public synchronized Object addingService(ServiceReference<Object> reference) {
        Object service = this.bundleContext.getService(reference);
        if (service instanceof Coordinator) {
            if (this.coordinator == null) {
                this.coordinator = (Coordinator)service;
                this.activate();
            }
        } else if (service instanceof RegionDigraph) {
            if (this.regionDigraph == null) {
                this.regionDigraph = (RegionDigraph)service;
                this.activate();
            }
        } else if (service instanceof Resolver) {
            if (this.resolver == null) {
                this.resolver = (Resolver)service;
                this.activate();
            }
        } else if (service instanceof ModelledResourceManager) {
            if (this.modelledResourceManager == null) {
                this.modelledResourceManager = (ModelledResourceManager)service;
                this.activate();
            }
        } else if (service instanceof IDirectoryFinder) {
            this.finders.add((IDirectoryFinder)service);
        } else {
            this.repositories.add((Repository)service);
        }
        return service;
    }

    public void modifiedService(ServiceReference<Object> reference, Object service) {
    }

    public synchronized void removedService(ServiceReference<Object> reference, Object service) {
        if (service instanceof Coordinator) {
            if (service.equals(this.coordinator)) {
                Coordinator coordinator = (Coordinator)this.findAlternateServiceFor(this.coordinator);
                if (coordinator == null) {
                    this.deactivate();
                }
                this.coordinator = coordinator;
            }
        } else if (service instanceof RegionDigraph) {
            if (service.equals(this.regionDigraph)) {
                RegionDigraph regionDigraph = (RegionDigraph)this.findAlternateServiceFor(this.regionDigraph);
                if (regionDigraph == null) {
                    this.deactivate();
                }
                this.regionDigraph = regionDigraph;
            }
        } else if (service instanceof Resolver) {
            if (service.equals(this.resolver)) {
                Resolver resolver = (Resolver)this.findAlternateServiceFor(this.resolver);
                if (resolver == null) {
                    this.deactivate();
                }
                this.resolver = resolver;
            }
        } else if (service instanceof ModelledResourceManager) {
            if (service.equals(this.modelledResourceManager)) {
                ModelledResourceManager modelledResourceManager = (ModelledResourceManager)this.findAlternateServiceFor(this.modelledResourceManager);
                if (modelledResourceManager == null) {
                    this.deactivate();
                }
                this.modelledResourceManager = modelledResourceManager;
            }
        } else if (service instanceof IDirectoryFinder) {
            this.finders.remove(service);
        } else {
            this.repositories.remove(service);
        }
    }
}

