/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.obr.internal;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.aries.subsystem.obr.internal.FelixCapabilityAdapter;
import org.apache.aries.subsystem.obr.internal.FelixRequirementAdapter;
import org.apache.aries.subsystem.obr.internal.NamespaceTranslator;
import org.apache.aries.subsystem.obr.internal.OsgiContentCapability;
import org.apache.aries.subsystem.obr.internal.OsgiIdentityCapability;
import org.apache.aries.subsystem.obr.internal.ResourceHelper;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Resource;
import org.osgi.resource.Requirement;
import org.osgi.service.repository.RepositoryContent;

public class FelixResourceAdapter
implements org.osgi.resource.Resource,
RepositoryContent {
    private final Resource resource;

    public FelixResourceAdapter(Resource resource) {
        this.resource = resource;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof org.osgi.resource.Resource)) {
            return false;
        }
        org.osgi.resource.Resource that = (org.osgi.resource.Resource)o;
        if (!ResourceHelper.getTypeAttribute(that).equals(ResourceHelper.getTypeAttribute(this))) {
            return false;
        }
        if (!ResourceHelper.getSymbolicNameAttribute(that).equals(ResourceHelper.getSymbolicNameAttribute(this))) {
            return false;
        }
        return ResourceHelper.getVersionAttribute(that).equals((Object)ResourceHelper.getVersionAttribute(this));
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + ResourceHelper.getTypeAttribute(this).hashCode();
        result = 31 * result + ResourceHelper.getSymbolicNameAttribute(this).hashCode();
        result = 31 * result + ResourceHelper.getVersionAttribute(this).hashCode();
        return result;
    }

    public List<org.osgi.resource.Capability> getCapabilities(String namespace) {
        if ((namespace = NamespaceTranslator.translate(namespace)) == null || namespace.equals("osgi.identity")) {
            OsgiIdentityCapability c = new OsgiIdentityCapability(this, this.resource.getSymbolicName(), this.resource.getVersion());
            return Collections.singletonList(c);
        }
        if (namespace.equals("osgi.content")) {
            OsgiContentCapability c = new OsgiContentCapability((org.osgi.resource.Resource)this, this.resource.getURI());
            return Collections.singletonList(c);
        }
        Capability[] capabilities = this.resource.getCapabilities();
        ArrayList<org.osgi.resource.Capability> result = new ArrayList<org.osgi.resource.Capability>(capabilities.length);
        for (Capability capability : capabilities) {
            if (namespace != null && !capability.getName().equals(namespace)) continue;
            result.add(new FelixCapabilityAdapter(capability, this));
        }
        result.trimToSize();
        return result;
    }

    public InputStream getContent() {
        try {
            return new URL(this.resource.getURI()).openStream();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Requirement> getRequirements(String namespace) {
        namespace = NamespaceTranslator.translate(namespace);
        org.apache.felix.bundlerepository.Requirement[] requirements = this.resource.getRequirements();
        ArrayList<Requirement> result = new ArrayList<Requirement>(requirements.length);
        for (org.apache.felix.bundlerepository.Requirement requirement : requirements) {
            if (namespace != null && !requirement.getName().equals(namespace)) continue;
            result.add(new FelixRequirementAdapter(requirement, this));
        }
        result.trimToSize();
        return result;
    }

    public String toString() {
        org.osgi.resource.Capability c = this.getCapabilities("osgi.identity").iterator().next();
        Map atts = c.getAttributes();
        return "" + atts.get("osgi.identity") + ';' + atts.get("version") + ';' + atts.get("type");
    }
}

