/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import org.apache.avro.Schema;
import org.apache.avro.io.BinaryData;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.mapred.Pair;
import org.apache.avro.reflect.ReflectData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.RawComparator;

public class AvroKeyComparator<T>
extends Configured
implements RawComparator<AvroWrapper<T>> {
    private Schema schema;

    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf != null) {
            this.schema = Pair.getKeySchema(AvroJob.getMapOutputSchema(conf));
        }
    }

    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        return BinaryData.compare((byte[])b1, (int)s1, (int)l1, (byte[])b2, (int)s2, (int)l2, (Schema)this.schema);
    }

    public int compare(AvroWrapper<T> x, AvroWrapper<T> y) {
        return ReflectData.get().compare(x.datum(), y.datum(), this.schema);
    }
}

