/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.avro.AvroRemoteException;
import org.apache.avro.Protocol;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.ipc.Ipc;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.generic.GenericResponder;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.Util;

public class RpcReceiveTool
implements Tool {
    private PrintStream out;
    private Object response;
    private CountDownLatch latch;
    private Protocol.Message expectedMessage;
    Server server;

    @Override
    public String getName() {
        return "rpcreceive";
    }

    @Override
    public String getShortDescription() {
        return "Opens an RPC Server and listens for one message.";
    }

    @Override
    public int run(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
        int r = this.run1(in, out, err, args);
        if (r != 0) {
            return r;
        }
        return this.run2(err);
    }

    int run1(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
        OptionParser p = new OptionParser();
        ArgumentAcceptingOptionSpec file = p.accepts("file", "Data file containing response datum.").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec data = p.accepts("data", "JSON-encoded response datum.").withRequiredArg().ofType(String.class);
        OptionSet opts = p.parse(args.toArray(new String[0]));
        if ((args = opts.nonOptionArguments()).size() != 3) {
            err.println("Usage: uri protocol_file message_name (-data d | -file f)");
            p.printHelpOn((OutputStream)err);
            return 1;
        }
        URI uri = new URI((String)args.get(0));
        Protocol protocol = Protocol.parse((File)new File((String)args.get(1)));
        String messageName = (String)args.get(2);
        this.expectedMessage = (Protocol.Message)protocol.getMessages().get(messageName);
        if (this.expectedMessage == null) {
            err.println(String.format("No message named '%s' found in protocol '%s'.", messageName, protocol));
            return 1;
        }
        if (data.value(opts) != null) {
            this.response = Util.jsonToGenericDatum(this.expectedMessage.getResponse(), (String)data.value(opts));
        } else if (file.value(opts) != null) {
            this.response = Util.datumFromFile(this.expectedMessage.getResponse(), (String)file.value(opts));
        } else {
            err.println("One of -data or -file must be specified.");
            return 1;
        }
        this.out = out;
        this.latch = new CountDownLatch(1);
        this.server = Ipc.createServer((Responder)new SinkResponder(protocol), (URI)uri);
        this.server.start();
        out.println("Port: " + this.server.getPort());
        return 0;
    }

    int run2(PrintStream err) throws InterruptedException {
        this.latch.await();
        err.println("Closing server.");
        this.server.close();
        return 0;
    }

    private class SinkResponder
    extends GenericResponder {
        public SinkResponder(Protocol local) {
            super(local);
        }

        public Object respond(Protocol.Message message, Object request) throws AvroRemoteException {
            if (!message.equals((Object)RpcReceiveTool.this.expectedMessage)) {
                RpcReceiveTool.this.out.println(String.format("Expected message '%s' but received '%s'.", RpcReceiveTool.this.expectedMessage.getName(), message.getName()));
                RpcReceiveTool.this.latch.countDown();
                throw new IllegalArgumentException("Unexpected message.");
            }
            RpcReceiveTool.this.out.print(message.getName());
            RpcReceiveTool.this.out.print("\t");
            try {
                JsonEncoder jsonEncoder = EncoderFactory.get().jsonEncoder(message.getRequest(), (OutputStream)RpcReceiveTool.this.out);
                GenericDatumWriter writer = new GenericDatumWriter(message.getRequest());
                writer.write(request, (Encoder)jsonEncoder);
                jsonEncoder.flush();
                RpcReceiveTool.this.out.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            RpcReceiveTool.this.out.println();
            new Thread(() -> {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                RpcReceiveTool.this.latch.countDown();
            }).start();
            return RpcReceiveTool.this.response;
        }
    }
}

