// @generated by protobuf-ts 2.1.0 with parameter generate_dependencies
// @generated from protobuf file "beam_job_api.proto" (package "org.apache.beam.model.job_management.v1", syntax proto3)
// tslint:disable
//
//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
//
//
// Protocol Buffers describing the Job API, api for communicating with a runner
// for job submission over GRPC.
//
import type { RpcTransport } from "@protobuf-ts/runtime-rpc";
import type { ServiceInfo } from "@protobuf-ts/runtime-rpc";
import { JobService } from "./beam_job_api";
import type { DescribePipelineOptionsResponse } from "./beam_job_api";
import type { DescribePipelineOptionsRequest } from "./beam_job_api";
import type { GetJobMetricsResponse } from "./beam_job_api";
import type { GetJobMetricsRequest } from "./beam_job_api";
import type { JobMessagesResponse } from "./beam_job_api";
import type { JobMessagesRequest } from "./beam_job_api";
import type { ServerStreamingCall } from "@protobuf-ts/runtime-rpc";
import type { CancelJobResponse } from "./beam_job_api";
import type { CancelJobRequest } from "./beam_job_api";
import type { GetJobPipelineResponse } from "./beam_job_api";
import type { GetJobPipelineRequest } from "./beam_job_api";
import type { JobStateEvent } from "./beam_job_api";
import type { GetJobStateRequest } from "./beam_job_api";
import type { GetJobsResponse } from "./beam_job_api";
import type { GetJobsRequest } from "./beam_job_api";
import type { RunJobResponse } from "./beam_job_api";
import type { RunJobRequest } from "./beam_job_api";
import { stackIntercept } from "@protobuf-ts/runtime-rpc";
import type { PrepareJobResponse } from "./beam_job_api";
import type { PrepareJobRequest } from "./beam_job_api";
import type { UnaryCall } from "@protobuf-ts/runtime-rpc";
import type { RpcOptions } from "@protobuf-ts/runtime-rpc";
/**
 * Job Service for running RunnerAPI pipelines
 *
 * @generated from protobuf service org.apache.beam.model.job_management.v1.JobService
 */
export interface IJobServiceClient {
    /**
     * Prepare a job for execution. The job will not be executed until a call is made to run with the
     * returned preparationId.
     *
     * @generated from protobuf rpc: Prepare(org.apache.beam.model.job_management.v1.PrepareJobRequest) returns (org.apache.beam.model.job_management.v1.PrepareJobResponse);
     */
    prepare(input: PrepareJobRequest, options?: RpcOptions): UnaryCall<PrepareJobRequest, PrepareJobResponse>;
    /**
     * Submit the job for execution
     *
     * @generated from protobuf rpc: Run(org.apache.beam.model.job_management.v1.RunJobRequest) returns (org.apache.beam.model.job_management.v1.RunJobResponse);
     */
    run(input: RunJobRequest, options?: RpcOptions): UnaryCall<RunJobRequest, RunJobResponse>;
    /**
     * Get a list of all invoked jobs
     *
     * @generated from protobuf rpc: GetJobs(org.apache.beam.model.job_management.v1.GetJobsRequest) returns (org.apache.beam.model.job_management.v1.GetJobsResponse);
     */
    getJobs(input: GetJobsRequest, options?: RpcOptions): UnaryCall<GetJobsRequest, GetJobsResponse>;
    /**
     * Get the current state of the job
     *
     * @generated from protobuf rpc: GetState(org.apache.beam.model.job_management.v1.GetJobStateRequest) returns (org.apache.beam.model.job_management.v1.JobStateEvent);
     */
    getState(input: GetJobStateRequest, options?: RpcOptions): UnaryCall<GetJobStateRequest, JobStateEvent>;
    /**
     * Get the job's pipeline
     *
     * @generated from protobuf rpc: GetPipeline(org.apache.beam.model.job_management.v1.GetJobPipelineRequest) returns (org.apache.beam.model.job_management.v1.GetJobPipelineResponse);
     */
    getPipeline(input: GetJobPipelineRequest, options?: RpcOptions): UnaryCall<GetJobPipelineRequest, GetJobPipelineResponse>;
    /**
     * Cancel the job
     *
     * @generated from protobuf rpc: Cancel(org.apache.beam.model.job_management.v1.CancelJobRequest) returns (org.apache.beam.model.job_management.v1.CancelJobResponse);
     */
    cancel(input: CancelJobRequest, options?: RpcOptions): UnaryCall<CancelJobRequest, CancelJobResponse>;
    /**
     * Subscribe to a stream of state changes of the job, will immediately return the current state of the job as the first response.
     *
     * @generated from protobuf rpc: GetStateStream(org.apache.beam.model.job_management.v1.GetJobStateRequest) returns (stream org.apache.beam.model.job_management.v1.JobStateEvent);
     */
    getStateStream(input: GetJobStateRequest, options?: RpcOptions): ServerStreamingCall<GetJobStateRequest, JobStateEvent>;
    /**
     * Subscribe to a stream of state changes and messages from the job
     *
     * @generated from protobuf rpc: GetMessageStream(org.apache.beam.model.job_management.v1.JobMessagesRequest) returns (stream org.apache.beam.model.job_management.v1.JobMessagesResponse);
     */
    getMessageStream(input: JobMessagesRequest, options?: RpcOptions): ServerStreamingCall<JobMessagesRequest, JobMessagesResponse>;
    /**
     * Fetch metrics for a given job
     *
     * @generated from protobuf rpc: GetJobMetrics(org.apache.beam.model.job_management.v1.GetJobMetricsRequest) returns (org.apache.beam.model.job_management.v1.GetJobMetricsResponse);
     */
    getJobMetrics(input: GetJobMetricsRequest, options?: RpcOptions): UnaryCall<GetJobMetricsRequest, GetJobMetricsResponse>;
    /**
     * Get the supported pipeline options of the runner
     *
     * @generated from protobuf rpc: DescribePipelineOptions(org.apache.beam.model.job_management.v1.DescribePipelineOptionsRequest) returns (org.apache.beam.model.job_management.v1.DescribePipelineOptionsResponse);
     */
    describePipelineOptions(input: DescribePipelineOptionsRequest, options?: RpcOptions): UnaryCall<DescribePipelineOptionsRequest, DescribePipelineOptionsResponse>;
}
/**
 * Job Service for running RunnerAPI pipelines
 *
 * @generated from protobuf service org.apache.beam.model.job_management.v1.JobService
 */
export class JobServiceClient implements IJobServiceClient, ServiceInfo {
    typeName = JobService.typeName;
    methods = JobService.methods;
    options = JobService.options;
    constructor(private readonly _transport: RpcTransport) {
    }
    /**
     * Prepare a job for execution. The job will not be executed until a call is made to run with the
     * returned preparationId.
     *
     * @generated from protobuf rpc: Prepare(org.apache.beam.model.job_management.v1.PrepareJobRequest) returns (org.apache.beam.model.job_management.v1.PrepareJobResponse);
     */
    prepare(input: PrepareJobRequest, options?: RpcOptions): UnaryCall<PrepareJobRequest, PrepareJobResponse> {
        const method = this.methods[0], opt = this._transport.mergeOptions(options);
        return stackIntercept<PrepareJobRequest, PrepareJobResponse>("unary", this._transport, method, opt, input);
    }
    /**
     * Submit the job for execution
     *
     * @generated from protobuf rpc: Run(org.apache.beam.model.job_management.v1.RunJobRequest) returns (org.apache.beam.model.job_management.v1.RunJobResponse);
     */
    run(input: RunJobRequest, options?: RpcOptions): UnaryCall<RunJobRequest, RunJobResponse> {
        const method = this.methods[1], opt = this._transport.mergeOptions(options);
        return stackIntercept<RunJobRequest, RunJobResponse>("unary", this._transport, method, opt, input);
    }
    /**
     * Get a list of all invoked jobs
     *
     * @generated from protobuf rpc: GetJobs(org.apache.beam.model.job_management.v1.GetJobsRequest) returns (org.apache.beam.model.job_management.v1.GetJobsResponse);
     */
    getJobs(input: GetJobsRequest, options?: RpcOptions): UnaryCall<GetJobsRequest, GetJobsResponse> {
        const method = this.methods[2], opt = this._transport.mergeOptions(options);
        return stackIntercept<GetJobsRequest, GetJobsResponse>("unary", this._transport, method, opt, input);
    }
    /**
     * Get the current state of the job
     *
     * @generated from protobuf rpc: GetState(org.apache.beam.model.job_management.v1.GetJobStateRequest) returns (org.apache.beam.model.job_management.v1.JobStateEvent);
     */
    getState(input: GetJobStateRequest, options?: RpcOptions): UnaryCall<GetJobStateRequest, JobStateEvent> {
        const method = this.methods[3], opt = this._transport.mergeOptions(options);
        return stackIntercept<GetJobStateRequest, JobStateEvent>("unary", this._transport, method, opt, input);
    }
    /**
     * Get the job's pipeline
     *
     * @generated from protobuf rpc: GetPipeline(org.apache.beam.model.job_management.v1.GetJobPipelineRequest) returns (org.apache.beam.model.job_management.v1.GetJobPipelineResponse);
     */
    getPipeline(input: GetJobPipelineRequest, options?: RpcOptions): UnaryCall<GetJobPipelineRequest, GetJobPipelineResponse> {
        const method = this.methods[4], opt = this._transport.mergeOptions(options);
        return stackIntercept<GetJobPipelineRequest, GetJobPipelineResponse>("unary", this._transport, method, opt, input);
    }
    /**
     * Cancel the job
     *
     * @generated from protobuf rpc: Cancel(org.apache.beam.model.job_management.v1.CancelJobRequest) returns (org.apache.beam.model.job_management.v1.CancelJobResponse);
     */
    cancel(input: CancelJobRequest, options?: RpcOptions): UnaryCall<CancelJobRequest, CancelJobResponse> {
        const method = this.methods[5], opt = this._transport.mergeOptions(options);
        return stackIntercept<CancelJobRequest, CancelJobResponse>("unary", this._transport, method, opt, input);
    }
    /**
     * Subscribe to a stream of state changes of the job, will immediately return the current state of the job as the first response.
     *
     * @generated from protobuf rpc: GetStateStream(org.apache.beam.model.job_management.v1.GetJobStateRequest) returns (stream org.apache.beam.model.job_management.v1.JobStateEvent);
     */
    getStateStream(input: GetJobStateRequest, options?: RpcOptions): ServerStreamingCall<GetJobStateRequest, JobStateEvent> {
        const method = this.methods[6], opt = this._transport.mergeOptions(options);
        return stackIntercept<GetJobStateRequest, JobStateEvent>("serverStreaming", this._transport, method, opt, input);
    }
    /**
     * Subscribe to a stream of state changes and messages from the job
     *
     * @generated from protobuf rpc: GetMessageStream(org.apache.beam.model.job_management.v1.JobMessagesRequest) returns (stream org.apache.beam.model.job_management.v1.JobMessagesResponse);
     */
    getMessageStream(input: JobMessagesRequest, options?: RpcOptions): ServerStreamingCall<JobMessagesRequest, JobMessagesResponse> {
        const method = this.methods[7], opt = this._transport.mergeOptions(options);
        return stackIntercept<JobMessagesRequest, JobMessagesResponse>("serverStreaming", this._transport, method, opt, input);
    }
    /**
     * Fetch metrics for a given job
     *
     * @generated from protobuf rpc: GetJobMetrics(org.apache.beam.model.job_management.v1.GetJobMetricsRequest) returns (org.apache.beam.model.job_management.v1.GetJobMetricsResponse);
     */
    getJobMetrics(input: GetJobMetricsRequest, options?: RpcOptions): UnaryCall<GetJobMetricsRequest, GetJobMetricsResponse> {
        const method = this.methods[8], opt = this._transport.mergeOptions(options);
        return stackIntercept<GetJobMetricsRequest, GetJobMetricsResponse>("unary", this._transport, method, opt, input);
    }
    /**
     * Get the supported pipeline options of the runner
     *
     * @generated from protobuf rpc: DescribePipelineOptions(org.apache.beam.model.job_management.v1.DescribePipelineOptionsRequest) returns (org.apache.beam.model.job_management.v1.DescribePipelineOptionsResponse);
     */
    describePipelineOptions(input: DescribePipelineOptionsRequest, options?: RpcOptions): UnaryCall<DescribePipelineOptionsRequest, DescribePipelineOptionsResponse> {
        const method = this.methods[9], opt = this._transport.mergeOptions(options);
        return stackIntercept<DescribePipelineOptionsRequest, DescribePipelineOptionsResponse>("unary", this._transport, method, opt, input);
    }
}
