/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1.IntegrationKit;
import org.apache.camel.v1.IntegrationKitSpec;
import org.apache.camel.v1.IntegrationKitSpecBuilder;
import org.apache.camel.v1.IntegrationKitSpecFluent;
import org.apache.camel.v1.IntegrationKitStatus;
import org.apache.camel.v1.IntegrationKitStatusBuilder;
import org.apache.camel.v1.IntegrationKitStatusFluent;

public class IntegrationKitFluent<A extends IntegrationKitFluent<A>>
extends BaseFluent<A> {
    private ObjectMetaBuilder metadata;
    private IntegrationKitSpecBuilder spec;
    private IntegrationKitStatusBuilder status;
    private String kind;
    private String apiVersion;

    public IntegrationKitFluent() {
    }

    public IntegrationKitFluent(IntegrationKit instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IntegrationKit instance) {
        IntegrationKit integrationKit = instance = instance != null ? instance : new IntegrationKit();
        if (instance != null) {
            this.withMetadata(instance.getMetadata());
            this.withSpec((IntegrationKitSpec)instance.getSpec());
            this.withStatus((IntegrationKitStatus)instance.getStatus());
            this.withKind(instance.getKind());
            this.withApiVersion(instance.getApiVersion());
        }
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove((Object)"metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public IntegrationKitSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    public A withSpec(IntegrationKitSpec spec) {
        this._visitables.remove((Object)"spec");
        if (spec != null) {
            this.spec = new IntegrationKitSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        } else {
            this.spec = null;
            this._visitables.get((Object)"spec").remove((Object)this.spec);
        }
        return (A)((Object)this);
    }

    public boolean hasSpec() {
        return this.spec != null;
    }

    public SpecNested<A> withNewSpec() {
        return new SpecNested(null);
    }

    public SpecNested<A> withNewSpecLike(IntegrationKitSpec item) {
        return new SpecNested(item);
    }

    public SpecNested<A> editSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(null));
    }

    public SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(new IntegrationKitSpecBuilder().build()));
    }

    public SpecNested<A> editOrNewSpecLike(IntegrationKitSpec item) {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(item));
    }

    public IntegrationKitStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    public A withStatus(IntegrationKitStatus status) {
        this._visitables.remove((Object)"status");
        if (status != null) {
            this.status = new IntegrationKitStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get((Object)"status").remove((Object)this.status);
        }
        return (A)((Object)this);
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public StatusNested<A> withNewStatus() {
        return new StatusNested(null);
    }

    public StatusNested<A> withNewStatusLike(IntegrationKitStatus item) {
        return new StatusNested(item);
    }

    public StatusNested<A> editStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(null));
    }

    public StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(new IntegrationKitStatusBuilder().build()));
    }

    public StatusNested<A> editOrNewStatusLike(IntegrationKitStatus item) {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(item));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IntegrationKitFluent that = (IntegrationKitFluent)((Object)o);
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals((Object)this.spec, (Object)that.spec)) {
            return false;
        }
        if (!Objects.equals((Object)this.status, (Object)that.status)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        return Objects.equals(this.apiVersion, that.apiVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metadata, this.spec, this.status, this.kind, this.apiVersion, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        public N and() {
            return (N)IntegrationKitFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class SpecNested<N>
    extends IntegrationKitSpecFluent<SpecNested<N>>
    implements Nested<N> {
        IntegrationKitSpecBuilder builder;

        SpecNested(IntegrationKitSpec item) {
            this.builder = new IntegrationKitSpecBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationKitFluent.this.withSpec(this.builder.build());
        }

        public N endSpec() {
            return this.and();
        }
    }

    public class StatusNested<N>
    extends IntegrationKitStatusFluent<StatusNested<N>>
    implements Nested<N> {
        IntegrationKitStatusBuilder builder;

        StatusNested(IntegrationKitStatus item) {
            this.builder = new IntegrationKitStatusBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationKitFluent.this.withStatus(this.builder.build());
        }

        public N endStatus() {
            return this.and();
        }
    }
}

