/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.buildstatus;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1.buildstatus.Failure;
import org.apache.camel.v1.buildstatus.failure.Recovery;
import org.apache.camel.v1.buildstatus.failure.RecoveryBuilder;
import org.apache.camel.v1.buildstatus.failure.RecoveryFluent;

public class FailureFluent<A extends FailureFluent<A>>
extends BaseFluent<A> {
    private String reason;
    private RecoveryBuilder recovery;
    private ZonedDateTime time;

    public FailureFluent() {
    }

    public FailureFluent(Failure instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Failure instance) {
        Failure failure = instance = instance != null ? instance : new Failure();
        if (instance != null) {
            this.withReason(instance.getReason());
            this.withRecovery(instance.getRecovery());
            this.withTime(instance.getTime());
        }
    }

    public String getReason() {
        return this.reason;
    }

    public A withReason(String reason) {
        this.reason = reason;
        return (A)((Object)this);
    }

    public boolean hasReason() {
        return this.reason != null;
    }

    public Recovery buildRecovery() {
        return this.recovery != null ? this.recovery.build() : null;
    }

    public A withRecovery(Recovery recovery) {
        this._visitables.remove((Object)"recovery");
        if (recovery != null) {
            this.recovery = new RecoveryBuilder(recovery);
            this._visitables.get((Object)"recovery").add(this.recovery);
        } else {
            this.recovery = null;
            this._visitables.get((Object)"recovery").remove((Object)this.recovery);
        }
        return (A)((Object)this);
    }

    public boolean hasRecovery() {
        return this.recovery != null;
    }

    public RecoveryNested<A> withNewRecovery() {
        return new RecoveryNested(null);
    }

    public RecoveryNested<A> withNewRecoveryLike(Recovery item) {
        return new RecoveryNested(item);
    }

    public RecoveryNested<A> editRecovery() {
        return this.withNewRecoveryLike(Optional.ofNullable(this.buildRecovery()).orElse(null));
    }

    public RecoveryNested<A> editOrNewRecovery() {
        return this.withNewRecoveryLike(Optional.ofNullable(this.buildRecovery()).orElse(new RecoveryBuilder().build()));
    }

    public RecoveryNested<A> editOrNewRecoveryLike(Recovery item) {
        return this.withNewRecoveryLike(Optional.ofNullable(this.buildRecovery()).orElse(item));
    }

    public ZonedDateTime getTime() {
        return this.time;
    }

    public A withTime(ZonedDateTime time) {
        this.time = time;
        return (A)((Object)this);
    }

    public boolean hasTime() {
        return this.time != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FailureFluent that = (FailureFluent)((Object)o);
        if (!Objects.equals(this.reason, that.reason)) {
            return false;
        }
        if (!Objects.equals((Object)this.recovery, (Object)that.recovery)) {
            return false;
        }
        return Objects.equals(this.time, that.time);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.reason, this.recovery, this.time, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.reason != null) {
            sb.append("reason:");
            sb.append(this.reason + ",");
        }
        if (this.recovery != null) {
            sb.append("recovery:");
            sb.append(this.recovery + ",");
        }
        if (this.time != null) {
            sb.append("time:");
            sb.append(this.time);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RecoveryNested<N>
    extends RecoveryFluent<RecoveryNested<N>>
    implements Nested<N> {
        RecoveryBuilder builder;

        RecoveryNested(Recovery item) {
            this.builder = new RecoveryBuilder(this, item);
        }

        public N and() {
            return (N)FailureFluent.this.withRecovery(this.builder.build());
        }

        public N endRecovery() {
            return this.and();
        }
    }
}

