/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.windows.WindowsArrowButton;
import com.jgoodies.looks.windows.WindowsComboBoxEditor;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;

public final class WindowsComboBoxUI
extends com.sun.java.swing.plaf.windows.WindowsComboBoxUI {
    private static final JTextField phantom = new JTextField("Phantom");

    public static ComponentUI createUI(JComponent b) {
        return new WindowsComboBoxUI();
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension size = super.getMinimumSize(c);
        Dimension textFieldSize = phantom.getMinimumSize();
        return new Dimension(size.width, Math.max(textFieldSize.height, size.height));
    }

    protected ComboBoxEditor createEditor() {
        return new WindowsComboBoxEditor.UIResource();
    }

    protected LayoutManager createLayoutManager() {
        return new WindowsComboBoxLayoutManager();
    }

    protected JButton createArrowButton() {
        return LookUtils.IS_LAF_WINDOWS_XP_ENABLED ? super.createArrowButton() : new WindowsArrowButton(5);
    }

    protected Rectangle rectangleForCurrentValue() {
        if (this.comboBox.isEditable() || !this.comboBox.isEnabled()) {
            return super.rectangleForCurrentValue();
        }
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        Insets rendererMargin = UIManager.getInsets("ComboBox.rendererMargin");
        int buttonSize = height - (insets.top + insets.bottom);
        if (this.arrowButton != null) {
            buttonSize = this.arrowButton.getWidth();
        }
        if (this.comboBox.getComponentOrientation().isLeftToRight()) {
            return new Rectangle(insets.left + rendererMargin.left, insets.top + rendererMargin.top, width - (insets.left + rendererMargin.left + insets.right + rendererMargin.right + buttonSize), height - (insets.top + rendererMargin.top + insets.bottom + rendererMargin.bottom));
        }
        return new Rectangle(insets.left + rendererMargin.left + buttonSize, insets.top + rendererMargin.top, width - (insets.left + rendererMargin.left + insets.right + rendererMargin.right + buttonSize), height - (insets.top + rendererMargin.top + insets.bottom + rendererMargin.bottom));
    }

    private class WindowsComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        private WindowsComboBoxLayoutManager() {
            super((BasicComboBoxUI)((Object)WindowsComboBoxUI.this));
        }

        public void layoutContainer(Container parent) {
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = WindowsComboBoxUI.this.getInsets();
            int buttonWidth = UIManager.getInt("ScrollBar.width");
            int buttonHeight = height - (insets.top + insets.bottom);
            if (WindowsComboBoxUI.this.arrowButton != null) {
                if (cb.getComponentOrientation().isLeftToRight()) {
                    WindowsComboBoxUI.this.arrowButton.setBounds(width - (insets.right + buttonWidth), insets.top, buttonWidth, buttonHeight);
                } else {
                    WindowsComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, buttonWidth, buttonHeight);
                }
            }
            if (WindowsComboBoxUI.this.editor != null) {
                WindowsComboBoxUI.this.editor.setBounds(WindowsComboBoxUI.this.rectangleForCurrentValue());
            }
        }
    }
}

