/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.ResultIterator;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncrementalFaultList<E>
implements List<E> {
    protected int pageSize;
    protected List elements;
    protected DataContext dataContext;
    protected ObjEntity rootEntity;
    protected SelectQuery internalQuery;
    protected int unfetchedObjects;
    protected int idWidth;
    private IncrementalListHelper helper;
    protected int maxFetchSize = 10000;

    public IncrementalFaultList(IncrementalFaultList<E> list) {
        this.pageSize = list.pageSize;
        this.internalQuery = list.internalQuery;
        this.dataContext = list.dataContext;
        this.rootEntity = list.rootEntity;
        this.maxFetchSize = list.maxFetchSize;
        this.idWidth = list.idWidth;
        this.helper = list.helper;
        this.elements = Collections.synchronizedList(new ArrayList());
    }

    public IncrementalFaultList(DataContext dataContext, Query query) {
        QueryMetadata metadata = query.getMetaData(dataContext.getEntityResolver());
        if (metadata.getPageSize() <= 0) {
            throw new CayenneRuntimeException("Not a paginated query; page size: " + metadata.getPageSize());
        }
        this.dataContext = dataContext;
        this.pageSize = metadata.getPageSize();
        this.rootEntity = metadata.getObjEntity();
        if (this.rootEntity == null) {
            throw new CayenneRuntimeException("Pagination is not supported for queries not rooted in an ObjEntity");
        }
        this.internalQuery = new SelectQuery(this.rootEntity);
        this.internalQuery.setFetchingDataRows(metadata.isFetchingDataRows());
        this.internalQuery.setPrefetchTree(metadata.getPrefetchTree());
        this.helper = this.createHelper(metadata);
        this.idWidth = metadata.getDbEntity().getPrimaryKeys().size();
        ArrayList elementsUnsynced = new ArrayList();
        this.fillIn(query, elementsUnsynced);
        this.elements = Collections.synchronizedList(elementsUnsynced);
    }

    IncrementalListHelper createHelper(QueryMetadata metadata) {
        if (metadata.isFetchingDataRows()) {
            return new DataRowListHelper();
        }
        return new PersistentListHelper();
    }

    SelectQuery getInternalQuery() {
        return this.internalQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillIn(Query query) {
        List list = this.elements;
        synchronized (list) {
            this.fillIn(query, this.elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillIn(Query query, List elementsList) {
        elementsList.clear();
        try {
            long t1 = System.currentTimeMillis();
            ResultIterator it = this.dataContext.performIteratedQuery(query);
            try {
                while (it.hasNextRow()) {
                    elementsList.add(it.nextRow());
                }
                QueryLogger.logSelectCount(elementsList.size(), System.currentTimeMillis() - t1);
            }
            finally {
                it.close();
            }
        }
        catch (CayenneException e) {
            throw new CayenneRuntimeException("Error performing query.", Util.unwindException(e));
        }
        this.unfetchedObjects = elementsList.size();
    }

    public void resolveAll() {
        this.resolveInterval(0, this.size());
    }

    private void validateListObject(Object object) throws IllegalArgumentException {
        if (this.internalQuery.isFetchingDataRows()) {
            if (!(object instanceof Map)) {
                throw new IllegalArgumentException("Only Map objects can be stored in this list.");
            }
        } else if (!(object instanceof Persistent)) {
            throw new IllegalArgumentException("Only DataObjects can be stored in this list.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveInterval(int fromIndex, int toIndex) {
        if (fromIndex >= toIndex) {
            return;
        }
        List list = this.elements;
        synchronized (list) {
            if (this.elements.size() == 0) {
                return;
            }
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            if (toIndex > this.elements.size()) {
                toIndex = this.elements.size();
            }
            ArrayList<Expression> quals = new ArrayList<Expression>(this.pageSize);
            ArrayList ids = new ArrayList(this.pageSize);
            for (int i = fromIndex; i < toIndex; ++i) {
                Object object = this.elements.get(i);
                if (!this.helper.unresolvedSuspect(object)) continue;
                quals.add(this.buildIdQualifier(object));
                ids.add(object);
            }
            int qualsSize = quals.size();
            if (qualsSize == 0) {
                return;
            }
            boolean fetchesDataRows = this.internalQuery.isFetchingDataRows();
            ArrayList objects = new ArrayList(qualsSize);
            int fetchEnd = Math.min(qualsSize, this.maxFetchSize);
            int fetchBegin = 0;
            while (fetchBegin < qualsSize) {
                SelectQuery query = new SelectQuery(this.rootEntity, ExpressionFactory.joinExp(1, quals.subList(fetchBegin, fetchEnd)));
                query.setFetchingDataRows(fetchesDataRows);
                if (!query.isFetchingDataRows()) {
                    query.setPrefetchTree(this.internalQuery.getPrefetchTree());
                }
                objects.addAll(this.dataContext.performQuery(query));
                fetchBegin = fetchEnd;
                fetchEnd += Math.min(this.maxFetchSize, qualsSize - fetchEnd);
            }
            this.checkPageResultConsistency(objects, ids);
            Iterator it = objects.iterator();
            while (it.hasNext()) {
                this.helper.updateWithResolvedObjectInRange(it.next(), fromIndex, toIndex);
            }
            this.unfetchedObjects -= objects.size();
        }
    }

    Expression buildIdQualifier(Object id) {
        Map map = (Map)id;
        if (map.isEmpty()) {
            throw new CayenneRuntimeException("Empty id map");
        }
        return ExpressionFactory.matchAllDbExp(map, 3);
    }

    void checkPageResultConsistency(List<?> objects, List<?> ids) {
        if (objects.size() < ids.size()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Some ObjectIds are missing from the database. ");
            buffer.append("Expected ").append(ids.size()).append(", fetched ").append(objects.size());
            boolean first = true;
            for (Object id : ids) {
                boolean found = false;
                for (Object object : objects) {
                    if (!this.helper.replacesObject(object, id)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(id.toString());
            }
            throw new CayenneRuntimeException(buffer.toString());
        }
        if (objects.size() > ids.size()) {
            throw new CayenneRuntimeException("Expected " + ids.size() + " objects, retrieved " + objects.size());
        }
    }

    public int pageIndex(int elementIndex) {
        if (elementIndex < 0 || elementIndex > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + elementIndex);
        }
        if (this.pageSize <= 0 || elementIndex < 0) {
            return -1;
        }
        return elementIndex / this.pageSize;
    }

    public int getMaxFetchSize() {
        return this.maxFetchSize;
    }

    public void setMaxFetchSize(int fetchSize) {
        this.maxFetchSize = fetchSize;
    }

    public DataContext getDataContext() {
        return this.dataContext;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new IncrementalListIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new IncrementalListIterator(index);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int listIndex = 0;

            @Override
            public boolean hasNext() {
                return this.listIndex < IncrementalFaultList.this.elements.size();
            }

            @Override
            public E next() {
                if (this.listIndex >= IncrementalFaultList.this.elements.size()) {
                    throw new NoSuchElementException("no more elements");
                }
                return IncrementalFaultList.this.get(this.listIndex++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not supported.");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, Object element) {
        this.validateListObject(element);
        List list = this.elements;
        synchronized (list) {
            this.elements.add(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Object o) {
        this.validateListObject(o);
        List list = this.elements;
        synchronized (list) {
            return this.elements.add(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        List list = this.elements;
        synchronized (list) {
            return this.elements.addAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        List list = this.elements;
        synchronized (list) {
            return this.elements.addAll(index, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        List list = this.elements;
        synchronized (list) {
            this.elements.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        List list = this.elements;
        synchronized (list) {
            return this.elements.contains(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        List list = this.elements;
        synchronized (list) {
            return this.elements.containsAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int index) {
        List list = this.elements;
        synchronized (list) {
            Object o = this.elements.get(index);
            if (this.helper.unresolvedSuspect(o)) {
                int pageStart = this.pageIndex(index) * this.pageSize;
                this.resolveInterval(pageStart, pageStart + this.pageSize);
                return this.elements.get(index);
            }
            return o;
        }
    }

    @Override
    public int indexOf(Object o) {
        return this.helper.indexOfObject(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        List list = this.elements;
        synchronized (list) {
            return this.elements.isEmpty();
        }
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.helper.lastIndexOfObject(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        List list = this.elements;
        synchronized (list) {
            E object = this.get(index);
            this.elements.remove(index);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        List list = this.elements;
        synchronized (list) {
            return this.elements.remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        List list = this.elements;
        synchronized (list) {
            return this.elements.removeAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        List list = this.elements;
        synchronized (list) {
            return this.elements.retainAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, Object element) {
        this.validateListObject(element);
        List list = this.elements;
        synchronized (list) {
            return (E)this.elements.set(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        List list = this.elements;
        synchronized (list) {
            return this.elements.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        List list = this.elements;
        synchronized (list) {
            this.resolveInterval(fromIndex, toIndex);
            return this.elements.subList(fromIndex, toIndex);
        }
    }

    @Override
    public Object[] toArray() {
        this.resolveAll();
        return this.elements.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.resolveAll();
        return this.elements.toArray(a);
    }

    public int getUnfetchedObjects() {
        return this.unfetchedObjects;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IncrementalListIterator
    implements ListIterator<E> {
        int listIndex;

        public IncrementalListIterator(int startIndex) {
            this.listIndex = startIndex;
        }

        @Override
        public void add(Object o) {
            throw new UnsupportedOperationException("add operation not supported");
        }

        @Override
        public boolean hasNext() {
            return this.listIndex < IncrementalFaultList.this.elements.size();
        }

        @Override
        public boolean hasPrevious() {
            return this.listIndex > 0;
        }

        @Override
        public E next() {
            if (this.listIndex >= IncrementalFaultList.this.elements.size()) {
                throw new NoSuchElementException("at the end of the list");
            }
            return IncrementalFaultList.this.get(this.listIndex++);
        }

        @Override
        public int nextIndex() {
            return this.listIndex;
        }

        @Override
        public E previous() {
            if (this.listIndex < 1) {
                throw new NoSuchElementException("at the beginning of the list");
            }
            return IncrementalFaultList.this.get(--this.listIndex);
        }

        @Override
        public int previousIndex() {
            return this.listIndex - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove operation not supported");
        }

        @Override
        public void set(Object o) {
            IncrementalFaultList.this.set(this.listIndex - 1, o);
        }
    }

    class DataRowListHelper
    extends IncrementalListHelper {
        DataRowListHelper() {
        }

        boolean unresolvedSuspect(Object object) {
            return !(object instanceof Map);
        }

        boolean objectsAreEqual(Object object, Object objectInTheList) {
            if (object == null && objectInTheList == null) {
                return true;
            }
            if (object != null && objectInTheList != null) {
                Map id = (Map)objectInTheList;
                Map map = (Map)object;
                if (id.size() != map.size()) {
                    return false;
                }
                for (Map.Entry entry : id.entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (Util.nullSafeEquals(value, map.get(key))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        boolean replacesObject(Object object, Object objectInTheList) {
            Map id = (Map)objectInTheList;
            if (id.size() > IncrementalFaultList.this.idWidth) {
                return false;
            }
            Map map = (Map)object;
            for (Map.Entry entry : id.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (Util.nullSafeEquals(value, map.get(key))) continue;
                return false;
            }
            return true;
        }
    }

    class PersistentListHelper
    extends IncrementalListHelper {
        PersistentListHelper() {
        }

        boolean unresolvedSuspect(Object object) {
            return !(object instanceof Persistent);
        }

        boolean objectsAreEqual(Object object, Object objectInTheList) {
            if (objectInTheList instanceof Persistent) {
                return object == objectInTheList;
            }
            return ((Object)((Persistent)object).getObjectId().getIdSnapshot()).equals(objectInTheList);
        }

        boolean replacesObject(Object object, Object objectInTheList) {
            if (objectInTheList instanceof Persistent) {
                return false;
            }
            Persistent dataObject = (Persistent)object;
            return ((Object)dataObject.getObjectId().getIdSnapshot()).equals(objectInTheList);
        }
    }

    abstract class IncrementalListHelper {
        IncrementalListHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int indexOfObject(Object object) {
            if (this.unresolvedSuspect(object)) {
                return -1;
            }
            List list = IncrementalFaultList.this.elements;
            synchronized (list) {
                for (int i = 0; i < IncrementalFaultList.this.elements.size(); ++i) {
                    if (!this.objectsAreEqual(object, IncrementalFaultList.this.elements.get(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int lastIndexOfObject(Object object) {
            if (this.unresolvedSuspect(object)) {
                return -1;
            }
            List list = IncrementalFaultList.this.elements;
            synchronized (list) {
                for (int i = IncrementalFaultList.this.elements.size() - 1; i >= 0; --i) {
                    if (!this.objectsAreEqual(object, IncrementalFaultList.this.elements.get(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateWithResolvedObjectInRange(Object object, int from, int to) {
            boolean found = false;
            List list = IncrementalFaultList.this.elements;
            synchronized (list) {
                for (int i = from; i < to; ++i) {
                    if (!this.replacesObject(object, IncrementalFaultList.this.elements.get(i))) continue;
                    IncrementalFaultList.this.elements.set(i, object);
                    found = true;
                    break;
                }
            }
            if (!found) {
                throw new CayenneRuntimeException("Can't find id for " + object);
            }
        }

        abstract boolean unresolvedSuspect(Object var1);

        abstract boolean objectsAreEqual(Object var1, Object var2);

        abstract boolean replacesObject(Object var1, Object var2);
    }
}

