/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.commons.collections.Transformer;

public class RowDescriptorBuilder {
    private static final Transformer UPPERCASE_TRANSFORMER = new Transformer(){

        public Object transform(Object input) {
            return input != null ? input.toString().toUpperCase() : null;
        }
    };
    private static final Transformer LOWERCASE_TRANSFORMER = new Transformer(){

        public Object transform(Object input) {
            return input != null ? input.toString().toLowerCase() : null;
        }
    };
    protected ColumnDescriptor[] columns;
    protected ResultSetMetaData resultSetMetadata;
    protected Transformer caseTransformer;
    protected Map<String, String> typeOverrides;

    public RowDescriptor getDescriptor(ExtendedTypeMap typeMap) throws SQLException, IllegalStateException {
        ColumnDescriptor[] columnsForRD;
        if (this.resultSetMetadata != null) {
            columnsForRD = this.mergeResultSetAndPresetColumns();
        } else if (this.columns != null) {
            columnsForRD = this.columns;
        } else {
            throw new IllegalStateException("Can't build RowDescriptor, both 'columns' and 'resultSetMetadata' are null");
        }
        this.performTransformAndTypeOverride(columnsForRD);
        ExtendedType[] converters = new ExtendedType[columnsForRD.length];
        for (int i = 0; i < columnsForRD.length; ++i) {
            converters[i] = typeMap.getRegisteredType(columnsForRD[i].getJavaClass());
        }
        return new RowDescriptor(columnsForRD, converters);
    }

    protected ColumnDescriptor[] mergeResultSetAndPresetColumns() throws SQLException {
        int columnLen;
        int rsLen = this.resultSetMetadata.getColumnCount();
        if (rsLen == 0) {
            throw new CayenneRuntimeException("'ResultSetMetadata' is empty.");
        }
        int n = columnLen = this.columns != null ? this.columns.length : 0;
        if (rsLen < columnLen) {
            throw new CayenneRuntimeException("'ResultSetMetadata' has less elements then 'columns'.");
        }
        if (rsLen == columnLen) {
            return this.columns;
        }
        ColumnDescriptor[] rsColumns = new ColumnDescriptor[rsLen];
        int outputLen = 0;
        for (int i = 0; i < rsLen; ++i) {
            String rowkey = this.resolveDataRowKeyFromResultSet(i + 1);
            if (rowkey.length() == 0) continue;
            rsColumns[outputLen] = this.getColumnDescriptor(rowkey, this.columns, i + 1);
            ++outputLen;
        }
        if (outputLen < rsLen) {
            ColumnDescriptor[] rsColumnsCut = new ColumnDescriptor[outputLen];
            System.arraycopy(rsColumns, 0, rsColumnsCut, 0, outputLen);
            return rsColumnsCut;
        }
        return rsColumns;
    }

    private ColumnDescriptor getColumnDescriptor(String rowKey, ColumnDescriptor[] columnArray, int position) throws SQLException {
        int len = columnArray != null ? columnArray.length : 0;
        for (int i = 0; i < len; ++i) {
            String columnRowKey;
            if (columnArray[i] == null || (columnRowKey = columnArray[i].getDataRowKey()) == null || !columnRowKey.equalsIgnoreCase(rowKey)) continue;
            return columnArray[i];
        }
        return new ColumnDescriptor(rowKey, this.resultSetMetadata.getColumnType(position), this.resultSetMetadata.getColumnClassName(position));
    }

    private String resolveDataRowKeyFromResultSet(int position) throws SQLException {
        String name = this.resultSetMetadata.getColumnLabel(position);
        if ((name == null || name.length() == 0) && (name = this.resultSetMetadata.getColumnName(position)) == null) {
            name = "";
        }
        return name;
    }

    private void performTransformAndTypeOverride(ColumnDescriptor[] columnArray) {
        int i;
        int len = columnArray.length;
        if (this.caseTransformer != null) {
            for (i = 0; i < len; ++i) {
                columnArray[i].setDataRowKey((String)this.caseTransformer.transform(columnArray[i].getDataRowKey()));
                columnArray[i].setName((String)this.caseTransformer.transform(columnArray[i].getName()));
            }
        }
        if (this.typeOverrides != null) {
            for (i = 0; i < len; ++i) {
                String type = this.typeOverrides.get(columnArray[i].getName());
                if (type == null) continue;
                columnArray[i].setJavaClass(type);
            }
        }
    }

    public RowDescriptorBuilder setColumns(ColumnDescriptor[] columns) {
        this.columns = columns;
        return this;
    }

    public RowDescriptorBuilder setResultSet(ResultSet resultSet) throws SQLException {
        this.resultSetMetadata = resultSet.getMetaData();
        return this;
    }

    public RowDescriptorBuilder useLowercaseColumnNames() {
        this.caseTransformer = LOWERCASE_TRANSFORMER;
        return this;
    }

    public RowDescriptorBuilder useUppercaseColumnNames() {
        this.caseTransformer = UPPERCASE_TRANSFORMER;
        return this;
    }

    public RowDescriptorBuilder overrideColumnType(String columnName, String type) {
        if (this.typeOverrides == null) {
            this.typeOverrides = new HashMap<String, String>();
        }
        this.typeOverrides.put(columnName, type);
        return this;
    }

    public boolean isOverriden(String columnName) {
        return this.typeOverrides != null && this.typeOverrides.containsKey(columnName);
    }
}

