/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.cayenne.access.types.AbstractType;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.validation.ValidationResult;

public class BooleanType
implements ExtendedType {
    public String getClassName() {
        return Boolean.class.getName();
    }

    public boolean validateProperty(Object source, String property, Object value, DbAttribute dbAttribute, ValidationResult validationResult) {
        return AbstractType.validateNull(source, property, value, dbAttribute, validationResult);
    }

    public void setJdbcObject(PreparedStatement st, Object val, int pos, int type, int precision) throws Exception {
        if (val == null) {
            st.setNull(pos, type);
        } else if (type == -7 || type == 16) {
            boolean flag = Boolean.TRUE.equals(val);
            st.setBoolean(pos, flag);
        } else {
            st.setObject(pos, val, type);
        }
    }

    public Object materializeObject(ResultSet rs, int index, int type) throws Exception {
        boolean b = rs.getBoolean(index);
        return rs.wasNull() ? null : (b ? Boolean.TRUE : Boolean.FALSE);
    }

    public Object materializeObject(CallableStatement st, int index, int type) throws Exception {
        boolean b = st.getBoolean(index);
        return st.wasNull() ? null : (b ? Boolean.TRUE : Boolean.FALSE);
    }
}

