/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.codegen;

import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.gen.ClientClassGenerationAction;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.dialog.codegen.CodeGeneratorControllerBase;
import org.apache.cayenne.modeler.dialog.codegen.StandardModeController;
import org.apache.cayenne.modeler.pref.DataMapDefaults;
import org.apache.cayenne.validation.BeanValidationFailure;
import org.apache.cayenne.validation.ValidationResult;
import org.apache.commons.collections.Predicate;

public class ClientModeController
extends StandardModeController {
    protected Predicate checkPredicate = new Predicate(){

        public boolean evaluate(Object object) {
            if (object instanceof ObjEntity) {
                ObjEntity entity = (ObjEntity)object;
                return entity.isClientAllowed() && ClientModeController.this.getParentController().getProblem(entity.getName()) == null;
            }
            return false;
        }
    };

    public ClientModeController(CodeGeneratorControllerBase parent) {
        super(parent);
    }

    public void validateEntity(ValidationResult validationBuffer, ObjEntity entity) {
        if (!entity.isClientAllowed()) {
            validationBuffer.addFailure(new BeanValidationFailure(entity.getName(), "clientAllowed", "Not a client entity"));
        } else {
            super.validateEntity(validationBuffer, entity, true);
        }
    }

    protected DataMapDefaults createDefaults() {
        DataMapDefaults prefs = this.getApplication().getFrameController().getProjectController().getDataMapPreferences("__client");
        prefs.updateSuperclassPackage(this.getParentController().getDataMap(), true);
        this.preferences = prefs;
        return prefs;
    }

    protected ClassGenerationAction newGenerator() {
        return new ClientClassGenerationAction();
    }

    public Predicate getDefaultEntityFilter() {
        return this.checkPredicate;
    }
}

