/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db;

import java.sql.Connection;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.modeler.ClassLoadingService;
import org.apache.cayenne.modeler.dialog.db.DataSourceWizard;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.modeler.util.CayenneController;

public class ConnectionWizard
extends DataSourceWizard {
    protected Connection connection;
    protected DbAdapter adapter;

    public ConnectionWizard(CayenneController parent, String title, String altDataSourceKey, DBConnectionInfo altDataSource) {
        super(parent, title, altDataSourceKey, altDataSource);
    }

    public void okAction() {
        DBConnectionInfo info = this.getConnectionInfo();
        ClassLoadingService classLoader = this.getApplication().getClassLoadingService();
        try {
            this.adapter = info.makeAdapter(classLoader);
        }
        catch (Throwable th) {
            this.reportError("DbAdapter Error", th);
            return;
        }
        try {
            this.connection = info.makeDataSource(classLoader).getConnection();
        }
        catch (Throwable th) {
            this.reportError("Connection Error", th);
            return;
        }
        this.canceled = false;
        this.view.dispose();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public DbAdapter getAdapter() {
        return this.adapter;
    }
}

