/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.pref;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conf.DataSourceFactory;
import org.apache.cayenne.conn.PoolManager;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.pref.DomainPreference;
import org.apache.cayenne.pref.HSQLEmbeddedPreferenceService;
import org.apache.cayenne.project.CayenneUserDir;
import org.apache.cayenne.query.SelectQuery;

public class PreferencesDataSourceFactory
implements DataSourceFactory {
    protected int minPoolSize;
    protected int maxPoolSize;

    public PreferencesDataSourceFactory() {
        this(1, 5);
    }

    public PreferencesDataSourceFactory(int minPoolSize, int maxPoolSize) {
        this.minPoolSize = minPoolSize;
        this.maxPoolSize = maxPoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void initializeWithParentConfiguration(Configuration configuaration) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource getDataSource(final String location) throws Exception {
        File dbDir;
        if (location == null) {
            throw new NullPointerException("Null location");
        }
        String configuredName = System.getProperty("cayenne.modeler.application.name");
        String name = configuredName != null ? configuredName : "CayenneModeler";
        String subdir = System.getProperty("cayenne.modeler.pref.version");
        if (subdir == null) {
            subdir = "1.2";
        }
        if (!(dbDir = new File(CayenneUserDir.getInstance().resolveFile("prefs"), subdir)).isDirectory()) {
            throw new CayenneRuntimeException("No preferences database directory exists: " + dbDir);
        }
        if (!new File(dbDir, "db.properties").exists()) {
            throw new CayenneRuntimeException("No preferences database exists in directory " + dbDir);
        }
        String preferencesDB = new File(dbDir, "db").getAbsolutePath();
        HSQLEmbeddedPreferenceService service = new HSQLEmbeddedPreferenceService(preferencesDB, "pref", name){

            protected void startTimer() {
            }

            protected void initPreferences() {
            }

            protected void initSchema() {
                throw new CayenneRuntimeException("No preferences matching location: " + location);
            }
        };
        try {
            service.startService();
            DataSource dataSource = this.toDataSource(service.getDataContext(), location);
            return dataSource;
        }
        finally {
            try {
                service.stopService();
            }
            catch (Throwable th) {}
        }
    }

    DataSource toDataSource(DataContext context, String location) throws Exception {
        Map params;
        Expression locationFilter = ExpressionFactory.matchExp("key", location);
        List preferences = context.performQuery(new SelectQuery(DomainPreference.class, locationFilter));
        if (preferences.isEmpty()) {
            throw new CayenneRuntimeException("No preferences matching location: " + location);
        }
        ArrayList<Object> ids = new ArrayList<Object>(preferences.size());
        for (DomainPreference pref : preferences) {
            ids.add(DataObjectUtils.pkForObject(pref));
        }
        Expression qualifier = Expression.fromString("db:id in $ids");
        SelectQuery query = new SelectQuery(DBConnectionInfo.class, qualifier.expWithParameters(params = Collections.singletonMap("ids", ids)));
        List connectionData = context.performQuery(query);
        if (connectionData.isEmpty()) {
            throw new CayenneRuntimeException("No preferences matching location: " + location);
        }
        if (connectionData.size() > 1) {
            throw new CayenneRuntimeException("More than one preference matched location: " + location);
        }
        DBConnectionInfo info = (DBConnectionInfo)connectionData.get(0);
        if (info.getJdbcDriver() == null) {
            throw new CayenneRuntimeException("Incomplete connection info: no JDBC driver set.");
        }
        if (info.getUrl() == null) {
            throw new SQLException("Incomplete connection info: no DB URL set.");
        }
        return new PoolManager(info.getJdbcDriver(), info.getUrl(), 1, 5, info.getUserName(), info.getPassword());
    }
}

