/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail2.javax;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.mail.Authenticator;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.mail2.core.EmailException;
import org.apache.commons.mail2.javax.AbstractEmailTest;
import org.apache.commons.mail2.javax.DataSourceResolver;
import org.apache.commons.mail2.javax.DefaultAuthenticator;
import org.apache.commons.mail2.javax.Email;
import org.apache.commons.mail2.javax.EmailAttachment;
import org.apache.commons.mail2.javax.HtmlEmail;
import org.apache.commons.mail2.javax.ImageHtmlEmail;
import org.apache.commons.mail2.javax.MultiPartEmail;
import org.apache.commons.mail2.javax.SimpleEmail;
import org.apache.commons.mail2.javax.resolver.DataSourceUrlResolver;
import org.apache.commons.mail2.javax.settings.EmailConfiguration;
import org.apache.commons.mail2.javax.util.MimeMessageUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class EmailLiveTest
extends AbstractEmailTest {
    private Email create(Class<? extends Email> clazz) throws Exception {
        Email email = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        email.setStartTLSEnabled(true);
        email.setStartTLSRequired(true);
        email.setSSLOnConnect(false);
        email.setSSLCheckServerIdentity(false);
        email.setHostName("localhost");
        email.setSmtpPort(25);
        email.setBounceAddress("test_from@apache.org");
        email.setDebug(false);
        email.setCharset(EmailConfiguration.MAIL_CHARSET);
        email.setFrom("test_from@apache.org");
        email.addTo("test_to@apache.org");
        email.setAuthenticator((Authenticator)new DefaultAuthenticator("user", "password"));
        return email;
    }

    protected String getFromUrl(URL url) throws Exception {
        URLDataSource dataSource = new URLDataSource(url);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream inputStream = dataSource.getInputStream();){
            IOUtils.copy((InputStream)inputStream, (OutputStream)baos);
        }
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }

    protected Email send(Email email) throws EmailException {
        email.buildMimeMessage();
        return email;
    }

    @BeforeEach
    public void setUpLiveTest() {
        System.setProperty("mail.mime.charset", StandardCharsets.UTF_8.name());
        System.setProperty("mail.mime.encodefilename", "true");
    }

    @Test
    public void testCorrectCharacterEncoding() throws Exception {
        String subject = "[email] 5.Test: Subject with three greek UTF-8 characters : \u03b1\u03b2\u03b3";
        String textMsg = "My test body with three greek UTF-8 characters : \u03b1\u03b2\u03b3\n";
        String attachmentName = "\u03b1\u03b2\u03b3.txt";
        MultiPartEmail email = (MultiPartEmail)this.create(MultiPartEmail.class);
        email.setSubject("[email] 5.Test: Subject with three greek UTF-8 characters : \u03b1\u03b2\u03b3");
        email.setMsg("My test body with three greek UTF-8 characters : \u03b1\u03b2\u03b3\n");
        ByteArrayDataSource attachment = new ByteArrayDataSource("My test body with three greek UTF-8 characters : \u03b1\u03b2\u03b3\n".getBytes(StandardCharsets.UTF_8), "text/plain");
        email.attach((DataSource)attachment, "\u03b1\u03b2\u03b3.txt", "Attachment in Greek");
        MimeMessageUtils.writeMimeMessage((MimeMessage)this.send((Email)email).getMimeMessage(), (File)new File("./target/test-emails/correct-encoding.eml"));
    }

    @Test
    public void testFoldedHeaderValue() throws Exception {
        SimpleEmail email = (SimpleEmail)this.create(SimpleEmail.class);
        email.setSubject("TestFoldedHeaderMail");
        email.setMsg("This is a test mail with a folded header value... :-)");
        email.addHeader("X-TestHeader", "This is a very long header value which should be folded into two lines, hopefully");
        MimeMessageUtils.writeMimeMessage((MimeMessage)this.send((Email)email).getMimeMessage(), (File)new File("./target/test-emails/foldedheader.eml"));
    }

    @Test
    public void testHtmlMailMimeLayout() throws Exception {
        URL url = new URL(EmailConfiguration.TEST_URL);
        File imageFile = new File("./src/test/resources/images/asf_logo_wide.gif");
        EmailAttachment attachment = new EmailAttachment();
        File attachmentFile = new File("./src/test/resources/attachments/logo.pdf");
        attachment.setName("logo.pdf");
        attachment.setDescription("The official Apache logo");
        attachment.setPath(attachmentFile.getAbsolutePath());
        HtmlEmail htmlEmail1 = (HtmlEmail)this.create(HtmlEmail.class);
        String textMsg = "Your email client does not support HTML messages";
        String htmlMsg = "<html><b>This is a HTML message without any image</b><html>";
        htmlEmail1.setSubject("[email] 1.Test: text + html content");
        htmlEmail1.setTextMsg(textMsg);
        htmlEmail1.setHtmlMsg(htmlMsg);
        MimeMessageUtils.writeMimeMessage((MimeMessage)this.send((Email)htmlEmail1).getMimeMessage(), (File)new File("./target/test-emails/htmlemail1.eml"));
        HtmlEmail htmlEmail2 = (HtmlEmail)this.create(HtmlEmail.class);
        textMsg = "Your email client does not support HTML messages";
        htmlMsg = "<html><b>This is a HTML message with an image attachment</b><html>";
        htmlEmail2.setSubject("[email] 2.Test: text + html content + image as attachment");
        htmlEmail2.setTextMsg(textMsg);
        htmlEmail2.setHtmlMsg(htmlMsg);
        htmlEmail2.attach(url, "Apache Logo", "The official Apache logo");
        MimeMessageUtils.writeMimeMessage((MimeMessage)this.send((Email)htmlEmail2).getMimeMessage(), (File)new File("./target/test-emails/htmlemail2.eml"));
        HtmlEmail htmlEmail3 = (HtmlEmail)this.create(HtmlEmail.class);
        textMsg = "Your email client does not support HTML messages";
        String cid = htmlEmail3.embed(imageFile, "Apache Logo");
        htmlMsg = "<html><b>This is a HTML message with an inline image - <img src=\"cid:" + cid + "\"> and NO attachment</b><html>";
        htmlEmail3.setSubject("[email] 3.Test: text + html content + inline image");
        htmlEmail3.setTextMsg(textMsg);
        htmlEmail3.setHtmlMsg(htmlMsg);
        MimeMessageUtils.writeMimeMessage((MimeMessage)this.send((Email)htmlEmail3).getMimeMessage(), (File)new File("./target/test-emails/htmlemail3.eml"));
        HtmlEmail htmlEmail4 = (HtmlEmail)this.create(HtmlEmail.class);
        textMsg = "Your email client does not support HTML messages";
        cid = htmlEmail4.embed(imageFile, "Apache Logo");
        htmlMsg = "<html><b>This is a HTML message with an inline image - <img src=\"cid:" + cid + "\"> and attachment</b><html>";
        htmlEmail4.setSubject("[email] 4.Test: text + html content + inline image + attachment");
        htmlEmail4.setTextMsg(textMsg);
        htmlEmail4.setHtmlMsg(htmlMsg);
        htmlEmail4.attach(attachment);
        MimeMessageUtils.writeMimeMessage((MimeMessage)this.send((Email)htmlEmail4).getMimeMessage(), (File)new File("./target/test-emails/htmlemail4.eml"));
    }

    @Test
    public void testImageHtmlEmailLocal() throws Exception {
        File htmlFile = new File("./src/test/resources/html/www.apache.org.html");
        String htmlMsg1 = FileUtils.readFileToString((File)htmlFile, (String)StandardCharsets.ISO_8859_1.name());
        ImageHtmlEmail email = (ImageHtmlEmail)this.create(ImageHtmlEmail.class);
        email.setDataSourceResolver((DataSourceResolver)new DataSourceUrlResolver(htmlFile.getParentFile().toURI().toURL(), false));
        email.setSubject("[testImageHtmlEmail] 1.Test: simple html content");
        email.setHtmlMsg(htmlMsg1);
        MimeMessageUtils.writeMimeMessage((MimeMessage)this.send((Email)email).getMimeMessage(), (File)new File("./target/test-emails/testImageHtmlEmailLocal.eml"));
    }

    @Test
    public void testImageHtmlEmailRemote() throws Exception {
    }

    @Test
    public void testMultiPartEmailFile() throws Exception {
        MultiPartEmail email = (MultiPartEmail)this.create(MultiPartEmail.class);
        email.setSubject("TestMultiPartMail");
        email.setMsg("This is a test mail ... :-)");
        email.attach(new File("./src/test/resources/attachments/logo.pdf"));
        MimeMessageUtils.writeMimeMessage((MimeMessage)this.send((Email)email).getMimeMessage(), (File)new File("./target/test-emails/multipart.eml"));
    }

    @Test
    public void testMultiPartEmailPath() throws Exception {
        MultiPartEmail email = (MultiPartEmail)this.create(MultiPartEmail.class);
        email.setSubject("TestMultiPartMail");
        email.setMsg("This is a test mail ... :-)");
        email.attach(Paths.get("./src/test/resources/attachments/logo.pdf", new String[0]), new OpenOption[0]);
        MimeMessageUtils.writeMimeMessage((MimeMessage)this.send((Email)email).getMimeMessage(), (File)new File("./target/test-emails/multipart.eml"));
    }

    @Test
    public void testPartialSend() throws Exception {
        SimpleEmail email = (SimpleEmail)this.create(SimpleEmail.class);
        email.addTo("test_to@apache.org");
        email.addTo("nobody@is.invalid");
        email.setSubject("TestPartialMail");
        email.setMsg("This is a test mail ... :-)");
        email.setSendPartial(true);
        MimeMessageUtils.writeMimeMessage((MimeMessage)this.send((Email)email).getMimeMessage(), (File)new File("./target/test-emails/partialmail.eml"));
    }

    @Test
    public void testSendingEmailsInBatch() throws Exception {
        ArrayList<SimpleEmail> emails = new ArrayList<SimpleEmail>();
        Session session = this.create(SimpleEmail.class).getMailSession();
        try (Transport transport = session.getTransport();){
            for (int i = 0; i < 3; ++i) {
                SimpleEmail personalizedEmail = (SimpleEmail)this.create(SimpleEmail.class);
                personalizedEmail.setMailSession(session);
                personalizedEmail.setSubject("Personalized Test Mail Nr. " + i);
                personalizedEmail.setMsg("This is a personalized test mail ... :-)");
                personalizedEmail.buildMimeMessage();
                emails.add(personalizedEmail);
            }
        }
    }

    @Test
    public void testSimpleEmail() throws Exception {
        SimpleEmail email = (SimpleEmail)this.create(SimpleEmail.class);
        email.setSubject("TestSimpleMail");
        email.setMsg("This is a test mail ... :-)");
        MimeMessageUtils.writeMimeMessage((MimeMessage)this.send((Email)email).getMimeMessage(), (File)new File("./target/test-emails/simplemail.eml"));
    }
}

