/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.compilers;

import org.apache.commons.jci.problems.CompilationProblem;
import org.codehaus.groovy.control.messages.ExceptionMessage;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;

public final class GroovyCompilationProblem
implements CompilationProblem {
    private final String fileName;
    private final String message;
    private final boolean error;
    private final int startLine;
    private final int startColumn;
    private final int endLine;
    private final int endColumn;

    public GroovyCompilationProblem(Message pMessage) {
        this.error = !(pMessage instanceof SimpleMessage);
        if (pMessage instanceof SyntaxErrorMessage) {
            SyntaxErrorMessage syntaxErrorMessage = (SyntaxErrorMessage)pMessage;
            SyntaxException syntaxException = syntaxErrorMessage.getCause();
            this.message = syntaxException.getMessage();
            this.fileName = syntaxException.getSourceLocator();
            this.startLine = syntaxException.getStartLine();
            this.startColumn = syntaxException.getStartColumn();
            this.endLine = syntaxException.getLine();
            this.endColumn = syntaxException.getEndColumn();
        } else {
            this.fileName = "";
            this.startLine = 0;
            this.startColumn = 0;
            this.endLine = 0;
            this.endColumn = 0;
            this.message = pMessage instanceof ExceptionMessage ? ((ExceptionMessage)pMessage).getCause().getMessage() : (pMessage instanceof SimpleMessage ? ((SimpleMessage)pMessage).getMessage() : pMessage.toString());
        }
    }

    public boolean isError() {
        return this.error;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.getMessage();
    }
}

