/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.core;

import java.io.StringWriter;
import java.io.Writer;
import junit.framework.TestSuite;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.test.BaseJellyTest;
import org.dom4j.io.HTMLWriter;
import org.dom4j.io.OutputFormat;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class TestFileTag
extends BaseJellyTest {
    public TestFileTag(String name) {
        super(name);
    }

    public static TestSuite suite() throws Exception {
        return new TestSuite(TestFileTag.class);
    }

    public void testSimpleFileTag() throws Exception {
        this.setUpScript("testFileTag.jelly");
        Script script = this.getJelly().compileScript();
        script.run(this.getJellyContext(), this.getXMLOutput());
        String data = (String)this.getJellyContext().getVariable("testFileTag");
        TestFileTag.assertEquals((String)"fully qualified attributes not passed", (String)"<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\"></html>", (String)data);
    }

    public void testDom4Xmlns() throws SAXException {
        StringWriter writer = new StringWriter();
        OutputFormat format = new OutputFormat();
        HTMLWriter xmlWriter = new HTMLWriter((Writer)writer, format);
        xmlWriter.setEscapeText(false);
        XMLOutput output = new XMLOutput((ContentHandler)xmlWriter, (LexicalHandler)xmlWriter);
        String golden = "<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">\n";
        golden = golden + "<html>";
        output.startDocument();
        output.write(golden);
        output.endDocument();
        TestFileTag.assertEquals((String)"output should contain the namespaces", (String)golden, (String)writer.toString());
    }
}

