/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.test.xml;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.jelly.Jelly;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;

public class TestXMLParserCache
extends TestCase {
    Jelly jelly = null;
    JellyContext context = null;
    XMLOutput xmlOutput = null;

    public TestXMLParserCache(String name) {
        super(name);
    }

    public static TestSuite suite() throws Exception {
        return new TestSuite(TestXMLParserCache.class);
    }

    public void setUp(String scriptName) throws Exception {
        this.context = new JellyContext();
        this.xmlOutput = XMLOutput.createXMLOutput((Writer)new StringWriter());
        this.jelly = new Jelly();
        String script = scriptName;
        URL url = ((Object)((Object)this)).getClass().getResource(script);
        if (url == null) {
            throw new Exception("Could not find Jelly script: " + script + " in package of class: " + ((Object)((Object)this)).getClass().getName());
        }
        this.jelly.setUrl(url);
    }

    public void testParserCache1() throws Exception {
        this.setUp("invalidScript1.jelly");
        this.jelly.setValidateXML(false);
        Script script = this.jelly.compileScript();
        script.run(this.context, this.xmlOutput);
        TestXMLParserCache.assertTrue((String)"should have set 'foo' variable to 'bar'", (boolean)this.context.getVariable("foo").equals("bar"));
        this.jelly.setValidateXML(true);
        try {
            script = this.jelly.compileScript();
            TestXMLParserCache.fail((String)"Invalid scripts should throw JellyException on parse, despite the cache");
        }
        catch (JellyException jellyException) {
            // empty catch block
        }
    }

    public void testParserCache2() throws Exception {
        this.setUp("nsFilterTest.jelly");
        Script script = this.jelly.compileScript();
        script.run(this.context, this.xmlOutput);
        TestXMLParserCache.assertTrue((String)"should have no var when default namspace is not set", (this.context.getVariable("usedDefaultNamespace") == null ? 1 : 0) != 0);
        this.jelly.setDefaultNamespaceURI("jelly:core");
        script = this.jelly.compileScript();
        script.run(this.context, this.xmlOutput);
        TestXMLParserCache.assertTrue((String)"should have var when default namspace is set", (boolean)this.context.getVariable("usedDefaultNamespace").equals("true"));
    }
}

