/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.io.File;
import java.net.URL;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.Assert;
import org.junit.Test;

public class ScriptTest
extends JexlTestCase {
    static final String TEST1 = "src/test/scripts/test1.jexl";
    static final String TEST_ADD = "src/test/scripts/testAdd.jexl";

    public ScriptTest() {
        super("ScriptTest");
    }

    @Test
    public void testSpacesScript() throws Exception {
        String code = " ";
        JexlScript s = this.JEXL.createScript(" ");
        Assert.assertNotNull((Object)s);
    }

    @Test
    public void testSimpleScript() throws Exception {
        String code = "while (x < 10) x = x + 1;";
        JexlScript s = this.JEXL.createScript("while (x < 10) x = x + 1;");
        MapContext jc = new MapContext();
        jc.set("x", (Object)new Integer(1));
        Object o = s.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is wrong", (Object)new Integer(10), (Object)o);
        Assert.assertEquals((String)"getText is wrong", (Object)"while (x < 10) x = x + 1;", (Object)s.getSourceText());
    }

    @Test
    public void testScriptFromFile() throws Exception {
        File testScript = new File(TEST1);
        JexlScript s = this.JEXL.createScript(testScript);
        MapContext jc = new MapContext();
        jc.set("out", (Object)System.out);
        Object result = s.execute((JexlContext)jc);
        Assert.assertNotNull((String)"No result", (Object)result);
        Assert.assertEquals((String)"Wrong result", (Object)new Integer(7), (Object)result);
    }

    @Test
    public void testArgScriptFromFile() throws Exception {
        File testScript = new File(TEST_ADD);
        JexlScript s = this.JEXL.createScript(testScript, new String[]{"x", "y"});
        MapContext jc = new MapContext();
        jc.set("out", (Object)System.out);
        Object result = s.execute((JexlContext)jc, new Object[]{13, 29});
        Assert.assertNotNull((String)"No result", (Object)result);
        Assert.assertEquals((String)"Wrong result", (Object)new Integer(42), (Object)result);
    }

    @Test
    public void testScriptFromURL() throws Exception {
        URL testUrl = new File(TEST1).toURI().toURL();
        JexlScript s = this.JEXL.createScript(testUrl);
        MapContext jc = new MapContext();
        jc.set("out", (Object)System.out);
        Object result = s.execute((JexlContext)jc);
        Assert.assertNotNull((String)"No result", (Object)result);
        Assert.assertEquals((String)"Wrong result", (Object)new Integer(7), (Object)result);
    }

    @Test
    public void testArgScriptFromURL() throws Exception {
        URL testUrl = new File(TEST_ADD).toURI().toURL();
        JexlScript s = this.JEXL.createScript(testUrl, new String[]{"x", "y"});
        MapContext jc = new MapContext();
        jc.set("out", (Object)System.out);
        Object result = s.execute((JexlContext)jc, new Object[]{13, 29});
        Assert.assertNotNull((String)"No result", (Object)result);
        Assert.assertEquals((String)"Wrong result", (Object)new Integer(42), (Object)result);
    }

    @Test
    public void testScriptUpdatesContext() throws Exception {
        String jexlCode = "resultat.setCode('OK')";
        JexlExpression e = this.JEXL.createExpression("resultat.setCode('OK')");
        JexlScript s = this.JEXL.createScript("resultat.setCode('OK')");
        Tester resultatJexl = new Tester();
        MapContext jc = new MapContext();
        jc.set("resultat", (Object)resultatJexl);
        resultatJexl.setCode("");
        e.evaluate((JexlContext)jc);
        Assert.assertEquals((Object)"OK", (Object)resultatJexl.getCode());
        resultatJexl.setCode("");
        s.execute((JexlContext)jc);
        Assert.assertEquals((Object)"OK", (Object)resultatJexl.getCode());
    }

    public static class Tester {
        private String code;

        public String getCode() {
            return this.code;
        }

        public void setCode(String c) {
            this.code = c;
        }
    }
}

