/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.parser;

import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.parser.ASTJexlScript;
import org.apache.commons.jexl3.parser.Parser;
import org.apache.commons.jexl3.parser.StringParser;
import org.junit.Assert;
import org.junit.Test;

public class ParserTest {
    static final JexlFeatures FEATURES = new JexlFeatures();

    @Test
    public void testParse() throws Exception {
        Parser parser = new Parser(";");
        ASTJexlScript sn = parser.parse(null, FEATURES, "foo = 1;", null);
        Assert.assertNotNull((String)"parsed node is null", (Object)sn);
        sn = parser.parse(null, FEATURES, "foo = \"bar\";", null);
        Assert.assertNotNull((String)"parsed node is null", (Object)sn);
        sn = parser.parse(null, FEATURES, "foo = 'bar';", null);
        Assert.assertNotNull((String)"parsed node is null", (Object)sn);
    }

    @Test
    public void testErrorAssign() throws Exception {
        String[] ops;
        for (String op : ops = new String[]{"=", "+=", "-=", "/=", "*=", "^=", "&=", "|="}) {
            Parser parser = new Parser(";");
            try {
                ASTJexlScript sn = parser.parse(null, FEATURES, "foo() " + op + " 1;", null);
                Assert.fail((String)("should have failed on invalid assignment " + op));
            }
            catch (JexlException.Parsing xparse) {
                String ss = xparse.getDetail();
                String string = xparse.toString();
            }
        }
    }

    @Test
    public void testErrorAmbiguous() throws Exception {
        Parser parser = new Parser(";");
        try {
            ASTJexlScript sn = parser.parse(null, FEATURES, "x = 1 y = 5", null);
            Assert.fail((String)"should have failed on ambiguous statement");
        }
        catch (JexlException.Ambiguous sn) {
        }
        catch (JexlException xother) {
            Assert.fail((String)xother.toString());
        }
    }

    @Test
    public void testIdentifierEscape() {
        String[] ids;
        for (String id : ids = new String[]{"a\\ b", "a\\ b\\ c", "a\\'b\\\"c", "a\\ \\ c"}) {
            String esc0 = StringParser.unescapeIdentifier((String)id);
            Assert.assertFalse((boolean)esc0.contains("\\"));
            String esc1 = StringParser.escapeIdentifier((String)esc0);
            Assert.assertEquals((Object)id, (Object)esc1);
        }
    }

    @Test
    public void testControlCharacters() {
        String[][] strings;
        for (String[] pair : strings = new String[][]{{"a\nb\tc", "'a\nb\tc'"}, {"a\nb\tc", "'a\\nb\\tc'"}, {"a\nb\tc", "\"a\\nb\\tc\""}, {"\b\t\n\f\r", "'\\b\\t\\n\\f\\r'"}, {"'hi'", "'\\'hi\\''"}, {"\"hi\"", "'\"hi\"'"}, {"\"hi\"", "'\"hi\"'"}}) {
            String output = StringParser.buildString((CharSequence)pair[1], (boolean)true);
            Assert.assertEquals((Object)pair[0], (Object)output);
        }
    }
}

