/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PublicFieldsTest
extends JexlTestCase {
    private static final String LOWER42 = "fourty-two";
    private static final String UPPER42 = "FOURTY-TWO";
    private Struct pub;
    private JexlContext ctxt;

    public PublicFieldsTest() {
        super("PublicFieldsTest");
    }

    @Override
    @BeforeEach
    public void setUp() {
        this.pub = new Struct();
        this.ctxt = new MapContext();
        this.ctxt.set("pub", (Object)this.pub);
    }

    @Test
    void testGetEnum() throws Exception {
        this.ctxt.set("com.jexl.gender", Gender.class);
        String src = "x = com.jexl.gender.FEMALE";
        JexlScript script = this.JEXL.createScript("x = com.jexl.gender.FEMALE");
        Object result = script.execute(this.ctxt);
        Assertions.assertEquals((Object)((Object)Gender.FEMALE), (Object)result);
        Assertions.assertEquals((Object)((Object)Gender.FEMALE), (Object)this.ctxt.get("x"));
    }

    @Test
    void testGetInnerDouble() throws Exception {
        JexlExpression get = this.JEXL.createExpression("pub.inner.aDouble");
        Assertions.assertEquals((Object)42.0, (Object)get.evaluate(this.ctxt));
        this.JEXL.setProperty((Object)this.pub, "inner.aDouble", (Object)-42);
        Assertions.assertEquals((Object)-42.0, (Object)get.evaluate(this.ctxt));
    }

    @Test
    void testGetInt() throws Exception {
        JexlExpression get = this.JEXL.createExpression("pub.anInt");
        Assertions.assertEquals((Object)42, (Object)get.evaluate(this.ctxt));
        this.JEXL.setProperty((Object)this.pub, "anInt", (Object)-42);
        Assertions.assertEquals((Object)-42, (Object)get.evaluate(this.ctxt));
    }

    @Test
    void testGetStaticField() throws Exception {
        this.ctxt.set("com.jexl", Inner.class);
        String src = "x = com.jexl.NOT42";
        JexlScript script = this.JEXL.createScript("x = com.jexl.NOT42");
        Object result = script.execute(this.ctxt);
        Assertions.assertEquals((Object)Inner.NOT42, (Object)result);
        Assertions.assertEquals((Object)Inner.NOT42, (Object)this.ctxt.get("x"));
    }

    @Test
    void testGetString() throws Exception {
        JexlExpression get = this.JEXL.createExpression("pub.aString");
        Assertions.assertEquals((Object)LOWER42, (Object)get.evaluate(this.ctxt));
        this.JEXL.setProperty((Object)this.pub, "aString", (Object)UPPER42);
        Assertions.assertEquals((Object)UPPER42, (Object)get.evaluate(this.ctxt));
    }

    @Test
    void testSetInnerDouble() throws Exception {
        JexlExpression set = this.JEXL.createExpression("pub.inner.aDouble = value");
        this.ctxt.set("value", (Object)-42.0);
        Assertions.assertEquals((Object)-42.0, (Object)set.evaluate(this.ctxt));
        Assertions.assertEquals((Object)-42.0, (Object)this.JEXL.getProperty((Object)this.pub, "inner.aDouble"));
        this.ctxt.set("value", (Object)42.0);
        Assertions.assertEquals((Object)42.0, (Object)set.evaluate(this.ctxt));
        Assertions.assertEquals((Object)42.0, (Object)this.JEXL.getProperty((Object)this.pub, "inner.aDouble"));
        Assertions.assertThrows(JexlException.class, () -> {
            this.ctxt.set("value", (Object)UPPER42);
            Assertions.assertNull((Object)set.evaluate(this.ctxt));
        });
    }

    @Test
    void testSetInt() throws Exception {
        JexlExpression set = this.JEXL.createExpression("pub.anInt = value");
        this.ctxt.set("value", (Object)-42);
        Assertions.assertEquals((Object)-42, (Object)set.evaluate(this.ctxt));
        Assertions.assertEquals((Object)-42, (Object)this.JEXL.getProperty((Object)this.pub, "anInt"));
        this.ctxt.set("value", (Object)42);
        Assertions.assertEquals((Object)42, (Object)set.evaluate(this.ctxt));
        Assertions.assertEquals((Object)42, (Object)this.JEXL.getProperty((Object)this.pub, "anInt"));
        Assertions.assertThrows(JexlException.class, () -> {
            this.ctxt.set("value", (Object)UPPER42);
            Assertions.assertNull((Object)set.evaluate(this.ctxt));
        });
    }

    @Test
    void testSetString() throws Exception {
        JexlExpression set = this.JEXL.createExpression("pub.aString = value");
        this.ctxt.set("value", (Object)UPPER42);
        Assertions.assertEquals((Object)UPPER42, (Object)set.evaluate(this.ctxt));
        Assertions.assertEquals((Object)UPPER42, (Object)this.JEXL.getProperty((Object)this.pub, "aString"));
        this.ctxt.set("value", (Object)LOWER42);
        Assertions.assertEquals((Object)LOWER42, (Object)set.evaluate(this.ctxt));
        Assertions.assertEquals((Object)LOWER42, (Object)this.JEXL.getProperty((Object)this.pub, "aString"));
    }

    public static class Struct {
        public Inner inner = new Inner();
        public int anInt = 42;
        public String aString = "fourty-two";
    }

    public static enum Gender {
        MALE,
        FEMALE;

    }

    public static class Inner {
        public static double NOT42 = -42.0;
        public double aDouble = 42.0;
    }
}

