/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.parser;

import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.junit.Asserter;
import org.junit.jupiter.api.Test;

class FeatureControllerTest
extends JexlTestCase {
    public FeatureControllerTest() {
        super("FeatureControllerTest");
    }

    private JexlEngine createEngine(JexlFeatures features) {
        return new JexlBuilder().features(features).imports(new String[]{"java.lang"}).create();
    }

    @Test
    void testAnnotationFeatureSwitch() throws Exception {
        Asserter onAsserter = new Asserter(this.createEngine(new JexlFeatures().methodCall(true).annotation(true)));
        Asserter offAsserter = new Asserter(this.createEngine(new JexlFeatures().methodCall(true).annotation(false)));
        String expr = "@silent ''.toString()";
        onAsserter.assertExpression("@silent ''.toString()", "", new Object[0]);
        offAsserter.failExpression("@silent ''.toString()", "@1:1 annotation error in '@silent'");
    }

    @Test
    void testLoopFeatureSwitch() throws Exception {
        Asserter onAsserter = new Asserter(this.createEngine(new JexlFeatures().loops(true)));
        onAsserter.setVariable("cond", true);
        onAsserter.setVariable("i", 0);
        Asserter offAsserter = new Asserter(this.createEngine(new JexlFeatures().loops(false)));
        offAsserter.setVariable("cond", true);
        offAsserter.setVariable("i", 0);
        String matchException = "@1:1 loop error in 'while (...) ...'";
        String whileExpr = "while (cond) { i++;  cond = false; }; i;";
        onAsserter.assertExpression("while (cond) { i++;  cond = false; }; i;", 1, new Object[0]);
        offAsserter.failExpression("while (cond) { i++;  cond = false; }; i;", matchException, String::equals);
        matchException = "@1:1 loop error in 'do ... while (...)'";
        onAsserter.setVariable("i", 0);
        offAsserter.setVariable("i", 0);
        String doWhileExpr = "do { i++; } while(false); i;";
        onAsserter.assertExpression("do { i++; } while(false); i;", 1, new Object[0]);
        offAsserter.failExpression("do { i++; } while(false); i;", matchException, String::equals);
        matchException = "@1:1 loop error in 'for (... : ...) ...'";
        onAsserter.setVariable("i", 0);
        offAsserter.setVariable("i", 0);
        String forExpr = "for (let j : [1, 2]) { i = i + j; }; i;";
        onAsserter.assertExpression(forExpr, 3, new Object[0]);
        offAsserter.failExpression(forExpr, matchException, String::equals);
        int[] a = new int[]{1, 2};
        onAsserter.setVariable("a", a);
        offAsserter.setVariable("a", a);
        onAsserter.setVariable("i", 0);
        offAsserter.setVariable("i", 0);
        forExpr = "for (let j = 0; j < 2; ++j) { i = i + a[j]; } i;";
        onAsserter.assertExpression(forExpr, 3, new Object[0]);
        offAsserter.failExpression(forExpr, matchException, String::equals);
    }

    @Test
    void testMethodCallFeatureSwitch() throws Exception {
        Asserter onAsserter = new Asserter(this.createEngine(new JexlFeatures().methodCall(true)));
        Asserter offAsserter = new Asserter(this.createEngine(new JexlFeatures().methodCall(false)));
        String expr = "'jexl'.toUpperCase()";
        onAsserter.assertExpression("'jexl'.toUpperCase()", "JEXL", new Object[0]);
        offAsserter.failExpression("'jexl'.toUpperCase()", "@1:7 method call error in '.toUpperCase(...)'", String::equals);
    }

    @Test
    void testNewInstanceFeatureSwitch() throws Exception {
        Asserter onAsserter = new Asserter(this.createEngine(new JexlFeatures().newInstance(true)));
        Asserter offAsserter = new Asserter(this.createEngine(new JexlFeatures().newInstance(false)));
        String expr = "new('java.lang.String', 'JEXL')";
        onAsserter.assertExpression(expr, "JEXL", new Object[0]);
        offAsserter.failExpression(expr, "@1:1 create instance error in 'new(..., ...)'", String::equals);
        expr = "new String('JEXL')";
        onAsserter.assertExpression(expr, "JEXL", new Object[0]);
        offAsserter.failExpression(expr, "@1:1 create instance error in 'new ...(...)'", String::equals);
    }

    @Test
    void testSideEffectDisabled() throws Exception {
        Asserter asserter = new Asserter(this.createEngine(new JexlFeatures().sideEffect(false)));
        asserter.setVariable("i", 1);
        String matchException = "@1:1 assign/modify error in 'i'";
        asserter.failExpression("i = 1", matchException);
        asserter.failExpression("i = i + 1", matchException);
        asserter.failExpression("i = i - 1", matchException);
        asserter.failExpression("i = i * 2", matchException);
        asserter.failExpression("i = i / 2", matchException);
        asserter.failExpression("i = i % 2", matchException);
        asserter.failExpression("i = i ^ 0", matchException);
        asserter.failExpression("i = i << 1", matchException);
        asserter.failExpression("i = i >> 1", matchException);
        asserter.failExpression("i = i >>> 1", matchException);
        asserter.failExpression("i += 1", matchException);
        asserter.failExpression("i -= 1", matchException);
        asserter.failExpression("i *= 2", matchException);
        asserter.failExpression("i /= 2", matchException);
        asserter.failExpression("i %= 2", matchException);
        asserter.failExpression("i ^= 0", matchException);
        asserter.failExpression("i <<= 1", matchException);
        asserter.failExpression("i >>= 1", matchException);
        asserter.failExpression("i >>>= 1", matchException);
        asserter.failExpression("i++", matchException);
        asserter.failExpression("i--", matchException);
        matchException = "@1:3 assign/modify error in 'i'";
        asserter.failExpression("++i", matchException);
        asserter.failExpression("--i", matchException);
    }

    @Test
    void testSideEffectEnabled() throws Exception {
        Asserter asserter = new Asserter(this.createEngine(new JexlFeatures().sideEffect(true)));
        asserter.assertExpression("i = 1", 1, new Object[0]);
        asserter.assertExpression("i = i + 1", 2, new Object[0]);
        asserter.assertExpression("i = i - 1", 1, new Object[0]);
        asserter.assertExpression("i = i * 2", 2, new Object[0]);
        asserter.assertExpression("i = i / 2", 1, new Object[0]);
        asserter.assertExpression("i = i % 2", 1, new Object[0]);
        asserter.assertExpression("i = i ^ 0", 1L, new Object[0]);
        asserter.assertExpression("i = i << 1", 2L, new Object[0]);
        asserter.assertExpression("i = i >> 1", 1L, new Object[0]);
        asserter.assertExpression("i = i >>> 1", 0L, new Object[0]);
        asserter.assertExpression("i = 1", 1, new Object[0]);
        asserter.assertExpression("i += 1", 2, new Object[0]);
        asserter.assertExpression("i -= 1", 1, new Object[0]);
        asserter.assertExpression("i *= 2", 2, new Object[0]);
        asserter.assertExpression("i /= 2", 1, new Object[0]);
        asserter.assertExpression("i %= 2", 1, new Object[0]);
        asserter.assertExpression("i ^= 0", 1L, new Object[0]);
        asserter.assertExpression("i <<= 1", 2L, new Object[0]);
        asserter.assertExpression("i >>= 1", 1L, new Object[0]);
        asserter.assertExpression("i >>>= 1", 0L, new Object[0]);
        asserter.assertExpression("i = 1", 1, new Object[0]);
        asserter.assertExpression("++i", 2, new Object[0]);
        asserter.assertExpression("--i", 1, new Object[0]);
        asserter.assertExpression("i++", 1, new Object[0]);
        asserter.assertExpression("i--", 2, new Object[0]);
    }

    @Test
    void testStructuredLiteralFeatureSwitch() throws Exception {
        Asserter onAsserter = new Asserter(this.createEngine(new JexlFeatures().structuredLiteral(true)));
        Asserter offAsserter = new Asserter(this.createEngine(new JexlFeatures().structuredLiteral(false)));
        String arrayLitExpr = "[1, 2, 3, 4][3]";
        onAsserter.assertExpression("[1, 2, 3, 4][3]", 4, new Object[0]);
        offAsserter.failExpression("[1, 2, 3, 4][3]", "@1:1 set/map/array literal error in '[ ... ]'", String::equals);
        String mapLitExpr = "{'A' : 1, 'B' : 2}['B']";
        onAsserter.assertExpression("{'A' : 1, 'B' : 2}['B']", 2, new Object[0]);
        offAsserter.failExpression("{'A' : 1, 'B' : 2}['B']", "@1:1 set/map/array literal error in '{ ... }'", String::equals);
        String setLitExpr = "{'A', 'B'}.size()";
        onAsserter.assertExpression("{'A', 'B'}.size()", 2, new Object[0]);
        offAsserter.failExpression("{'A', 'B'}.size()", "@1:1 set/map/array literal error in '{ ... }'", String::equals);
        String rangeLitExpr = "(0..3).size()";
        onAsserter.assertExpression("(0..3).size()", 4, new Object[0]);
        offAsserter.failExpression("(0..3).size()", "@1:5 set/map/array literal error in '( .. )'", String::equals);
    }
}

