/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.solvers;

import org.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import org.apache.commons.math3.analysis.QuinticFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.function.Sin;
import org.apache.commons.math3.analysis.solvers.NewtonSolver;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public final class NewtonSolverTest {
    @Test
    public void testSinZero() {
        Sin f = new Sin();
        NewtonSolver solver = new NewtonSolver();
        double result = solver.solve(100, (DifferentiableUnivariateFunction)f, 3.0, 4.0);
        Assert.assertEquals((double)result, (double)Math.PI, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, (DifferentiableUnivariateFunction)f, 1.0, 4.0);
        Assert.assertEquals((double)result, (double)Math.PI, (double)solver.getAbsoluteAccuracy());
        Assert.assertTrue((solver.getEvaluations() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testQuinticZero() {
        final QuinticFunction q = new QuinticFunction();
        DifferentiableUnivariateFunction f = new DifferentiableUnivariateFunction(){

            public double value(double x) {
                return q.value(x);
            }

            public UnivariateFunction derivative() {
                return new UnivariateFunction(){

                    public double value(double x) {
                        return q.value(new DerivativeStructure(1, 1, 0, x)).getPartialDerivative(new int[]{1});
                    }
                };
            }
        };
        NewtonSolver solver = new NewtonSolver();
        double result = solver.solve(100, f, -0.2, 0.2);
        Assert.assertEquals((double)result, (double)0.0, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, f, -0.1, 0.3);
        Assert.assertEquals((double)result, (double)0.0, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, f, -0.3, 0.45);
        Assert.assertEquals((double)result, (double)0.0, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, f, 0.3, 0.7);
        Assert.assertEquals((double)result, (double)0.5, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, f, 0.2, 0.6);
        Assert.assertEquals((double)result, (double)0.5, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, f, 0.05, 0.95);
        Assert.assertEquals((double)result, (double)0.5, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, f, 0.85, 1.25);
        Assert.assertEquals((double)result, (double)1.0, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, f, 0.8, 1.2);
        Assert.assertEquals((double)result, (double)1.0, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, f, 0.85, 1.75);
        Assert.assertEquals((double)result, (double)1.0, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, f, 0.55, 1.45);
        Assert.assertEquals((double)result, (double)1.0, (double)solver.getAbsoluteAccuracy());
        result = solver.solve(100, f, 0.85, 5.0);
        Assert.assertEquals((double)result, (double)1.0, (double)solver.getAbsoluteAccuracy());
    }
}

