/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.scalar;

import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.optim.InitialGuess;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.MultivariateFunctionMappingAdapter;
import org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunction;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.NelderMeadSimplex;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.SimplexOptimizer;
import org.junit.Assert;
import org.junit.Test;

public class MultivariateFunctionMappingAdapterTest {
    @Test
    public void testStartSimplexInsideRange() {
        BiQuadratic biQuadratic = new BiQuadratic(2.0, 2.5, 1.0, 3.0, 2.0, 3.0);
        MultivariateFunctionMappingAdapter wrapped = new MultivariateFunctionMappingAdapter((MultivariateFunction)biQuadratic, biQuadratic.getLower(), biQuadratic.getUpper());
        SimplexOptimizer optimizer = new SimplexOptimizer(1.0E-10, 1.0E-30);
        NelderMeadSimplex simplex = new NelderMeadSimplex((double[][])new double[][]{wrapped.boundedToUnbounded(new double[]{1.5, 2.75}), wrapped.boundedToUnbounded(new double[]{1.5, 2.95}), wrapped.boundedToUnbounded(new double[]{1.7, 2.9})});
        PointValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(300), new ObjectiveFunction((MultivariateFunction)wrapped), simplex, GoalType.MINIMIZE, new InitialGuess(wrapped.boundedToUnbounded(new double[]{1.5, 2.25}))});
        double[] bounded = wrapped.unboundedToBounded(optimum.getPoint());
        Assert.assertEquals((double)biQuadratic.getBoundedXOptimum(), (double)bounded[0], (double)2.0E-7);
        Assert.assertEquals((double)biQuadratic.getBoundedYOptimum(), (double)bounded[1], (double)2.0E-7);
    }

    @Test
    public void testOptimumOutsideRange() {
        BiQuadratic biQuadratic = new BiQuadratic(4.0, 0.0, 1.0, 3.0, 2.0, 3.0);
        MultivariateFunctionMappingAdapter wrapped = new MultivariateFunctionMappingAdapter((MultivariateFunction)biQuadratic, biQuadratic.getLower(), biQuadratic.getUpper());
        SimplexOptimizer optimizer = new SimplexOptimizer(1.0E-10, 1.0E-30);
        NelderMeadSimplex simplex = new NelderMeadSimplex((double[][])new double[][]{wrapped.boundedToUnbounded(new double[]{1.5, 2.75}), wrapped.boundedToUnbounded(new double[]{1.5, 2.95}), wrapped.boundedToUnbounded(new double[]{1.7, 2.9})});
        PointValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(100), new ObjectiveFunction((MultivariateFunction)wrapped), simplex, GoalType.MINIMIZE, new InitialGuess(wrapped.boundedToUnbounded(new double[]{1.5, 2.25}))});
        double[] bounded = wrapped.unboundedToBounded(optimum.getPoint());
        Assert.assertEquals((double)biQuadratic.getBoundedXOptimum(), (double)bounded[0], (double)2.0E-7);
        Assert.assertEquals((double)biQuadratic.getBoundedYOptimum(), (double)bounded[1], (double)2.0E-7);
    }

    @Test
    public void testUnbounded() {
        BiQuadratic biQuadratic = new BiQuadratic(4.0, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        MultivariateFunctionMappingAdapter wrapped = new MultivariateFunctionMappingAdapter((MultivariateFunction)biQuadratic, biQuadratic.getLower(), biQuadratic.getUpper());
        SimplexOptimizer optimizer = new SimplexOptimizer(1.0E-10, 1.0E-30);
        NelderMeadSimplex simplex = new NelderMeadSimplex((double[][])new double[][]{wrapped.boundedToUnbounded(new double[]{1.5, 2.75}), wrapped.boundedToUnbounded(new double[]{1.5, 2.95}), wrapped.boundedToUnbounded(new double[]{1.7, 2.9})});
        PointValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(300), new ObjectiveFunction((MultivariateFunction)wrapped), simplex, GoalType.MINIMIZE, new InitialGuess(wrapped.boundedToUnbounded(new double[]{1.5, 2.25}))});
        double[] bounded = wrapped.unboundedToBounded(optimum.getPoint());
        Assert.assertEquals((double)biQuadratic.getBoundedXOptimum(), (double)bounded[0], (double)2.0E-7);
        Assert.assertEquals((double)biQuadratic.getBoundedYOptimum(), (double)bounded[1], (double)2.0E-7);
    }

    @Test
    public void testHalfBounded() {
        BiQuadratic biQuadratic = new BiQuadratic(4.0, 4.0, 1.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 3.0);
        MultivariateFunctionMappingAdapter wrapped = new MultivariateFunctionMappingAdapter((MultivariateFunction)biQuadratic, biQuadratic.getLower(), biQuadratic.getUpper());
        SimplexOptimizer optimizer = new SimplexOptimizer(1.0E-13, 1.0E-30);
        NelderMeadSimplex simplex = new NelderMeadSimplex((double[][])new double[][]{wrapped.boundedToUnbounded(new double[]{1.5, 2.75}), wrapped.boundedToUnbounded(new double[]{1.5, 2.95}), wrapped.boundedToUnbounded(new double[]{1.7, 2.9})});
        PointValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(200), new ObjectiveFunction((MultivariateFunction)wrapped), simplex, GoalType.MINIMIZE, new InitialGuess(wrapped.boundedToUnbounded(new double[]{1.5, 2.25}))});
        double[] bounded = wrapped.unboundedToBounded(optimum.getPoint());
        Assert.assertEquals((double)biQuadratic.getBoundedXOptimum(), (double)bounded[0], (double)1.0E-7);
        Assert.assertEquals((double)biQuadratic.getBoundedYOptimum(), (double)bounded[1], (double)1.0E-7);
    }

    private static class BiQuadratic
    implements MultivariateFunction {
        private final double xOptimum;
        private final double yOptimum;
        private final double xMin;
        private final double xMax;
        private final double yMin;
        private final double yMax;

        public BiQuadratic(double xOptimum, double yOptimum, double xMin, double xMax, double yMin, double yMax) {
            this.xOptimum = xOptimum;
            this.yOptimum = yOptimum;
            this.xMin = xMin;
            this.xMax = xMax;
            this.yMin = yMin;
            this.yMax = yMax;
        }

        public double value(double[] point) {
            Assert.assertTrue((point[0] >= this.xMin ? 1 : 0) != 0);
            Assert.assertTrue((point[0] <= this.xMax ? 1 : 0) != 0);
            Assert.assertTrue((point[1] >= this.yMin ? 1 : 0) != 0);
            Assert.assertTrue((point[1] <= this.yMax ? 1 : 0) != 0);
            double dx = point[0] - this.xOptimum;
            double dy = point[1] - this.yOptimum;
            return dx * dx + dy * dy;
        }

        public double[] getLower() {
            return new double[]{this.xMin, this.yMin};
        }

        public double[] getUpper() {
            return new double[]{this.xMax, this.yMax};
        }

        public double getBoundedXOptimum() {
            return this.xOptimum < this.xMin ? this.xMin : (this.xOptimum > this.xMax ? this.xMax : this.xOptimum);
        }

        public double getBoundedYOptimum() {
            return this.yOptimum < this.yMin ? this.yMin : (this.yOptimum > this.yMax ? this.yMax : this.yOptimum);
        }
    }
}

