/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VFS;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class FileIteratorTest {
    private static FileObject baseFolder;
    private static final int FILE_COUNT = 14;

    @BeforeAll
    public static void setUpClass() throws Exception {
        baseFolder = VFS.getManager().resolveFile("ram://" + FileIteratorTest.class.getName());
        baseFolder.deleteAll();
        baseFolder.resolveFile("a.htm").createFile();
        baseFolder.resolveFile("a.html").createFile();
        baseFolder.resolveFile("a.xhtml").createFile();
        baseFolder.resolveFile("b.htm").createFile();
        baseFolder.resolveFile("b.html").createFile();
        baseFolder.resolveFile("b.xhtml").createFile();
        baseFolder.resolveFile("c.htm").createFile();
        baseFolder.resolveFile("c.html").createFile();
        baseFolder.resolveFile("c.xhtml").createFile();
        baseFolder.resolveFile("subdir1").createFolder();
        baseFolder.resolveFile("subdir1/subfile1.txt").createFile();
        baseFolder.resolveFile("subdir2").createFolder();
        baseFolder.resolveFile("subdir2/subfile1.txt").createFile();
    }

    @AfterAll
    public static void tearDownClass() throws Exception {
        if (baseFolder != null) {
            baseFolder.deleteAll();
        }
    }

    @Test
    public void testIterator() throws FileSystemException {
        FileObject expectedFile;
        FileObject[] findFiles = baseFolder.findFiles(Selectors.SELECT_ALL);
        Assertions.assertEquals((int)14, (int)findFiles.length);
        FileObject[] listFiles = baseFolder.getChildren();
        Assertions.assertTrue((14 > listFiles.length ? 1 : 0) != 0);
        int i = 0;
        for (FileObject actualFile : baseFolder) {
            expectedFile = findFiles[i];
            Assertions.assertEquals((Object)expectedFile, (Object)actualFile);
            ++i;
        }
        i = 0;
        for (FileObject element : baseFolder) {
            expectedFile = findFiles[i];
            Assertions.assertEquals((Object)expectedFile, (Object)element);
            ++i;
        }
    }
}

