/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.quantiles;

import java.util.Arrays;
import org.apache.datasketches.pig.quantiles.DoublesSketchToString;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DoublesSketchToStringTest {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();

    @Test
    public void nullInputTuple() throws Exception {
        DoublesSketchToString func = new DoublesSketchToString();
        String result = (String)func.exec(null);
        Assert.assertNull((Object)result);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void emptyInputTuple() throws Exception {
        DoublesSketchToString func = new DoublesSketchToString();
        String result = (String)func.exec(TUPLE_FACTORY.newTuple());
        Assert.assertNull((Object)result);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void tooManyInputs() throws Exception {
        DoublesSketchToString func = new DoublesSketchToString();
        func.exec(TUPLE_FACTORY.newTuple(2));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeForSketch() throws Exception {
        DoublesSketchToString func = new DoublesSketchToString();
        func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(1.0)));
    }

    @Test
    public void normalCase() throws Exception {
        DoublesSketchToString func = new DoublesSketchToString();
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        String result = (String)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()))));
        Assert.assertNotNull((Object)result);
    }
}

