/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.sampling;

import java.io.IOException;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.sampling.ArrayOfTuplesSerDe;
import org.apache.datasketches.pig.sampling.VarOptCommonAlgebraicTest;
import org.apache.datasketches.pig.sampling.VarOptUnion;
import org.apache.datasketches.sampling.VarOptItemsSketch;
import org.apache.datasketches.sampling.VarOptItemsUnion;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.testng.Assert;
import org.testng.annotations.Test;

public class VarOptUnionTest {
    @Test
    public void checkConstructors() {
        VarOptUnion udf = new VarOptUnion();
        Assert.assertNotNull((Object)udf);
        udf = new VarOptUnion("255");
        Assert.assertNotNull((Object)udf);
        try {
            new VarOptUnion("-1");
            Assert.fail((String)"Accepted negative k");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkExecution() {
        int k = 5;
        VarOptUnion udf = new VarOptUnion(Integer.toString(5));
        DataBag inputBag = BagFactory.getInstance().newDefaultBag();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        try {
            VarOptItemsSketch sketch = VarOptItemsSketch.newInstance((int)5);
            VarOptItemsUnion union = VarOptItemsUnion.newInstance((int)5);
            for (int i = 1; i < 2; ++i) {
                sketch.reset();
                Tuple t = TupleFactory.getInstance().newTuple(3);
                t.set(0, (Object)(1.0 * (double)i));
                t.set(1, (Object)i);
                t.set(2, (Object)(-i));
                sketch.update((Object)t, 1.0 * (double)i);
                Tuple sketchWrapper = TupleFactory.getInstance().newTuple(1);
                DataByteArray dba = new DataByteArray(sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfTuplesSerDe()));
                sketchWrapper.set(0, (Object)dba);
                inputBag.add(sketchWrapper);
                union.update(sketch);
                union.update(sketch);
            }
            inputTuple.set(0, (Object)inputBag);
            Assert.assertNull((Object)udf.getValue());
            udf.accumulate(inputTuple);
            udf.accumulate(inputTuple);
            DataByteArray outBytes = udf.getValue();
            udf.cleanup();
            Assert.assertNull((Object)udf.getValue());
            VarOptItemsSketch result = VarOptItemsSketch.heapify((Memory)Memory.wrap((byte[])outBytes.get()), (ArrayOfItemsSerDe)new ArrayOfTuplesSerDe());
            Assert.assertNotNull((Object)result);
            VarOptCommonAlgebraicTest.compareResults((VarOptItemsSketch<Tuple>)result, (VarOptItemsSketch<Tuple>)union.getResult());
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected exception");
        }
    }

    @Test
    public void degenerateExecInput() {
        VarOptUnion udf = new VarOptUnion();
        try {
            Assert.assertNull((Object)udf.exec(null));
            Assert.assertNull((Object)udf.exec(TupleFactory.getInstance().newTuple(0)));
            Tuple in = TupleFactory.getInstance().newTuple(1);
            in.set(0, null);
            Assert.assertNull((Object)udf.exec(in));
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected exception");
        }
    }

    @Test
    public void outputSchemaTest() throws IOException {
        VarOptUnion udf = new VarOptUnion("5");
        Schema inputSchema = new Schema();
        inputSchema.add(new Schema.FieldSchema("bytes", 50));
        Schema output = udf.outputSchema(inputSchema);
        Assert.assertEquals((int)output.size(), (int)1);
        Assert.assertEquals((byte)output.getField((int)0).type, (byte)50);
    }
}

