/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.theta;

import java.io.IOException;
import org.apache.datasketches.pig.PigTestingUtil;
import org.apache.datasketches.pig.theta.Estimate;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EstimateTest {
    @Test
    public void testNullEmpty() throws IOException {
        Estimate func = new Estimate();
        Tuple inputTuple = null;
        Double returnValue = (Double)func.exec(inputTuple);
        Assert.assertNull((Object)returnValue);
        inputTuple = TupleFactory.getInstance().newTuple(0);
        returnValue = (Double)func.exec(inputTuple);
        Assert.assertNull((Object)returnValue);
    }

    @Test
    public void testExact() throws IOException {
        Estimate func = new Estimate();
        Tuple dataTuple = TupleFactory.getInstance().newTuple(1);
        dataTuple.set(0, (Object)PigTestingUtil.createDbaFromQssRange(64, 0, 64));
        Double result = (Double)func.exec(dataTuple);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)result, (double)64.0, (double)0.0);
    }

    @Test
    public void testExactWithSeed() throws IOException {
        Estimate func = new Estimate(Long.toString(9001L));
        Tuple dataTuple = TupleFactory.getInstance().newTuple(1);
        dataTuple.set(0, (Object)PigTestingUtil.createDbaFromQssRange(64, 0, 64));
        Double result = (Double)func.exec(dataTuple);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)result, (double)64.0, (double)0.0);
    }

    @Test
    public void printlnTest() {
        EstimateTest.println(this.getClass().getSimpleName());
    }

    static void println(String s) {
    }
}

