/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;
import org.apache.derby.shared.common.sanity.SanityManager;

public class SYSROLESRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSROLES";
    private static final int SYSROLES_COLUMN_COUNT = 6;
    private static final int SYSROLES_ROLE_UUID = 1;
    private static final int SYSROLES_ROLEID = 2;
    private static final int SYSROLES_GRANTEE = 3;
    private static final int SYSROLES_GRANTOR = 4;
    private static final int SYSROLES_WITHADMINOPTION = 5;
    static final int SYSROLES_ISDEF = 6;
    private static final int[][] indexColumnPositions = new int[][]{{2, 3, 4}, {2, 6}, {1}};
    static final int SYSROLES_ROLEID_COLPOS_IN_INDEX_ID_EE_OR = 1;
    static final int SYSROLES_GRANTEE_COLPOS_IN_INDEX_ID_EE_OR = 2;
    static final int SYSROLES_INDEX_ID_EE_OR_IDX = 0;
    static final int SYSROLES_INDEX_ID_DEF_IDX = 1;
    static final int SYSROLES_INDEX_UUID_IDX = 2;
    private static final boolean[] uniqueness = new boolean[]{true, false, true};
    private static final String[] uuids = new String[]{"e03f4017-0115-382c-08df-ffffe275b270", "c851401a-0115-382c-08df-ffffe275b270", "c065801d-0115-382c-08df-ffffe275b270", "787c0020-0115-382c-08df-ffffe275b270", "629f8094-0116-d8f9-5f97-ffffe275b270"};

    SYSROLESRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(6, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        String oid_string = null;
        String roleid = null;
        String grantee = null;
        String grantor = null;
        boolean wao = false;
        boolean isdef = false;
        if (td != null) {
            RoleGrantDescriptor rgd = (RoleGrantDescriptor)td;
            roleid = rgd.getRoleName();
            grantee = rgd.getGrantee();
            grantor = rgd.getGrantor();
            wao = rgd.isWithAdminOption();
            isdef = rgd.isDef();
            UUID oid = rgd.getUUID();
            oid_string = oid.toString();
        }
        ExecRow row = this.getExecutionFactory().getValueRow(6);
        row.setColumn(1, new SQLChar(oid_string));
        row.setColumn(2, new SQLVarchar(roleid));
        row.setColumn(3, new SQLVarchar(grantee));
        row.setColumn(4, new SQLVarchar(grantor));
        row.setColumn(5, new SQLChar(wao ? "Y" : "N"));
        row.setColumn(6, new SQLChar(isdef ? "Y" : "N"));
        return row;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTupleDescriptor, DataDictionary dd) throws StandardException {
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        SanityManager.ASSERT(row.nColumns() == 6, "Wrong number of columns for a SYSROLES row");
        DataValueDescriptor col = row.getColumn(1);
        String oid_string = col.getString();
        col = row.getColumn(2);
        String roleid = col.getString();
        col = row.getColumn(3);
        String grantee = col.getString();
        col = row.getColumn(4);
        String grantor = col.getString();
        col = row.getColumn(5);
        String wao = col.getString();
        col = row.getColumn(6);
        String isdef = col.getString();
        RoleGrantDescriptor descriptor = ddg.newRoleGrantDescriptor(this.getUUIDFactory().recreateUUID(oid_string), roleid, grantee, grantor, wao.equals("Y"), isdef.equals("Y"));
        return descriptor;
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("UUID", false), SystemColumnImpl.getIdentifierColumn("ROLEID", false), SystemColumnImpl.getIdentifierColumn("GRANTEE", false), SystemColumnImpl.getIdentifierColumn("GRANTOR", false), SystemColumnImpl.getIndicatorColumn("WITHADMINOPTION"), SystemColumnImpl.getIndicatorColumn("ISDEF")};
    }
}

