/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import org.apache.derby.agg.Aggregator;

public class ModeAggregate
implements Aggregator<Integer, Integer, ModeAggregate> {
    private HashMap<Integer, Accumulator> _accumulators;

    public void init() {
        this._accumulators = new HashMap();
    }

    public void accumulate(Integer value) {
        this.getAccumulator(value).add(1);
    }

    public void merge(ModeAggregate otherAggregator) {
        HashMap<Integer, Accumulator> otherAccumulators = otherAggregator._accumulators;
        for (Integer value : otherAccumulators.keySet()) {
            this.getAccumulator(value).add(otherAccumulators.get(value).getCount());
        }
    }

    public Integer terminate() {
        return this._accumulators.isEmpty() ? null : Collections.max(this._accumulators.values()).getValue();
    }

    private Accumulator getAccumulator(Integer value) {
        Accumulator retval = this._accumulators.get(value);
        if (retval == null) {
            retval = new Accumulator(value);
            this._accumulators.put(value, retval);
        }
        return retval;
    }

    public static final class Accumulator
    implements Comparable<Accumulator>,
    Serializable {
        private Integer _value;
        private int _count;

        public Accumulator(Integer value) {
            this._value = value;
            this._count = 0;
        }

        public void add(int increment) {
            this._count += increment;
        }

        public Integer getValue() {
            return this._value;
        }

        public int getCount() {
            return this._count;
        }

        @Override
        public int compareTo(Accumulator that) {
            int retval = this._count - that._count;
            if (retval != 0) {
                return retval;
            }
            return this._value - that._value;
        }
    }
}

