/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.suites.AllPackages;
import org.apache.derbyTesting.functionTests.suites.EncryptionSuite;
import org.apache.derbyTesting.functionTests.tests.derbynet.PrepareStatementTest;
import org.apache.derbyTesting.functionTests.tests.lang.AnsiTrimTest;
import org.apache.derbyTesting.functionTests.tests.lang.CreateTableFromQueryTest;
import org.apache.derbyTesting.functionTests.tests.lang.DatabaseClassLoadingTest;
import org.apache.derbyTesting.functionTests.tests.lang.LangScripts;
import org.apache.derbyTesting.functionTests.tests.lang.SimpleTest;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class StandardTests
extends BaseJDBCTestCase {
    public StandardTests(String testcaseName) {
        super(testcaseName);
    }

    public static Test simpleTest(String serverHost, int serverPort) {
        return TestConfiguration.existingServerSuite(SimpleTest.class, false, serverHost, serverPort);
    }

    public static Test prepareStatementTest(String hostName, int portNo) {
        return TestConfiguration.existingServerSuite(PrepareStatementTest.class, false, hostName, portNo);
    }

    public static Test ansiTrimTest(String serverHost, int serverPort) {
        Test t = TestConfiguration.existingServerSuite(AnsiTrimTest.class, false, serverHost, serverPort);
        CleanDatabaseTestSetup cdts = new CleanDatabaseTestSetup(t, true, serverHost, serverPort){

            @Override
            public void decorateSQL(Statement s) throws SQLException {
                AnsiTrimTest.decorate(s);
            }
        };
        return cdts;
    }

    public static Test createTableFromQueryTest(String serverHost, int serverPort) {
        Test t = TestConfiguration.existingServerSuite(CreateTableFromQueryTest.class, false, serverHost, serverPort);
        CleanDatabaseTestSetup cdts = new CleanDatabaseTestSetup(t, true, serverHost, serverPort){

            @Override
            protected void decorateSQL(Statement stmt) throws SQLException {
                CreateTableFromQueryTest.decorate(stmt);
            }
        };
        return cdts;
    }

    public static Test databaseClassLoadingTest(String hostName, int portNo) {
        return TestConfiguration.existingServerSuite(DatabaseClassLoadingTest.class, false, hostName, portNo);
    }

    public static Test dynamicLikeOptimizationTest(String hostName, int portNo) {
        System.out.println("********* FIXME!");
        return null;
    }

    public static Test grantRevokeTest(String hostName, int portNo) {
        System.out.println("********* FIXME!");
        return null;
    }

    public static Test groupByExpressionTest(String hostName, int portNo) {
        System.out.println("********* FIXME!");
        return null;
    }

    public static Test langScripts(String hostName, int portNo) {
        return TestConfiguration.existingServerSuite(LangScripts.class, false, hostName, portNo);
    }

    public static Test all(String serverHost, int serverPort) throws Exception {
        BaseTestSuite suite = new BaseTestSuite("All_" + serverHost + ":" + serverPort);
        suite.addTest(TestConfiguration.existingServerSuite(AllPackages.class, false, serverHost, serverPort));
        suite.addTest(TestConfiguration.existingServerSuite(StandardTests.allPackagesSuite(), false, serverHost, serverPort));
        suite.addTest(TestConfiguration.existingServerSuite(EncryptionSuite.class, false, serverHost, serverPort));
        CleanDatabaseTestSetup cdts = new CleanDatabaseTestSetup((Test)suite, true, serverHost, serverPort){

            @Override
            public void decorateSQL(Statement s) throws SQLException {
            }
        };
        return cdts;
    }

    private static Class allPackagesSuite() {
        return null;
    }
}

