/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.Wrapper41DBMD;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.Wrapper42DBMD;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.Version;
import org.apache.derbyTesting.functionTests.util.Barrier;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DatabaseMetaDataTest
extends BaseJDBCTestCase {
    private static final String[][] NUMERIC_FUNCTIONS = new String[][]{{"ABS", "-25.67"}, {"ACOS", "0.0707"}, {"ASIN", "0.997"}, {"ATAN", "14.10"}, {"ATAN2", "0.56", "1.2"}, {"CEILING", "3.45"}, {"COS", "1.2"}, {"COT", "3.4"}, {"DEGREES", "2.1"}, {"EXP", "2.3"}, {"FLOOR", "3.22"}, {"LOG", "34.1"}, {"LOG10", "18.7"}, {"MOD", "124", "7"}, {"PI"}, {"POWER", "2", "3"}, {"RADIANS", "54"}, {"RAND", "17"}, {"ROUND", "345.345", "1"}, {"SIGN", "-34"}, {"SIN", "0.32"}, {"SQRT", "6.22"}, {"TAN", "0.57"}, {"TRUNCATE", "345.395", "1"}};
    private static final String[][] TIMEDATE_FUNCTIONS = new String[][]{{"CURDATE"}, {"CURTIME"}, {"DAYNAME", "{d '1995-12-19'h}"}, {"DAYOFMONTH", "{d '1995-12-19'}"}, {"DAYOFWEEK", "{d '1995-12-19'}"}, {"DAYOFYEAR", "{d '1995-12-19'}"}, {"HOUR", "{t '16:13:03'}"}, {"MINUTE", "{t '16:13:03'}"}, {"MONTH", "{d '1995-12-19'}"}, {"MONTHNAME", "{d '1995-12-19'}"}, {"NOW"}, {"QUARTER", "{d '1995-12-19'}"}, {"SECOND", "{t '16:13:03'}"}, {"TIMESTAMPADD", "SQL_TSI_DAY", "7", "{ts '1995-12-19 12:15:54'}"}, {"TIMESTAMPDIFF", "SQL_TSI_DAY", "{ts '1995-12-19 12:15:54'}", "{ts '1997-11-02 00:15:23'}"}, {"WEEK", "{d '1995-12-19'}"}, {"YEAR", "{d '1995-12-19'}"}};
    private static final String[][] SYSTEM_FUNCTIONS = new String[][]{{"DATABASE"}, {"IFNULL", "'this'", "'that'"}, {"USER"}};
    private static final String[][] STRING_FUNCTIONS = new String[][]{{"ASCII", "'Yellow'"}, {"CHAR", "65"}, {"CONCAT", "'hello'", "'there'"}, {"DIFFERENCE", "'Pires'", "'Piers'"}, {"INSERT", "'Bill Clinton'", "4", "'William'"}, {"LCASE", "'Fernando Alonso'"}, {"LEFT", "'Bonjour'", "3"}, {"LENGTH", "'four    '"}, {"LOCATE", "'jour'", "'Bonjour'"}, {"LTRIM", "'   left trim   '"}, {"REPEAT", "'echo'", "3"}, {"REPLACE", "'to be or not to be'", "'be'", "'England'"}, {"RTRIM", "'  right trim   '"}, {"SOUNDEX", "'Derby'"}, {"SPACE", "12"}, {"SUBSTRING", "'Ruby the Rubicon Jeep'", "10", "7"}, {"UCASE", "'Fernando Alonso'"}};
    private boolean modifiedDatabase;
    private String schema;
    private static final String[] IDS = new String[]{"one_dmd_test", "TWO_dmd_test", "ThReE_dmd_test", "\"four_dmd_test\"", "\"FIVE_dmd_test\"", "\"sIx_dmd_test\""};
    private static final String[] BUILTIN_SCHEMAS = new String[]{"APP", "NULLID", "SQLJ", "SYS", "SYSCAT", "SYSCS_DIAG", "SYSCS_UTIL", "SYSFUN", "SYSIBM", "SYSPROC", "SYSSTAT"};

    public DatabaseMetaDataTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.schema = TestConfiguration.getCurrent().getUserName();
        DatabaseMetaDataTest.assertTrue((String)"schema name must be at least three characters long", (this.schema.length() > 2 ? 1 : 0) != 0);
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.modifiedDatabase) {
            Connection connection = this.getConnection();
            connection.setAutoCommit(false);
            DatabaseMetaData databaseMetaData = this.getDMD();
            for (String string : IDS) {
                JDBC.dropSchema(databaseMetaData, DatabaseMetaDataTest.getStoredIdentifier(string));
            }
            this.commit();
        }
        super.tearDown();
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("DatabaseMetaDataTest");
        baseTestSuite.addTest(TestConfiguration.defaultSuite(DatabaseMetaDataTest.class));
        baseTestSuite.addTest(DatabaseMetaDataTest.connectionPoolingSuite("embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(DatabaseMetaDataTest.connectionPoolingSuite("client")));
        baseTestSuite.addTest((Test)TestConfiguration.singleUseDatabaseDecorator((Test)new DatabaseMetaDataTest("initialCompilationTest")));
        baseTestSuite.addTest((Test)TestConfiguration.singleUseDatabaseDecorator((Test)new DatabaseMetaDataTest("concurrentCompilationTest")));
        Properties properties = new Properties();
        properties.setProperty("derby.locks.waitTimeout", "90");
        properties.setProperty("derby.language.stalePlanCheckInterval", "5");
        baseTestSuite.addTest((Test)TestConfiguration.singleUseDatabaseDecorator((Test)new DatabasePropertyTestSetup((Test)new DatabaseMetaDataTest("recompileTimeoutTest"), properties, true)));
        return baseTestSuite;
    }

    private static Test connectionPoolingSuite(String string) {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("Base connection pooling suite:DISABLED");
        }
        BaseTestSuite baseTestSuite = new BaseTestSuite("Base connection pooling suite");
        baseTestSuite.addTest((Test)new DatabaseMetaDataTest("testConnectionSpecific"));
        BaseTestSuite baseTestSuite2 = new BaseTestSuite("DatabaseMetaData with connection pooling:" + string);
        BaseTestSuite baseTestSuite3 = new BaseTestSuite("ConnectionPoolDataSource");
        BaseTestSuite baseTestSuite4 = new BaseTestSuite("XADataSource");
        baseTestSuite3.addTest(TestConfiguration.connectionCPDecorator((Test)baseTestSuite));
        baseTestSuite4.addTest(TestConfiguration.connectionXADecorator((Test)baseTestSuite));
        baseTestSuite2.addTest((Test)baseTestSuite3);
        baseTestSuite2.addTest((Test)baseTestSuite4);
        return baseTestSuite2;
    }

    private String[] getSortedIdentifiers() {
        Object[] objectArray = new String[IDS.length];
        for (int i = 0; i < IDS.length; ++i) {
            objectArray[i] = DatabaseMetaDataTest.getStoredIdentifier(IDS[i]);
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    private DatabaseMetaData getDMD() throws SQLException {
        return this.getConnection().getMetaData();
    }

    public void initialCompilationTest() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        connection.setTransactionIsolation(4);
        Statement statement = this.createStatement();
        JDBC.assertDrainResults(statement.executeQuery("SELECT * FROM SYS.SYSSTATEMENTS"));
        statement.close();
        this.getDMD().getIndexInfo(null, null, "T", false, false).close();
        this.getDMD().getIndexInfo(null, null, "T", false, false).close();
    }

    public void concurrentCompilationTest() throws Exception {
        final Barrier barrier = new Barrier(2);
        final DatabaseMetaData databaseMetaData = this.getDMD();
        final Exception[] exceptionArray = new Exception[1];
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    DatabaseMetaDataTest.this.concurrentCompilationTestHelper(barrier, databaseMetaData);
                }
                catch (Exception exception) {
                    exceptionArray[0] = exception;
                }
            }
        };
        thread.start();
        Connection connection = this.openDefaultConnection();
        this.concurrentCompilationTestHelper(barrier, connection.getMetaData());
        connection.close();
        thread.join();
        if (exceptionArray[0] != null) {
            DatabaseMetaDataTest.fail("Exception in other thread", exceptionArray[0]);
        }
        this.testGetBestRowIdentifier();
        this.testGetIndexInfo();
    }

    private void concurrentCompilationTestHelper(Barrier barrier, DatabaseMetaData databaseMetaData) throws Exception {
        barrier.await();
        ResultSet resultSet = databaseMetaData.getBestRowIdentifier(null, null, "", 0, true);
        ResultSet resultSet2 = databaseMetaData.getIndexInfo(null, null, "", true, true);
        JDBC.assertDrainResults(resultSet);
        JDBC.assertDrainResults(resultSet2);
    }

    public void recompileTimeoutTest() throws SQLException {
        int n;
        DatabaseMetaData databaseMetaData = this.getDMD();
        JDBC.assertDrainResults(databaseMetaData.getTables(null, "%", "%", null));
        Statement statement = this.createStatement();
        for (n = 0; n < 20; ++n) {
            statement.executeUpdate("create table t" + n + "(x int)");
        }
        for (n = 0; n < 5; ++n) {
            long l = System.currentTimeMillis();
            JDBC.assertDrainResults(databaseMetaData.getTables(null, "%", "T0", null));
            l = System.currentTimeMillis() - l;
            if (l <= 60000L) continue;
            DatabaseMetaDataTest.fail((String)("getTables() took a very long time, possibly because of an internal timeout. i=" + n + ", time=" + l));
        }
    }

    public void testDetermineFeatureSupport() throws SQLException {
        DatabaseMetaData databaseMetaData = this.getDMD();
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsAlterTableWithAddColumn());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsAlterTableWithDropColumn());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsANSI92EntryLevelSQL());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsANSI92FullSQL());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsANSI92IntermediateSQL());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsBatchUpdates());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsCatalogsInDataManipulation());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsCatalogsInIndexDefinitions());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsCatalogsInPrivilegeDefinitions());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsCatalogsInProcedureCalls());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsCatalogsInTableDefinitions());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsColumnAliasing());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsConvert());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsConvert(4, 5));
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsCoreSQLGrammar());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsCorrelatedSubqueries());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsDataDefinitionAndDataManipulationTransactions());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsDataManipulationTransactionsOnly());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsDifferentTableCorrelationNames());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsExpressionsInOrderBy());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsExtendedSQLGrammar());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsFullOuterJoins());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsGetGeneratedKeys());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsGroupBy());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsGroupByBeyondSelect());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsGroupByUnrelated());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsIntegrityEnhancementFacility());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsLikeEscapeClause());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsLimitedOuterJoins());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsMinimumSQLGrammar());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsMixedCaseIdentifiers());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsMixedCaseQuotedIdentifiers());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsMultipleOpenResults());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsMultipleResultSets());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsMultipleTransactions());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsNamedParameters());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsNonNullableColumns());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsOpenCursorsAcrossCommit());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsOpenCursorsAcrossRollback());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsOpenStatementsAcrossCommit());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsOpenStatementsAcrossRollback());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsOrderByUnrelated());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsOuterJoins());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsPositionedDelete());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsPositionedUpdate());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsResultSetConcurrency(1003, 1007));
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsResultSetConcurrency(1003, 1008));
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsResultSetConcurrency(1004, 1007));
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsResultSetConcurrency(1004, 1008));
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsResultSetConcurrency(1005, 1007));
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsResultSetConcurrency(1005, 1008));
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsResultSetHoldability(2));
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsResultSetHoldability(1));
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsResultSetType(1003));
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsResultSetType(1004));
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsResultSetType(1005));
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsSavepoints());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsSchemasInDataManipulation());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsSchemasInIndexDefinitions());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsSchemasInPrivilegeDefinitions());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsSchemasInProcedureCalls());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsSchemasInTableDefinitions());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsSelectForUpdate());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.supportsStatementPooling());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsStoredProcedures());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsSubqueriesInComparisons());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsSubqueriesInExists());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsSubqueriesInIns());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsSubqueriesInQuantifieds());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsTableCorrelationNames());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsTransactionIsolationLevel(2));
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsTransactionIsolationLevel(1));
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsTransactionIsolationLevel(4));
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsTransactionIsolationLevel(8));
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsTransactions());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsUnion());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.supportsUnionAll());
    }

    public void testDataSourceLimits() throws SQLException {
        DatabaseMetaData databaseMetaData = this.getDMD();
        DatabaseMetaDataTest.assertEquals((int)0, (int)databaseMetaData.getMaxBinaryLiteralLength());
        DatabaseMetaDataTest.assertEquals((int)0, (int)databaseMetaData.getMaxCatalogNameLength());
        DatabaseMetaDataTest.assertEquals((int)0, (int)databaseMetaData.getMaxCharLiteralLength());
        DatabaseMetaDataTest.assertEquals((int)128, (int)databaseMetaData.getMaxColumnNameLength());
        DatabaseMetaDataTest.assertEquals((int)0, (int)databaseMetaData.getMaxColumnsInGroupBy());
        DatabaseMetaDataTest.assertEquals((int)0, (int)databaseMetaData.getMaxColumnsInIndex());
        DatabaseMetaDataTest.assertEquals((int)0, (int)databaseMetaData.getMaxColumnsInOrderBy());
        DatabaseMetaDataTest.assertEquals((int)0, (int)databaseMetaData.getMaxColumnsInSelect());
        DatabaseMetaDataTest.assertEquals((int)0, (int)databaseMetaData.getMaxColumnsInTable());
        DatabaseMetaDataTest.assertEquals((int)0, (int)databaseMetaData.getMaxConnections());
        DatabaseMetaDataTest.assertEquals((int)128, (int)databaseMetaData.getMaxCursorNameLength());
        DatabaseMetaDataTest.assertEquals((int)0, (int)databaseMetaData.getMaxIndexLength());
        DatabaseMetaDataTest.assertEquals((int)128, (int)databaseMetaData.getMaxProcedureNameLength());
        DatabaseMetaDataTest.assertEquals((int)0, (int)databaseMetaData.getMaxRowSize());
        DatabaseMetaDataTest.assertEquals((int)128, (int)databaseMetaData.getMaxSchemaNameLength());
        DatabaseMetaDataTest.assertEquals((int)0, (int)databaseMetaData.getMaxStatementLength());
        DatabaseMetaDataTest.assertEquals((int)0, (int)databaseMetaData.getMaxStatements());
        DatabaseMetaDataTest.assertEquals((int)128, (int)databaseMetaData.getMaxTableNameLength());
        DatabaseMetaDataTest.assertEquals((int)0, (int)databaseMetaData.getMaxTablesInSelect());
        DatabaseMetaDataTest.assertEquals((int)128, (int)databaseMetaData.getMaxUserNameLength());
    }

    public void testMiscellaneous() throws SQLException {
        DatabaseMetaData databaseMetaData = this.getDMD();
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.allProceduresAreCallable());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.allTablesAreSelectable());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.dataDefinitionCausesTransactionCommit());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.dataDefinitionIgnoredInTransactions());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.deletesAreDetected(1003));
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.deletesAreDetected(1004));
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.deletesAreDetected(1005));
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.insertsAreDetected(1003));
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.insertsAreDetected(1004));
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.insertsAreDetected(1005));
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.updatesAreDetected(1003));
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.updatesAreDetected(1004));
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.updatesAreDetected(1005));
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.othersDeletesAreVisible(1003));
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.othersDeletesAreVisible(1004));
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.othersDeletesAreVisible(1005));
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.othersInsertsAreVisible(1003));
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.othersInsertsAreVisible(1004));
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.othersInsertsAreVisible(1005));
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.othersUpdatesAreVisible(1003));
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.othersUpdatesAreVisible(1004));
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.othersUpdatesAreVisible(1005));
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.ownDeletesAreVisible(1003));
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.ownDeletesAreVisible(1004));
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.ownDeletesAreVisible(1005));
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.ownInsertsAreVisible(1003));
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.ownInsertsAreVisible(1004));
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.ownInsertsAreVisible(1005));
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.ownUpdatesAreVisible(1003));
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.ownUpdatesAreVisible(1004));
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.ownUpdatesAreVisible(1005));
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.doesMaxRowSizeIncludeBlobs());
        DatabaseMetaDataTest.assertEquals((String)"", (String)databaseMetaData.getCatalogSeparator());
        DatabaseMetaDataTest.assertEquals((String)"CATALOG", (String)databaseMetaData.getCatalogTerm());
        DatabaseMetaDataTest.assertEquals((int)2, (int)databaseMetaData.getDefaultTransactionIsolation());
        DatabaseMetaDataTest.assertEquals((String)"", (String)databaseMetaData.getExtraNameCharacters());
        DatabaseMetaDataTest.assertEquals((String)"\"", (String)databaseMetaData.getIdentifierQuoteString());
        DatabaseMetaDataTest.assertEquals((String)"PROCEDURE", (String)databaseMetaData.getProcedureTerm());
        DatabaseMetaDataTest.assertEquals((int)1, (int)databaseMetaData.getResultSetHoldability());
        DatabaseMetaDataTest.assertEquals((String)"SCHEMA", (String)databaseMetaData.getSchemaTerm());
        DatabaseMetaDataTest.assertEquals((String)"", (String)databaseMetaData.getSearchStringEscape());
        DatabaseMetaDataTest.assertEquals((int)2, (int)databaseMetaData.getSQLStateType());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.isCatalogAtStart());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.locatorsUpdateCopy());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.usesLocalFilePerTable());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.usesLocalFiles());
    }

    public void testVersionInfo() throws SQLException {
        DatabaseMetaData databaseMetaData = this.getDMD();
        int n = databaseMetaData.getDatabaseMajorVersion();
        int n2 = databaseMetaData.getDatabaseMinorVersion();
        int n3 = databaseMetaData.getDriverMajorVersion();
        int n4 = databaseMetaData.getDriverMinorVersion();
        String string = databaseMetaData.getDatabaseProductVersion();
        String string2 = databaseMetaData.getDriverVersion();
        if (DatabaseMetaDataTest.usingEmbedded()) {
            DatabaseMetaDataTest.assertEquals((String)"Embedded Major version ", (int)n, (int)n3);
            DatabaseMetaDataTest.assertEquals((String)"Embedded Minor version ", (int)n2, (int)n4);
            DatabaseMetaDataTest.assertEquals((String)"Embedded version", (String)string, (String)string2);
        }
        DatabaseMetaDataTest.assertEquals((String)"Apache Derby", (String)databaseMetaData.getDatabaseProductName());
        String string3 = databaseMetaData.getDriverName();
        if (DatabaseMetaDataTest.usingEmbedded()) {
            DatabaseMetaDataTest.assertEquals((String)"Apache Derby Embedded JDBC Driver", (String)string3);
        } else if (DatabaseMetaDataTest.usingDerbyNetClient()) {
            DatabaseMetaDataTest.assertEquals((String)"Apache Derby Network Client JDBC Driver", (String)string3);
        }
        int n5 = databaseMetaData.getJDBCMajorVersion();
        int n6 = databaseMetaData.getJDBCMinorVersion();
        int n7 = -1;
        int n8 = -1;
        if (JDBC.vmSupportsJDBC42()) {
            n7 = 4;
            n8 = 2;
        } else if (JDBC.vmSupportsJDBC41()) {
            n7 = 4;
            n8 = 1;
        } else if (JDBC.vmSupportsJDBC4()) {
            n7 = 4;
            n8 = 0;
        }
        if (n7 != -1) {
            DatabaseMetaDataTest.assertEquals((String)"JDBC Major version", (int)n7, (int)n5);
            DatabaseMetaDataTest.assertEquals((String)"JDBC Minor version", (int)n8, (int)n6);
        }
    }

    public void testGetURL() throws SQLException {
        String string;
        DatabaseMetaData databaseMetaData = this.getDMD();
        try {
            string = databaseMetaData.getURL();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            DatabaseMetaDataTest.assertTrue((String)"getURL not supported", (boolean)JDBC.vmSupportsJSR169());
            DatabaseMetaDataTest.assertFalse((String)"getURL not supported", (boolean)JDBC.vmSupportsJDBC3());
            return;
        }
        DatabaseMetaDataTest.assertFalse((String)"getURL is supported!", (boolean)JDBC.vmSupportsJSR169());
        DatabaseMetaDataTest.assertTrue((String)"getURL is supported!", (boolean)JDBC.vmSupportsJDBC3());
        TestConfiguration testConfiguration = this.getTestConfiguration();
        String string2 = testConfiguration.getJDBCUrl();
        if (DatabaseMetaDataTest.usingDerbyNetClient()) {
            List<String> list = Arrays.asList(string.split(";"));
            string = list.get(0);
            HashSet<String> hashSet = new HashSet<String>(list.subList(1, list.size()));
            HashSet<CallSite> hashSet2 = new HashSet<CallSite>();
            Properties properties = testConfiguration.getConnectionAttributes();
            for (String string3 : properties.stringPropertyNames()) {
                hashSet2.add((CallSite)((Object)(string3 + "=" + properties.getProperty(string3))));
            }
            DatabaseMetaDataTest.assertEquals((String)"Connection attributes don't match", hashSet2, hashSet);
        }
        DatabaseMetaDataTest.assertEquals((String)"getURL match", (String)string2, (String)string);
    }

    public void testIdentifierStorage() throws SQLException {
        DatabaseMetaData databaseMetaData = this.getDMD();
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.storesLowerCaseIdentifiers());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.storesLowerCaseQuotedIdentifiers());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.storesMixedCaseIdentifiers());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.storesMixedCaseQuotedIdentifiers());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.storesUpperCaseIdentifiers());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.storesUpperCaseQuotedIdentifiers());
    }

    public void testNullInfo() throws SQLException {
        DatabaseMetaData databaseMetaData = this.getDMD();
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.nullPlusNonNullIsNull());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.nullsAreSortedAtEnd());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.nullsAreSortedAtStart());
        DatabaseMetaDataTest.assertTrue((boolean)databaseMetaData.nullsAreSortedHigh());
        DatabaseMetaDataTest.assertFalse((boolean)databaseMetaData.nullsAreSortedLow());
    }

    public void testSQLKeywords() throws SQLException {
        String string = this.getDMD().getSQLKeywords();
        DatabaseMetaDataTest.assertNotNull((Object)string);
    }

    public void testConnectionSpecific() throws SQLException {
        DatabaseMetaData databaseMetaData = this.getDMD();
        DatabaseMetaDataTest.assertSame((Object)this.getConnection(), (Object)databaseMetaData.getConnection());
        DatabaseMetaDataTest.assertEquals((String)this.getTestConfiguration().getUserName(), (String)databaseMetaData.getUserName());
        DatabaseMetaDataTest.assertEquals((boolean)this.getConnection().isReadOnly(), (boolean)databaseMetaData.isReadOnly());
    }

    public void testConstants() {
        DatabaseMetaDataTest.assertEquals((int)0, (int)0);
        DatabaseMetaDataTest.assertEquals((int)1, (int)1);
        DatabaseMetaDataTest.assertEquals((int)2, (int)2);
    }

    public void testUDTs() throws Exception {
        Version version = this.getDataVersion(this.getConnection());
        if (version.compareTo(new Version(10, 6, 0, 0)) < 0) {
            return;
        }
        DatabaseMetaData databaseMetaData = this.getDMD();
        this.createObjectsForUDTTests();
        ResultSet resultSet = databaseMetaData.getUDTs(null, null, null, null);
        String[] stringArray = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS", "BASE_TYPE"};
        int[] nArray = new int[]{12, 12, 12, -1, 4, 12, 5};
        boolean[] blArray = new boolean[]{true, true, false, false, false, true, true};
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSet, stringArray, nArray, blArray);
        String[][] stringArray2 = new String[][]{{null, this.schema, "PRICE", "org.apache.derbyTesting.functionTests.tests.lang.Price", "2000", null, null}};
        JDBC.assertFullResultSet(resultSet, stringArray2);
        resultSet = databaseMetaData.getUDTs(null, null, null, new int[]{2000});
        JDBC.assertFullResultSet(resultSet, stringArray2);
        resultSet = databaseMetaData.getUDTs(null, null, null, new int[]{2001, 2000});
        JDBC.assertFullResultSet(resultSet, stringArray2);
        resultSet = databaseMetaData.getUDTs(null, null, null, new int[]{2001, 2002});
        JDBC.assertEmpty(resultSet);
        resultSet = databaseMetaData.getUDTs(null, this.schema, "PRICE", new int[]{2001, 2000});
        JDBC.assertFullResultSet(resultSet, stringArray2);
        resultSet = databaseMetaData.getUDTs(null, this.schema.substring(0, 2) + "%", "PRI%", new int[]{2001, 2000});
        JDBC.assertFullResultSet(resultSet, stringArray2);
        resultSet = databaseMetaData.getUDTs(null, "FOO", "PRICE", new int[]{2001, 2000});
        JDBC.assertEmpty(resultSet);
        resultSet = databaseMetaData.getColumns(null, this.schema, "ORDERS", null);
        stringArray2 = new String[][]{{"", this.schema, "ORDERS", "TOTALPRICE", "2000", "\"" + this.schema + "\".\"PRICE\"", "-1", null, null, null, "1", "", null, null, null, null, "1", "YES", null, null, null, null, "NO", "NO", null}};
        JDBC.assertFullResultSet(resultSet, stringArray2);
        resultSet = databaseMetaData.getColumns(null, this.schema, "ORDERS", null);
        this.crossCheckGetColumnsAndResultSetMetaData(resultSet, false, 0);
        this.dropObjectsForUDTTests();
    }

    private void createObjectsForUDTTests() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create type price external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java");
        statement.execute("create table orders( totalPrice price )");
        this.commit();
        this.getConnection().setAutoCommit(true);
    }

    private void dropObjectsForUDTTests() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("drop table orders");
        statement.execute("drop type price restrict");
        this.commit();
        this.getConnection().setAutoCommit(true);
    }

    public void testUnimplementedSQLObjectAttributes() throws SQLException {
        DatabaseMetaData databaseMetaData = this.getDMD();
        ResultSet resultSet = databaseMetaData.getAttributes(null, null, null, null);
        String[] stringArray = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "ATTR_NAME", "DATA_TYPE", "ATTR_TYPE_NAME", "ATTR_SIZE", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "ATTR_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE"};
        int[] nArray = new int[]{12, 12, 12, 12, 4, 12, 4, 4, 4, 4, 12, 12, 4, 4, 4, 4, 12, 12, 12, 12, 5};
        boolean bl = true;
        if (DatabaseMetaDataTest.usingDerbyNetClient()) {
            bl = false;
        }
        boolean[] blArray = new boolean[]{true, true, false, bl, bl, bl, bl, bl, bl, bl, true, true, bl, bl, bl, bl, bl, true, true, true, true};
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSet, stringArray, nArray, blArray);
        JDBC.assertEmpty(resultSet);
        resultSet = databaseMetaData.getCatalogs();
        this.checkCatalogsShape(resultSet);
        JDBC.assertEmpty(resultSet);
        resultSet = databaseMetaData.getSuperTables(null, null, null);
        stringArray = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "SUPERTABLE_NAME"};
        nArray = new int[]{12, 12, 12, 12};
        blArray = new boolean[]{true, true, false, false};
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSet, stringArray, nArray, blArray);
        JDBC.assertEmpty(resultSet);
        resultSet = databaseMetaData.getSuperTypes(null, null, null);
        stringArray = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SUPERTYPE_CAT", "SUPERTYPE_SCHEM", "SUPERTYPE_NAME"};
        nArray = new int[]{12, 12, 12, 12, 12, 12};
        blArray = new boolean[]{true, true, false, true, true, false};
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSet, stringArray, nArray, blArray);
        JDBC.assertEmpty(resultSet);
        ResultSet[] resultSetArray = this.getVersionColumns(null, null, "No_such_table");
        DatabaseMetaDataTest.checkVersionColumnsShape(resultSetArray);
        JDBC.assertEmpty(resultSetArray[0]);
        JDBC.assertEmpty(resultSetArray[1]);
        resultSet.close();
        resultSetArray[0].close();
        resultSetArray[1].close();
    }

    public ResultSet getVersionColumnsODBC(String string, String string2, String string3) throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL SYSIBM.SQLSPECIALCOLUMNS (2, ?, ?, ?, 1, 1, 'DATATYPE=''ODBC''')");
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string3);
        callableStatement.execute();
        return callableStatement.getResultSet();
    }

    private ResultSet[] getVersionColumns(String string, String string2, String string3) throws SQLException {
        ResultSet[] resultSetArray = new ResultSet[2];
        DatabaseMetaData databaseMetaData = this.getDMD();
        resultSetArray[0] = databaseMetaData.getVersionColumns(string, string2, string3);
        resultSetArray[1] = this.getVersionColumnsODBC(string, string2, string3);
        return resultSetArray;
    }

    public static String getStoredIdentifier(String string) {
        if (string.charAt(0) == '\"') {
            return string.substring(1, string.length() - 1);
        }
        return string.toUpperCase(Locale.ENGLISH);
    }

    public void testGetSchemasReadOnly() throws SQLException {
        DatabaseMetaData databaseMetaData = this.getDMD();
        ResultSet resultSet = databaseMetaData.getSchemas();
        DatabaseMetaDataTest.checkSchemas(resultSet, new String[0]);
    }

    public void testGetSchemasModify() throws SQLException {
        this.createSchemasForTests();
        DatabaseMetaData databaseMetaData = this.getDMD();
        ResultSet resultSet = databaseMetaData.getSchemas();
        DatabaseMetaDataTest.checkSchemas(resultSet, IDS);
    }

    private void createSchemasForTests() throws SQLException {
        this.modifiedDatabase = true;
        Statement statement = this.createStatement();
        for (String string : IDS) {
            statement.executeUpdate("CREATE SCHEMA " + string);
        }
        statement.close();
        this.commit();
    }

    public static void checkSchemas(ResultSet resultSet, String[] stringArray) throws SQLException {
        int n;
        DatabaseMetaDataTest.checkSchemasShape(resultSet);
        Object[] objectArray = new String[BUILTIN_SCHEMAS.length + stringArray.length];
        System.arraycopy(BUILTIN_SCHEMAS, 0, objectArray, 0, BUILTIN_SCHEMAS.length);
        System.arraycopy(stringArray, 0, objectArray, BUILTIN_SCHEMAS.length, stringArray.length);
        for (n = BUILTIN_SCHEMAS.length; n < objectArray.length; ++n) {
            objectArray[n] = DatabaseMetaDataTest.getStoredIdentifier((String)objectArray[n]);
        }
        Arrays.sort(objectArray);
        n = 0;
        while (resultSet.next()) {
            String string = resultSet.getString("TABLE_SCHEM");
            DatabaseMetaDataTest.assertNotNull((Object)string);
            DatabaseMetaDataTest.assertNull((Object)resultSet.getString("TABLE_CATALOG"));
            if (n >= objectArray.length || !((String)objectArray[n]).equals(string)) continue;
            ++n;
        }
        resultSet.close();
        DatabaseMetaDataTest.assertEquals((String)"Schemas missing ", (int)objectArray.length, (int)n);
    }

    private static void checkSchemasShape(ResultSet resultSet) throws SQLException {
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSet, new String[]{"TABLE_SCHEM", "TABLE_CATALOG"}, new int[]{12, 12}, new boolean[]{false, true});
    }

    private ResultSet getDMDTables(DatabaseMetaData databaseMetaData, String string, String string2, String string3, String[] stringArray) throws SQLException, IOException {
        this.checkGetTablesODBC(string, string2, string3, stringArray);
        return databaseMetaData.getTables(string, string2, string3, stringArray);
    }

    public void testGetTablesReadOnly() throws SQLException, IOException {
        DatabaseMetaData databaseMetaData = this.getDMD();
        ResultSet resultSet = this.getDMDTables(databaseMetaData, null, null, null, null);
        this.checkTablesShape(resultSet);
        int n = JDBC.assertDrainResults(resultSet);
        DatabaseMetaDataTest.assertTrue((String)"getTables() on all was empty!", (n > 0 ? 1 : 0) != 0);
        resultSet = this.getDMDTables(databaseMetaData, "%", "%", "%", null);
        this.checkTablesShape(resultSet);
        DatabaseMetaDataTest.assertEquals((String)"Different counts from getTables", (int)n, (int)JDBC.assertDrainResults(resultSet));
        resultSet = this.getDMDTables(databaseMetaData, null, "NO_such_schema", null, null);
        this.checkTablesShape(resultSet);
        JDBC.assertEmpty(resultSet);
        resultSet = this.getDMDTables(databaseMetaData, null, "SQLJ", null, null);
        this.checkTablesShape(resultSet);
        JDBC.assertEmpty(resultSet);
        resultSet = this.getDMDTables(databaseMetaData, null, "SQLJ", "%", null);
        this.checkTablesShape(resultSet);
        JDBC.assertEmpty(resultSet);
        resultSet = this.getDMDTables(databaseMetaData, null, "SYS", "No_such_table", null);
        this.checkTablesShape(resultSet);
        JDBC.assertEmpty(resultSet);
        String[] stringArray = new String[]{"TABLE"};
        resultSet = this.getDMDTables(databaseMetaData, null, "SYS", null, stringArray);
        this.checkTablesShape(resultSet);
        JDBC.assertEmpty(resultSet);
        resultSet = this.getDMDTables(databaseMetaData, null, "SYS", "%", stringArray);
        this.checkTablesShape(resultSet);
        JDBC.assertEmpty(resultSet);
        String[] stringArray2 = new String[]{"SYSTEM_TABLE"};
        resultSet = this.getDMDTables(databaseMetaData, null, "SYS", null, stringArray2);
        this.checkTablesShape(resultSet);
        int n2 = JDBC.assertDrainResults(resultSet);
        DatabaseMetaDataTest.assertTrue((String)"getTables() on system tables was empty!", (n2 > 0 ? 1 : 0) != 0);
        resultSet = this.getDMDTables(databaseMetaData, null, "SYS", "%", stringArray2);
        this.checkTablesShape(resultSet);
        DatabaseMetaDataTest.assertEquals((int)n2, (int)JDBC.assertDrainResults(resultSet));
        String[] stringArray3 = new String[]{"VIEW"};
        resultSet = this.getDMDTables(databaseMetaData, null, "SYS", null, stringArray3);
        JDBC.assertEmpty(resultSet);
        resultSet = this.getDMDTables(databaseMetaData, null, "SYS", "%", stringArray3);
        JDBC.assertEmpty(resultSet);
        String[] stringArray4 = new String[]{"SYNONYM", "SYSTEM TABLE", "TABLE", "VIEW"};
        resultSet = this.getDMDTables(databaseMetaData, null, null, null, stringArray4);
        this.checkTablesShape(resultSet);
        DatabaseMetaDataTest.assertEquals((String)"Different counts from getTables", (int)n, (int)JDBC.assertDrainResults(resultSet));
        resultSet = this.getDMDTables(databaseMetaData, "%", "%", "%", stringArray4);
        this.checkTablesShape(resultSet);
        DatabaseMetaDataTest.assertEquals((String)"Different counts from getTables", (int)n, (int)JDBC.assertDrainResults(resultSet));
    }

    public void testGetTablesModify() throws Exception {
        String string;
        int n;
        Object object;
        int n2 = this.createTablesForTest(false);
        DatabaseMetaData databaseMetaData = this.getDMD();
        String[] stringArray = new String[]{"TABLE"};
        Object[] objectArray = this.getSortedIdentifiers();
        ResultSet resultSet = this.getDMDTables(databaseMetaData, null, null, null, stringArray);
        this.checkTablesShape(resultSet);
        int n3 = 0;
        while (resultSet.next()) {
            boolean bl;
            DatabaseMetaDataTest.assertEquals((String)"TABLE_CAT", (String)"", (String)resultSet.getString("TABLE_CAT"));
            object = resultSet.getString("TABLE_SCHEM");
            boolean bl2 = bl = Arrays.binarySearch(objectArray, object) >= 0;
            if (bl) {
                DatabaseMetaDataTest.assertEquals((String)"TABLE_SCHEM", (String)objectArray[n3 / objectArray.length], (String)object);
                DatabaseMetaDataTest.assertEquals((String)"TABLE_NAME", (String)objectArray[n3 % objectArray.length], (String)resultSet.getString("TABLE_NAME"));
            }
            DatabaseMetaDataTest.assertEquals((String)"TABLE_TYPE", (String)"TABLE", (String)resultSet.getString("TABLE_TYPE"));
            DatabaseMetaDataTest.assertEquals((String)"REMARKS", (String)"", (String)resultSet.getString("REMARKS"));
            DatabaseMetaDataTest.assertNull((String)"TYPE_CAT", (Object)resultSet.getString("TYPE_CAT"));
            DatabaseMetaDataTest.assertNull((String)"TYPE_SCHEM", (Object)resultSet.getString("TYPE_SCHEM"));
            DatabaseMetaDataTest.assertNull((String)"TYPE_NAME", (Object)resultSet.getString("TYPE_NAME"));
            DatabaseMetaDataTest.assertNull((String)"SELF_REFERENCING_COL_NAME", (Object)resultSet.getString("SELF_REFERENCING_COL_NAME"));
            DatabaseMetaDataTest.assertNull((String)"REF_GENERATION", (Object)resultSet.getString("REF_GENERATION"));
            if (!bl) continue;
            ++n3;
        }
        resultSet.close();
        DatabaseMetaDataTest.assertEquals((String)"getTables count for all user tables", (int)n2, (int)n3);
        object = new Random();
        for (Object object2 : objectArray) {
            n = ((Random)object).nextInt(6);
            string = ((String)object2).substring(0, n + 2) + "%";
            resultSet = this.getDMDTables(databaseMetaData, null, string, null, stringArray);
            this.checkTablesShape(resultSet);
            n3 = 0;
            while (resultSet.next()) {
                DatabaseMetaDataTest.assertEquals((String)"TABLE_SCHEM", (String)object2, (String)resultSet.getString("TABLE_SCHEM"));
                DatabaseMetaDataTest.assertEquals((String)"TABLE_NAME", (String)objectArray[n3 % objectArray.length], (String)resultSet.getString("TABLE_NAME"));
                DatabaseMetaDataTest.assertEquals((String)"TABLE_TYPE", (String)"TABLE", (String)resultSet.getString("TABLE_TYPE"));
                ++n3;
            }
            resultSet.close();
            DatabaseMetaDataTest.assertEquals((String)"getTables count schema pattern", (int)objectArray.length, (int)n3);
        }
        for (Object object2 : objectArray) {
            n = ((Random)object).nextInt(6);
            string = ((String)object2).substring(0, n + 2) + "%";
            resultSet = this.getDMDTables(databaseMetaData, null, null, string, stringArray);
            this.checkTablesShape(resultSet);
            n3 = 0;
            while (resultSet.next()) {
                DatabaseMetaDataTest.assertEquals((String)"TABLE_SCHEM", (String)objectArray[n3 % objectArray.length], (String)resultSet.getString("TABLE_SCHEM"));
                DatabaseMetaDataTest.assertEquals((String)"TABLE_TYPE", (String)"TABLE", (String)resultSet.getString("TABLE_TYPE"));
                DatabaseMetaDataTest.assertEquals((String)"TABLE_NAME", (String)object2, (String)resultSet.getString("TABLE_NAME"));
                ++n3;
            }
            resultSet.close();
            DatabaseMetaDataTest.assertEquals((String)"getTables count schema pattern", (int)objectArray.length, (int)n3);
        }
    }

    private void checkGetTablesODBC(String string, String string2, String string3, String[] stringArray) throws SQLException, IOException {
        Object object;
        String string4 = null;
        if (stringArray != null) {
            int n = stringArray.length;
            object = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    ((StringBuilder)object).append(",");
                }
                ((StringBuilder)object).append(stringArray[i]);
            }
            string4 = ((StringBuilder)object).toString();
        }
        CallableStatement callableStatement = this.prepareCall("CALL SYSIBM.SQLTABLES(?, ?, ?, ?, 'DATATYPE=''ODBC''')");
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string3);
        callableStatement.setString(4, string4);
        callableStatement.execute();
        object = callableStatement.getResultSet();
        DatabaseMetaDataTest.assertNotNull((Object)object);
        this.checkTablesShape((ResultSet)object);
        ResultSet resultSet = this.getDMD().getTables(string, string2, string3, stringArray);
        JDBC.assertSameContents((ResultSet)object, resultSet);
        callableStatement.close();
    }

    private int createTablesForTest(boolean bl) throws Exception {
        Version version;
        this.getConnection().setAutoCommit(false);
        List<String> list = DatabaseMetaDataTest.getSQLTypes(this.getConnection());
        if (bl) {
            list.remove("XML");
        }
        if ((version = this.getDataVersion(this.getConnection())).compareTo(new Version(10, 7, 0, 0)) < 0) {
            list.remove("BOOLEAN");
        }
        int n = list.size();
        this.createSchemasForTests();
        Statement statement = this.createStatement();
        int n2 = 0;
        for (String string : IDS) {
            for (String string2 : IDS) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("CREATE TABLE ");
                stringBuilder.append(string);
                stringBuilder.append('.');
                stringBuilder.append(string2);
                stringBuilder.append(" (");
                for (int i = 1; i <= 5; ++i) {
                    boolean bl2;
                    String string3 = IDS[n2 % IDS.length];
                    boolean bl3 = bl2 = string3.charAt(string3.length() - 1) == '\"';
                    if (bl2) {
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                    stringBuilder.append(string3);
                    stringBuilder.append('_');
                    stringBuilder.append(i);
                    if (bl2) {
                        stringBuilder.append('\"');
                    }
                    stringBuilder.append(' ');
                    stringBuilder.append(list.get(n2++ % n));
                    if (i >= 5) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append(")");
                statement.execute(stringBuilder.toString());
            }
        }
        statement.close();
        this.commit();
        return IDS.length * IDS.length;
    }

    public void testGetColumnsReadOnly() throws Exception {
        ResultSet[] resultSetArray = this.getColumns(null, null, null, null);
        for (int i = 0; i < 2; ++i) {
            this.checkColumnsShape(resultSetArray[i], i);
            this.crossCheckGetColumnsAndResultSetMetaData(resultSetArray[i], false, i);
        }
    }

    public void testGetColumnsModify() throws Exception {
        int n = this.createTablesForTest(true);
        this.testGetColumnsReadOnly();
        Random random = new Random();
        String[] stringArray = this.getSortedIdentifiers();
        for (int i = 1; i < 20; ++i) {
            String string;
            String string2;
            int n2;
            int n3 = 0;
            String string3 = this.getPattern(random, stringArray);
            String string4 = this.getPattern(random, stringArray);
            String string5 = this.getPattern(random, stringArray);
            ResultSet[] resultSetArray = this.getColumns(null, string3, string4, string5);
            for (n2 = 0; n2 < 2; ++n2) {
                this.checkColumnsShape(resultSetArray[n2], n2);
                while (resultSetArray[n2].next()) {
                    String string6 = resultSetArray[n2].getString("TABLE_SCHEM");
                    string2 = resultSetArray[n2].getString("TABLE_NAME");
                    string = resultSetArray[n2].getString("COLUMN_NAME");
                    this.assertMatchesPattern(string3, string6);
                    this.assertMatchesPattern(string4, string2);
                    this.assertMatchesPattern(string5, string);
                    ++n3;
                }
                resultSetArray[n2].close();
            }
            resultSetArray = this.getColumns(null, string3, string4, string5);
            for (n2 = 0; n2 < 2; ++n2) {
                this.crossCheckGetColumnsAndResultSetMetaData(resultSetArray[n2], true, n2);
            }
            resultSetArray = this.getColumns(null, null, null, null);
            n2 = 0;
            for (int j = 0; j < 2; ++j) {
                while (resultSetArray[j].next()) {
                    string2 = resultSetArray[j].getString("TABLE_SCHEM");
                    string = resultSetArray[j].getString("TABLE_NAME");
                    String string7 = resultSetArray[j].getString("COLUMN_NAME");
                    if (!this.doesMatch(string3, 0, string2, 0) || !this.doesMatch(string4, 0, string, 0) || !this.doesMatch(string5, 0, string7, 0)) continue;
                    ++n2;
                }
                resultSetArray[j].close();
            }
            DatabaseMetaDataTest.assertEquals((String)"Mismatched column count on getColumns() filtering", (int)n3, (int)n2);
        }
    }

    private void assertMatchesPattern(String string, String string2) {
        if (!this.doesMatch(string, 0, string2, 0)) {
            DatabaseMetaDataTest.fail((String)("Bad pattern matching:" + string + " result:" + string2));
        }
    }

    private boolean doesMatch(String string, int n, String string2, int n2) {
        while (n != string.length() || n2 != string2.length()) {
            if (n == string.length()) {
                return false;
            }
            char c = string.charAt(n);
            if (c == '_') {
                if (n2 == string2.length()) {
                    return false;
                }
                ++n;
                ++n2;
                continue;
            }
            if (c == '%') {
                if (n == string.length() - 1) {
                    return true;
                }
                for (int i = n2; i < string2.length(); ++i) {
                    if (!this.doesMatch(string, n + 1, string2, i)) continue;
                    return true;
                }
                return false;
            }
            if (n2 == string2.length()) {
                return false;
            }
            if (c != string2.charAt(n2)) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    private String getPattern(Random random, String[] stringArray) {
        int n = random.nextInt(100);
        if (n < 10) {
            return "%";
        }
        if (n < 30) {
            return stringArray[random.nextInt(stringArray.length)];
        }
        String string = n < 40 ? "XxZZzXXZZZxxXxZz" : stringArray[random.nextInt(stringArray.length)];
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < string.length()) {
            boolean bl;
            int n3 = random.nextInt(10);
            if (n3 < 5) {
                n3 = 0;
            }
            if (stringBuilder.length() == 0) {
                bl = false;
            } else {
                char c = stringBuilder.charAt(stringBuilder.length() - 1);
                boolean bl2 = bl = c == '_' || c == '%';
            }
            if (n3 == 0) {
                stringBuilder.append(string.charAt(n2++));
                continue;
            }
            if (n3 == 5) {
                ++n2;
                if (bl) continue;
                stringBuilder.append('_');
                continue;
            }
            n2 += n3 - 5;
            if (bl) continue;
            stringBuilder.append('%');
        }
        return stringBuilder.toString();
    }

    private void crossCheckGetColumnsAndResultSetMetaData(ResultSet resultSet, boolean bl, int n) throws Exception {
        Statement statement = this.createStatement();
        while (resultSet.next()) {
            String string = resultSet.getString("TABLE_SCHEM");
            String string2 = resultSet.getString("TABLE_NAME");
            ResultSet resultSet2 = statement.executeQuery("SELECT * FROM " + JDBC.escape(string, string2));
            ResultSetMetaData resultSetMetaData = resultSet2.getMetaData();
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                if (!bl) {
                    if (i != 1) {
                        DatabaseMetaDataTest.assertTrue((boolean)resultSet.next());
                    }
                    DatabaseMetaDataTest.assertEquals((String)"ORDINAL_POSITION", (int)i, (int)resultSet.getInt("ORDINAL_POSITION"));
                }
                DatabaseMetaDataTest.assertEquals((String)"TABLE_CAT", (String)"", (String)resultSet.getString("TABLE_CAT"));
                DatabaseMetaDataTest.assertEquals((String)"TABLE_SCHEM", (String)string, (String)resultSet.getString("TABLE_SCHEM"));
                DatabaseMetaDataTest.assertEquals((String)"TABLE_NAME", (String)string2, (String)resultSet.getString("TABLE_NAME"));
                this.crossCheckGetColumnRowAndResultSetMetaData(resultSet, resultSetMetaData, n);
                if (bl) break;
            }
            resultSet2.close();
        }
        resultSet.close();
        statement.close();
    }

    public void crossCheckGetColumnRowAndResultSetMetaData(ResultSet resultSet, ResultSetMetaData resultSetMetaData, int n) throws Exception {
        boolean bl;
        int n2 = resultSet.getInt("ORDINAL_POSITION");
        Version version = this.getDataVersion(this.getConnection());
        String string = resultSet.getString("TABLE_CAT");
        String string2 = resultSet.getString("TABLE_SCHEM");
        String string3 = resultSet.getString("TABLE_NAME");
        ResultSet resultSet2 = resultSet.getStatement().getConnection().getMetaData().getTables(string, string2, string3, JDBC.GET_TABLES_VIEW);
        boolean bl2 = bl = JDBC.assertDrainResults(resultSet2) > 0;
        if (!bl) {
            DatabaseMetaDataTest.assertEquals((String)"RSMD.getCatalogName", (String)string, (String)resultSetMetaData.getCatalogName(n2));
            DatabaseMetaDataTest.assertEquals((String)"RSMD.getSchemaName", (String)string2, (String)resultSetMetaData.getSchemaName(n2));
            DatabaseMetaDataTest.assertEquals((String)"RSMD.getTableName", (String)string3, (String)resultSetMetaData.getTableName(n2));
        }
        DatabaseMetaDataTest.assertEquals((String)"COLUMN_NAME", (String)resultSetMetaData.getColumnName(n2), (String)resultSet.getString("COLUMN_NAME"));
        int n3 = resultSet.getInt("DATA_TYPE");
        if (n3 == 2000 && DatabaseMetaDataTest.usingDerbyNetClient() && version.compareTo(new Version(10, 6, 0, 0)) < 0) {
            DatabaseMetaDataTest.assertEquals((String)"DATA_TYPE", (int)-4, (int)resultSetMetaData.getColumnType(n2));
        } else if (n3 == -3 && DatabaseMetaDataTest.usingDerbyNetClient()) {
            DatabaseMetaDataTest.assertEquals((String)"DATA_TYPE", (int)-3, (int)resultSetMetaData.getColumnType(n2));
        } else if (n3 == -2 && DatabaseMetaDataTest.usingDerbyNetClient()) {
            DatabaseMetaDataTest.assertEquals((String)"DATA_TYPE", (int)-2, (int)resultSetMetaData.getColumnType(n2));
        } else if (n3 == 2 && DatabaseMetaDataTest.usingDerbyNetClient()) {
            DatabaseMetaDataTest.assertEquals((String)"DATA_TYPE", (int)3, (int)resultSetMetaData.getColumnType(n2));
            DatabaseMetaDataTest.assertEquals((String)"TYPE_NAME", (String)"DECIMAL", (String)resultSetMetaData.getColumnTypeName(n2));
            DatabaseMetaDataTest.assertEquals((String)"TYPE_NAME", (String)"NUMERIC", (String)resultSet.getString("TYPE_NAME"));
        } else {
            DatabaseMetaDataTest.assertEquals((String)"DATA_TYPE", (int)resultSetMetaData.getColumnType(n2), (int)resultSet.getInt("DATA_TYPE"));
            DatabaseMetaDataTest.assertEquals((String)"TYPE_NAME", (String)resultSetMetaData.getColumnTypeName(n2), (String)resultSet.getString("TYPE_NAME"));
        }
        if (n == 0) {
            DatabaseMetaDataTest.assertEquals((String)"BUFFER_LENGTH", (int)0, (int)resultSet.getInt("BUFFER_LENGTH"));
            DatabaseMetaDataTest.assertTrue((String)"BUFFER_LENGTH", (boolean)resultSet.wasNull());
        } else if (n2 == 0) {
            DatabaseMetaDataTest.assertEquals((String)"BUFFER_LENGTH", (int)0, (int)resultSet.getInt("BUFFER_LENGTH"));
        } else {
            DatabaseMetaDataTest.assertTrue((resultSet.getInt("BUFFER_LENGTH") != 0 ? 1 : 0) != 0);
        }
        DatabaseMetaDataTest.assertEquals((String)"NULLABLE", (int)resultSetMetaData.isNullable(n2), (int)resultSet.getInt("NULLABLE"));
        DatabaseMetaDataTest.assertEquals((String)"REMARKS", (String)"", (String)resultSet.getString("REMARKS"));
        if (n == 0) {
            DatabaseMetaDataTest.assertEquals((String)"SQL_DATA_TYPE", (int)0, (int)resultSet.getInt("SQL_DATA_TYPE"));
            DatabaseMetaDataTest.assertTrue((boolean)resultSet.wasNull());
            DatabaseMetaDataTest.assertEquals((String)"SQL_DATETIME_SUB", (int)0, (int)resultSet.getInt("SQL_DATETIME_SUB"));
            DatabaseMetaDataTest.assertTrue((boolean)resultSet.wasNull());
        } else if (n3 == 91) {
            DatabaseMetaDataTest.assertTrue((resultSet.getInt("SQL_DATA_TYPE") == 9 ? 1 : 0) != 0);
            DatabaseMetaDataTest.assertTrue((resultSet.getInt("SQL_DATETIME_SUB") == 1 ? 1 : 0) != 0);
        } else if (n3 == 92) {
            DatabaseMetaDataTest.assertTrue((resultSet.getInt("SQL_DATA_TYPE") == 9 ? 1 : 0) != 0);
            DatabaseMetaDataTest.assertTrue((resultSet.getInt("SQL_DATETIME_SUB") == 2 ? 1 : 0) != 0);
        } else if (n3 == 93) {
            DatabaseMetaDataTest.assertTrue((resultSet.getInt("SQL_DATA_TYPE") == 9 ? 1 : 0) != 0);
            DatabaseMetaDataTest.assertTrue((resultSet.getInt("SQL_DATETIME_SUB") == 3 ? 1 : 0) != 0);
        } else {
            DatabaseMetaDataTest.assertTrue((resultSet.getInt("SQL_DATA_TYPE") == n3 ? 1 : 0) != 0);
        }
        switch (resultSetMetaData.isNullable(n2)) {
            case 0: {
                DatabaseMetaDataTest.assertEquals((String)"IS_NULLABLE", (String)"NO", (String)resultSet.getString("IS_NULLABLE"));
                break;
            }
            case 1: {
                DatabaseMetaDataTest.assertEquals((String)"IS_NULLABLE", (String)"YES", (String)resultSet.getString("IS_NULLABLE"));
                break;
            }
            case 2: {
                DatabaseMetaDataTest.assertEquals((String)"IS_NULLABLE", (String)"", (String)resultSet.getString("IS_NULLABLE"));
                break;
            }
            default: {
                DatabaseMetaDataTest.fail((String)"invalid return from rsmdt.isNullable(col)");
            }
        }
        DatabaseMetaDataTest.assertNull((String)"SCOPE_CATALOG", (Object)resultSet.getString("SCOPE_CATALOG"));
        DatabaseMetaDataTest.assertNull((String)"SCOPE_CATLOG", (Object)resultSet.getString("SCOPE_CATLOG"));
        DatabaseMetaDataTest.assertNull((String)"SCOPE_SCHEMA", (Object)resultSet.getString("SCOPE_SCHEMA"));
        DatabaseMetaDataTest.assertNull((String)"SCOPE_TABLE", (Object)resultSet.getString("SCOPE_TABLE"));
        DatabaseMetaDataTest.assertEquals((String)"SOURCE_DATA_TYPE", (int)0, (int)resultSet.getShort("SOURCE_DATA_TYPE"));
        DatabaseMetaDataTest.assertTrue((boolean)resultSet.wasNull());
        DatabaseMetaDataTest.assertEquals((String)"IS_AUTOINCREMENT", (String)(resultSetMetaData.isAutoIncrement(n2) ? "YES" : "NO"), (String)resultSet.getString("IS_AUTOINCREMENT"));
        DatabaseMetaDataTest.assertFalse((boolean)resultSet.wasNull());
    }

    private ResultSet getColumnsODBC(String string, String string2, String string3, String string4) throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL SYSIBM.SQLCOLUMNS(?, ?, ?, ?, 'DATATYPE=''ODBC''')");
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string3);
        callableStatement.setString(4, string4);
        callableStatement.execute();
        return callableStatement.getResultSet();
    }

    private ResultSet[] getColumns(String string, String string2, String string3, String string4) throws SQLException {
        ResultSet[] resultSetArray = new ResultSet[2];
        DatabaseMetaData databaseMetaData = this.getDMD();
        resultSetArray[0] = databaseMetaData.getColumns(string, string2, string3, string4);
        resultSetArray[1] = this.getColumnsODBC(string, string2, string3, string4);
        return resultSetArray;
    }

    public void testTableTypes() throws SQLException {
        DatabaseMetaData databaseMetaData = this.getDMD();
        ResultSet resultSet = databaseMetaData.getTableTypes();
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSet, new String[]{"TABLE_TYPE"}, new int[]{12}, null);
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"SYNONYM"}, {"SYSTEM TABLE"}, {"TABLE"}, {"VIEW"}}, true);
        resultSet.close();
    }

    public void testGetTypeInfo() throws Exception {
        Object object;
        String[] stringArray;
        boolean bl;
        int n = 16;
        String[] stringArray2 = new String[]{"TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX"};
        int[] nArray = new int[]{12, 4, 4, 12, 12, 12, 5, n, 5, n, n, n, 12, 5, 5, 4, 4, 4};
        boolean[] blArray = new boolean[]{false, false, true, true, true, true, false, false, false, true, false, true, true, true, true, true, true, true};
        blArray[0] = true;
        ResultSet resultSet = this.getDMD().getTypeInfo();
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSet, stringArray2, nArray, blArray);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(Arrays.asList(-5, -2, 2004, 16, 1, 2005, 91, 3, 8, 6, 4, -4, -1, 2, 7, 5, 92, 93, -3, 12, 2009, 2000));
        Version version = this.getDataVersion(this.getConnection());
        boolean bl2 = bl = version.compareTo(new Version(10, 7, 0, 0)) >= 0;
        if (!bl) {
            arrayList.remove((Object)16);
        }
        Collections.sort(arrayList);
        int n2 = 0;
        while (resultSet.next()) {
            int n3;
            boolean bl3;
            boolean bl4;
            stringArray = resultSet.getString("TYPE_NAME");
            DatabaseMetaDataTest.assertNotNull((Object)stringArray);
            int n4 = resultSet.getInt("DATA_TYPE");
            DatabaseMetaDataTest.assertFalse((boolean)resultSet.wasNull());
            if (!((Integer)arrayList.get(n2)).equals(n4)) {
                DatabaseMetaDataTest.fail((String)("Unexpected type " + (String)stringArray));
            } else {
                ++n2;
            }
            int n5 = -1;
            switch (n4) {
                case 16: {
                    n5 = 1;
                    break;
                }
                case -2: 
                case 1: {
                    n5 = 254;
                    break;
                }
                case 2004: 
                case 2005: {
                    n5 = Integer.MAX_VALUE;
                    break;
                }
                case 91: {
                    n5 = 10;
                    break;
                }
                case 92: {
                    n5 = 8;
                    break;
                }
                case 93: {
                    n5 = 29;
                    break;
                }
                case 2: 
                case 3: {
                    n5 = 31;
                    break;
                }
                case 6: 
                case 8: {
                    n5 = 52;
                    break;
                }
                case 7: {
                    n5 = 23;
                    break;
                }
                case -5: {
                    n5 = 19;
                    break;
                }
                case 4: {
                    n5 = 10;
                    break;
                }
                case 5: {
                    n5 = 5;
                    break;
                }
                case -4: 
                case -1: {
                    n5 = 32700;
                    break;
                }
                case -3: {
                    n5 = 32672;
                    break;
                }
                case 12: {
                    n5 = 32672;
                    break;
                }
                case 2000: 
                case 2009: {
                    n5 = 0;
                }
            }
            DatabaseMetaDataTest.assertEquals((String)("PRECISION " + (String)stringArray), (int)n5, (int)resultSet.getInt("PRECISION"));
            if (stringArray.equals("XML") || stringArray.equals("OBJECT")) {
                DatabaseMetaDataTest.assertTrue((boolean)resultSet.wasNull());
            } else {
                DatabaseMetaDataTest.assertFalse((boolean)resultSet.wasNull());
            }
            switch (n4) {
                case -3: 
                case -2: 
                case 1: 
                case 12: 
                case 2004: 
                case 2005: {
                    object = "length";
                    break;
                }
                case 2: 
                case 3: {
                    object = "precision,scale";
                    break;
                }
                case 6: {
                    object = "precision";
                    break;
                }
                default: {
                    object = null;
                }
            }
            DatabaseMetaDataTest.assertEquals((String)("CREATE_PARAMS " + (String)stringArray), (String)object, (String)resultSet.getString("CREATE_PARAMS"));
            DatabaseMetaDataTest.assertEquals((String)("NULLABLE " + (String)stringArray), (int)1, (int)resultSet.getInt("NULLABLE"));
            DatabaseMetaDataTest.assertFalse((boolean)resultSet.wasNull());
            switch (n4) {
                case -4: {
                    bl4 = false;
                    break;
                }
                case -1: {
                    bl4 = true;
                    break;
                }
                case 2004: {
                    bl4 = false;
                    break;
                }
                case 2005: {
                    bl4 = true;
                    break;
                }
                case 1: 
                case 12: {
                    bl4 = 3 != 0;
                    break;
                }
                case 2009: {
                    bl4 = false;
                    break;
                }
                default: {
                    bl4 = 2 != 0;
                }
            }
            DatabaseMetaDataTest.assertEquals((String)("SEARCHABLE " + (String)stringArray), (int)(bl4 ? 1 : 0), (int)resultSet.getInt("SEARCHABLE"));
            bl4 = n4 == 3 || n4 == 2;
            DatabaseMetaDataTest.assertEquals((String)("FIXED_PREC_SCALE " + (String)stringArray), (boolean)bl4, (boolean)resultSet.getBoolean("FIXED_PREC_SCALE"));
            DatabaseMetaDataTest.assertFalse((boolean)resultSet.wasNull());
            switch (n4) {
                case -5: 
                case 4: 
                case 5: {
                    bl3 = true;
                    break;
                }
                default: {
                    bl3 = false;
                }
            }
            DatabaseMetaDataTest.assertEquals((String)("AUTO_INCREMENT " + (String)stringArray), (boolean)bl3, (boolean)resultSet.getBoolean("AUTO_INCREMENT"));
            DatabaseMetaDataTest.assertEquals((String)("LOCAL_TYPE_NAME " + (String)stringArray), (String)stringArray, (String)resultSet.getString("LOCAL_TYPE_NAME"));
            boolean bl5 = true;
            switch (n4) {
                case 2: 
                case 3: {
                    n3 = 31;
                    break;
                }
                case 93: {
                    n3 = 9;
                    break;
                }
                case -5: 
                case 4: 
                case 5: 
                case 91: 
                case 92: {
                    n3 = 0;
                    break;
                }
                default: {
                    n3 = 0;
                    bl5 = false;
                }
            }
            DatabaseMetaDataTest.assertEquals((String)("MINIMUM_SCALE " + (String)stringArray), (int)0, (int)resultSet.getInt("MINIMUM_SCALE"));
            DatabaseMetaDataTest.assertEquals((String)("MINIMUM_SCALE (wasNull) " + (String)stringArray), (!bl5 ? 1 : 0) != 0, (boolean)resultSet.wasNull());
            DatabaseMetaDataTest.assertEquals((String)("MAXIMUM_SCALE " + (String)stringArray), (int)n3, (int)resultSet.getInt("MAXIMUM_SCALE"));
            DatabaseMetaDataTest.assertEquals((String)("MAXIMUM_SCALE (wasNull)" + (String)stringArray), (!bl5 ? 1 : 0) != 0, (boolean)resultSet.wasNull());
            DatabaseMetaDataTest.assertEquals((String)("SQL_DATA_TYPE " + (String)stringArray), (int)0, (int)resultSet.getInt("SQL_DATA_TYPE"));
            DatabaseMetaDataTest.assertTrue((boolean)resultSet.wasNull());
            DatabaseMetaDataTest.assertEquals((String)("SQL_DATETIME_SUB " + (String)stringArray), (int)0, (int)resultSet.getInt("SQL_DATETIME_SUB"));
            DatabaseMetaDataTest.assertTrue((boolean)resultSet.wasNull());
        }
        resultSet.close();
        stringArray = new String[19];
        System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
        stringArray[2] = "COLUMN_SIZE";
        stringArray[11] = "AUTO_UNIQUE_VAL";
        stringArray[18] = "INTERVAL_PRECISION";
        int[] nArray2 = new int[stringArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        nArray2[1] = 5;
        nArray2[7] = 5;
        nArray2[9] = 5;
        nArray2[10] = 5;
        nArray2[11] = 5;
        nArray2[15] = 5;
        nArray2[16] = 5;
        nArray2[18] = 5;
        boolean[] blArray2 = new boolean[]{true, false, true, true, true, true, false, false, false, true, false, true, true, true, true, false, true, true, true};
        object = this.prepareCall("CALL SYSIBM.SQLGETTYPEINFO (0, 'DATATYPE=''ODBC''')");
        object.execute();
        ResultSet resultSet2 = object.getResultSet();
        DatabaseMetaDataTest.assertNotNull((Object)resultSet2);
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSet2, stringArray, nArray2, blArray2);
        resultSet2.close();
        object.close();
    }

    private void checkColumnsShape(ResultSet resultSet, int n) throws SQLException {
        int[] nArray = new int[]{12, 12, 12, 12, 4, 12, 4, 4, 4, 4, 4, 12, 12, 4, 4, 4, 4, 12, 12, 12, 12, 5, 12, 12, 12};
        boolean[] blArray = new boolean[]{false, false, false, false, true, true, true, true, true, true, true, false, true, true, true, true, false, false, true, true, true, true, false, false, true};
        if (n == 1) {
            nArray[4] = 5;
            nArray[8] = 5;
            nArray[9] = 5;
            nArray[10] = 5;
            nArray[13] = 5;
            nArray[14] = 5;
        }
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSet, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE", "IS_AUTOINCREMENT", "IS_GENERATEDCOLUMN", "SCOPE_CATLOG"}, nArray, blArray);
    }

    private void checkTablesShape(ResultSet resultSet) throws SQLException {
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSet, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION"}, new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12, 12}, new boolean[]{false, false, false, true, false, true, true, true, true, true});
    }

    private void checkCatalogsShape(ResultSet resultSet) throws SQLException {
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSet, new String[]{"TABLE_CAT"}, new int[]{1}, new boolean[]{false});
    }

    private static void checkVersionColumnsShape(ResultSet[] resultSetArray) throws SQLException {
        String[] stringArray = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
        int[] nArray = new int[]{5, 12, 4, 12, 4, 4, 5, 5};
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSetArray[0], stringArray, nArray, null);
        nArray[2] = 5;
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSetArray[1], stringArray, nArray, null);
    }

    public static void assertMetaDataResultSet(ResultSet resultSet, String[] stringArray, int[] nArray, boolean[] blArray) throws SQLException {
        DatabaseMetaDataTest.assertEquals((int)1003, (int)resultSet.getType());
        DatabaseMetaDataTest.assertEquals((int)1007, (int)resultSet.getConcurrency());
        if (stringArray != null) {
            JDBC.assertDatabaseMetaDataColumns(resultSet, blArray, nArray, stringArray);
        }
    }

    public void testNumericFunctions() throws SQLException {
        this.escapedFunctions(NUMERIC_FUNCTIONS, this.getDMD().getNumericFunctions());
    }

    public void testStringFunctions() throws SQLException {
        this.escapedFunctions(STRING_FUNCTIONS, this.getDMD().getStringFunctions());
    }

    public void testTimeDataFunctions() throws SQLException {
        this.escapedFunctions(TIMEDATE_FUNCTIONS, this.getDMD().getTimeDateFunctions());
    }

    public void testSystemFunctions() throws SQLException {
        this.escapedFunctions(SYSTEM_FUNCTIONS, this.getDMD().getSystemFunctions());
    }

    private void escapedFunctions(String[][] stringArray, String string) throws SQLException {
        boolean[] blArray = new boolean[stringArray.length];
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i];
                if (!string2.equals(stringArray2[0])) continue;
                if (blArray[i]) {
                    DatabaseMetaDataTest.fail((String)("Function in list twice: " + string2));
                }
                blArray[i] = true;
                bl = true;
                this.executeEscaped(stringArray2);
                break;
            }
            if (bl) continue;
            DatabaseMetaDataTest.fail((String)("Non-JDBC spec function in list: " + string2));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray3;
            if (blArray[i] || "CHAR".equals((stringArray3 = stringArray[i])[0])) continue;
            try {
                this.executeEscaped(stringArray3);
                DatabaseMetaDataTest.fail((String)("function works but not declared in list: " + stringArray3[0]));
                continue;
            }
            catch (SQLException sQLException) {
                DatabaseMetaDataTest.assertSQLState("42X01", sQLException);
            }
        }
    }

    private void executeEscaped(String[] stringArray) throws SQLException {
        String string = "VALUES { fn " + stringArray[0] + "(";
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (i != 0) {
                string = string + ", ";
            }
            string = string + stringArray[i + 1];
        }
        string = string + ") }";
        PreparedStatement preparedStatement = this.prepareStatement(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        JDBC.assertDrainResults(resultSet);
        resultSet.close();
        preparedStatement.close();
    }

    public static List<String> getSQLTypes(Connection connection) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Random random = new Random();
        ResultSet resultSet = connection.getMetaData().getTypeInfo();
        while (resultSet.next()) {
            int n;
            int n2;
            String string = resultSet.getString("TYPE_NAME");
            if ("OBJECT".equals(string)) continue;
            String string2 = resultSet.getString("CREATE_PARAMS");
            if (string2 == null) {
                arrayList.add(string);
                continue;
            }
            if (string2.contains("length")) {
                n2 = resultSet.getInt("PRECISION");
                int n3 = random.nextInt(n2) + 1;
                n = string.indexOf(40);
                if (n == -1) {
                    arrayList.add(string + "(" + n3 + ")");
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string.substring(0, n + 1));
                stringBuilder.append(n3);
                stringBuilder.append(string.substring(n + 1));
                arrayList.add(stringBuilder.toString());
                continue;
            }
            if (string2.contains("scale")) {
                n2 = resultSet.getInt("PRECISION");
                StringBuilder stringBuilder = new StringBuilder();
                n = random.nextInt(n2) + 1;
                stringBuilder.append(string);
                stringBuilder.append("(");
                stringBuilder.append(n);
                if (random.nextInt(100) < 95) {
                    stringBuilder.append(",");
                    stringBuilder.append(random.nextInt(n + 1));
                }
                stringBuilder.append(")");
                arrayList.add(stringBuilder.toString());
                continue;
            }
            if (string2.contains("precision")) {
                arrayList.add(string);
                continue;
            }
            DatabaseMetaDataTest.fail((String)("unknown how to generate valid type for " + string + " CREATE_PARAMS=" + string2));
        }
        return arrayList;
    }

    public static int getJDBCType(String string) {
        if ("SMALLINT".equals(string)) {
            return 5;
        }
        if ("INTEGER".equals(string) || "INT".equals(string)) {
            return 4;
        }
        if ("BIGINT".equals(string)) {
            return -5;
        }
        if (string.equals("FLOAT") || string.startsWith("FLOAT(")) {
            return 6;
        }
        if (string.equals("REAL")) {
            return 7;
        }
        if ("DOUBLE".equals(string) || "DOUBLE PRECISION".equals(string)) {
            return 8;
        }
        if ("DATE".equals(string)) {
            return 91;
        }
        if ("TIME".equals(string)) {
            return 92;
        }
        if ("TIMESTAMP".equals(string)) {
            return 93;
        }
        if (string.equals("DECIMAL") || string.startsWith("DECIMAL(")) {
            return 3;
        }
        if (string.equals("NUMERIC") || string.startsWith("NUMERIC(")) {
            return 2;
        }
        if (string.endsWith("FOR BIT DATA")) {
            if (string.startsWith("CHAR")) {
                return -2;
            }
            if (string.startsWith("CHARACTER")) {
                return -2;
            }
            if (string.startsWith("VARCHAR")) {
                return -3;
            }
            if (string.startsWith("CHARACTER VARYING")) {
                return -3;
            }
            if (string.startsWith("CHAR VARYING")) {
                return -3;
            }
        }
        if ("LONG VARCHAR".equals(string)) {
            return -1;
        }
        if ("LONG VARCHAR FOR BIT DATA".equals(string)) {
            return -4;
        }
        if (string.equals("CHAR") || string.startsWith("CHAR(")) {
            return 1;
        }
        if (string.equals("CHARACTER") || string.startsWith("CHARACTER(")) {
            return 1;
        }
        if (string.equals("VARCHAR") || string.startsWith("VARCHAR(")) {
            return 12;
        }
        if (string.equals("CHARACTER VARYING") || string.startsWith("CHARACTER VARYING(")) {
            return 12;
        }
        if (string.equals("CHAR VARYING") || string.startsWith("CHAR VARYING(")) {
            return 12;
        }
        if (string.equals("BLOB") || string.startsWith("BLOB(")) {
            return 2004;
        }
        if (string.equals("BINARY LARGE OBJECT") || string.startsWith("BINARY LARGE OBJECT(")) {
            return 2004;
        }
        if (string.equals("CLOB") || string.startsWith("CLOB(")) {
            return 2005;
        }
        if (string.equals("CHARACTER LARGE OBJECT") || string.startsWith("CHARACTER LARGE OBJECT(")) {
            return 2005;
        }
        if ("XML".equals(string)) {
            return 2009;
        }
        if (string.equals("BOOLEAN")) {
            return 16;
        }
        DatabaseMetaDataTest.fail((String)("Unexpected SQL type: " + string));
        return 0;
    }

    public static int getPrecision(int n, String string) {
        switch (n) {
            case -3: 
            case -2: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                int n2 = string.indexOf(40);
                int n3 = string.indexOf(41);
                int n4 = Integer.parseInt(string.substring(n2 + 1, n3));
                return n4;
            }
        }
        return 0;
    }

    public void testGetXXportedKeysODBC() throws SQLException, IOException {
        Statement statement = this.createStatement();
        statement.execute("create table pkt1 (i int not null, c char(1) not null)");
        statement.execute("create table pkt2 (i int not null, c char(1) not null)");
        statement.execute("create table pkt3 (i int not null, c char(1) not null)");
        statement.execute("alter table pkt1 add constraint pk1 primary key (i)");
        statement.execute("alter table pkt2 add constraint pk2 primary key (c)");
        statement.execute("alter table pkt3 add constraint pk3 primary key (i, c)");
        statement.execute("create table fkt1 (fi int, fc char(1), vc varchar(80))");
        statement.execute("create table fkt2 (fi int, fc char(1), vc varchar(80))");
        statement.execute("alter table fkt1 add constraint fk1 foreign key (fi) references pkt1(i)");
        statement.execute("alter table fkt1 add constraint fk2 foreign key (fc) references pkt2(c)");
        statement.execute("alter table fkt2 add constraint fk3 foreign key (fi, fc) references pkt3(i, c)");
        this.checkODBCKeys(null, this.schema, null, null, null, null);
        this.checkODBCKeys(null, this.schema, null, null, null, "FKT1");
        this.checkODBCKeys(null, this.schema, "PKT1", null, null, null);
        this.checkODBCKeys(null, this.schema, "PKT1", null, null, "FKT1");
        this.checkODBCKeys(null, this.schema, null, null, null, "FKT2");
        this.checkODBCKeys(null, this.schema, "PKT2", null, null, null);
        this.checkODBCKeys(null, this.schema, "PKT2", null, null, "FKT2");
        this.checkODBCKeys(null, this.schema, null, null, null, "FKT3");
        this.checkODBCKeys(null, this.schema, "PKT3", null, null, null);
        this.checkODBCKeys(null, this.schema, "PKT3", null, null, "FKT3");
        this.checkODBCKeys(null, this.schema, "FKT1", null, null, null);
        this.checkODBCKeys(null, this.schema, null, null, null, "PKT3");
        this.checkODBCKeys(null, this.schema, "FKT1", null, null, "PKT1");
        this.checkODBCKeys(null, this.schema, "FKT2", null, null, "PKT2");
        this.checkODBCKeys(null, this.schema, "FKT3", null, null, "PKT3");
        this.checkODBCKeys(null, this.schema, "PKT1", null, null, "FKT2");
        this.checkODBCKeys(null, this.schema, "PKT1", null, null, "FKT3");
        this.checkODBCKeys(null, this.schema, "PKT2", null, null, "FKT3");
        this.checkODBCKeys(null, this.schema, "FKT1", null, null, "PKT2");
        this.checkODBCKeys(null, this.schema, "FKT1", null, null, "PKT3");
        this.checkODBCKeys(null, this.schema, "FKT2", null, null, "PKT3");
        statement.execute("drop table fkt1");
        statement.execute("drop table fkt2");
        statement.execute("drop table pkt1");
        statement.execute("drop table pkt2");
        statement.execute("drop table pkt3");
        statement.close();
    }

    private void checkODBCKeys(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException, IOException {
        CallableStatement callableStatement = this.prepareCall("CALL SYSIBM.SQLFOREIGNKEYS(?, ?, ?, ?, ?, ?, 'DATATYPE=''ODBC''')");
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string3);
        callableStatement.setString(4, string4);
        callableStatement.setString(5, string5);
        callableStatement.setString(6, string6);
        callableStatement.execute();
        ResultSet resultSet = callableStatement.getResultSet();
        DatabaseMetaDataTest.assertNotNull((Object)resultSet);
        this.checkODBCKeysShape(resultSet);
        ResultSet resultSet2 = null;
        if (string3 != null && string6 == null) {
            resultSet2 = this.getDMD().getExportedKeys(string, string2, string3);
        } else if (string3 == null && string6 != null) {
            resultSet2 = this.getDMD().getImportedKeys(string4, string5, string6);
        } else if (string3 != null) {
            resultSet2 = this.getDMD().getCrossReference(string, string2, string3, string4, string5, string6);
        } else {
            JDBC.assertFullResultSet(resultSet, new String[][]{{"", this.schema, "PKT1", "I", "", this.schema, "FKT1", "FI", "1", "3", "3", "FK1", "PK1", "7"}, {"", this.schema, "PKT2", "C", "", this.schema, "FKT1", "FC", "1", "3", "3", "FK2", "PK2", "7"}, {"", this.schema, "PKT3", "I", "", this.schema, "FKT2", "FI", "1", "3", "3", "FK3", "PK3", "7"}, {"", this.schema, "PKT3", "C", "", this.schema, "FKT2", "FC", "2", "3", "3", "FK3", "PK3", "7"}});
            try {
                this.getDMD().getCrossReference(string, string2, string3, string4, string5, string6);
                DatabaseMetaDataTest.fail((String)"Expected error from call to DMD.getCrossReference() with NULL primary and foreign key tables.");
            }
            catch (SQLException sQLException) {
                DatabaseMetaDataTest.assertSQLState(DatabaseMetaDataTest.usingEmbedded() ? "XJ103" : "XJ110", sQLException);
            }
        }
        if (resultSet2 != null) {
            JDBC.assertSameContents(resultSet, resultSet2);
        }
        callableStatement.close();
    }

    private void checkODBCKeysShape(ResultSet resultSet) throws SQLException {
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSet, new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"}, new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5}, new boolean[]{false, false, false, false, false, false, false, false, true, true, true, false, false, true});
    }

    public void testGetBestRowIdentifier() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table brit1 (i int not null primary key, j int)");
        statement.execute("create table brit2 (i int not null unique, j int)");
        statement.execute("create table brit3 (i int not null unique, j int not null unique)");
        statement.execute("create table brit4 (i int, j int)");
        statement.execute("create unique index brit4i on brit4(i)");
        statement.execute("create table brit5 (i int, j int)");
        statement.execute("create table brit6 (i int not null unique, j int not null primary key)");
        statement.execute("create table brit7 (i int not null, j int not null primary key)");
        statement.execute("create unique index brit7i on brit7(i)");
        statement.execute("create table brit8 (i int not null, j int not null unique)");
        statement.execute("create unique index brit8i on brit8(i)");
        statement.execute("create table brit9 (i int, j int)");
        statement.execute("create index brit9i on brit9(i)");
        statement.execute("create table brit10 (i int unique not null , j int not null, primary key (i,j))");
        statement.execute("create table brit11 (i int not null, j int not null, primary key (i,j))");
        statement.execute("create unique index brit11i on brit11(i)");
        statement.execute("create table brit12 (i int not null, j int not null, unique (i,j))");
        statement.execute("create unique index brit12i on brit12(i)");
        statement.execute("create table brit13 (i int not null, j int)");
        statement.execute("create table brit14 (i int not null unique, j int not null, k int, unique (i,j))");
        statement.execute("create table brit15 (i int not null, j int not null, k int)");
        statement.execute("create unique index brit15ij on brit15(i,j)");
        statement.execute("create unique index brit15i on brit15(i)");
        statement.execute("create table brit16 (i int not null primary key, j int)");
        statement.execute("create table brit17 (i int not null default 10, s smallint not null, c30 char(30) not null, vc10 varchar(10) not null default 'asdf', constraint PRIMKEY primary key(vc10, i), constraint UNIQUEKEY unique(c30, s), ai bigint generated always as identity (start with -10, increment by 2001))");
        statement.execute("create unique index brit17i on brit17(s, i)");
        statement.execute("create index brit17ij on brit17(s)");
        this.getConnection().setAutoCommit(false);
        String[][] stringArray = new String[][]{{"2", "I", "4", "INTEGER", "4", null, "10", "1"}};
        String[][] stringArray2 = new String[][]{{"2", "J", "4", "INTEGER", "4", null, "10", "1"}};
        String[][] stringArray3 = new String[][]{{"2", "I", "4", "INTEGER", "4", null, "10", "1"}, {"2", "J", "4", "INTEGER", "4", null, "10", "1"}};
        ResultSet[] resultSetArray = this.getBestRowIdentifier(null, this.schema, "BRIT1", 0, true);
        this.verifyBRIResults(resultSetArray, stringArray);
        resultSetArray = this.getBestRowIdentifier(null, this.schema, "BRIT2", 0, true);
        this.verifyBRIResults(resultSetArray, stringArray);
        resultSetArray = this.getBestRowIdentifier(null, this.schema, "BRIT3", 0, true);
        this.verifyBRIResults(resultSetArray, stringArray);
        resultSetArray = this.getBestRowIdentifier(null, this.schema, "BRIT4", 0, true);
        this.verifyBRIResults(resultSetArray, stringArray);
        resultSetArray = this.getBestRowIdentifier(null, this.schema, "BRIT5", 0, true);
        this.verifyBRIResults(resultSetArray, stringArray3);
        resultSetArray = this.getBestRowIdentifier(null, this.schema, "BRIT6", 0, true);
        this.verifyBRIResults(resultSetArray, stringArray2);
        resultSetArray = this.getBestRowIdentifier(null, this.schema, "BRIT7", 0, true);
        this.verifyBRIResults(resultSetArray, stringArray2);
        resultSetArray = this.getBestRowIdentifier(null, this.schema, "BRIT8", 0, true);
        this.verifyBRIResults(resultSetArray, stringArray2);
        resultSetArray = this.getBestRowIdentifier(null, this.schema, "BRIT9", 0, true);
        this.verifyBRIResults(resultSetArray, stringArray3);
        resultSetArray = this.getBestRowIdentifier(null, this.schema, "BRIT10", 0, true);
        this.verifyBRIResults(resultSetArray, stringArray3);
        resultSetArray = this.getBestRowIdentifier(null, this.schema, "BRIT11", 0, true);
        this.verifyBRIResults(resultSetArray, stringArray3);
        resultSetArray = this.getBestRowIdentifier(null, this.schema, "BRIT12", 0, true);
        this.verifyBRIResults(resultSetArray, stringArray3);
        resultSetArray = this.getBestRowIdentifier(null, this.schema, "BRIT13", 0, false);
        this.verifyBRIResults(resultSetArray, stringArray);
        resultSetArray = this.getBestRowIdentifier(null, this.schema, "BRIT13", 0, true);
        this.verifyBRIResults(resultSetArray, stringArray3);
        resultSetArray = this.getBestRowIdentifier(null, this.schema, "BRIT14", 0, true);
        this.verifyBRIResults(resultSetArray, stringArray);
        resultSetArray = this.getBestRowIdentifier(null, this.schema, "BRIT15", 0, true);
        this.verifyBRIResults(resultSetArray, stringArray);
        resultSetArray = this.getBestRowIdentifier(null, this.schema, "BRIT16", 1, true);
        this.verifyBRIResults(resultSetArray, stringArray);
        resultSetArray = this.getBestRowIdentifier(null, this.schema, "BRIT16", 2, true);
        this.verifyBRIResults(resultSetArray, stringArray);
        try {
            resultSetArray = this.getBestRowIdentifier(null, this.schema, "BRIT16", -1, true);
        }
        catch (SQLException sQLException) {
            DatabaseMetaDataTest.assertSQLState("42XAT", sQLException);
        }
        try {
            resultSetArray = this.getBestRowIdentifier(null, this.schema, "BRIT16", 3, true);
        }
        catch (SQLException sQLException) {
            DatabaseMetaDataTest.assertSQLState("42XAT", sQLException);
        }
        resultSetArray = this.getBestRowIdentifier(null, this.schema, "BRIT17", 0, true);
        Object[][] objectArray = new String[][]{{"2", "I", "4", "INTEGER", "4", null, "10", "1"}, {"2", "VC10", "12", "VARCHAR", "10", null, null, "1"}};
        JDBC.assertUnorderedResultSet(resultSetArray[0], objectArray, true);
        objectArray[0][5] = "4";
        objectArray[1][5] = "20";
        JDBC.assertUnorderedResultSet(resultSetArray[1], objectArray, true);
        try {
            this.getBestRowIdentifier(null, this.schema, null, 0, true);
        }
        catch (SQLException sQLException) {
            DatabaseMetaDataTest.assertSQLState("XJ103", sQLException);
        }
        resultSetArray = this.getBestRowIdentifier(null, "SYS", "SYSTABLES", 0, true);
        objectArray = new String[][]{{"2", "TABLEID", "1", "CHAR", "36", null, null, "1"}};
        JDBC.assertUnorderedResultSet(resultSetArray[0], objectArray, true);
        objectArray[0][5] = "72";
        JDBC.assertUnorderedResultSet(resultSetArray[1], objectArray, true);
        this.getConnection().setAutoCommit(true);
        statement.execute("drop table brit1");
        statement.execute("drop table brit2");
        statement.execute("drop table brit3");
        statement.execute("drop index brit4i");
        statement.execute("drop table brit4");
        statement.execute("drop table brit5");
        statement.execute("drop table brit6");
        statement.execute("drop index brit7i");
        statement.execute("drop table brit7");
        statement.execute("drop index brit8i");
        statement.execute("drop table brit8");
        statement.execute("drop index brit9i");
        statement.execute("drop table brit9");
        statement.execute("drop table brit10");
        statement.execute("drop index brit11i");
        statement.execute("drop table brit11");
        statement.execute("drop index brit12i");
        statement.execute("drop table brit12");
        statement.execute("drop table brit13");
        statement.execute("drop table brit14");
        statement.execute("drop index brit15i");
        statement.execute("drop index brit15ij");
        statement.execute("drop table brit15");
        statement.execute("drop table brit16");
        statement.execute("drop index brit17i");
        statement.execute("drop index brit17ij");
        statement.execute("drop table brit17");
        statement.close();
    }

    private ResultSet getBestRowIdentifierODBC(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL SYSIBM.SQLSPECIALCOLUMNS(1, ?, ?, ?, ?, ?, 'DATATYPE=''ODBC''')");
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string3);
        callableStatement.setInt(4, n);
        callableStatement.setBoolean(5, bl);
        callableStatement.execute();
        return callableStatement.getResultSet();
    }

    private ResultSet[] getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        ResultSet[] resultSetArray = new ResultSet[2];
        DatabaseMetaData databaseMetaData = this.getDMD();
        resultSetArray[0] = databaseMetaData.getBestRowIdentifier(string, string2, string3, n, bl);
        resultSetArray[1] = this.getBestRowIdentifierODBC(string, string2, string3, n, bl);
        String[] stringArray = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
        int[] nArray = new int[]{5, 12, 4, 12, 4, 4, 5, 5};
        int[] nArray2 = new int[]{5, 12, 5, 12, 4, 4, 5, 5};
        boolean[] blArray = new boolean[]{true, false, true, true, true, true, true, true};
        if (n != 0 && n != 1 && n != 2) {
            blArray = new boolean[]{false, false, false, false, false, false, false, false};
            nArray2 = nArray;
        }
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSetArray[0], stringArray, nArray, blArray);
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSetArray[1], stringArray, nArray2, blArray);
        return resultSetArray;
    }

    public void verifyBRIResults(ResultSet[] resultSetArray, String[][] stringArray) throws SQLException {
        JDBC.assertFullResultSet(resultSetArray[0], (Object[][])stringArray, true);
        for (String[] stringArray2 : stringArray) {
            stringArray2[5] = "4";
        }
        JDBC.assertFullResultSet(resultSetArray[1], (Object[][])stringArray, true);
        for (String[] stringArray2 : stringArray) {
            stringArray2[5] = null;
        }
    }

    public void testGetColumnPrivileges() throws SQLException {
        try {
            this.getColumnPrivileges(null, null, null, null);
            DatabaseMetaDataTest.fail((String)"expected error XJ103");
        }
        catch (SQLException sQLException) {
            DatabaseMetaDataTest.assertSQLState("XJ103", sQLException);
        }
        ResultSet[] resultSetArray = this.getColumnPrivileges(null, null, "", null);
        JDBC.assertEmpty(resultSetArray[0]);
        JDBC.assertEmpty(resultSetArray[1]);
        resultSetArray = this.getColumnPrivileges("", "", "", "");
        JDBC.assertEmpty(resultSetArray[0]);
        JDBC.assertEmpty(resultSetArray[1]);
        resultSetArray = this.getColumnPrivileges("%", "%", "%", "%");
        JDBC.assertEmpty(resultSetArray[0]);
        JDBC.assertEmpty(resultSetArray[1]);
        resultSetArray = this.getColumnPrivileges(null, "SYS", "SYSTABLES", "TABLEID");
        JDBC.assertEmpty(resultSetArray[0]);
        JDBC.assertEmpty(resultSetArray[1]);
    }

    private ResultSet getColumnPrivilegesODBC(String string, String string2, String string3, String string4) throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL SYSIBM.SQLCOLPRIVILEGES(?, ?, ?, ?, 'DATATYPE=''ODBC''')");
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string3);
        callableStatement.setString(4, string4);
        callableStatement.execute();
        return callableStatement.getResultSet();
    }

    private ResultSet[] getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        ResultSet[] resultSetArray = new ResultSet[2];
        DatabaseMetaData databaseMetaData = this.getDMD();
        resultSetArray[0] = databaseMetaData.getColumnPrivileges(string, string2, string3, string4);
        resultSetArray[1] = this.getColumnPrivilegesODBC(string, string2, string3, string4);
        String[] stringArray = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
        int[] nArray = new int[]{12, 12, 12, 12, 12, 12, 12, 12};
        boolean[] blArray = new boolean[]{false, false, false, false, false, false, false, false};
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSetArray[0], stringArray, nArray, blArray);
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSetArray[1], stringArray, nArray, blArray);
        return resultSetArray;
    }

    public void testGetTablePrivileges() throws SQLException {
        ResultSet[] resultSetArray = this.getTablePrivileges(null, null, null);
        JDBC.assertEmpty(resultSetArray[0]);
        JDBC.assertEmpty(resultSetArray[1]);
        resultSetArray = this.getTablePrivileges("", "", "");
        JDBC.assertEmpty(resultSetArray[0]);
        JDBC.assertEmpty(resultSetArray[1]);
        resultSetArray = this.getTablePrivileges("%", "%", "%");
        JDBC.assertEmpty(resultSetArray[0]);
        JDBC.assertEmpty(resultSetArray[1]);
        resultSetArray = this.getTablePrivileges(null, "SYS", "SYSTABLES");
        JDBC.assertEmpty(resultSetArray[0]);
        JDBC.assertEmpty(resultSetArray[1]);
    }

    private ResultSet getTablePrivilegesODBC(String string, String string2, String string3) throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL SYSIBM.SQLTABLEPRIVILEGES(?, ?, ?, 'DATATYPE=''ODBC''')");
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string3);
        callableStatement.execute();
        return callableStatement.getResultSet();
    }

    private ResultSet[] getTablePrivileges(String string, String string2, String string3) throws SQLException {
        ResultSet[] resultSetArray = new ResultSet[2];
        DatabaseMetaData databaseMetaData = this.getDMD();
        resultSetArray[0] = databaseMetaData.getTablePrivileges(string, string2, string3);
        resultSetArray[1] = this.getTablePrivilegesODBC(string, string2, string3);
        String[] stringArray = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
        int[] nArray = new int[]{12, 12, 12, 12, 12, 12, 12};
        boolean[] blArray = new boolean[]{false, false, false, false, false, false, false};
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSetArray[0], stringArray, nArray, blArray);
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSetArray[1], stringArray, nArray, blArray);
        return resultSetArray;
    }

    public void testGetIndexInfo() throws SQLException {
        try {
            this.getIndexInfo(null, null, null, true, true);
            DatabaseMetaDataTest.fail((String)"expected error XJ103");
        }
        catch (SQLException sQLException) {
            DatabaseMetaDataTest.assertSQLState("XJ103", sQLException);
        }
        ResultSet[] resultSetArray = this.getIndexInfo("", "SYS", "SYSCOLUMNS", true, false);
        String[][] stringArray = new String[][]{{"", "SYS", "SYSCOLUMNS", "false", "", "SYSCOLUMNS_INDEX1", "3", "1", "REFERENCEID", "A", null, null, null}, {"", "SYS", "SYSCOLUMNS", "false", "", "SYSCOLUMNS_INDEX1", "3", "2", "COLUMNNAME", "A", null, null, null}};
        this.assertFullResultSet(resultSetArray, stringArray, true);
        resultSetArray = this.getIndexInfo("", "SYS", "SYSCOLUMNS", false, false);
        stringArray = new String[][]{{"", "SYS", "SYSCOLUMNS", "false", "", "SYSCOLUMNS_INDEX1", "3", "1", "REFERENCEID", "A", null, null, null}, {"", "SYS", "SYSCOLUMNS", "false", "", "SYSCOLUMNS_INDEX1", "3", "2", "COLUMNNAME", "A", null, null, null}, {"", "SYS", "SYSCOLUMNS", "true", "", "SYSCOLUMNS_INDEX2", "3", "1", "COLUMNDEFAULTID", "A", null, null, null}};
        this.assertFullResultSet(resultSetArray, stringArray, true);
        resultSetArray = this.getIndexInfo("", "SYS", "SYSTABLES", true, false);
        stringArray = new String[][]{{"", "SYS", "SYSTABLES", "false", "", "SYSTABLES_INDEX1", "3", "1", "TABLENAME", "A", null, null, null}, {"", "SYS", "SYSTABLES", "false", "", "SYSTABLES_INDEX1", "3", "2", "SCHEMAID", "A", null, null, null}, {"", "SYS", "SYSTABLES", "false", "", "SYSTABLES_INDEX2", "3", "1", "TABLEID", "A", null, null, null}};
        this.assertFullResultSet(resultSetArray, stringArray, true);
        resultSetArray = this.getIndexInfo("", "SYS", "SYSSTABLES", true, false);
        JDBC.assertEmpty(resultSetArray[0]);
        JDBC.assertEmpty(resultSetArray[1]);
    }

    public void testMoreGetIndexInfo() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table iit (i int not null, j int)");
        statement.execute("create unique index iii on iit(i asc, j desc)");
        DatabaseMetaData databaseMetaData = this.getDMD();
        ResultSet resultSet = databaseMetaData.getIndexInfo("", this.schema, "IIT", false, false);
        boolean bl = resultSet.next();
        if (bl) {
            DatabaseMetaDataTest.assertEquals((String)"A", (String)resultSet.getString(10));
        }
        if (bl = resultSet.next()) {
            DatabaseMetaDataTest.assertEquals((String)"D", (String)resultSet.getString(10));
        }
        if (bl = (resultSet = this.getIndexInfoODBC("", this.schema, "IIT", false, false)).next()) {
            DatabaseMetaDataTest.assertEquals((String)"A", (String)resultSet.getString(10));
        }
        if (bl = resultSet.next()) {
            DatabaseMetaDataTest.assertEquals((String)"D", (String)resultSet.getString(10));
        }
        statement.execute("drop index iii");
        statement.execute("drop table iit");
        statement.close();
    }

    private ResultSet getIndexInfoODBC(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL SYSIBM.SQLSTATISTICS(?, ?, ?, ?, ?, 'DATATYPE=''ODBC''')");
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string3);
        callableStatement.setBoolean(4, !bl);
        callableStatement.setBoolean(5, bl2);
        callableStatement.execute();
        return callableStatement.getResultSet();
    }

    private ResultSet[] getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        ResultSet[] resultSetArray = new ResultSet[2];
        DatabaseMetaData databaseMetaData = this.getDMD();
        resultSetArray[0] = databaseMetaData.getIndexInfo(string, string2, string3, bl, bl2);
        resultSetArray[1] = this.getIndexInfoODBC(string, string2, string3, bl, bl2);
        String[] stringArray = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"};
        int[] nArray = new int[]{12, 12, 12, 16, 12, 12, 5, 5, 12, 1, -5, -5, 12};
        boolean[] blArray = new boolean[]{false, false, false, false, false, true, true, true, false, false, true, true, true};
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSetArray[0], stringArray, nArray, blArray);
        nArray[3] = 5;
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSetArray[1], stringArray, nArray, blArray);
        return resultSetArray;
    }

    private void assertFullResultSet(ResultSet[] resultSetArray, String[][] stringArray, boolean bl) throws SQLException {
        JDBC.assertFullResultSet(resultSetArray[0], (Object[][])stringArray, bl);
        JDBC.assertFullResultSet(resultSetArray[1], (Object[][])stringArray, bl);
    }

    private void assertFullUnorderedResultSet(ResultSet[] resultSetArray, String[][] stringArray, boolean bl) throws SQLException {
        JDBC.assertUnorderedResultSet(resultSetArray[0], stringArray, bl);
        JDBC.assertUnorderedResultSet(resultSetArray[1], stringArray, bl);
    }

    private void createObjectsForKeysTests() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table kt1 (i int not null default 10, s smallint not null, c30 char(30) not null, vc10 varchar(10) not null default 'asdf', constraint PRIMKEY primary key(vc10, i), constraint UNIQUEKEY unique(c30, s), ai bigint generated always as identity (start with -10, increment by 2001))");
        statement.execute("create unique index u1 on kt1(s, i)");
        statement.execute("create index u2 on kt1(s)");
        statement.execute("create view kv as select * from kt1");
        statement.execute("create table reftab (vc10 varchar(10), i int, s smallint, c30 char(30), s2 smallint, c302 char(30), dprim decimal(5,1) not null, dfor decimal(5,1) not null, constraint PKEY_REFTAB primary key (dprim), constraint FKEYSELF foreign key (dfor) references reftab, constraint FKEY1 foreign key(vc10, i) references kt1, constraint FKEY2 foreign key(c30, s2) references kt1 (c30, s), constraint FKEY3 foreign key(c30, s) references kt1 (c30, s))");
        statement.execute("create table reftab2 (t2_vc10 varchar(10), t2_i int, constraint T2_FKEY1 foreign key(t2_vc10, t2_i) references kt1)");
        this.commit();
        this.getConnection().setAutoCommit(true);
    }

    private void dropObjectsForKeysTests() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("drop table reftab2");
        statement.execute("drop table reftab");
        this.commit();
        statement.execute("drop view kv");
        statement.execute("drop index u2");
        statement.execute("drop index u1");
        statement.execute("drop table kt1");
        this.commit();
        this.getConnection().setAutoCommit(true);
    }

    public void testGetPrimaryKeys() throws SQLException {
        String[][] stringArray = new String[][]{{"", this.schema, "KT1", "I", "2", "PRIMKEY"}, {"", this.schema, "KT1", "VC10", "1", "PRIMKEY"}};
        this.createObjectsForKeysTests();
        ResultSet[] resultSetArray = this.getPrimaryKeys("", "%", "KT1");
        this.assertFullResultSet(resultSetArray, stringArray, true);
        resultSetArray = this.getPrimaryKeys(null, this.schema, "KT1");
        this.assertFullResultSet(resultSetArray, stringArray, true);
        resultSetArray = this.getPrimaryKeys(null, null, "KT1");
        this.assertFullResultSet(resultSetArray, stringArray, true);
        resultSetArray = this.getPrimaryKeys(null, "", "KT1");
        JDBC.assertEmpty(resultSetArray[0]);
        JDBC.assertEmpty(resultSetArray[1]);
        DatabaseMetaData databaseMetaData = this.getDMD();
        try {
            resultSetArray[0] = databaseMetaData.getPrimaryKeys(null, null, null);
            DatabaseMetaDataTest.fail((String)"table name may not be null, should've given error");
        }
        catch (SQLException sQLException) {
            DatabaseMetaDataTest.assertSQLState("XJ103", sQLException);
        }
        try {
            resultSetArray[1] = this.getPrimaryKeysODBC(null, null, null);
            DatabaseMetaDataTest.fail((String)"table name may not be null, should've given error");
        }
        catch (SQLException sQLException) {
            DatabaseMetaDataTest.assertSQLState("XJ103", sQLException);
        }
        resultSetArray = this.getPrimaryKeys(null, null, "%");
        JDBC.assertEmpty(resultSetArray[0]);
        JDBC.assertEmpty(resultSetArray[1]);
        this.dropObjectsForKeysTests();
    }

    private ResultSet getPrimaryKeysODBC(String string, String string2, String string3) throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL SYSIBM.SQLPRIMARYKEYS(?, ?, ?, 'DATATYPE=''ODBC''')");
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string3);
        callableStatement.execute();
        return callableStatement.getResultSet();
    }

    private ResultSet[] getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        ResultSet[] resultSetArray = new ResultSet[2];
        DatabaseMetaData databaseMetaData = this.getDMD();
        resultSetArray[0] = databaseMetaData.getPrimaryKeys(string, string2, string3);
        resultSetArray[1] = this.getPrimaryKeysODBC(string, string2, string3);
        String[] stringArray = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"};
        int[] nArray = new int[]{12, 12, 12, 12, 5, 12};
        boolean[] blArray = new boolean[]{false, false, false, false, true, false};
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSetArray[0], stringArray, nArray, blArray);
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSetArray[1], stringArray, nArray, blArray);
        return resultSetArray;
    }

    public void testGetXXportedKeys() throws SQLException {
        String[][] stringArray = new String[][]{{"", this.schema, "KT1", "VC10", "", this.schema, "REFTAB", "VC10", "1", "3", "3", "FKEY1", "PRIMKEY", "7"}, {"", this.schema, "KT1", "I", "", this.schema, "REFTAB", "I", "2", "3", "3", "FKEY1", "PRIMKEY", "7"}, {"", this.schema, "KT1", "C30", "", this.schema, "REFTAB", "C30", "1", "3", "3", "FKEY3", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "C30", "", this.schema, "REFTAB", "C30", "1", "3", "3", "FKEY2", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "S", "", this.schema, "REFTAB", "S", "2", "3", "3", "FKEY3", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "S", "", this.schema, "REFTAB", "S2", "2", "3", "3", "FKEY2", "UNIQUEKEY", "7"}, {"", this.schema, "REFTAB", "DPRIM", "", this.schema, "REFTAB", "DFOR", "1", "3", "3", "FKEYSELF", "PKEY_REFTAB", "7"}};
        String[][] stringArray2 = new String[][]{{"", this.schema, "KT1", "VC10", "", this.schema, "REFTAB2", "T2_VC10", "1", "3", "3", "T2_FKEY1", "PRIMKEY", "7"}, {"", this.schema, "KT1", "I", "", this.schema, "REFTAB2", "T2_I", "2", "3", "3", "T2_FKEY1", "PRIMKEY", "7"}};
        this.createObjectsForKeysTests();
        ResultSet[] resultSetArray = this.getImportedKeys("", "%", "REFTAB");
        this.assertFullUnorderedResultSet(resultSetArray, stringArray, true);
        resultSetArray = this.getImportedKeys("", "%", "REFTAB2");
        this.assertFullResultSet(resultSetArray, stringArray2, true);
        resultSetArray = this.getImportedKeys(null, this.schema, "REFTAB");
        this.assertFullUnorderedResultSet(resultSetArray, stringArray, true);
        resultSetArray = this.getImportedKeys(null, this.schema, "REFTAB2");
        this.assertFullResultSet(resultSetArray, stringArray2, true);
        resultSetArray = this.getImportedKeys(null, null, "REFTAB");
        this.assertFullUnorderedResultSet(resultSetArray, stringArray, true);
        resultSetArray = this.getImportedKeys(null, "", "REFTAB");
        JDBC.assertEmpty(resultSetArray[0]);
        JDBC.assertEmpty(resultSetArray[1]);
        DatabaseMetaData databaseMetaData = this.getDMD();
        try {
            resultSetArray[0] = databaseMetaData.getImportedKeys(null, null, null);
            DatabaseMetaDataTest.fail((String)"table name may not be null, should've given error");
        }
        catch (SQLException sQLException) {
            DatabaseMetaDataTest.assertSQLState("XJ103", sQLException);
        }
        try {
            resultSetArray[1] = this.getImportedKeysODBC(null, null, null);
            DatabaseMetaDataTest.fail((String)"table name may not be null, should've given error");
        }
        catch (SQLException sQLException) {
            DatabaseMetaDataTest.assertSQLState("XJ103", sQLException);
        }
        resultSetArray = this.getImportedKeys(null, null, "%");
        JDBC.assertEmpty(resultSetArray[0]);
        JDBC.assertEmpty(resultSetArray[1]);
        stringArray = new String[][]{{"", this.schema, "KT1", "VC10", "", this.schema, "REFTAB", "VC10", "1", "3", "3", "FKEY1", "PRIMKEY", "7"}, {"", this.schema, "KT1", "I", "", this.schema, "REFTAB", "I", "2", "3", "3", "FKEY1", "PRIMKEY", "7"}, {"", this.schema, "KT1", "C30", "", this.schema, "REFTAB", "C30", "1", "3", "3", "FKEY2", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "S", "", this.schema, "REFTAB", "S2", "2", "3", "3", "FKEY2", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "C30", "", this.schema, "REFTAB", "C30", "1", "3", "3", "FKEY3", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "S", "", this.schema, "REFTAB", "S", "2", "3", "3", "FKEY3", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "VC10", "", this.schema, "REFTAB2", "T2_VC10", "1", "3", "3", "T2_FKEY1", "PRIMKEY", "7"}, {"", this.schema, "KT1", "I", "", this.schema, "REFTAB2", "T2_I", "2", "3", "3", "T2_FKEY1", "PRIMKEY", "7"}};
        stringArray2 = new String[][]{{"", this.schema, "REFTAB", "DPRIM", "", this.schema, "REFTAB", "DFOR", "1", "3", "3", "FKEYSELF", "PKEY_REFTAB", "7"}};
        resultSetArray = this.getExportedKeys("", "%", "KT1");
        this.assertFullResultSet(resultSetArray, stringArray, true);
        resultSetArray = this.getExportedKeys("", "%", "REFTAB");
        this.assertFullResultSet(resultSetArray, stringArray2, true);
        resultSetArray = this.getExportedKeys(null, this.schema, "KT1");
        this.assertFullResultSet(resultSetArray, stringArray, true);
        resultSetArray = this.getExportedKeys(null, this.schema, "REFTAB");
        this.assertFullResultSet(resultSetArray, stringArray2, true);
        resultSetArray = this.getExportedKeys(null, null, "KT1");
        this.assertFullResultSet(resultSetArray, stringArray, true);
        resultSetArray = this.getExportedKeys(null, "", "KT1");
        JDBC.assertEmpty(resultSetArray[0]);
        JDBC.assertEmpty(resultSetArray[1]);
        try {
            resultSetArray[0] = databaseMetaData.getExportedKeys(null, this.schema, null);
            DatabaseMetaDataTest.fail((String)"table name may not be null, should've given error");
        }
        catch (SQLException sQLException) {
            DatabaseMetaDataTest.assertSQLState("XJ103", sQLException);
        }
        try {
            resultSetArray[1] = this.getExportedKeysODBC(null, this.schema, null);
            DatabaseMetaDataTest.fail((String)"table name may not be null, should've given error");
        }
        catch (SQLException sQLException) {
            DatabaseMetaDataTest.assertSQLState("XJ103", sQLException);
        }
        resultSetArray = this.getExportedKeys(null, null, "%");
        JDBC.assertEmpty(resultSetArray[0]);
        JDBC.assertEmpty(resultSetArray[1]);
        stringArray = new String[][]{{"", this.schema, "KT1", "VC10", "", this.schema, "REFTAB", "VC10", "1", "3", "3", "FKEY1", "PRIMKEY", "7"}, {"", this.schema, "KT1", "I", "", this.schema, "REFTAB", "I", "2", "3", "3", "FKEY1", "PRIMKEY", "7"}, {"", this.schema, "KT1", "C30", "", this.schema, "REFTAB", "C30", "1", "3", "3", "FKEY2", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "S", "", this.schema, "REFTAB", "S2", "2", "3", "3", "FKEY2", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "C30", "", this.schema, "REFTAB", "C30", "1", "3", "3", "FKEY3", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "S", "", this.schema, "REFTAB", "S", "2", "3", "3", "FKEY3", "UNIQUEKEY", "7"}};
        stringArray2 = new String[][]{{"", this.schema, "REFTAB", "DPRIM", "", this.schema, "REFTAB", "DFOR", "1", "3", "3", "FKEYSELF", "PKEY_REFTAB", "7"}};
        resultSetArray = this.getCrossReference("", this.schema, "KT1", "", this.schema, "REFTAB");
        this.assertFullResultSet(resultSetArray, stringArray, true);
        resultSetArray = this.getCrossReference("", this.schema, "REFTAB", "", this.schema, "REFTAB");
        this.assertFullResultSet(resultSetArray, stringArray2, true);
        resultSetArray = this.getCrossReference("", this.schema, "KT1", "", this.schema, "REFTAB");
        this.assertFullResultSet(resultSetArray, stringArray, true);
        resultSetArray = this.getCrossReference("", this.schema, "REFTAB", "", this.schema, "REFTAB");
        this.assertFullResultSet(resultSetArray, stringArray2, true);
        resultSetArray = this.getCrossReference(null, this.schema, "KT1", null, this.schema, "REFTAB");
        this.assertFullResultSet(resultSetArray, stringArray, true);
        resultSetArray = this.getCrossReference(null, this.schema, "REFTAB", null, this.schema, "REFTAB");
        this.assertFullResultSet(resultSetArray, stringArray2, true);
        resultSetArray = this.getCrossReference(null, this.schema, "%", null, this.schema, "%");
        JDBC.assertEmpty(resultSetArray[0]);
        Object[][] objectArray = new String[][]{{"", this.schema, "KT1", "VC10", "", this.schema, "REFTAB", "VC10", "1", "3", "3", "FKEY1", "PRIMKEY", "7"}, {"", this.schema, "KT1", "I", "", this.schema, "REFTAB", "I", "2", "3", "3", "FKEY1", "PRIMKEY", "7"}, {"", this.schema, "KT1", "C30", "", this.schema, "REFTAB", "C30", "1", "3", "3", "FKEY2", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "S", "", this.schema, "REFTAB", "S2", "2", "3", "3", "FKEY2", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "C30", "", this.schema, "REFTAB", "C30", "1", "3", "3", "FKEY3", "UNIQUEKEY", "7"}, {"", this.schema, "KT1", "S", "", this.schema, "REFTAB", "S", "2", "3", "3", "FKEY3", "UNIQUEKEY", "7"}, {"", this.schema, "REFTAB", "DPRIM", "", this.schema, "REFTAB", "DFOR", "1", "3", "3", "FKEYSELF", "PKEY_REFTAB", "7"}, {"", this.schema, "KT1", "VC10", "", this.schema, "REFTAB2", "T2_VC10", "1", "3", "3", "T2_FKEY1", "PRIMKEY", "7"}, {"", this.schema, "KT1", "I", "", this.schema, "REFTAB2", "T2_I", "2", "3", "3", "T2_FKEY1", "PRIMKEY", "7"}};
        JDBC.assertFullResultSet(resultSetArray[1], objectArray, true);
        resultSetArray = this.getCrossReference(null, null, "%", null, null, "%");
        JDBC.assertEmpty(resultSetArray[0]);
        JDBC.assertResultSetContains(resultSetArray[1], objectArray);
        try {
            resultSetArray[0] = databaseMetaData.getCrossReference(null, null, null, null, null, null);
            DatabaseMetaDataTest.fail((String)"table name may not be null, should've given error");
        }
        catch (SQLException sQLException) {
            if (DatabaseMetaDataTest.usingDerbyNetClient()) {
                DatabaseMetaDataTest.assertSQLState("XJ110", sQLException);
            }
            DatabaseMetaDataTest.assertSQLState("XJ103", sQLException);
        }
        try {
            resultSetArray[1] = this.getCrossReferenceODBC(null, this.schema, null, null, this.schema, null);
        }
        catch (SQLException sQLException) {
            if (DatabaseMetaDataTest.usingDerbyNetClient()) {
                DatabaseMetaDataTest.assertSQLState("XJ110", sQLException);
            }
            DatabaseMetaDataTest.assertSQLState("XJ103", sQLException);
        }
        try {
            resultSetArray[0] = databaseMetaData.getCrossReference(null, null, "", null, null, null);
            DatabaseMetaDataTest.fail((String)"table name may not be null, should've given error");
        }
        catch (SQLException sQLException) {
            if (DatabaseMetaDataTest.usingDerbyNetClient()) {
                DatabaseMetaDataTest.assertSQLState("XJ111", sQLException);
            }
            DatabaseMetaDataTest.assertSQLState("XJ103", sQLException);
        }
        try {
            resultSetArray[1] = this.getCrossReferenceODBC(null, this.schema, "", null, this.schema, null);
        }
        catch (SQLException sQLException) {
            if (DatabaseMetaDataTest.usingDerbyNetClient()) {
                DatabaseMetaDataTest.assertSQLState("XJ111", sQLException);
            }
            DatabaseMetaDataTest.assertSQLState("XJ103", sQLException);
        }
        resultSetArray = this.getCrossReference(null, this.schema, "%", null, this.schema, "%");
        JDBC.assertEmpty(resultSetArray[0]);
        JDBC.assertFullResultSet(resultSetArray[1], objectArray, true);
        resultSetArray[0].close();
        resultSetArray[1].close();
        this.dropObjectsForKeysTests();
    }

    private ResultSet getImportedKeysODBC(String string, String string2, String string3) throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL SYSIBM.SQLFOREIGNKEYS(null, null, null, ?, ?, ?, 'IMPORTEDKEY=1;DATATYPE=''ODBC''')");
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string3);
        callableStatement.execute();
        return callableStatement.getResultSet();
    }

    private ResultSet[] getImportedKeys(String string, String string2, String string3) throws SQLException {
        ResultSet[] resultSetArray = new ResultSet[2];
        DatabaseMetaData databaseMetaData = this.getDMD();
        resultSetArray[0] = databaseMetaData.getImportedKeys(string, string2, string3);
        resultSetArray[1] = this.getImportedKeysODBC(string, string2, string3);
        this.assertGetImportedAndExportedKeysShape(resultSetArray);
        return resultSetArray;
    }

    private void assertGetImportedAndExportedKeysShape(ResultSet[] resultSetArray) throws SQLException {
        String[] stringArray = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
        int[] nArray = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5};
        boolean[] blArray = new boolean[]{false, false, false, false, false, false, false, false, true, true, true, false, false, true};
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSetArray[0], stringArray, nArray, blArray);
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSetArray[1], stringArray, nArray, blArray);
    }

    private ResultSet getExportedKeysODBC(String string, String string2, String string3) throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL SYSIBM.SQLFOREIGNKEYS(?, ?, ?, null, null, null, 'EXPORTEDKEY=1;DATATYPE=''ODBC''')");
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string3);
        callableStatement.execute();
        return callableStatement.getResultSet();
    }

    private ResultSet[] getExportedKeys(String string, String string2, String string3) throws SQLException {
        ResultSet[] resultSetArray = new ResultSet[2];
        DatabaseMetaData databaseMetaData = this.getDMD();
        resultSetArray[0] = databaseMetaData.getExportedKeys(string, string2, string3);
        resultSetArray[1] = this.getExportedKeysODBC(string, string2, string3);
        this.assertGetImportedAndExportedKeysShape(resultSetArray);
        return resultSetArray;
    }

    private ResultSet getCrossReferenceODBC(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL SYSIBM.SQLFOREIGNKEYS(?, ?, ?, ?, ?, ?, 'DATATYPE=''ODBC''')");
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string3);
        callableStatement.setString(4, string4);
        callableStatement.setString(5, string5);
        callableStatement.setString(6, string6);
        callableStatement.execute();
        return callableStatement.getResultSet();
    }

    private ResultSet[] getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        ResultSet[] resultSetArray = new ResultSet[2];
        DatabaseMetaData databaseMetaData = this.getDMD();
        resultSetArray[0] = databaseMetaData.getCrossReference(string, string2, string3, string4, string5, string6);
        resultSetArray[1] = this.getCrossReferenceODBC(string, string2, string3, string4, string5, string6);
        this.assertGetImportedAndExportedKeysShape(resultSetArray);
        return resultSetArray;
    }

    public void testReferentialAction() throws SQLException {
        int n;
        Statement statement = this.createStatement();
        this.getConnection().setAutoCommit(false);
        statement.execute("create table refaction1(a int not null primary key)");
        statement.execute("create table refactnone(a int references refaction1(a))");
        statement.execute("create table refactrestrict(a int references refaction1(a) on delete restrict)");
        statement.execute("create table refactnoaction(a int references refaction1(a) on delete no action)");
        statement.execute("create table refactcascade(a int references refaction1(a) on delete cascade)");
        statement.execute("create table refactsetnull(a int references refaction1(a) on delete set null)");
        statement.execute("create table refactupdrestrict(a int references refaction1(a) on update restrict)");
        statement.execute("create table refactupdnoaction(a int references refaction1(a) on update no action)");
        short s = 1;
        short s2 = 3;
        short s3 = 0;
        short s4 = 2;
        int n2 = 4;
        ResultSet[] resultSetArray = this.getCrossReference("", this.schema, "REFACTION1", "", this.schema, "REFACTNONE");
        this.verifyReferentialAction(resultSetArray, new short[]{s2, s2});
        resultSetArray = this.getCrossReference("", this.schema, "REFACTION1", "", this.schema, "REFACTRESTRICT");
        this.verifyReferentialAction(resultSetArray, new short[]{s2, s});
        resultSetArray = this.getCrossReference("", this.schema, "REFACTION1", "", this.schema, "REFACTNOACTION");
        this.verifyReferentialAction(resultSetArray, new short[]{s2, s2});
        resultSetArray = this.getCrossReference("", this.schema, "REFACTION1", "", this.schema, "REFACTCASCADE");
        this.verifyReferentialAction(resultSetArray, new short[]{s2, s3});
        resultSetArray = this.getCrossReference("", this.schema, "REFACTION1", "", this.schema, "REFACTSETNULL");
        this.verifyReferentialAction(resultSetArray, new short[]{s2, s4});
        resultSetArray = this.getCrossReference("", this.schema, "REFACTION1", "", this.schema, "REFACTUPDRESTRICT");
        this.verifyReferentialAction(resultSetArray, new short[]{s, s2});
        resultSetArray = this.getCrossReference("", this.schema, "REFACTION1", "", this.schema, "REFACTUPDNOACTION");
        this.verifyReferentialAction(resultSetArray, new short[]{s2, s2});
        resultSetArray = this.getImportedKeys(null, this.schema, "REFACTNONE");
        this.verifyReferentialAction(resultSetArray, new short[]{s2, s2});
        resultSetArray = this.getImportedKeys(null, this.schema, "REFACTRESTRICT");
        this.verifyReferentialAction(resultSetArray, new short[]{s, s});
        resultSetArray = this.getImportedKeys(null, this.schema, "REFACTNOACTION");
        this.verifyReferentialAction(resultSetArray, new short[]{s2, s2});
        resultSetArray = this.getImportedKeys(null, this.schema, "REFACTCASCADE");
        this.verifyReferentialAction(resultSetArray, new short[]{s2, s3});
        resultSetArray = this.getImportedKeys(null, this.schema, "REFACTSETNULL");
        this.verifyReferentialAction(resultSetArray, new short[]{s2, s4});
        resultSetArray = this.getImportedKeys(null, this.schema, "REFACTUPDRESTRICT");
        this.verifyReferentialAction(resultSetArray, new short[]{s2, s2});
        resultSetArray = this.getImportedKeys(null, this.schema, "REFACTUPDNOACTION");
        this.verifyReferentialAction(resultSetArray, new short[]{s2, s2});
        resultSetArray = this.getExportedKeys(null, this.schema, "REFACTION1");
        short[][] sArrayArray = new short[][]{{s2, s3}, {s2, s2}, {s2, s2}, {s2, s}, {s2, s4}, {s2, s2}, {s, s2}};
        for (n = 0; n < 6; ++n) {
            resultSetArray[0].next();
            DatabaseMetaDataTest.assertEquals((short)sArrayArray[n][0], (short)resultSetArray[0].getShort(10));
            DatabaseMetaDataTest.assertEquals((short)sArrayArray[n][1], (short)resultSetArray[0].getShort(11));
        }
        for (n = 0; n < 6; ++n) {
            resultSetArray[1].next();
            DatabaseMetaDataTest.assertEquals((short)sArrayArray[n][0], (short)resultSetArray[1].getShort(10));
            DatabaseMetaDataTest.assertEquals((short)sArrayArray[n][1], (short)resultSetArray[1].getShort(11));
        }
        statement.execute("drop table refactnone");
        statement.execute("drop table refactupdrestrict");
        statement.execute("drop table refactupdnoaction");
        statement.execute("drop table refactrestrict");
        statement.execute("drop table refactnoaction");
        statement.execute("drop table refactcascade");
        statement.execute("drop table refactsetnull");
        statement.execute("drop table refaction1");
        this.commit();
        resultSetArray[0].close();
        resultSetArray[1].close();
        statement.close();
        this.getConnection().setAutoCommit(true);
    }

    public void verifyReferentialAction(ResultSet[] resultSetArray, short[] sArray) throws SQLException {
        resultSetArray[0].next();
        DatabaseMetaDataTest.assertEquals((short)sArray[0], (short)resultSetArray[0].getShort(10));
        DatabaseMetaDataTest.assertEquals((short)sArray[1], (short)resultSetArray[0].getShort(11));
        resultSetArray[1].next();
        DatabaseMetaDataTest.assertEquals((short)sArray[0], (short)resultSetArray[1].getShort(10));
        DatabaseMetaDataTest.assertEquals((short)sArray[1], (short)resultSetArray[1].getShort(11));
    }

    public void testGetProceduresGetProcColumns() throws Exception {
        Object[] objectArray;
        boolean bl = true;
        Version version = this.getDataVersion(this.getConnection());
        if (version.compareTo(new Version(10, 7, 0, 0)) < 0) {
            bl = false;
        }
        Statement statement = this.createStatement();
        this.getConnection().setAutoCommit(false);
        statement.execute("create procedure GETPCTEST1 (out outb VARCHAR(3), a VARCHAR(3), b NUMERIC, c SMALLINT, e SMALLINT, f INTEGER, g BIGINT, h FLOAT, i DOUBLE PRECISION, k DATE, l TIME, T TIMESTAMP )language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest.getpc' parameter style java");
        statement.execute("create procedure GETPCTEST2 (pa INTEGER, pb BIGINT)language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest.getpc' parameter style java");
        statement.execute("create procedure GETPCTEST3A (STRING1 VARCHAR(5), out STRING2 VARCHAR(5))language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest.getpc' parameter style java");
        statement.execute("create procedure GETPCTEST3B (in STRING3 VARCHAR(5), inout STRING4 VARCHAR(5))language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest.getpc' parameter style java");
        statement.execute("create procedure GETPCTEST4A()  language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest.getpc4a' parameter style java");
        statement.execute("create procedure GETPCTEST4B() language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest.getpc4b' parameter style java");
        statement.execute("create procedure GETPCTEST4Bx(out retparam INTEGER) language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest.getpc4b' parameter style java");
        if (bl) {
            statement.execute("create procedure GETPCTEST5(in inarg boolean, out outarg boolean, inout inoutarg boolean) language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest.foo' parameter style java");
        }
        JDBC.GeneratedId generatedId = new JDBC.GeneratedId();
        String string = ((Object)((Object)this)).getClass().getName();
        String string2 = string + ".getpc";
        String string3 = string + ".getpc4a";
        String string4 = string + ".getpc4b";
        String string5 = string + ".foo";
        ResultSet[] resultSetArray = this.getProcedures(null, "%", "GETPCTEST%");
        Object[][] objectArray2 = new Object[][]{{"", this.schema, "GETPCTEST1", null, null, null, string2, DatabaseMetaDataTest.i(1), generatedId}, {"", this.schema, "GETPCTEST2", null, null, null, string2, DatabaseMetaDataTest.i(1), generatedId}, {"", this.schema, "GETPCTEST3A", null, null, null, string2, DatabaseMetaDataTest.i(1), generatedId}, {"", this.schema, "GETPCTEST3B", null, null, null, string2, DatabaseMetaDataTest.i(1), generatedId}, {"", this.schema, "GETPCTEST4A", null, null, null, string3, DatabaseMetaDataTest.i(1), generatedId}, {"", this.schema, "GETPCTEST4B", null, null, null, string4, DatabaseMetaDataTest.i(1), generatedId}, {"", this.schema, "GETPCTEST4BX", null, null, null, string4, DatabaseMetaDataTest.i(1), generatedId}};
        if (bl) {
            objectArray2 = this.appendArray(objectArray2, new Object[][]{{"", this.schema, "GETPCTEST5", null, null, null, string5, DatabaseMetaDataTest.i(1), generatedId}});
        }
        JDBC.assertFullResultSet(resultSetArray[0], objectArray2, false);
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray = objectArray2[i];
            Object[] objectArray3 = new Object[objectArray.length - 1];
            System.arraycopy(objectArray, 0, objectArray3, 0, objectArray3.length);
            objectArray2[i] = objectArray3;
        }
        JDBC.assertFullResultSet(resultSetArray[1], objectArray2, false);
        resultSetArray = this.getProcedureColumns(null, "%", "GETPCTEST%", "%");
        objectArray2 = new Object[][]{{null, this.schema, "GETPCTEST1", "OUTB", DatabaseMetaDataTest.i(4), DatabaseMetaDataTest.i(12), "VARCHAR", DatabaseMetaDataTest.i(3), DatabaseMetaDataTest.i(6), null, null, DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(12), null, DatabaseMetaDataTest.i(6), DatabaseMetaDataTest.i(1), "YES", generatedId, DatabaseMetaDataTest.i(12), DatabaseMetaDataTest.i(0)}, {null, this.schema, "GETPCTEST1", "A", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(12), "VARCHAR", DatabaseMetaDataTest.i(3), DatabaseMetaDataTest.i(6), null, null, DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(12), null, DatabaseMetaDataTest.i(6), DatabaseMetaDataTest.i(2), "YES", generatedId, DatabaseMetaDataTest.i(12), DatabaseMetaDataTest.i(1)}, {null, this.schema, "GETPCTEST1", "B", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(2), "NUMERIC", DatabaseMetaDataTest.i(5), DatabaseMetaDataTest.i(14), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(2), null, null, DatabaseMetaDataTest.i(3), "YES", generatedId, DatabaseMetaDataTest.i(12), DatabaseMetaDataTest.i(2)}, {null, this.schema, "GETPCTEST1", "C", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(5), "SMALLINT", DatabaseMetaDataTest.i(5), DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(5), null, null, DatabaseMetaDataTest.i(4), "YES", generatedId, DatabaseMetaDataTest.i(12), DatabaseMetaDataTest.i(3)}, {null, this.schema, "GETPCTEST1", "E", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(5), "SMALLINT", DatabaseMetaDataTest.i(5), DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(5), null, null, DatabaseMetaDataTest.i(5), "YES", generatedId, DatabaseMetaDataTest.i(12), DatabaseMetaDataTest.i(4)}, {null, this.schema, "GETPCTEST1", "F", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(4), "INTEGER", DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(4), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(4), null, null, DatabaseMetaDataTest.i(6), "YES", generatedId, DatabaseMetaDataTest.i(12), DatabaseMetaDataTest.i(5)}, {null, this.schema, "GETPCTEST1", "G", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(-5), "BIGINT", DatabaseMetaDataTest.i(19), DatabaseMetaDataTest.i(40), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(-5), null, null, DatabaseMetaDataTest.i(7), "YES", generatedId, DatabaseMetaDataTest.i(12), DatabaseMetaDataTest.i(6)}, {null, this.schema, "GETPCTEST1", "H", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(8), "DOUBLE", DatabaseMetaDataTest.i(52), DatabaseMetaDataTest.i(8), null, DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(8), null, null, DatabaseMetaDataTest.i(8), "YES", generatedId, DatabaseMetaDataTest.i(12), DatabaseMetaDataTest.i(7)}, {null, this.schema, "GETPCTEST1", "I", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(8), "DOUBLE", DatabaseMetaDataTest.i(52), DatabaseMetaDataTest.i(8), null, DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(8), null, null, DatabaseMetaDataTest.i(9), "YES", generatedId, DatabaseMetaDataTest.i(12), DatabaseMetaDataTest.i(8)}, {null, this.schema, "GETPCTEST1", "K", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(91), "DATE", DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(6), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(9), DatabaseMetaDataTest.i(1), null, DatabaseMetaDataTest.i(10), "YES", generatedId, DatabaseMetaDataTest.i(12), DatabaseMetaDataTest.i(9)}, {null, this.schema, "GETPCTEST1", "L", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(92), "TIME", DatabaseMetaDataTest.i(8), DatabaseMetaDataTest.i(6), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(9), DatabaseMetaDataTest.i(2), null, DatabaseMetaDataTest.i(11), "YES", generatedId, DatabaseMetaDataTest.i(12), DatabaseMetaDataTest.i(10)}, {null, this.schema, "GETPCTEST1", "T", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(93), "TIMESTAMP", DatabaseMetaDataTest.i(29), DatabaseMetaDataTest.i(16), DatabaseMetaDataTest.i(9), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(9), DatabaseMetaDataTest.i(3), null, DatabaseMetaDataTest.i(12), "YES", generatedId, DatabaseMetaDataTest.i(12), DatabaseMetaDataTest.i(11)}, {null, this.schema, "GETPCTEST2", "PA", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(4), "INTEGER", DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(4), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(4), null, null, DatabaseMetaDataTest.i(1), "YES", generatedId, DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(0)}, {null, this.schema, "GETPCTEST2", "PB", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(-5), "BIGINT", DatabaseMetaDataTest.i(19), DatabaseMetaDataTest.i(40), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(-5), null, null, DatabaseMetaDataTest.i(2), "YES", generatedId, DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(1)}, {null, this.schema, "GETPCTEST3A", "STRING1", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(12), "VARCHAR", DatabaseMetaDataTest.i(5), DatabaseMetaDataTest.i(10), null, null, DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(12), null, DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), "YES", generatedId, DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(0)}, {null, this.schema, "GETPCTEST3A", "STRING2", DatabaseMetaDataTest.i(4), DatabaseMetaDataTest.i(12), "VARCHAR", DatabaseMetaDataTest.i(5), DatabaseMetaDataTest.i(10), null, null, DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(12), null, DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(2), "YES", generatedId, DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(1)}, {null, this.schema, "GETPCTEST3B", "STRING3", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(12), "VARCHAR", DatabaseMetaDataTest.i(5), DatabaseMetaDataTest.i(10), null, null, DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(12), null, DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), "YES", generatedId, DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(0)}, {null, this.schema, "GETPCTEST3B", "STRING4", DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(12), "VARCHAR", DatabaseMetaDataTest.i(5), DatabaseMetaDataTest.i(10), null, null, DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(12), null, DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(2), "YES", generatedId, DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(1)}, {null, this.schema, "GETPCTEST4BX", "RETPARAM", DatabaseMetaDataTest.i(4), DatabaseMetaDataTest.i(4), "INTEGER", DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(4), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(4), null, null, DatabaseMetaDataTest.i(1), "YES", generatedId, DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(0)}};
        if (bl) {
            objectArray2 = this.appendArray(objectArray2, new Object[][]{{null, this.schema, "GETPCTEST5", "INARG", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(16), "BOOLEAN", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(16), null, null, DatabaseMetaDataTest.i(1), "YES", generatedId, DatabaseMetaDataTest.i(3), DatabaseMetaDataTest.i(0)}, {null, this.schema, "GETPCTEST5", "OUTARG", DatabaseMetaDataTest.i(4), DatabaseMetaDataTest.i(16), "BOOLEAN", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(16), null, null, DatabaseMetaDataTest.i(2), "YES", generatedId, DatabaseMetaDataTest.i(3), DatabaseMetaDataTest.i(1)}, {null, this.schema, "GETPCTEST5", "INOUTARG", DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(16), "BOOLEAN", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(16), null, null, DatabaseMetaDataTest.i(3), "YES", generatedId, DatabaseMetaDataTest.i(3), DatabaseMetaDataTest.i(2)}});
        }
        Object[][] objectArray4 = new Object[objectArray2.length][];
        objectArray = new Object[objectArray2.length][];
        for (int i = 0; i < objectArray4.length; ++i) {
            Object[] objectArray5 = objectArray2[i];
            Object[] objectArray6 = (Object[])objectArray5.clone();
            objectArray6[15] = null;
            objectArray6[14] = null;
            ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(objectArray5));
            arrayList.remove(19);
            if (i == 9) {
                arrayList.set(9, null);
            }
            if (i >= 9 && i <= 11) {
                arrayList.set(10, DatabaseMetaDataTest.i(2));
            }
            objectArray4[i] = objectArray6;
            objectArray[i] = arrayList.toArray();
        }
        JDBC.assertFullResultSet(resultSetArray[0], objectArray4, false);
        JDBC.assertFullResultSet(resultSetArray[1], (Object[][])objectArray, false);
        if (bl) {
            statement.execute("drop procedure GETPCTEST5");
        }
        statement.execute("drop procedure GETPCTEST4Bx");
        statement.execute("drop procedure GETPCTEST4B");
        statement.execute("drop procedure GETPCTEST4A");
        statement.execute("drop procedure GETPCTEST3B");
        statement.execute("drop procedure GETPCTEST3A");
        statement.execute("drop procedure GETPCTEST2");
        statement.execute("drop procedure GETPCTEST1");
        this.commit();
    }

    private Object[][] appendArray(Object[][] objectArray, Object[][] objectArray2) {
        int n = objectArray.length;
        int n2 = objectArray2.length;
        int n3 = n + n2;
        Object[][] objectArray3 = new Object[n3][];
        System.arraycopy(objectArray, 0, objectArray3, 0, n);
        System.arraycopy(objectArray2, 0, objectArray3, n, n2);
        DatabaseMetaDataTest.println("Appended array");
        return objectArray3;
    }

    private ResultSet getProceduresODBC(String string, String string2, String string3) throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL SYSIBM.SQLPROCEDURES(?, ?, ?, 'DATATYPE=''ODBC''')");
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string3);
        callableStatement.execute();
        return callableStatement.getResultSet();
    }

    private ResultSet[] getProcedures(String string, String string2, String string3) throws SQLException {
        ResultSet[] resultSetArray = new ResultSet[2];
        DatabaseMetaData databaseMetaData = this.getDMD();
        resultSetArray[0] = databaseMetaData.getProcedures(string, string2, string3);
        resultSetArray[1] = this.getProceduresODBC(string, string2, string3);
        String[] stringArray = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "RESERVED1", "RESERVED2", "RESERVED3", "REMARKS", "PROCEDURE_TYPE", "SPECIFIC_NAME"};
        int[] nArray = new int[]{12, 12, 12, 4, 4, 4, 12, 5, 12};
        boolean[] blArray = new boolean[]{false, false, false, true, true, true, true, true, false};
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSetArray[0], stringArray, nArray, blArray);
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
        int[] nArray2 = new int[nArray.length - 1];
        System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
        boolean[] blArray2 = new boolean[blArray.length - 1];
        System.arraycopy(blArray, 0, blArray2, 0, blArray2.length);
        stringArray2[3] = "NUM_INPUT_PARAMS";
        stringArray2[4] = "NUM_OUTPUT_PARAMS";
        stringArray2[5] = "NUM_RESULT_SETS";
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSetArray[1], stringArray2, nArray2, blArray2);
        return resultSetArray;
    }

    private ResultSet getProcedureColumnsODBC(String string, String string2, String string3, String string4) throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL SYSIBM.SQLPROCEDURECOLS(?, ?, ?, ?, 'DATATYPE=''ODBC''')");
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.setString(3, string3);
        callableStatement.setString(4, string4);
        callableStatement.execute();
        return callableStatement.getResultSet();
    }

    private ResultSet[] getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        ResultSet[] resultSetArray = new ResultSet[2];
        DatabaseMetaData databaseMetaData = this.getDMD();
        resultSetArray[0] = databaseMetaData.getProcedureColumns(string, string2, string3, string4);
        resultSetArray[1] = this.getProcedureColumnsODBC(string, string2, string3, string4);
        String[] stringArray = new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SPECIFIC_NAME", "METHOD_ID", "PARAMETER_ID"};
        int[] nArray = new int[]{12, 12, 12, 12, 5, 4, 12, 4, 4, 5, 5, 5, 12, 12, 4, 4, 4, 4, 12, 12, 5, 5};
        boolean[] blArray = new boolean[]{true, false, false, false, false, false, false, false, false, true, true, false, true, true, true, true, true, false, false, false, false, false};
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSetArray[0], stringArray, nArray, blArray);
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, 19);
        System.arraycopy(stringArray, 20, stringArray2, 19, 2);
        int[] nArray2 = new int[nArray.length - 1];
        System.arraycopy(nArray, 0, nArray2, 0, 19);
        System.arraycopy(nArray, 20, nArray2, 19, 2);
        boolean[] blArray2 = new boolean[]{true, false, false, false, false, false, false, false, false, true, true, false, true, true, false, true, true, false, false, false, false};
        stringArray2[7] = "COLUMN_SIZE";
        stringArray2[8] = "BUFFER_LENGTH";
        stringArray2[9] = "DECIMAL_DIGITS";
        stringArray2[10] = "NUM_PREC_RADIX";
        nArray2[5] = 5;
        nArray2[14] = 5;
        nArray2[15] = 5;
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSetArray[1], stringArray2, nArray2, blArray2);
        return resultSetArray;
    }

    public void testGetFunctionColumns() throws Exception {
        boolean bl = true;
        Version version = this.getDataVersion(this.getConnection());
        if (version.compareTo(new Version(10, 7, 0, 0)) < 0) {
            bl = false;
        }
        if (version.compareTo(new Version(10, 2, 0, 0)) < 0) {
            return;
        }
        DatabaseMetaData databaseMetaData = this.getDMD();
        Statement statement = this.createStatement();
        this.getConnection().setAutoCommit(false);
        statement.execute("create function f_gfc_1 (a VARCHAR(3), b NUMERIC, c SMALLINT, e CHAR(3), f INTEGER, g BIGINT, h FLOAT, i DOUBLE PRECISION, k DATE, l TIME, T TIMESTAMP ) returns int language java external name 'org.apache.derbyTesting.BlahBlah.blah' parameter style java");
        if (bl) {
            statement.execute("create function f_gfc_2 ( a boolean) returns boolean language java external name 'org.apache.derbyTesting.functionTests.BlahBlah.blah' parameter style java");
        }
        Method method = databaseMetaData.getClass().getMethod("getFunctionColumns", String.class, String.class, String.class, String.class);
        ResultSet resultSet = (ResultSet)method.invoke((Object)databaseMetaData, (Object[])new String[]{null, "%", "F_GFC_%", "%"});
        JDBC.GeneratedId generatedId = new JDBC.GeneratedId();
        Object[][] objectArray = new Object[][]{{null, this.schema, "F_GFC_1", "", DatabaseMetaDataTest.i(4), DatabaseMetaDataTest.i(4), "INTEGER", DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(4), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(0), "YES", generatedId, DatabaseMetaDataTest.i(11), DatabaseMetaDataTest.i(-1)}, {null, this.schema, "F_GFC_1", "A", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(12), "VARCHAR", DatabaseMetaDataTest.i(3), DatabaseMetaDataTest.i(6), null, null, DatabaseMetaDataTest.i(1), null, DatabaseMetaDataTest.i(6), DatabaseMetaDataTest.i(1), "YES", generatedId, DatabaseMetaDataTest.i(11), DatabaseMetaDataTest.i(0)}, {null, this.schema, "F_GFC_1", "B", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(2), "NUMERIC", DatabaseMetaDataTest.i(5), DatabaseMetaDataTest.i(14), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(2), "YES", generatedId, DatabaseMetaDataTest.i(11), DatabaseMetaDataTest.i(1)}, {null, this.schema, "F_GFC_1", "C", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(5), "SMALLINT", DatabaseMetaDataTest.i(5), DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(3), "YES", generatedId, DatabaseMetaDataTest.i(11), DatabaseMetaDataTest.i(2)}, {null, this.schema, "F_GFC_1", "E", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(1), "CHAR", DatabaseMetaDataTest.i(3), DatabaseMetaDataTest.i(6), null, null, DatabaseMetaDataTest.i(1), null, DatabaseMetaDataTest.i(6), DatabaseMetaDataTest.i(4), "YES", generatedId, DatabaseMetaDataTest.i(11), DatabaseMetaDataTest.i(3)}, {null, this.schema, "F_GFC_1", "F", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(4), "INTEGER", DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(4), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(5), "YES", generatedId, DatabaseMetaDataTest.i(11), DatabaseMetaDataTest.i(4)}, {null, this.schema, "F_GFC_1", "G", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(-5), "BIGINT", DatabaseMetaDataTest.i(19), DatabaseMetaDataTest.i(40), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(6), "YES", generatedId, DatabaseMetaDataTest.i(11), DatabaseMetaDataTest.i(5)}, {null, this.schema, "F_GFC_1", "H", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(8), "DOUBLE", DatabaseMetaDataTest.i(52), DatabaseMetaDataTest.i(8), null, DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(7), "YES", generatedId, DatabaseMetaDataTest.i(11), DatabaseMetaDataTest.i(6)}, {null, this.schema, "F_GFC_1", "I", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(8), "DOUBLE", DatabaseMetaDataTest.i(52), DatabaseMetaDataTest.i(8), null, DatabaseMetaDataTest.i(2), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(8), "YES", generatedId, DatabaseMetaDataTest.i(11), DatabaseMetaDataTest.i(7)}, {null, this.schema, "F_GFC_1", "K", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(91), "DATE", DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(6), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(9), "YES", generatedId, DatabaseMetaDataTest.i(11), DatabaseMetaDataTest.i(8)}, {null, this.schema, "F_GFC_1", "L", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(92), "TIME", DatabaseMetaDataTest.i(8), DatabaseMetaDataTest.i(6), DatabaseMetaDataTest.i(0), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(10), "YES", generatedId, DatabaseMetaDataTest.i(11), DatabaseMetaDataTest.i(9)}, {null, this.schema, "F_GFC_1", "T", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(93), "TIMESTAMP", DatabaseMetaDataTest.i(29), DatabaseMetaDataTest.i(16), DatabaseMetaDataTest.i(9), DatabaseMetaDataTest.i(10), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(11), "YES", generatedId, DatabaseMetaDataTest.i(11), DatabaseMetaDataTest.i(10)}};
        if (bl) {
            objectArray = this.appendArray(objectArray, new Object[][]{{null, this.schema, "F_GFC_2", "", DatabaseMetaDataTest.i(4), DatabaseMetaDataTest.i(16), "BOOLEAN", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(0), "YES", generatedId, DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(-1)}, {null, this.schema, "F_GFC_2", "A", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(16), "BOOLEAN", DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(1), null, null, DatabaseMetaDataTest.i(1), "YES", generatedId, DatabaseMetaDataTest.i(1), DatabaseMetaDataTest.i(0)}});
        }
        JDBC.assertFullResultSet(resultSet, objectArray, false);
        if (bl) {
            statement.execute("drop function f_gfc_2");
        }
        statement.execute("drop function f_gfc_1");
        this.commit();
    }

    private static Integer i(int n) {
        return n;
    }

    public void test_jdbc4_1() throws Exception {
        Version version = this.getDataVersion(this.getConnection());
        if (version.compareTo(new Version(10, 8, 0, 0)) < 0) {
            return;
        }
        Statement statement = this.createStatement();
        DatabaseMetaData databaseMetaData = this.getDMD();
        DatabaseMetaDataTest.println("Testing JDBC 4.1 methods on a " + databaseMetaData.getClass().getName());
        Wrapper41DBMD wrapper41DBMD = new Wrapper41DBMD(databaseMetaData);
        DatabaseMetaDataTest.assertEquals((boolean)true, (boolean)wrapper41DBMD.generatedKeyAlwaysReturned());
        ResultSet resultSet = wrapper41DBMD.getPseudoColumns(null, null, null, null);
        DatabaseMetaDataTest.assertMetaDataResultSet(resultSet, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "COLUMN_SIZE", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "COLUMN_USAGE", "REMARKS", "CHAR_OCTET_LENGTH", "IS_NULLABLE"}, new int[]{12, 12, 12, 12, 4, 4, 4, 4, 12, 12, 4, 12}, new boolean[]{true, true, false, false, false, false, true, true, false, true, true, false});
        JDBC.assertFullResultSet(resultSet, new String[0][]);
        statement.execute("create table t_jdbc41( a int, b int, c generated always as ( -a ) )");
        ResultSet resultSet2 = databaseMetaData.getColumns(null, this.schema, "T_JDBC41", null);
        String[][] stringArray = new String[][]{{"", this.schema, "T_JDBC41", "A", "4", "INTEGER", "10", null, "0", "10", "1", "", null, null, null, null, "1", "YES", null, null, null, null, "NO", "NO", null}, {"", this.schema, "T_JDBC41", "B", "4", "INTEGER", "10", null, "0", "10", "1", "", null, null, null, null, "2", "YES", null, null, null, null, "NO", "NO", null}, {"", this.schema, "T_JDBC41", "C", "4", "INTEGER", "10", null, "0", "10", "1", "", "GENERATED ALWAYS AS ( -a )", null, null, null, "3", "YES", null, null, null, null, "NO", "YES", null}};
        JDBC.assertFullResultSet(resultSet2, stringArray);
        statement.execute("drop table t_jdbc41");
    }

    public void test_jdbc4_2() throws Exception {
        Version version = this.getDataVersion(this.getConnection());
        if (version.compareTo(new Version(10, 10, 0, 0)) < 0) {
            return;
        }
        Statement statement = this.createStatement();
        DatabaseMetaData databaseMetaData = this.getDMD();
        DatabaseMetaDataTest.println("Testing JDBC 4.2 methods on a " + databaseMetaData.getClass().getName());
        Wrapper42DBMD wrapper42DBMD = new Wrapper42DBMD(databaseMetaData);
        DatabaseMetaDataTest.assertEquals((long)0L, (long)wrapper42DBMD.getMaxLogicalLobSize());
        DatabaseMetaDataTest.assertEquals((boolean)false, (boolean)wrapper42DBMD.supportsRefCursors());
    }

    public void testBugFixes() throws SQLException {
        Statement statement = this.createStatement();
        this.getConnection().setAutoCommit(false);
        DatabaseMetaData databaseMetaData = this.getDMD();
        statement.execute("CREATE TABLE Derby655t1(c11_ID BIGINT NOT NULL)");
        statement.execute("CREATE TABLE Derby655t2 (c21_ID BIGINT NOT NULL primary key)");
        statement.execute("ALTER TABLE Derby655t1 ADD CONSTRAINT F_12 Foreign Key (c11_ID) REFERENCES Derby655t2 (c21_ID) ON DELETE CASCADE ON UPDATE NO ACTION");
        statement.execute("CREATE TABLE Derby655t3(c31_ID BIGINT NOT NULL primary key)");
        statement.execute("ALTER TABLE Derby655t2 ADD CONSTRAINT F_443 Foreign Key (c21_ID) REFERENCES Derby655t3(c31_ID) ON DELETE CASCADE ON UPDATE NO ACTION");
        ResultSet resultSet = databaseMetaData.getImportedKeys("", this.schema, "DERBY655T1");
        JDBC.assertDrainResults(resultSet, 1);
        statement.execute("drop table Derby655t1");
        statement.execute("drop table Derby655t2");
        statement.execute("drop table Derby655t3");
        if (JDBC.vmSupportsJDBC3()) {
            statement.execute("create procedure isReadO() language java external name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.DatabaseMetaDataTest.isro' parameter style java");
            statement.execute("call isReadO()");
        }
    }

    public static void isro() throws SQLException {
        DriverManager.getConnection("jdbc:default:connection").getMetaData().isReadOnly();
    }

    public void testGetColumns_DERBY5274() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table derby5274(x bigint not null generated always as identity (start with 648518346341351400, increment by 648518346341351400))");
        String[][] stringArrayArray = new String[][]{{"TABLE_SCHEM", this.schema}, {"TABLE_NAME", "DERBY5274"}, {"COLUMN_NAME", "X"}, {"COLUMN_DEF", "AUTOINCREMENT: start 648518346341351400 increment 648518346341351400"}, {"IS_NULLABLE", "NO"}};
        ResultSet resultSet = this.getDMD().getColumns(null, null, "DERBY5274", null);
        DatabaseMetaDataTest.assertTrue((String)"No columns found", (boolean)resultSet.next());
        for (String[] stringArray : stringArrayArray) {
            String string = stringArray[0];
            String string2 = stringArray[1];
            DatabaseMetaDataTest.assertEquals((String)string, (String)string2, (String)resultSet.getString(string));
        }
        JDBC.assertEmpty(resultSet);
        this.rollback();
    }

    public static byte[] getpc(String string, BigDecimal bigDecimal, short s, byte by, short s2, int n, long l, float f, double d, byte[] byArray, Date date, Time time, Timestamp timestamp) {
        return byArray;
    }

    public static void getpc(int n, long[] lArray) {
    }

    private static void getpc(int n, long l) {
    }

    public void getpc(String string, String string2) {
    }

    public static void getpc4a() {
    }

    public static int getpc4b() {
        return 4;
    }

    public void testDMDconnClosed() throws SQLException {
        ResultSet resultSet = this.getConnection().getMetaData().getTables("%", "%", "%", null);
        this.getConnection().close();
        try {
            resultSet.next();
            DatabaseMetaDataTest.fail((String)"No Exception throw when getting metadata.");
        }
        catch (SQLException sQLException) {
            DatabaseMetaDataTest.assertSQLState("XCL16", sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Version getDataVersion(Connection connection) throws Exception {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("values syscs_util.syscs_get_database_property('DataDictionaryVersion')");
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            String string = resultSet.getString(1);
            int n = string.indexOf(46);
            int n2 = Integer.parseInt(string.substring(0, n));
            int n3 = Integer.parseInt(string.substring(n + 1, string.length()));
            Version version = new Version(n2, n3, 0, 0);
            return version;
        }
        catch (Exception exception) {
            DatabaseMetaDataTest.printStackTrace(exception);
            Version version = null;
            return version;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }
}

