/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.lucene;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.optional.lucene.LuceneSupport;
import org.apache.derby.optional.utils.ToolUtilities;
import org.apache.derby.vti.StringColumnVTI;

class LuceneListIndexesVTI
extends StringColumnVTI {
    private Connection connection = LuceneSupport.getDefaultConnection();
    private StorageFile[] indexes;
    private int row = -1;
    private String schema;
    private String table;
    private String column;
    private Properties rowProperties;

    public LuceneListIndexesVTI() throws SQLException {
        super(new String[]{"SCHEMANAME", "TABLENAME", "COLUMNNAME", "LASTUPDATED", "LUCENEVERSION", "ANALYZER", "INDEXDESCRIPTORMAKER"});
        StorageFactory dir = LuceneSupport.getStorageFactory(this.connection);
        StorageFile luceneDir = dir.newStorageFile("LUCENE");
        ArrayList<StorageFile> allIndexes = new ArrayList<StorageFile>();
        StorageFile[] schemas = LuceneListIndexesVTI.listDirectories(dir, luceneDir);
        if (schemas != null) {
            for (StorageFile schema : schemas) {
                StorageFile[] tables;
                for (StorageFile table : tables = LuceneListIndexesVTI.listDirectories(dir, schema)) {
                    StorageFile[] indexes;
                    for (StorageFile index : indexes = LuceneListIndexesVTI.listDirectories(dir, table)) {
                        allIndexes.add(index);
                    }
                }
            }
        }
        this.indexes = new StorageFile[allIndexes.size()];
        allIndexes.toArray(this.indexes);
    }

    public void close() throws SQLException {
        this.connection = null;
        this.indexes = null;
        this.schema = null;
        this.table = null;
        this.column = null;
        this.rowProperties = null;
    }

    public boolean next() throws SQLException {
        this.schema = null;
        this.table = null;
        this.column = null;
        this.rowProperties = null;
        ++this.row;
        return this.row < this.indexes.length;
    }

    protected String getRawColumn(int col) throws SQLException {
        this.readSchemaTableColumn();
        switch (col) {
            case 1: {
                return this.schema;
            }
            case 2: {
                return this.table;
            }
            case 3: {
                return this.column;
            }
            case 5: {
                return this.getProperty("derby.lucene.version");
            }
            case 6: {
                return this.getProperty("derby.lucene.analyzer");
            }
            case 7: {
                return this.getProperty("derby.lucene.index.descriptor.maker");
            }
        }
        throw ToolUtilities.newSQLException("XCL14.S", col, this.getColumnCount());
    }

    public Timestamp getTimestamp(int col) throws SQLException {
        if (col != 4) {
            throw ToolUtilities.newSQLException("XCL14.S", col, this.getColumnCount());
        }
        try {
            long timestampMillis = Long.parseLong(this.getProperty("derby.lucene.last.updated"));
            return new Timestamp(timestampMillis);
        }
        catch (NumberFormatException nfe) {
            throw ToolUtilities.wrap(nfe);
        }
    }

    private void readSchemaTableColumn() throws SQLException {
        if (this.column != null) {
            return;
        }
        StorageFile columnDir = this.indexes[this.row];
        this.column = columnDir.getName();
        StorageFile tableDir = columnDir.getParentDir();
        this.table = tableDir.getName();
        StorageFile schemaDir = tableDir.getParentDir();
        this.schema = schemaDir.getName();
    }

    private String getProperty(String key) throws SQLException {
        return this.getRowProperties().getProperty(key);
    }

    private Properties getRowProperties() throws SQLException {
        if (this.rowProperties == null) {
            try {
                this.readSchemaTableColumn();
                String delimitedColumnName = LuceneSupport.delimitID(this.column);
                StorageFile indexPropertiesFile = LuceneSupport.getIndexPropertiesFile(this.connection, this.schema, this.table, delimitedColumnName);
                this.rowProperties = LuceneListIndexesVTI.readIndexProperties(indexPropertiesFile);
            }
            catch (IOException ioe) {
                throw ToolUtilities.wrap(ioe);
            }
            catch (PrivilegedActionException pae) {
                throw ToolUtilities.wrap(pae);
            }
        }
        return this.rowProperties;
    }

    private static StorageFile[] listDirectories(final StorageFactory storageFactory, final StorageFile dir) {
        return AccessController.doPrivileged(new PrivilegedAction<StorageFile[]>(){

            @Override
            public StorageFile[] run() {
                String[] fileNames;
                ArrayList<StorageFile> subdirectories = new ArrayList<StorageFile>();
                for (String fileName : fileNames = dir.list()) {
                    StorageFile candidate = storageFactory.newStorageFile(dir, fileName);
                    if (!candidate.isDirectory()) continue;
                    subdirectories.add(candidate);
                }
                StorageFile[] result = new StorageFile[subdirectories.size()];
                subdirectories.toArray(result);
                return result;
            }
        });
    }

    private static Properties readIndexProperties(final StorageFile file) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                @Override
                public Properties run() throws IOException {
                    return LuceneSupport.readIndexPropertiesNoPrivs(file);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getCause();
        }
    }
}

