/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.services.io.FormatableIntHolder;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AccessPathImpl;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class HashTableNode
extends SingleChildResultSetNode {
    PredicateList searchPredicateList;
    PredicateList joinPredicateList;
    SubqueryList pSubqueryList;
    SubqueryList rSubqueryList;

    HashTableNode(ResultSetNode childResult, Properties tableProperties, ResultColumnList resultColumns, PredicateList searchPredicateList, PredicateList joinPredicateList, AccessPathImpl accessPath, CostEstimate costEstimate, SubqueryList pSubqueryList, SubqueryList rSubqueryList, int[] hashKeyColumns, ContextManager cm) {
        super(childResult, tableProperties, cm);
        this.setResultColumns(resultColumns);
        this.searchPredicateList = searchPredicateList;
        this.joinPredicateList = joinPredicateList;
        this.trulyTheBestAccessPath = accessPath;
        this.setCostEstimate(costEstimate);
        this.pSubqueryList = pSubqueryList;
        this.rSubqueryList = rSubqueryList;
        this.setHashKeyColumns(hashKeyColumns);
    }

    public Optimizable modifyAccessPath(JBitSet outerTables, Optimizer optimizer) throws StandardException {
        return this;
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.searchPredicateList != null) {
            this.printLabel(depth, "searchPredicateList: ");
            this.searchPredicateList.treePrint(depth + 1);
        }
        if (this.joinPredicateList != null) {
            this.printLabel(depth, "joinPredicateList: ");
            this.joinPredicateList.treePrint(depth + 1);
        }
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT(this.getResultColumns() != null, "Tree structure bad");
        if (this.childResult instanceof FromVTI) {
            ((FromVTI)this.childResult).computeProjectionAndRestriction(this.searchPredicateList);
        }
        this.generateMinion(acb, mb, false);
    }

    @Override
    void generateResultSet(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateMinion(acb, mb, true);
    }

    private void generateMinion(ExpressionClassBuilder acb, MethodBuilder mb, boolean genChildResultSet) throws StandardException {
        ValueNode searchClause = null;
        Object equijoinClause = null;
        this.verifyProperties(this.getDataDictionary());
        if (this.searchPredicateList != null) {
            this.searchPredicateList.removeRedundantPredicates();
            searchClause = this.searchPredicateList.restorePredicates();
            this.searchPredicateList = null;
        }
        ResultColumnList.ColumnMapping mappingArrays = this.getResultColumns().mapSourceColumns();
        int[] mapArray = mappingArrays.mapArray;
        int mapArrayItem = acb.addItem(new ReferencedColumnsDescriptorImpl(mapArray));
        Object[] fihArray = FormatableIntHolder.getFormatableIntHolders(this.hashKeyColumns());
        FormatableArrayHolder hashKeyHolder = new FormatableArrayHolder(fihArray);
        int hashKeyItem = acb.addItem(hashKeyHolder);
        acb.pushGetResultSetFactoryExpression(mb);
        if (genChildResultSet) {
            this.childResult.generateResultSet(acb, mb);
        } else {
            this.childResult.generate((ActivationClassBuilder)acb, mb);
        }
        this.assignResultSetNumber();
        if (this.pSubqueryList != null && this.pSubqueryList.size() > 0) {
            this.pSubqueryList.setPointOfAttachment(this.getResultSetNumber());
            SanityManager.ASSERT(this.pSubqueryList.size() == 0, "pSubqueryList.size() expected to be 0");
        }
        if (this.rSubqueryList != null && this.rSubqueryList.size() > 0) {
            this.rSubqueryList.setPointOfAttachment(this.getResultSetNumber());
            SanityManager.ASSERT(this.rSubqueryList.size() == 0, "rSubqueryList.size() expected to be 0");
        }
        this.setCostEstimate(this.childResult.getFinalCostEstimate());
        if (searchClause == null) {
            mb.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder userExprFun = acb.newUserExprFun();
            searchClause.generateExpression(acb, userExprFun);
            userExprFun.methodReturn();
            userExprFun.complete();
            acb.pushMethodReference(mb, userExprFun);
        }
        this.joinPredicateList.generateQualifiers(acb, mb, (Optimizable)((Object)this.childResult), false);
        if (this.reflectionNeededForProjection()) {
            this.getResultColumns().generateCore(acb, mb, false);
        } else {
            mb.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        }
        mb.push(this.getResultSetNumber());
        mb.push(mapArrayItem);
        mb.push(this.getResultColumns().reusableResult());
        mb.push(hashKeyItem);
        mb.push(false);
        mb.push(-1L);
        mb.push(this.initialCapacity);
        mb.push(this.loadFactor);
        mb.push(this.getCostEstimate().singleScanRowCount());
        mb.push(this.getCostEstimate().getEstimatedCost());
        mb.callMethod((short)185, null, "getHashTableResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 14);
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.searchPredicateList != null) {
            this.searchPredicateList = (PredicateList)this.searchPredicateList.accept(v);
        }
        if (this.joinPredicateList != null) {
            this.joinPredicateList = (PredicateList)this.joinPredicateList.accept(v);
        }
    }
}

