/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.IOException;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class NetworkServerControlClientCommandTest
extends BaseJDBCTestCase {
    public NetworkServerControlClientCommandTest(String name) {
        super(name);
    }

    public void testPingWithoutArgs() throws InterruptedException, IOException {
        if (!this.hasDefaultDerbyPortUsing()) {
            return;
        }
        String[] pingWithoutArgsCmd = new String[]{"org.apache.derby.drda.NetworkServerControl", "ping"};
        pingWithoutArgsCmd = this.decorateCmdWithEnglishLocale(pingWithoutArgsCmd);
        this.assertSuccessfulPing(pingWithoutArgsCmd);
    }

    private boolean hasDefaultDerbyPortUsing() {
        return TestConfiguration.getCurrent().getPort() == 1527;
    }

    private String[] decorateCmdWithEnglishLocale(String[] cmd) {
        String[] newCmd = new String[cmd.length + 1];
        newCmd[0] = "-Dderby.ui.locale=en_US";
        System.arraycopy(cmd, 0, newCmd, 1, cmd.length);
        return newCmd;
    }

    public void testPingWithDefinedHost() throws InterruptedException, IOException {
        if (!this.hasDefaultDerbyPortUsing()) {
            return;
        }
        String currentHost = TestConfiguration.getCurrent().getHostName();
        String[] pingWithoutArgsCmd = new String[]{"org.apache.derby.drda.NetworkServerControl", "ping", "-h", currentHost};
        pingWithoutArgsCmd = this.decorateCmdWithEnglishLocale(pingWithoutArgsCmd);
        this.assertSuccessfulPing(pingWithoutArgsCmd);
    }

    public void testPingWithDefinedHostAndPort() throws InterruptedException, IOException {
        String currentPort = Integer.toString(TestConfiguration.getCurrent().getPort());
        String currentHost = TestConfiguration.getCurrent().getHostName();
        String[] pingWithoutArgsCmd = new String[]{"org.apache.derby.drda.NetworkServerControl", "ping", "-h", currentHost, "-p", currentPort};
        pingWithoutArgsCmd = this.decorateCmdWithEnglishLocale(pingWithoutArgsCmd);
        this.assertSuccessfulPing(pingWithoutArgsCmd);
    }

    public void testPingWithWrongHost() throws InterruptedException, IOException {
        String[] pingWithoutArgsCmd = new String[]{"org.apache.derby.drda.NetworkServerControl", "ping", "-h", "nothere.invalid"};
        pingWithoutArgsCmd = this.decorateCmdWithEnglishLocale(pingWithoutArgsCmd);
        this.assertFailedPing(pingWithoutArgsCmd, "Unable to find host");
    }

    public void testPingWithBogusPort() throws InterruptedException, IOException {
        String currentHost = TestConfiguration.getCurrent().getHostName();
        String bogusPort = Integer.toString(TestConfiguration.getCurrent().getBogusPort());
        String[] pingWithoutArgsCmd = new String[]{"org.apache.derby.drda.NetworkServerControl", "ping", "-h", currentHost, "-p", bogusPort};
        pingWithoutArgsCmd = this.decorateCmdWithEnglishLocale(pingWithoutArgsCmd);
        this.assertFailedPing(pingWithoutArgsCmd, "Could not connect to Derby Network Server");
    }

    private void assertSuccessfulPing(String[] pingCmd) throws InterruptedException, IOException {
        NetworkServerControlClientCommandTest.assertExecJavaCmdAsExpected(new String[]{"Connection obtained"}, pingCmd, 0);
    }

    private void assertFailedPing(String[] pingCmd, String expectedMessage) throws InterruptedException, IOException {
        NetworkServerControlClientCommandTest.assertExecJavaCmdAsExpected(new String[]{expectedMessage}, pingCmd, 1);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("NetworkServerControlClientCommandTest");
        if (!Derby.hasServer() || JDBC.vmSupportsJSR169()) {
            return suite;
        }
        Test test = TestConfiguration.clientServerSuite(NetworkServerControlClientCommandTest.class);
        test = SecurityManagerSetup.noSecurityManager(test);
        suite.addTest(test);
        return suite;
    }
}

