/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.c3AsciiStream;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.c3Reader;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class CharacterStreamsTest
extends BaseJDBCTestCase {
    private static final String ASCII_VALUE = "Lieberman ran with Gore";
    private static final int LEN_ASCII_VALUE = 23;
    private static final String CHAR_VALUE1 = "A Mississippi Republican";
    private static final int LEN_CHAR_VALUE1 = 24;
    private static final String CHAR_VALUE2 = "Lott has apologized";
    private static final int LEN_CHAR_VALUE2 = 19;

    public static Test suite() {
        return TestConfiguration.embeddedSuite(CharacterStreamsTest.class);
    }

    public CharacterStreamsTest(String string) {
        super(string);
    }

    public void testSetAsciiStreamIntoChar() throws Exception {
        this.runTestSetAsciiStream(1);
    }

    public void testSetAsciiStreamIntoVarchar() throws Exception {
        this.runTestSetAsciiStream(2);
    }

    public void testSetAsciiStreamIntoLongVarchar() throws Exception {
        this.runTestSetAsciiStream(3);
    }

    public void testSetAsciiStreamIntoClob() throws Exception {
        this.runTestSetAsciiStream(4);
    }

    public void testSetCharacterStreamIntoChar() throws Exception {
        this.runTestSetCharacterStream(1);
    }

    public void testSetCharacterStreamIntoVarchar() throws Exception {
        this.runTestSetCharacterStream(2);
    }

    public void testSetCharacterStreamIntoLongVarchar() throws Exception {
        this.runTestSetCharacterStream(3);
    }

    public void testSetCharacterStreamIntoClob() throws Exception {
        this.runTestSetCharacterStream(4);
    }

    public void testSetAsciiStreamLongValues() throws Exception {
        this.runTestSetAsciiStreamLongValues();
    }

    public void testSetCharacterStreamLongValues() throws Exception {
        this.runTestSetCharacterStreamLongValues();
    }

    private void runTestSetAsciiStream(int n) throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("insert into charstream(c, vc, lvc, lob) values(?,?,?,?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("select id, c, {fn length(c)} AS CLEN, cast (vc as varchar(25)) AS VC, {fn length(vc)} AS VCLEN, cast (lvc as varchar(25)) AS LVC, {fn length(lvc)} AS LVCLEN, cast (lob as varchar(25)) AS LOB, {fn length(lob)} AS LOBLEN from charstream where id > ? order by 1");
        CharacterStreamsTest.println("\nTest setAsciiStream into CHAR");
        preparedStatement.setString(1, null);
        preparedStatement.setString(2, null);
        preparedStatement.setString(3, null);
        preparedStatement.setString(4, null);
        int n2 = this.getMaxId();
        this.setAscii(preparedStatement, n);
        preparedStatement2.setInt(1, n2);
        this.verifyAsciiStreamResults(preparedStatement2.executeQuery(), n);
        PreparedStatement preparedStatement3 = this.prepareStatement("SELECT id, c, vc, lvc, lob FROM charstream where id > ? order by 1");
        preparedStatement3.setInt(1, n2);
        this.verifyResultsUsingAsciiStream(preparedStatement3.executeQuery(), n);
        this.verifyResultsUsingCharacterStream(preparedStatement3.executeQuery(), n);
        this.verifyResultsUsingCharacterStreamBlock(preparedStatement3.executeQuery(), n);
        preparedStatement3.close();
        preparedStatement.close();
        preparedStatement2.close();
    }

    private void runTestSetCharacterStream(int n) throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("insert into charstream(c, vc, lvc, lob) values(?,?,?,?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("select id, c, {fn length(c)} AS CLEN, cast (vc as varchar(25)) AS VC, {fn length(vc)} AS VCLEN, cast (lvc as varchar(25)) AS LVC, {fn length(lvc)} AS LVCLEN, cast (lob as varchar(25)) AS LOB, {fn length(lob)} AS LOBLEN from charstream where id > ? order by 1");
        CharacterStreamsTest.println("\nTest setCharacterStream into CHAR");
        preparedStatement.setString(1, null);
        preparedStatement.setString(2, null);
        preparedStatement.setString(3, null);
        preparedStatement.setString(4, null);
        int n2 = this.getMaxId();
        this.setCharacter(preparedStatement, n);
        preparedStatement2.setInt(1, n2);
        this.verifyCharStreamResults(preparedStatement2.executeQuery(), n);
        preparedStatement.close();
        preparedStatement2.close();
    }

    private void runTestSetAsciiStreamLongValues() throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("insert into charstream(c, vc, lvc, lob) values(?,?,?,?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("DELETE FROM charstream");
        PreparedStatement preparedStatement3 = this.prepareStatement("select c, vc, lvc, lob from charstream");
        CharacterStreamsTest.println("setAsciiStream(LONG ASCII STREAMS)");
        this.checkAsciiStreams(preparedStatement2, preparedStatement, preparedStatement3, 18, 104, 67, 67);
        this.checkAsciiStreams(preparedStatement2, preparedStatement, preparedStatement3, 25, 16732, 14563, 14563);
        this.checkAsciiStreams(preparedStatement2, preparedStatement, preparedStatement3, 1, 32433, 32673, 32673);
        this.checkAsciiStreams(preparedStatement2, preparedStatement, preparedStatement3, 0, 32532, 32700, 32700);
        preparedStatement.close();
        preparedStatement2.close();
        preparedStatement3.close();
    }

    private void runTestSetCharacterStreamLongValues() throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("insert into charstream(c, vc, lvc, lob) values(?,?,?,?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("DELETE FROM charstream");
        PreparedStatement preparedStatement3 = this.prepareStatement("select length(c), length(vc), length(lvc), length(lob) from charstream");
        PreparedStatement preparedStatement4 = this.prepareStatement("select c, vc, lvc, lob from charstream");
        CharacterStreamsTest.println("setCharacterStream(LONG CHARACTER STREAMS WITH UNICODE)");
        this.checkCharacterStreams(preparedStatement2, preparedStatement, preparedStatement4, preparedStatement3, 14, 93, 55, 55, 0);
        this.checkCharacterStreams(preparedStatement2, preparedStatement, preparedStatement4, preparedStatement3, 21, 10887, 10887, 10887, 3);
        this.checkCharacterStreams(preparedStatement2, preparedStatement, preparedStatement4, preparedStatement3, 25, 19332, 18733, 18733, 0);
        this.checkCharacterStreams(preparedStatement2, preparedStatement, preparedStatement4, preparedStatement3, 1, 32433, 32673, 32673, 0);
        this.checkCharacterStreams(preparedStatement2, preparedStatement, preparedStatement4, preparedStatement3, 0, 32532, 32700, 32700, 0);
        preparedStatement.close();
        preparedStatement2.close();
        preparedStatement4.close();
    }

    private int getMaxId() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select max(id) from charstream");
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        statement.close();
        return n;
    }

    private void setAscii(PreparedStatement preparedStatement, int n) throws Exception {
        byte[] byArray = null;
        CharacterStreamsTest.println("CORRECT NUMBER OF BYTES IN STREAM");
        byArray = ASCII_VALUE.getBytes("US-ASCII");
        preparedStatement.setAsciiStream(n, (InputStream)new ByteArrayInputStream(byArray), 23);
        preparedStatement.executeUpdate();
        CharacterStreamsTest.println("MORE BYTES IN STREAM THAN PASSED IN VALUE");
        try {
            byArray = "against Republicans George W. Bush ".getBytes("US-ASCII");
            preparedStatement.setAsciiStream(n, (InputStream)new ByteArrayInputStream(byArray), 19);
            preparedStatement.executeUpdate();
            CharacterStreamsTest.fail((String)"FAIL - MORE BYTES IN ASCII STREAM THAN SPECIFIED LENGTH");
        }
        catch (SQLException sQLException) {
            CharacterStreamsTest.assertSQLState("XJ001", sQLException);
        }
        CharacterStreamsTest.println("LESS BYTES IN STREAM THAN PASSED IN VALUE");
        try {
            byArray = "and Dick Cheney.".getBytes("US-ASCII");
            preparedStatement.setAsciiStream(n, (InputStream)new ByteArrayInputStream(byArray), 17);
            preparedStatement.executeUpdate();
            CharacterStreamsTest.fail((String)"FAIL - LESS BYTES IN ASCII STREAM THAN SPECIFIED LENGTH");
        }
        catch (SQLException sQLException) {
            CharacterStreamsTest.assertSQLState("XJ001", sQLException);
        }
        CharacterStreamsTest.println("NULL ASCII STREAM");
        preparedStatement.setAsciiStream(n, (InputStream)null, 1);
        preparedStatement.executeUpdate();
    }

    private void setCharacter(PreparedStatement preparedStatement, int n) throws Exception {
        StringReader stringReader = null;
        stringReader = new StringReader(CHAR_VALUE1);
        preparedStatement.setCharacterStream(n, (Reader)stringReader, 24);
        preparedStatement.executeUpdate();
        stringReader = new StringReader(CHAR_VALUE2);
        preparedStatement.setCharacterStream(n, (Reader)stringReader, 19);
        preparedStatement.executeUpdate();
        try {
            stringReader = new StringReader("for comments he made at");
            preparedStatement.setCharacterStream(n, (Reader)stringReader, 20);
            preparedStatement.executeUpdate();
            CharacterStreamsTest.fail((String)"FAIL - MORE CHARACTERS IN READER THAN SPECIFIED LENGTH");
        }
        catch (SQLException sQLException) {
            CharacterStreamsTest.assertSQLState("XJ001", sQLException);
        }
        try {
            stringReader = new StringReader("a birthday party");
            preparedStatement.setCharacterStream(n, (Reader)stringReader, 17);
            preparedStatement.executeUpdate();
            CharacterStreamsTest.fail((String)"FAIL - LESS CHARACTERS IN READER THAN SPECIFIED LENGTH");
        }
        catch (SQLException sQLException) {
            CharacterStreamsTest.assertSQLState("XJ001", sQLException);
        }
        preparedStatement.setCharacterStream(n, (Reader)null, 1);
        preparedStatement.executeUpdate();
    }

    private void verifyAsciiStreamResults(ResultSet resultSet, int n) throws Exception {
        CharacterStreamsTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        String string = resultSet.getString(n * 2);
        CharacterStreamsTest.assertFalse((String)"FAIL - value should not be null", (boolean)resultSet.wasNull());
        int n2 = resultSet.getInt(n * 2 + 1);
        CharacterStreamsTest.assertFalse((String)"FAIL - length should not be null", (boolean)resultSet.wasNull());
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong value on column " + n), (String)ASCII_VALUE, (String)string.trim());
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong length " + n), (int)23, (int)n2);
        CharacterStreamsTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        string = resultSet.getString(n * 2);
        CharacterStreamsTest.assertTrue((String)"FAIL - value should be null", (boolean)resultSet.wasNull());
        n2 = resultSet.getInt(n * 2 + 1);
        CharacterStreamsTest.assertTrue((String)"FAIL - length should be null", (boolean)resultSet.wasNull());
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong value on column " + n), null, (String)string);
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong length " + n), (int)0, (int)n2);
        CharacterStreamsTest.assertFalse((String)"FAIL - more rows than expected", (boolean)resultSet.next());
    }

    private void verifyCharStreamResults(ResultSet resultSet, int n) throws Exception {
        CharacterStreamsTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        String string = resultSet.getString(n * 2);
        CharacterStreamsTest.assertFalse((String)"FAIL - value should not be null", (boolean)resultSet.wasNull());
        int n2 = resultSet.getInt(n * 2 + 1);
        CharacterStreamsTest.assertFalse((String)"FAIL - length should not be null", (boolean)resultSet.wasNull());
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong value on column " + n), (String)CHAR_VALUE1, (String)string.trim());
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong length " + n), (int)24, (int)n2);
        CharacterStreamsTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        string = resultSet.getString(n * 2);
        CharacterStreamsTest.assertFalse((String)"FAIL - value should not be null", (boolean)resultSet.wasNull());
        n2 = resultSet.getInt(n * 2 + 1);
        CharacterStreamsTest.assertFalse((String)"FAIL - length should not be null", (boolean)resultSet.wasNull());
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong value on column " + n), (String)CHAR_VALUE2, (String)string.trim());
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong length " + n), (int)19, (int)n2);
        CharacterStreamsTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        string = resultSet.getString(n * 2);
        CharacterStreamsTest.assertTrue((String)"FAIL - value should be null", (boolean)resultSet.wasNull());
        n2 = resultSet.getInt(n * 2 + 1);
        CharacterStreamsTest.assertTrue((String)"FAIL - length should be null", (boolean)resultSet.wasNull());
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong value on column " + n), null, (String)string);
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong length " + n), (int)0, (int)n2);
        CharacterStreamsTest.assertFalse((String)"FAIL - more rows than expected", (boolean)resultSet.next());
        resultSet.close();
    }

    private void verifyResultsUsingAsciiStream(ResultSet resultSet, int n) throws Exception {
        CharacterStreamsTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        InputStream inputStream = resultSet.getAsciiStream(n + 1);
        CharacterStreamsTest.assertFalse((String)"FAIL - value should not be null", (boolean)resultSet.wasNull());
        byte[] byArray = new byte[23];
        CharacterStreamsTest.assertEquals((String)"FAIL - wrong length read from stream", (int)23, (int)inputStream.read(byArray));
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong value on column " + n), (String)ASCII_VALUE, (String)new String(byArray, "US-ASCII"));
        CharacterStreamsTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        String string = resultSet.getString(n + 1);
        CharacterStreamsTest.assertTrue((String)"FAIL - value should be null", (boolean)resultSet.wasNull());
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong value on column " + n), null, (String)string);
        CharacterStreamsTest.assertFalse((String)"FAIL - more rows than expected", (boolean)resultSet.next());
        resultSet.close();
    }

    private void verifyResultsUsingCharacterStream(ResultSet resultSet, int n) throws Exception {
        CharacterStreamsTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        Reader reader = resultSet.getCharacterStream(n + 1);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while ((n2 = reader.read()) != -1) {
            stringBuffer.append((char)n2);
        }
        String string = stringBuffer.toString().trim();
        CharacterStreamsTest.assertEquals((String)"FAIL - wrong length read from stream", (int)23, (int)string.length());
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong value on column " + n), (String)ASCII_VALUE, (String)string);
        CharacterStreamsTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        string = resultSet.getString(n + 1);
        CharacterStreamsTest.assertTrue((String)"FAIL - value should be null", (boolean)resultSet.wasNull());
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong value on column " + n), null, (String)string);
        CharacterStreamsTest.assertFalse((String)"FAIL - more rows than expected", (boolean)resultSet.next());
        resultSet.close();
    }

    private void verifyResultsUsingCharacterStreamBlock(ResultSet resultSet, int n) throws Exception {
        CharacterStreamsTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        Reader reader = resultSet.getCharacterStream(n + 1);
        CharacterStreamsTest.assertFalse((String)"FAIL - value should not be null", (boolean)resultSet.wasNull());
        char[] cArray = new char[23];
        CharacterStreamsTest.assertEquals((String)"FAIL - wrong length read from stream", (int)23, (int)reader.read(cArray));
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong value on column " + n), (String)ASCII_VALUE, (String)new String(cArray));
        CharacterStreamsTest.assertTrue((String)"FAIL - row not found", (boolean)resultSet.next());
        String string = resultSet.getString(n + 1);
        CharacterStreamsTest.assertTrue((String)"FAIL - value should be null", (boolean)resultSet.wasNull());
        CharacterStreamsTest.assertEquals((String)("FAIL - wrong value on column " + n), null, (String)string);
        CharacterStreamsTest.assertFalse((String)"FAIL - more rows than expected", (boolean)resultSet.next());
        resultSet.close();
    }

    private void checkAsciiStreams(PreparedStatement preparedStatement, PreparedStatement preparedStatement2, PreparedStatement preparedStatement3, int n, int n2, int n3, int n4) throws SQLException, IOException {
        preparedStatement.executeUpdate();
        preparedStatement2.setAsciiStream(1, (InputStream)new c3AsciiStream(n), n);
        preparedStatement2.setAsciiStream(2, (InputStream)new c3AsciiStream(n2), n2);
        preparedStatement2.setAsciiStream(3, (InputStream)new c3AsciiStream(n3), n3);
        preparedStatement2.setAsciiStream(4, (InputStream)new c3AsciiStream(n4), n4);
        preparedStatement2.executeUpdate();
        ResultSet resultSet = preparedStatement3.executeQuery();
        resultSet.next();
        InputStream inputStream = resultSet.getAsciiStream(1);
        this.checkAsciiStream(inputStream, n, 25);
        inputStream = resultSet.getAsciiStream(2);
        this.checkAsciiStream(inputStream, n2, -1);
        inputStream = resultSet.getAsciiStream(3);
        this.checkAsciiStream(inputStream, n3, -1);
        inputStream = resultSet.getAsciiStream(4);
        this.checkAsciiStream(inputStream, n4, -1);
        resultSet.close();
        resultSet = preparedStatement3.executeQuery();
        resultSet.next();
        Reader reader = resultSet.getCharacterStream(1);
        this.checkAsciiStream(reader, n, 25);
        reader = resultSet.getCharacterStream(2);
        this.checkAsciiStream(reader, n2, -1);
        reader = resultSet.getCharacterStream(3);
        this.checkAsciiStream(reader, n3, -1);
        reader = resultSet.getCharacterStream(4);
        this.checkAsciiStream(reader, n4, -1);
        resultSet.close();
        resultSet = preparedStatement3.executeQuery();
        resultSet.next();
        reader = new StringReader(resultSet.getString(1));
        this.checkAsciiStream(reader, n, 25);
        reader = new StringReader(resultSet.getString(2));
        this.checkAsciiStream(reader, n2, -1);
        reader = new StringReader(resultSet.getString(3));
        this.checkAsciiStream(reader, n3, -1);
        reader = new StringReader(resultSet.getString(4));
        this.checkAsciiStream(reader, n4, -1);
        resultSet.close();
    }

    private Reader getSourceStream(int n, int n2) {
        switch (n2) {
            case 0: {
                return new c3Reader(n);
            }
            case 1: {
                return new LoopingAlphabetReader((long)n, CharAlphabet.modernLatinLowercase());
            }
            case 2: {
                return new LoopingAlphabetReader((long)n, CharAlphabet.tamil());
            }
            case 3: {
                return new LoopingAlphabetReader((long)n, CharAlphabet.cjkSubset());
            }
        }
        CharacterStreamsTest.fail((String)("Illegal value of bytesPerChar: " + n2));
        return null;
    }

    private void checkCharacterStreams(PreparedStatement preparedStatement, PreparedStatement preparedStatement2, PreparedStatement preparedStatement3, PreparedStatement preparedStatement4, int n, int n2, int n3, int n4, int n5) throws SQLException, IOException {
        preparedStatement.executeUpdate();
        preparedStatement2.setCharacterStream(1, this.getSourceStream(n, n5), n);
        preparedStatement2.setCharacterStream(2, this.getSourceStream(n2, n5), n2);
        preparedStatement2.setCharacterStream(3, this.getSourceStream(n3, n5), n3);
        preparedStatement2.setCharacterStream(4, this.getSourceStream(n4, n5), n4);
        preparedStatement2.executeUpdate();
        ResultSet resultSet = preparedStatement4.executeQuery();
        CharacterStreamsTest.assertTrue((boolean)resultSet.next());
        CharacterStreamsTest.assertEquals((int)25, (int)resultSet.getInt(1));
        CharacterStreamsTest.assertEquals((int)n2, (int)resultSet.getInt(2));
        CharacterStreamsTest.assertEquals((int)n3, (int)resultSet.getInt(3));
        CharacterStreamsTest.assertEquals((int)n4, (int)resultSet.getInt(4));
        CharacterStreamsTest.assertFalse((boolean)resultSet.next());
        resultSet.close();
        ResultSet resultSet2 = preparedStatement3.executeQuery();
        resultSet2.next();
        InputStream inputStream = resultSet2.getAsciiStream(1);
        this.checkCharStream(inputStream, n, 25, n5);
        inputStream = resultSet2.getAsciiStream(2);
        this.checkCharStream(inputStream, n2, -1, n5);
        inputStream = resultSet2.getAsciiStream(3);
        this.checkCharStream(inputStream, n3, -1, n5);
        inputStream = resultSet2.getAsciiStream(4);
        this.checkCharStream(inputStream, n4, -1, n5);
        resultSet2.close();
        resultSet2 = preparedStatement3.executeQuery();
        resultSet2.next();
        Reader reader = resultSet2.getCharacterStream(1);
        this.checkCharStream(reader, n, 25, n5);
        reader = resultSet2.getCharacterStream(2);
        this.checkCharStream(reader, n2, -1, n5);
        reader = resultSet2.getCharacterStream(3);
        this.checkCharStream(reader, n3, -1, n5);
        reader = resultSet2.getCharacterStream(4);
        this.checkCharStream(reader, n4, -1, n5);
        resultSet2.close();
        resultSet2 = preparedStatement3.executeQuery();
        resultSet2.next();
        String string = resultSet2.getString(1);
        reader = new StringReader(string);
        this.checkCharStream(reader, n, 25, n5);
        string = resultSet2.getString(2);
        reader = new StringReader(string);
        this.checkCharStream(reader, n2, -1, n5);
        string = resultSet2.getString(3);
        reader = new StringReader(string);
        this.checkCharStream(reader, n3, -1, n5);
        string = resultSet2.getString(4);
        reader = new StringReader(string);
        this.checkCharStream(reader, n4, -1, n5);
        resultSet2.close();
    }

    private void checkAsciiStream(InputStream inputStream, int n, int n2) throws IOException {
        c3AsciiStream c3AsciiStream2 = new c3AsciiStream(n);
        int n3 = 0;
        while (true) {
            int n4 = c3AsciiStream2 == null ? (n3 == n2 ? -2 : 32) : ((InputStream)c3AsciiStream2).read();
            int n5 = inputStream.read();
            if (n4 == -1) {
                c3AsciiStream2 = null;
                if (n2 != -1 && n2 != n) {
                    n4 = 32;
                }
            }
            if (n4 == -2) {
                n4 = -1;
            }
            CharacterStreamsTest.assertEquals((String)("FAIL - wrong value at position " + n3), (int)n4, (int)n5);
            if (c3AsciiStream2 == null && n2 == -1 || n5 == -1 && n2 != -1) break;
            ++n3;
        }
        if (n2 != -1) {
            n = n2;
        }
        CharacterStreamsTest.assertEquals((String)"FAIL - wrong length", (int)n, (int)n3);
        inputStream.close();
    }

    private void checkAsciiStream(Reader reader, int n, int n2) throws IOException {
        c3AsciiStream c3AsciiStream2 = new c3AsciiStream(n);
        int n3 = 0;
        while (true) {
            int n4 = c3AsciiStream2 == null ? (n3 == n2 ? -2 : 32) : ((InputStream)c3AsciiStream2).read();
            int n5 = reader.read();
            if (n4 == -1) {
                c3AsciiStream2 = null;
                if (n2 != -1 && n2 != n) {
                    n4 = 32;
                }
            }
            if (n4 == -2) {
                n4 = -1;
            }
            CharacterStreamsTest.assertEquals((String)"FAIL - wrong value", (int)n4, (int)n5);
            if (c3AsciiStream2 == null && n2 == -1 || n5 == -1 && n2 != -1) break;
            ++n3;
        }
        if (n2 != -1) {
            n = n2;
        }
        CharacterStreamsTest.assertEquals((String)"FAIL - wrong length", (int)n, (int)n3);
        reader.close();
    }

    private void checkCharStream(InputStream inputStream, int n, int n2, int n3) throws IOException {
        Reader reader = this.getSourceStream(n, n3);
        int n4 = 0;
        while (true) {
            int n5 = reader == null ? (n4 == n2 ? -2 : 32) : reader.read();
            int n6 = inputStream.read();
            if (n5 == -1) {
                reader = null;
                if (n2 != -1 && n2 != n) {
                    n5 = 32;
                }
            }
            if (n5 == -2) {
                n5 = -1;
            }
            if (n5 != -1) {
                n5 = n5 <= 255 ? (n5 &= 0xFF) : 63;
            }
            CharacterStreamsTest.assertEquals((String)"FAIL - wrong value", (int)n5, (int)n6);
            if (reader == null && n2 == -1 || n6 == -1 && n2 != -1) break;
            ++n4;
        }
        if (n2 != -1) {
            n = n2;
        }
        CharacterStreamsTest.assertEquals((String)"FAIL - wrong length", (int)n, (int)n4);
        inputStream.close();
    }

    private void checkCharStream(Reader reader, int n, int n2, int n3) throws IOException {
        Reader reader2 = this.getSourceStream(n, n3);
        int n4 = 0;
        while (true) {
            int n5 = reader2 == null ? (n4 == n2 ? -2 : 32) : reader2.read();
            int n6 = reader.read();
            if (n5 == -1) {
                reader2 = null;
                if (n2 != -1 && n2 != n) {
                    n5 = 32;
                }
            }
            if (n5 == -2) {
                n5 = -1;
            }
            CharacterStreamsTest.assertEquals((String)"FAIL - wrong value", (int)n5, (int)n6);
            if (reader2 == null && n2 == -1 || n6 == -1 && n2 != -1) break;
            ++n4;
        }
        if (n2 != -1) {
            n = n2;
        }
        CharacterStreamsTest.assertEquals((String)"FAIL - wrong length", (int)n, (int)n4);
        reader.close();
    }

    protected void setUp() throws Exception {
        this.createStatement().executeUpdate("create table charstream(id int GENERATED ALWAYS AS IDENTITY primary key, c char(25), vc varchar(32532), lvc long varchar, lob clob(300K))");
    }

    @Override
    protected void tearDown() throws Exception {
        this.rollback();
        this.createStatement().executeUpdate("DROP TABLE charstream");
        this.commit();
        super.tearDown();
    }
}

