/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ExistsWithSubqueriesTest
extends BaseJDBCTestCase {
    private static final String EXISTS_PREFIX_1 = "select * from ( values 'GOT_A_ROW' ) as T where exists (";
    private static final String EXISTS_PREFIX_2 = "select j from onerow where exists (";

    public ExistsWithSubqueriesTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("EXISTS with SET operations");
        baseTestSuite.addTest(TestConfiguration.embeddedSuite(ExistsWithSubqueriesTest.class));
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.executeUpdate("create table empty (i int)");
                statement.executeUpdate("create table onerow (j int)");
                statement.executeUpdate("insert into onerow values 2");
                statement.executeUpdate("create table diffrow (k int)");
                statement.executeUpdate("insert into diffrow values 4");
                statement.executeUpdate("create table tworows (p int)");
                statement.executeUpdate("insert into tworows values 2, 4");
                statement.executeUpdate("create table onerow2col (j1 int, j2 int)");
                statement.executeUpdate("insert into onerow2col values (2, 2)");
            }
        };
    }

    public void testSetOpsWithVALUES() throws Exception {
        Statement statement = this.createStatement();
        String[][] stringArray = new String[1][1];
        stringArray[0][0] = "GOT_A_ROW";
        this.checkQuery(statement, stringArray, "select * from ( values 'GOT_A_ROW' ) as T where exists (values 1 union values 1)");
        this.checkQuery(statement, stringArray, "select * from ( values 'GOT_A_ROW' ) as T where exists (values 1 intersect values 1)");
        this.checkQuery(statement, stringArray, "select * from ( values 'GOT_A_ROW' ) as T where exists (values 1 except values 0)");
        this.checkQuery(statement, null, "select * from ( values 'GOT_A_ROW' ) as T where exists (values 1 intersect values 0)");
        this.checkQuery(statement, null, "select * from ( values 'GOT_A_ROW' ) as T where exists (values 1 except values 1)");
        statement.close();
    }

    public void testNonCorrelatedSetOps() throws Exception {
        Statement statement = this.createStatement();
        String[][] stringArray = new String[1][1];
        stringArray[0][0] = "GOT_A_ROW";
        this.checkQuery(statement, stringArray, "select * from ( values 'GOT_A_ROW' ) as T where exists (select * from diffrow union select * from onerow)");
        this.checkQuery(statement, stringArray, "select * from ( values 'GOT_A_ROW' ) as T where exists (select k from diffrow union select j from onerow)");
        this.checkQuery(statement, stringArray, "select * from ( values 'GOT_A_ROW' ) as T where exists (select * from diffrow intersect select 4 from onerow)");
        this.checkQuery(statement, stringArray, "select * from ( values 'GOT_A_ROW' ) as T where exists (select k from diffrow intersect select 4 from onerow)");
        this.checkQuery(statement, stringArray, "select * from ( values 'GOT_A_ROW' ) as T where exists (select * from diffrow except select * from onerow)");
        this.checkQuery(statement, stringArray, "select * from ( values 'GOT_A_ROW' ) as T where exists (select k from diffrow except select j from onerow)");
        this.checkQuery(statement, stringArray, "select * from ( values 'GOT_A_ROW' ) as T where exists ((select * from tworows where p = 2) except (select * from tworows where p <> 2))");
        this.checkQuery(statement, stringArray, "select * from ( values 'GOT_A_ROW' ) as T where exists ((select * from tworows where p = 2) intersect (select * from tworows where p = 2))");
        this.checkQuery(statement, null, "select * from ( values 'GOT_A_ROW' ) as T where exists (select i from empty union select * from empty)");
        this.checkQuery(statement, null, "select * from ( values 'GOT_A_ROW' ) as T where exists (select * from onerow intersect select * from empty)");
        this.checkQuery(statement, null, "select * from ( values 'GOT_A_ROW' ) as T where exists (select j from onerow intersect select i from empty)");
        this.checkQuery(statement, null, "select * from ( values 'GOT_A_ROW' ) as T where exists (select * from empty except select * from onerow)");
        this.checkQuery(statement, null, "select * from ( values 'GOT_A_ROW' ) as T where exists (select i from empty except select j from onerow)");
        this.checkQuery(statement, null, "select * from ( values 'GOT_A_ROW' ) as T where exists (select * from onerow intersect select * from diffrow)");
        this.checkQuery(statement, null, "select * from ( values 'GOT_A_ROW' ) as T where exists (select j from onerow intersect select k from diffrow)");
        this.checkQuery(statement, null, "select * from ( values 'GOT_A_ROW' ) as T where exists (select * from onerow except select * from onerow)");
        this.checkQuery(statement, null, "select * from ( values 'GOT_A_ROW' ) as T where exists (select j from onerow except select j from onerow)");
        this.checkQuery(statement, null, "select * from ( values 'GOT_A_ROW' ) as T where exists ((select * from tworows where p = 2) intersect (select * from tworows where p <> 2))");
        this.checkQuery(statement, null, "select * from ( values 'GOT_A_ROW' ) as T where exists ((select * from tworows where p = 2) except (select * from tworows where p = 2))");
        this.assertCompileError("42X04", "select * from ( values 'GOT_A_ROW' ) as T where exists ((select * from onerow where j = 2) intersect (select oops from onerow where j <> 2))");
        this.assertCompileError("42X04", "select * from ( values 'GOT_A_ROW' ) as T where exists ((select * from onerow where j = 2) intersect (select * from onerow where oops <> 2))");
        statement.close();
    }

    public void testCorrelatedSetOps() throws Exception {
        Statement statement = this.createStatement();
        String[][] stringArray = new String[1][1];
        stringArray[0][0] = "2";
        this.checkQuery(statement, stringArray, "select j from onerow where exists (select 1 from diffrow where 1 = 1 union select * from diffrow where onerow.j < k)");
        this.checkQuery(statement, stringArray, "select j from onerow where exists (select 1 from diffrow where 1 = 1 union select diffrow.* from diffrow where onerow.j < k)");
        this.checkQuery(statement, stringArray, "select j from onerow where exists (select 1 from diffrow where 1 = 1 union select k from diffrow where onerow.j < k)");
        this.checkQuery(statement, stringArray, "select j from onerow where exists (select 1 from diffrow where 1 = 0 union select * from diffrow where exists   (select 2 from diffrow intersect      select 2 from diffrow where onerow.j < k))");
        this.checkQuery(statement, stringArray, "select j from onerow where exists (select 1 from diffrow where 1 = 1 union select * from diffrow where exists   (select 2 from empty intersect     select 3 from empty where onerow.j < i))");
        this.checkQuery(statement, stringArray, "select j from onerow where exists (select 1 from diffrow where 1 = 1 union select * from diffrow where exists   (select 2 from onerow2col intersect     select 3 from empty where onerow.j < diffrow.k))");
        this.checkQuery(statement, stringArray, "select j from onerow where exists (select 1 from diffrow where 1 = 1 union select * from diffrow where exists   (select 2 from onerow2col intersect     select 3 from empty where onerow.j < k)   and (onerow.j < diffrow.k))");
        this.checkQuery(statement, null, "select j from onerow where exists (select 1 from diffrow where 1 = 0 union select * from diffrow where onerow.j > k)");
        this.checkQuery(statement, null, "select j from onerow where exists (select 1 from diffrow where 1 = 0 union select * from diffrow where exists   (select 2 from diffrow intersect      select 3 from diffrow where onerow.j < k))");
        this.checkQuery(statement, null, "select j from onerow where exists (select 1 from diffrow where 1 = 0 union select * from diffrow where exists   (select 2 from empty intersect     select 3 from empty where onerow.j < i))");
        this.checkQuery(statement, null, "select j from onerow where exists (select 1 from diffrow where 1 = 0 union select * from diffrow where exists   (select 2 from onerow2col intersect     select 3 from empty where onerow.j < diffrow.k))");
        this.checkQuery(statement, null, "select j from onerow where exists (select 1 from diffrow where 1 = 0 union select * from diffrow where exists   (select 2 from onerow2col intersect     select 3 from empty where onerow.j < k)   and (onerow.j < diffrow.k))");
        this.assertCompileError("42X58", "select j from onerow where exists (select 1 from diffrow where 1 = 0 union select * from onerow2col where onerow.j < j)");
        this.assertCompileError("42X04", "select j from onerow where exists (select * from (select 1 from diffrow where 1 = 0 union select * from diffrow where onerow.j < k) x)");
        this.assertCompileError("42X10", "select j from onerow where exists (select 1 from diffrow where 1 = 1 union select onerow.* from diffrow where onerow.j < k)");
        statement.close();
    }

    private void checkQuery(Statement statement, String[][] stringArray, String string) throws Exception {
        ResultSet resultSet = statement.executeQuery(string);
        if (stringArray == null) {
            JDBC.assertEmpty(resultSet);
        } else {
            JDBC.assertFullResultSet(resultSet, stringArray);
        }
        resultSet.close();
    }

    public void testDerby3033() throws Exception {
        this.setupDerby3033();
        PreparedStatement preparedStatement = this.prepareStatement("select c1, c2_b from (select distinct st.c1,st.c2_b,dsr.c3_a,st.c3_b       from              d3033_a dsr,              d3033_b st       where dsr.c4_a is null       and   dsr.c2 = ?       and   dsr.c1 = st.c1       and   not exists (               select 1               from d3033_c               where d3033_c.c1 = st.c1               and   d3033_c.c2 = ?               and   d3033_c.c3_c = ?               ) ) temp ");
        preparedStatement.setInt(1, 4);
        preparedStatement.setInt(2, 4);
        preparedStatement.setInt(3, 100);
        String[][] stringArray = new String[][]{{"1", "100"}, {"2", "200"}, {"3", "300"}};
        ResultSet resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, stringArray);
        preparedStatement.close();
    }

    private void updateStats(Statement statement, String string) throws Exception {
        ResultSet resultSet = statement.executeQuery("select * from " + string);
        int n = 0;
        while (resultSet.next()) {
            ++n;
        }
        resultSet.close();
    }

    private void setupDerby3033() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table d3033_a (c1 int, c2 int, c3_a int, c4_a date)");
        statement.executeUpdate("create table d3033_b (c1 int primary key not null, c2_b int, c3_b date)");
        statement.executeUpdate("create table d3033_c (c1 int, c2 int, c3_c int)");
        statement.executeUpdate("insert into d3033_a (c1,c2,c3_a) values(1, 4, 10)");
        statement.executeUpdate("insert into d3033_a (c1,c2,c3_a) values(2, 4, 20)");
        statement.executeUpdate("insert into d3033_a (c1,c2,c3_a) values(3, 4, 30)");
        statement.executeUpdate("insert into d3033_b values(1, 100, CURRENT_DATE)");
        statement.executeUpdate("insert into d3033_b values(2, 200, CURRENT_DATE)");
        statement.executeUpdate("insert into d3033_b values(3, 300, CURRENT_DATE)");
        statement.executeUpdate("insert into d3033_b values(4, 400, CURRENT_DATE)");
        statement.executeUpdate("insert into d3033_c values(1, 4, 100)");
        statement.executeUpdate("insert into d3033_c values(3, 4, 100)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into d3033_a (c1, c2, c3_a) values (?,?,?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("insert into d3033_b (c1, c2_b, c3_b) values (?,?,?)");
        Date date = new Date();
        Timestamp timestamp = new Timestamp(date.getTime());
        for (int i = 0; i < 15; ++i) {
            preparedStatement2.setInt(1, 100 + i);
            preparedStatement2.setInt(2, 100 + i);
            preparedStatement2.setTimestamp(3, timestamp);
            preparedStatement2.executeUpdate();
            for (int j = 0; j < 200; ++j) {
                preparedStatement.setInt(1, 1000 + j);
                preparedStatement.setInt(2, 100 + i);
                preparedStatement.setInt(3, 1000 + (j + 1) * 10);
                preparedStatement.executeUpdate();
            }
        }
        statement.executeUpdate("alter table d3033_a add constraint d3033_a_fk foreign key (c2) references d3033_b(c1) on delete cascade on update no action");
        statement.executeUpdate("alter table d3033_c add constraint d3033_c_fk foreign key (c1) references d3033_b(c1) on delete cascade on update no action");
        statement.executeUpdate("delete from d3033_c");
        this.updateStats(statement, "d3033_a");
        this.updateStats(statement, "d3033_b");
        this.updateStats(statement, "d3033_c");
        statement.close();
    }

    public void testDerby6408() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        JDBC.assertFullResultSet(statement.executeQuery("values (exists(select * from empty), not exists (select * from empty), not (exists (select * from empty)), not (not exists (select * from empty)))"), new String[][]{{"false", "true", "true", "false"}});
        JDBC.assertFullResultSet(statement.executeQuery("values (exists(select * from onerow), not exists (select * from onerow), not (exists (select * from onerow)), not (not exists (select * from onerow)))"), new String[][]{{"true", "false", "false", "true"}});
        JDBC.assertFullResultSet(statement.executeQuery("select exists(select * from empty), not exists (select * from empty), not (exists (select * from empty)), not (not exists (select * from empty)) from onerow"), new String[][]{{"false", "true", "true", "false"}});
        JDBC.assertEmpty(statement.executeQuery("select * from onerow where (exists (select * from empty)) is null"));
        JDBC.assertEmpty(statement.executeQuery("select * from onerow where (not exists (select * from empty)) is null"));
        JDBC.assertEmpty(statement.executeQuery("select * from onerow where (not (not exists (select * from empty))) is null"));
        JDBC.assertEmpty(statement.executeQuery("select * from onerow where (exists (select * from onerow)) is null"));
        JDBC.assertEmpty(statement.executeQuery("select * from onerow where (not exists (select * from onerow)) is null"));
        JDBC.assertEmpty(statement.executeQuery("select * from onerow where (not (not exists (select * from onerow))) is null"));
        JDBC.assertSingleValueResultSet(statement.executeQuery("values 1 in (select j from onerow)"), "false");
        JDBC.assertSingleValueResultSet(statement.executeQuery("values 2 in (select j from onerow)"), "true");
        JDBC.assertSingleValueResultSet(statement.executeQuery("values 1 > all (select 2 from tworows)"), "false");
        JDBC.assertSingleValueResultSet(statement.executeQuery("values 1 < all (select 2 from tworows)"), "true");
        statement.execute("create table d6408(id int generated by default as identity, b boolean not null)");
        statement.execute("insert into d6408(b) values exists (select * from empty), not exists (select * from empty), exists (select * from onerow), not exists (select * from onerow)");
        JDBC.assertFullResultSet(statement.executeQuery("select b from d6408 order by id"), new String[][]{{"false"}, {"true"}, {"true"}, {"false"}});
        statement.execute("update d6408 set b = exists (select * from empty)");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select distinct b from d6408"), "false");
        statement.execute("update d6408 set b = not exists (select * from empty)");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select distinct b from d6408"), "true");
        statement.execute("update d6408 set b = exists (select * from onerow)");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select distinct b from d6408"), "true");
        statement.execute("update d6408 set b = not exists (select * from onerow)");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select distinct b from d6408"), "false");
    }
}

