/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LuceneCollationTest
extends GeneratedColumnsHelper {
    private static final String RUTH = "RUTH";
    private static final String LOAD_TOOL = "call syscs_util.syscs_register_tool( 'luceneSupport', true )";
    private static final String UNLOAD_TOOL = "call syscs_util.syscs_register_tool( 'luceneSupport', false )";
    private static final String INDEX_POEMS = "call LuceneSupport.createIndex( 'ruth', 'poems', 'poemText', null )";
    private static final String UPDATE_POEMS_INDEX = "call LuceneSupport.updateIndex( 'ruth', 'poems', 'poemText', null )";
    private static final String DROP_POEMS_INDEX = "call LuceneSupport.dropIndex( 'ruth', 'poems', 'poemText' )";

    public LuceneCollationTest(String string) {
        super(string);
    }

    public static Test suite() {
        Test test = Decorator.territoryCollatedDatabase(TestConfiguration.embeddedSuite(LuceneCollationTest.class), "en");
        return SecurityManagerSetup.noSecurityManager(test);
    }

    public void test_001_collation() throws Exception {
        Connection connection = this.getConnection();
        this.assertResults(connection, "values syscs_util.syscs_get_database_property( 'derby.database.collation' )", new String[][]{{"TERRITORY_BASED"}}, true);
    }

    public void test_002_basic() throws Exception {
        Connection connection = this.openUserConnection(RUTH);
        this.createSchema(connection);
        this.goodStatement(connection, LOAD_TOOL);
        this.goodStatement(connection, INDEX_POEMS);
        this.goodStatement(connection, UPDATE_POEMS_INDEX);
        this.assertResults(connection, "select * from table ( ruth.poems__poemText( 'star', 1000, null ) ) luceneResults order by poemID", new String[][]{{"3", "3", "2", "0.22933942"}, {"4", "4", "3", "0.22933942"}, {"5", "5", "4", "0.26756266"}}, false);
        this.assertResults(connection, "select schemaName, tableName, columnName from table ( LuceneSupport.listIndexes() ) listindexes", new String[][]{{RUTH, "POEMS", "POEMTEXT"}}, false);
        this.goodStatement(connection, DROP_POEMS_INDEX);
        this.goodStatement(connection, UNLOAD_TOOL);
        this.dropSchema(connection);
    }

    private void createSchema(Connection connection) throws Exception {
        this.createPoemsTable(connection);
    }

    private void createPoemsTable(Connection connection) throws Exception {
        this.goodStatement(connection, "create table poems\n(\n    poemID int,\n    versionStamp int not null,\n    originalAuthor       varchar( 50 ),\n    lastEditor           varchar( 50 ),\n    poemText            clob,\n    constraint poemsKey primary key( poemID, versionStamp )\n)\n");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into poems values ( ?, ?, ?, ?, ? )");
        int n = 1;
        int n2 = 1;
        preparedStatement.setInt(1, n++);
        preparedStatement.setInt(2, n2++);
        preparedStatement.setString(3, "Geoffrey Chaucer");
        preparedStatement.setString(4, "Geoffrey Chaucer");
        preparedStatement.setString(5, "Whan that Aprill, with his shoures soote The droghte of March hath perced to the roote And bathed every veyne in swich licour, Of which vertu engendred is the flour;");
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, n++);
        preparedStatement.setInt(2, n2++);
        preparedStatement.setString(3, "Andrew Marvell");
        preparedStatement.setString(4, "Andrew Marvell");
        preparedStatement.setString(5, "Had we but world enough, and time, This coyness, lady, were no crime.");
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, n++);
        preparedStatement.setInt(2, n2++);
        preparedStatement.setString(3, "John Milton");
        preparedStatement.setString(4, "John Milton");
        preparedStatement.setString(5, "From morn to noon he fell, from noon to dewy eve, a summers day, and with the setting sun dropped from the ze4ith like a falling star on Lemnos, the Aegean isle");
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, n++);
        preparedStatement.setInt(2, n2++);
        preparedStatement.setString(3, "Lord Byron");
        preparedStatement.setString(4, "Lord Byron");
        preparedStatement.setString(5, "The Assyrian came down like the wolf on the fold, And his cohorts were gleaming in purple and gold; And the sheen of their spears was like stars on the sea, When the blue wave rolls nightly on deep Galilee.");
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, n++);
        preparedStatement.setInt(2, n2++);
        preparedStatement.setString(3, "Walt Whitman");
        preparedStatement.setString(4, "Walt Whitman");
        preparedStatement.setString(5, "When lilacs last in the dooryard bloomd, And the great star early droopd in the western sky in the night, I mournd, and yet shall mourn with ever-returning spring.");
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    private void dropSchema(Connection connection) throws Exception {
        this.goodStatement(connection, "drop table poems");
    }
}

