/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class NestedCommitTest
extends BaseJDBCTestCase {
    public NestedCommitTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(NestedCommitTest.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNestedCommit() throws Exception {
        Statement statement = this.createStatement();
        statement.getConnection().setHoldability(2);
        try {
            statement.executeUpdate("CREATE PROCEDURE doConnCommit()        DYNAMIC RESULT SETS 0 LANGUAGE JAVA        EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.Triggers.doConnCommit'     CONTAINS SQL       PARAMETER STYLE JAVA");
            statement.executeUpdate("CREATE PROCEDURE doConnRollback()        DYNAMIC RESULT SETS 0 LANGUAGE JAVA        EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.Triggers.doConnRollback'     CONTAINS SQL       PARAMETER STYLE JAVA");
            statement.executeUpdate("CREATE PROCEDURE doConnStmt(IN TEXT CHAR(50))        DYNAMIC RESULT SETS 0 LANGUAGE JAVA        EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.Triggers.doConnStmt'     CONTAINS SQL       PARAMETER STYLE JAVA");
            statement.executeUpdate("CREATE FUNCTION doConnCommitInt()        RETURNS INT EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.Triggers.doConnCommitInt'        LANGUAGE JAVA PARAMETER STYLE JAVA");
            statement.executeUpdate("CREATE FUNCTION doConnStmtInt(TEXT CHAR(50))        RETURNS INT EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.Triggers.doConnStmtInt'        LANGUAGE JAVA PARAMETER STYLE JAVA");
            statement.executeUpdate("create table x (x int)");
            statement.executeUpdate("insert into x values 1,2,3,4");
            this.setAutoCommit(false);
            CallableStatement callableStatement = this.prepareCall("call doConnCommit()");
            NestedCommitTest.assertUpdateCount(callableStatement, 0);
            callableStatement = this.prepareCall("call doConnRollback()");
            NestedCommitTest.assertUpdateCount(callableStatement, 0);
            callableStatement = this.prepareCall("call doConnStmt('call doConnCommit()')");
            NestedCommitTest.assertUpdateCount(callableStatement, 0);
            callableStatement = this.prepareCall("call doConnStmt('call doConnRollback()')");
            NestedCommitTest.assertUpdateCount(callableStatement, 0);
            ResultSet resultSet = statement.executeQuery("values doConnCommitInt()");
            NestedCommitTest.assertTrue((boolean)resultSet.next());
            try {
                resultSet.getString(1);
            }
            catch (SQLException sQLException) {
                NestedCommitTest.assertSQLState("XCL16", sQLException);
            }
            resultSet = statement.executeQuery("values doConnStmtInt('values doConnCommitInt()')");
            JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1"}}, true);
            NestedCommitTest.assertStatementError("38000", statement, "insert into x select x+doConnCommitInt() from x");
            NestedCommitTest.assertStatementError("38000", statement, "delete from x where x in (select x+doConnCommitInt() from x)");
            NestedCommitTest.assertStatementError("38000", statement, "delete from x where x = doConnCommitInt()");
            NestedCommitTest.assertStatementError("38000", statement, "update x set x = doConnCommitInt()");
            NestedCommitTest.assertStatementError("38000", statement, "select doConnStmtInt('call doConnStmt(''call doConnCommit()'')') from x");
            callableStatement = this.prepareCall("call doConnStmt('set isolation serializable')");
            NestedCommitTest.assertUpdateCount(callableStatement, 0);
        }
        finally {
            this.dontThrow(statement, "drop table x");
            this.dontThrow(statement, "drop procedure doConnCommit");
            this.dontThrow(statement, "drop procedure doConnRollback");
            this.dontThrow(statement, "drop function doConnCommitInt");
            this.dontThrow(statement, "drop procedure doConnStmt");
            this.dontThrow(statement, "drop function doConnStmtInt");
            this.commit();
        }
    }

    private void dontThrow(Statement statement, String string) {
        try {
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

