/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class PredicateTest
extends BaseJDBCTestCase {
    public PredicateTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.embeddedSuite(PredicateTest.class);
    }

    public void testTransitiveClosureWithConstantsOnLeftSide() throws SQLException, IOException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table t1 (i int)");
        statement.execute("create table t2 (j int)");
        statement.execute("insert into t1 values 1, 5, 7, 11, 13, 17, 19");
        statement.execute("insert into t2 values 23, 29, 31, 37, 43, 47, 53");
        statement.execute("insert into t1 select 23 * i from t1 where i < 19");
        statement.execute("insert into t2 select 23 * j from t2 where j < 55");
        statement.execute("call syscs_util.syscs_set_runtimestatistics(1)");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select i from t1, t2 where t1.i = t2.j and t1.i >= 23 and t2.j <= 30"), "23");
        List<String> list = Arrays.asList("Operator: <", "Operator: <=", "Operator: <", "Operator: <=", "Operator: =");
        PredicateTest.assertEquals(list, this.extractOperators(this.getStatistics()));
        JDBC.assertSingleValueResultSet(statement.executeQuery("select i from t1, t2 where t1.i = t2.j and 23 <= t1.i and 30 >= t2.j"), "23");
        PredicateTest.assertEquals(list, this.extractOperators(this.getStatistics()));
        PreparedStatement preparedStatement = this.prepareStatement("select i from t1, t2 where t1.i = t2.j and t1.i >= ? and t2.j <= ?");
        preparedStatement.setInt(1, 23);
        preparedStatement.setInt(2, 30);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "23");
        PredicateTest.assertEquals(list, this.extractOperators(this.getStatistics()));
        PreparedStatement preparedStatement2 = this.prepareStatement("select i from t1, t2 where t1.i = t2.j and ? <= t1.i and ? >= t2.j");
        preparedStatement2.setInt(1, 23);
        preparedStatement2.setInt(2, 30);
        JDBC.assertSingleValueResultSet(preparedStatement2.executeQuery(), "23");
        PredicateTest.assertEquals(list, this.extractOperators(this.getStatistics()));
    }

    private String getStatistics() throws SQLException {
        ResultSet resultSet = this.createStatement().executeQuery("values syscs_util.syscs_get_runtimestatistics()");
        resultSet.next();
        String string = resultSet.getString(1);
        JDBC.assertEmpty(resultSet);
        return string;
    }

    private List<String> extractOperators(String string) throws IOException {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        while ((string2 = bufferedReader.readLine()) != null) {
            if (!(string2 = string2.trim()).startsWith("Operator: ")) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }
}

