/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeRun;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.JDBC;

public class OldVersions {
    private static int[][] VERSIONS = new int[][]{{10, 0, 2, 1}, {10, 1, 1, 0}, {10, 1, 2, 1}, {10, 1, 3, 1}, {10, 2, 1, 6}, {10, 2, 2, 0}, {10, 3, 1, 4}, {10, 3, 3, 0}, {10, 4, 1, 3}, {10, 4, 2, 0}, {10, 5, 1, 1}, {10, 5, 3, 0}, {10, 6, 1, 0}, {10, 6, 2, 1}, {10, 7, 1, 1}, {10, 8, 1, 2}, {10, 8, 2, 2}, {10, 8, 3, 0}, {10, 9, 1, 0}, {10, 10, 1, 1}, {10, 10, 2, 0}, {10, 11, 1, 1}, {10, 12, 1, 1}, {10, 13, 1, 1}, {10, 14, 2, 0}};
    public static int[] VERSION_10_3_3_0 = new int[]{10, 3, 3, 0};

    public static int[][] getSupportedVersions() {
        int[][] nArray = null;
        if (UpgradeRun.oldVersionsPath != null) {
            nArray = OldVersions.getVersions(UpgradeRun.oldVersionsPath);
        }
        if (nArray == null) {
            nArray = VERSIONS;
        }
        OldVersions.show(nArray);
        return OldVersions.getSupportedVersions(nArray);
    }

    private static int[][] getSupportedVersions(int[][] nArray) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (JDBC.vmSupportsJSR169() && nArray[i][0] == 10 && nArray[i][1] == 0) {
                OldVersions.traceit("Skipping 10.0 on JSR169");
                continue;
            }
            if (BaseTestCase.isCVM() && nArray[i][0] == 10 && nArray[i][1] == 3 && nArray[i][2] == 1 && nArray[i][3] == 4) {
                OldVersions.traceit("Skipping 10.3.1.4 on CVM");
                continue;
            }
            if (JDBC.vmSupportsJDBC3() && !JDBC.vmSupportsJNDI() && UpgradeRun.lessThan(nArray[i], new int[]{10, 10, 0, 0})) {
                OldVersions.traceit("Skipping " + Arrays.toString(nArray[i]) + " because JNDI is not available");
                continue;
            }
            arrayList.add(nArray[i]);
        }
        return (int[][])arrayList.toArray((T[])new int[arrayList.size()][]);
    }

    private static int[][] getVersions(String string) {
        BufferedReader bufferedReader = null;
        try {
            FileReader fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            OldVersions.alarm("File '" + string + "' was not found, using default old versions for upgrade tests.");
            return null;
        }
        OldVersions.traceit("Run upgrade tests on versions defined in '" + string + "'");
        return OldVersions.getVersions(bufferedReader, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int[][] getVersions(BufferedReader bufferedReader, String string) {
        Object object;
        int[][] nArray = new int[256][4];
        int n = 0;
        String string2 = null;
        int n2 = 0;
        try {
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n2;
                try {
                    object = OldVersions.split4(string2, '.');
                    if (((int[][])object).length >= 3) {
                        int[] nArray2 = new int[4];
                        for (int i = 0; i < 4; ++i) {
                            Object object2 = object[i];
                            if (i == 3) {
                                object2 = OldVersions.clean((String)object2, "0123456789");
                            }
                            nArray2[i] = Integer.parseInt((String)object2);
                        }
                        nArray[n++] = nArray2;
                        continue;
                    }
                    OldVersions.alarm("Illegal version format on: " + string2);
                }
                catch (NumberFormatException numberFormatException) {
                    OldVersions.alarm("NumberFormatException on line " + n2 + ": " + string2 + ":  " + numberFormatException.getMessage());
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    OldVersions.alarm("ArrayIndexOutOfBoundsException on line " + n2 + ": " + string2 + ":  " + arrayIndexOutOfBoundsException.getMessage());
                }
            }
        }
        catch (IOException iOException) {
            OldVersions.alarm("Error reading from file: " + string + iOException.getMessage());
        }
        object = new int[n][4];
        int n3 = 0;
        while (n3 < n) {
            object[n3] = nArray[n3];
            ++n3;
        }
        return object;
    }

    private static void show(int[][] nArray) {
        OldVersions.traceit("Upgrade test versions listed:");
        for (int i = 0; i < nArray.length; ++i) {
            Object object = "";
            for (int j = 0; j < nArray[i].length; ++j) {
                object = j == 0 ? "" + nArray[i][j] : (String)object + "." + nArray[i][j];
            }
            OldVersions.traceit((String)object);
        }
    }

    private static String[] split4(String string, char c) {
        String[] stringArray = new String[4];
        try {
            int n = string.indexOf(c);
            if (n < 0) {
                return stringArray;
            }
            stringArray[0] = string.substring(0, n);
            int n2 = string.indexOf(c, n + 1);
            if (n2 < 0) {
                return stringArray;
            }
            stringArray[1] = string.substring(n + 1, n2);
            int n3 = string.indexOf(c, n2 + 1);
            if (n3 < 0) {
                return stringArray;
            }
            stringArray[2] = string.substring(n2 + 1, n3);
            int n4 = string.indexOf(c, n3 + 1);
            if (n4 < 0) {
                n4 = string.length();
            }
            stringArray[3] = string.substring(n3 + 1, n4);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            OldVersions.println("split4 StringIndexOutOfBoundsException: " + stringIndexOutOfBoundsException.getMessage());
            stringIndexOutOfBoundsException.printStackTrace();
        }
        return stringArray;
    }

    private static String clean(String string, String string2) {
        for (int i = 0; i < string.length(); ++i) {
            if (OldVersions.matches(string.charAt(i), string2)) continue;
            return string.substring(0, i);
        }
        return string;
    }

    private static boolean matches(char c, String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    private static void println(String string) {
        BaseTestCase.println(string);
    }

    private static void traceit(String string) {
        BaseTestCase.traceit(string);
    }

    private static void alarm(String string) {
        BaseTestCase.alarm(string);
    }
}

