/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql;

import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.shared.common.error.StandardException;

public class StatementUtil {
    private static final String[] TypeNames = new String[]{"", "INSERT", "INSERT", "UPDATE", "DELETE", "ENABLED", "DISABLED"};

    private StatementUtil() {
    }

    public static String typeName(int n) {
        String string;
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = TypeNames[n];
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        return string;
    }

    public static SchemaDescriptor getSchemaDescriptor(String string, boolean bl, DataDictionary dataDictionary, LanguageConnectionContext languageConnectionContext, CompilerContext compilerContext) throws StandardException {
        SchemaDescriptor schemaDescriptor = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string == null) {
            schemaDescriptor = compilerContext.getCompilationSchema();
            if (schemaDescriptor == null) {
                schemaDescriptor = languageConnectionContext.getDefaultSchema();
                bl2 = true;
                compilerContext.setCompilationSchema(schemaDescriptor);
            } else {
                bl3 = true;
            }
            string = schemaDescriptor.getSchemaName();
        }
        SchemaDescriptor schemaDescriptor2 = dataDictionary.getSchemaDescriptor(string, languageConnectionContext.getTransactionCompile(), bl);
        if (bl2 || bl3) {
            if (schemaDescriptor2 != null && schemaDescriptor2.getUUID() != null) {
                if (!schemaDescriptor2.getUUID().equals(schemaDescriptor.getUUID())) {
                    if (bl2) {
                        languageConnectionContext.setDefaultSchema(schemaDescriptor2);
                    }
                    compilerContext.setCompilationSchema(schemaDescriptor2);
                }
            } else {
                schemaDescriptor.setUUID(null);
                schemaDescriptor2 = schemaDescriptor;
            }
        }
        return schemaDescriptor2;
    }
}

