/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Arrays;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.IdentitySequenceTest;
import org.apache.derbyTesting.functionTests.util.TestInputStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class AlterTableTest
extends BaseJDBCTestCase {
    private static final String CANNOT_ALTER_NON_IDENTITY_COLUMN = "42Z29";
    private static final String CANNOT_MODIFY_ALWAYS_IDENTITY_COLUMN = "42Z23";
    private static final String DUPLICATE_KEY = "23505";
    private static final String EXHAUSTED_IDENTITY_COLUMN = "2200H";

    public AlterTableTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("AlterTableTest Test");
        baseTestSuite.addTest(TestConfiguration.defaultSuite(AlterTableTest.class));
        return TestConfiguration.sqlAuthorizationDecorator((Test)baseTestSuite);
    }

    private void createTestObjects(Statement statement) throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        CleanDatabaseTestSetup.cleanDatabase(connection, false);
        statement.executeUpdate("create table t0(c1 int not null constraint p1 primary key)");
        statement.executeUpdate("create table t0_1(c1 int)");
        statement.executeUpdate("create table t0_2(c1 int)");
        statement.executeUpdate("create table t0_3(c1 int)");
        statement.executeUpdate("create table t1(c1 int)");
        statement.executeUpdate("create table t1_1(c1 int)");
        statement.executeUpdate("create table t2(c1 int)");
        statement.executeUpdate("create table t3(c1 int)");
        statement.executeUpdate("create table t4(c1 int not null)");
        statement.executeUpdate("create view v1 as select * from t2");
        statement.executeUpdate("create view v2 as select c1 from t2");
        statement.executeUpdate("create index i0_1 on t0_1(c1)");
        statement.executeUpdate("create index i0_2 on t0_2(c1)");
        statement.executeUpdate("insert into t1 values 1");
        statement.executeUpdate("insert into t1_1 values 1");
        statement.executeUpdate("insert into t2 values 1");
        statement.executeUpdate("insert into t2 values 2");
        statement.executeUpdate("insert into t3 values 1");
        statement.executeUpdate("insert into t3 values 2");
        statement.executeUpdate("insert into t3 values 3");
        statement.executeUpdate("insert into t4 values 1, 2, 3, 1");
        statement.executeUpdate("create schema emptyschema");
    }

    private void checkWarning(Statement statement, String string) throws Exception {
        SQLWarning sQLWarning = statement == null ? this.getConnection().getWarnings() : statement.getWarnings();
        AlterTableTest.assertNotNull((String)"Expected warning but found none", (Object)sQLWarning);
        AlterTableTest.assertSQLState(string, sQLWarning);
    }

    public void testAddColumn() throws Exception {
        Statement statement = this.createStatement();
        this.createTestObjects(statement);
        this.commit();
        AlterTableTest.assertStatementError("42Y55", statement, "alter table notexists add column c1 int");
        AlterTableTest.assertStatementError("X0Y32", statement, "alter table t0 add column c1 int");
        AlterTableTest.assertStatementError("42XA9", statement, "alter table t0 add column y");
        AlterTableTest.assertStatementError("42X62", statement, "alter table sys.systables add column c1 int");
        AlterTableTest.assertStatementError("42Y62", statement, "alter table v2 add column c2 int");
        AlterTableTest.assertStatementError("X0Y58", statement, "alter table t0 add column c2 int not null default 0 primary key");
        AlterTableTest.assertStatementError(DUPLICATE_KEY, statement, "alter table t3 add column c2 int not null default 0 unique");
        PreparedStatement preparedStatement = this.prepareStatement("select * from t1");
        ResultSet resultSet = preparedStatement.executeQuery();
        if (AlterTableTest.usingEmbedded()) {
            AlterTableTest.assertStatementError("X0X95", statement, " alter table t1 add column c2 int");
        }
        resultSet.close();
        preparedStatement.close();
        statement.executeUpdate("alter table t1 add column c2 int not null default 0");
        statement.executeUpdate("alter table t1 add column c3 int not null default 0 primary key");
        statement.executeUpdate("alter table t1 add column c4 int check(c4 = 1)");
        ResultSet resultSet2 = statement.executeQuery("select * from v1");
        JDBC.assertColumnNames(resultSet2, "C1");
        JDBC.assertFullResultSet(resultSet2, new String[][]{{"1"}, {"2"}});
        PreparedStatement preparedStatement2 = this.prepareStatement("select * from t2");
        resultSet2 = preparedStatement2.executeQuery();
        JDBC.assertColumnNames(resultSet2, "C1");
        JDBC.assertFullResultSet(resultSet2, new String[][]{{"1"}, {"2"}});
        statement.executeUpdate("alter table t2 add column c2 int");
        resultSet2 = statement.executeQuery("select * from v1");
        JDBC.assertColumnNames(resultSet2, "C1");
        JDBC.assertFullResultSet(resultSet2, new String[][]{{"1"}, {"2"}});
        resultSet2 = preparedStatement2.executeQuery();
        JDBC.assertColumnNames(resultSet2, "C1", "C2");
        JDBC.assertFullResultSet(resultSet2, new String[][]{{"1", null}, {"2", null}});
        statement.executeUpdate("alter table t0 add column c2 int not null default 0");
        statement.executeUpdate("insert into t0 values (1, default)");
        resultSet2 = statement.executeQuery("select * from t0");
        JDBC.assertColumnNames(resultSet2, "C1", "C2");
        JDBC.assertFullResultSet(resultSet2, new String[][]{{"1", "0"}});
        statement.executeUpdate("drop table t0");
        this.rollback();
        resultSet2 = statement.executeQuery(" select  * from t0");
        JDBC.assertColumnNames(resultSet2, "C1");
        JDBC.assertDrainResults(resultSet2, 0);
        statement.executeUpdate("alter table t0_1 add column c2 int not null primary key default 0");
        statement.executeUpdate("insert into t0_1 values (1, 1)");
        AlterTableTest.assertStatementError(DUPLICATE_KEY, statement, "insert into t0_1 values (1, 1)");
        resultSet2 = statement.executeQuery("select * from t0_1");
        JDBC.assertColumnNames(resultSet2, "C1", "C2");
        JDBC.assertFullResultSet(resultSet2, new String[][]{{"1", "1"}});
        this.rollback();
        statement.executeUpdate("alter table t0_1 add column c2 int not null unique  default 0");
        statement.executeUpdate(" insert into t0_1 values (1, default)");
        AlterTableTest.assertStatementError(DUPLICATE_KEY, statement, " insert into t0_1 values (2, default)");
        statement.executeUpdate("insert into t0_1 values (3, 1)");
        statement.executeUpdate("drop table t1");
        statement.executeUpdate("create table t1(c1 int)");
        statement.executeUpdate(" alter table t1 add column c2 int not null unique default 0");
        statement.executeUpdate("insert into t1 values (2, 2)");
        statement.executeUpdate("insert into t1 values (3, 1)");
        resultSet2 = statement.executeQuery("select tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE('TEST_DBO', tablename) from sys.systables where tabletype = 'T'");
        Object[][] objectArray = new String[][]{{"T0", "1"}, {"T0_1", "1"}, {"T0_2", "1"}, {"T0_3", "1"}, {"T1", "1"}, {"T1_1", "1"}, {"T2", "1"}, {"T3", "1"}, {"T4", "1"}};
        JDBC.assertUnorderedResultSet(resultSet2, objectArray, true);
        this.rollback();
        statement.executeUpdate(" create function countopens() returns varchar(128) language java parameter style java external name 'org.apache.derbyTesting.functionTests.util.T_ConsistencyChecker.countOpens'");
        this.commit();
        resultSet2 = statement.executeQuery("values countopens()");
        JDBC.assertFullResultSet(resultSet2, new String[][]{{"No open scans, etc."}});
    }

    public void testAddIdentityColumn() throws SQLException {
        Statement statement = this.createStatement();
        this.createTestObjects(statement);
        this.commit();
        statement.execute("alter table t0 add column id int generated always as identity");
        ResultSet resultSet = statement.executeQuery("select * from t0");
        JDBC.assertColumnNames(resultSet, "C1", "ID");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        AlterTableTest.assertTrue((boolean)resultSetMetaData.isAutoIncrement(2));
        AlterTableTest.assertEquals((int)0, (int)resultSetMetaData.isNullable(2));
        resultSet.close();
        this.assertCompileError(CANNOT_MODIFY_ALWAYS_IDENTITY_COLUMN, "insert into t0(c1, id) values (1, 1)");
        statement.execute("insert into t0(c1, id) values (1, default)");
        statement.execute("insert into t0(c1) values 2,3,4");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t0 order by id"), new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}});
        this.assertCompileError("428C1", "alter table t0 add column id2 bigint generated always as identity");
        statement.execute("create table table_with_identity(id int generated always as identity)");
        this.assertCompileError("428C1", "alter table table_with_identity add column id2 bigint generated always as identity");
        this.rollback();
        statement.execute("insert into t0 values 1,2,3,4,5");
        statement.execute("alter table t0 add column id int generated always as identity (start with 100, increment by 5)");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t0 order by id"), new String[][]{{"1", "100"}, {"2", "105"}, {"3", "110"}, {"4", "115"}, {"5", "120"}});
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t0 order by id"), new String[][]{{"1", "125"}, {"2", "130"}, {"3", "135"}});
        this.rollback();
        statement.execute("alter table t0 add column id int generated by default as identity");
        resultSet = statement.executeQuery("select * from t0");
        JDBC.assertColumnNames(resultSet, "C1", "ID");
        resultSetMetaData = resultSet.getMetaData();
        AlterTableTest.assertTrue((boolean)resultSetMetaData.isAutoIncrement(2));
        AlterTableTest.assertEquals((int)0, (int)resultSetMetaData.isNullable(2));
        resultSet.close();
        statement.execute("insert into t0(c1) values 1,2,3");
        statement.execute("insert into t0(c1, id) values (9, 10)");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t0 order by id"), new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"9", "10"}});
        this.rollback();
        statement.execute("insert into t0 values 1");
        statement.execute("alter table t0 add column id int generated by default as identity");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select id from t0"), "1");
        statement.execute("insert into t0(c1) values 5,6,7");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t0 where c1 > 1 order by c1"), new String[][]{{"5", "2"}, {"6", "3"}, {"7", "4"}});
        this.rollback();
        this.assertCompileError("42XA9", "alter table t0 add column id generated always as identity");
        statement.execute("insert into t0 values 1,2,3,4");
        AlterTableTest.assertStatementError(EXHAUSTED_IDENTITY_COLUMN, statement, "alter table t0 add column id smallint generated always as identity (start with 30000, increment by 1000)");
        this.rollback();
        statement.execute("insert into t0 values 1,2,3");
        statement.execute("alter table t0 add column id smallint generated always as identity (start with 30000, increment by 1000)");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t0 order by id"), new String[][]{{"1", "30000"}, {"2", "31000"}, {"3", "32000"}});
        AlterTableTest.assertStatementError(EXHAUSTED_IDENTITY_COLUMN, statement, "insert into t0(c1) values 4");
        this.rollback();
        statement.execute("alter table t0 add column id int generated always as identity");
        statement.execute("insert into t0(c1) values 1");
        statement.execute("alter table t0 drop column id");
        resultSet = statement.executeQuery("select * from t0");
        JDBC.assertColumnNames(resultSet, "C1");
        JDBC.assertSingleValueResultSet(resultSet, "1");
        this.rollback();
        statement.execute("alter table t0 add column id int generated always as identity");
        statement.execute("alter table t0 drop column id");
        statement.execute("drop table t0");
        this.rollback();
        statement.execute("alter table t0_1 add column id int primary key generated always as identity");
        this.rollback();
    }

    public void testAddIdentityColumn5() throws SQLException {
        Statement statement = this.createStatement();
        this.createTestObjects(statement);
        this.commit();
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        this.rollback();
        statement.execute("alter table t0 add column id int generated by default as identity");
        ResultSet resultSet = statement.executeQuery("select * from t0");
        JDBC.assertColumnNames(resultSet, "C1", "ID");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        AlterTableTest.assertTrue((boolean)resultSetMetaData.isAutoIncrement(2));
        AlterTableTest.assertEquals((int)0, (int)resultSetMetaData.isNullable(2));
        resultSet.close();
        this.rollback();
        statement.execute("insert into t0 values 1");
        statement.execute("alter table t0 add column id int generated by default as identity");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select id from t0"), "1");
        statement.execute("insert into t0(c1) values 5,6,7");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t0 where c1 > 1 order by c1"), new String[][]{{"5", "2"}, {"6", "3"}, {"7", "4"}});
        this.rollback();
    }

    public void testAddIdentityColumn4() throws SQLException {
        Statement statement = this.createStatement();
        this.createTestObjects(statement);
        this.commit();
        statement.execute("alter table t0 add column id int generated always as identity (start with 100, increment by 5)");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        this.rollback();
        statement.execute("alter table t0 add column id int generated by default as identity");
        ResultSet resultSet = statement.executeQuery("select * from t0");
        JDBC.assertColumnNames(resultSet, "C1", "ID");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        AlterTableTest.assertTrue((boolean)resultSetMetaData.isAutoIncrement(2));
        AlterTableTest.assertEquals((int)0, (int)resultSetMetaData.isNullable(2));
        resultSet.close();
        statement.execute("insert into t0(c1) values 1,2,3");
        statement.execute("insert into t0(c1, id) values (9, 10)");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t0 order by id"), new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"9", "10"}});
        this.rollback();
        statement.execute("insert into t0 values 1");
        statement.execute("alter table t0 add column id int generated by default as identity");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select id from t0"), "1");
        statement.execute("insert into t0(c1) values 5,6,7");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t0 where c1 > 1 order by c1"), new String[][]{{"5", "2"}, {"6", "3"}, {"7", "4"}});
        this.rollback();
    }

    public void testAddIdentityColumn3() throws SQLException {
        Statement statement = this.createStatement();
        this.createTestObjects(statement);
        this.commit();
        statement.execute("insert into t0 values 1,2,3,4,5");
        statement.execute("alter table t0 add column id int generated always as identity (start with 100, increment by 5)");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t0 order by id"), new String[][]{{"1", "100"}, {"2", "105"}, {"3", "110"}, {"4", "115"}, {"5", "120"}});
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t0 order by id"), new String[][]{{"1", "125"}, {"2", "130"}, {"3", "135"}});
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        this.rollback();
        statement.execute("alter table t0 add column id int generated by default as identity");
        ResultSet resultSet = statement.executeQuery("select * from t0");
        JDBC.assertColumnNames(resultSet, "C1", "ID");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        AlterTableTest.assertTrue((boolean)resultSetMetaData.isAutoIncrement(2));
        AlterTableTest.assertEquals((int)0, (int)resultSetMetaData.isNullable(2));
        resultSet.close();
        statement.execute("insert into t0(c1) values 1,2,3");
        statement.execute("insert into t0(c1, id) values (9, 10)");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t0 order by id"), new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"9", "10"}});
        this.rollback();
        statement.execute("insert into t0 values 1");
        statement.execute("alter table t0 add column id int generated by default as identity");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select id from t0"), "1");
        statement.execute("insert into t0(c1) values 5,6,7");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t0 where c1 > 1 order by c1"), new String[][]{{"5", "2"}, {"6", "3"}, {"7", "4"}});
        this.rollback();
        this.assertCompileError("42XA9", "alter table t0 add column id generated always as identity");
        statement.execute("insert into t0 values 1,2,3,4");
        AlterTableTest.assertStatementError(EXHAUSTED_IDENTITY_COLUMN, statement, "alter table t0 add column id smallint generated always as identity (start with 30000, increment by 1000)");
        this.rollback();
        statement.execute("insert into t0 values 1,2,3");
        statement.execute("alter table t0 add column id smallint generated always as identity (start with 30000, increment by 1000)");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t0 order by id"), new String[][]{{"1", "30000"}, {"2", "31000"}, {"3", "32000"}});
        AlterTableTest.assertStatementError(EXHAUSTED_IDENTITY_COLUMN, statement, "insert into t0(c1) values 4");
        this.rollback();
        statement.execute("alter table t0 add column id int generated always as identity");
        statement.execute("insert into t0(c1) values 1");
        statement.execute("alter table t0 drop column id");
        resultSet = statement.executeQuery("select * from t0");
        JDBC.assertColumnNames(resultSet, "C1");
        JDBC.assertSingleValueResultSet(resultSet, "1");
        this.rollback();
        statement.execute("alter table t0 add column id int generated always as identity");
        statement.execute("alter table t0 drop column id");
        statement.execute("drop table t0");
        this.rollback();
        statement.execute("alter table t0_1 add column id int primary key generated always as identity");
        this.rollback();
    }

    public void testAddIdentityColumn2() throws SQLException {
        Statement statement = this.createStatement();
        this.createTestObjects(statement);
        this.commit();
        statement.execute("alter table t0 add column id int generated always as identity");
        ResultSet resultSet = statement.executeQuery("select * from t0");
        JDBC.assertColumnNames(resultSet, "C1", "ID");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        AlterTableTest.assertTrue((boolean)resultSetMetaData.isAutoIncrement(2));
        AlterTableTest.assertEquals((int)0, (int)resultSetMetaData.isNullable(2));
        resultSet.close();
        this.assertCompileError(CANNOT_MODIFY_ALWAYS_IDENTITY_COLUMN, "insert into t0(c1, id) values (1, 1)");
        statement.execute("insert into t0(c1, id) values (1, default)");
        statement.execute("insert into t0(c1) values 2,3,4");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t0 order by id"), new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}});
        this.assertCompileError("428C1", "alter table t0 add column id2 bigint generated always as identity");
        statement.execute("create table table_with_identity(id int generated always as identity)");
        this.assertCompileError("428C1", "alter table table_with_identity add column id2 bigint generated always as identity");
        this.rollback();
        statement.execute("insert into t0 values 1,2,3,4,5");
        statement.execute("alter table t0 add column id int generated always as identity (start with 100, increment by 5)");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t0 order by id"), new String[][]{{"1", "100"}, {"2", "105"}, {"3", "110"}, {"4", "115"}, {"5", "120"}});
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t0 order by id"), new String[][]{{"1", "125"}, {"2", "130"}, {"3", "135"}});
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        statement.execute("delete from t0");
        statement.execute("insert into t0(c1) values 1,2,3,4,5,6,7,8,9");
        this.rollback();
        statement.execute("alter table t0 add column id int generated by default as identity");
        resultSet = statement.executeQuery("select * from t0");
        JDBC.assertColumnNames(resultSet, "C1", "ID");
        resultSetMetaData = resultSet.getMetaData();
        AlterTableTest.assertTrue((boolean)resultSetMetaData.isAutoIncrement(2));
        AlterTableTest.assertEquals((int)0, (int)resultSetMetaData.isNullable(2));
        resultSet.close();
        statement.execute("insert into t0(c1) values 1,2,3");
        statement.execute("insert into t0(c1, id) values (9, 10)");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t0 order by id"), new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"9", "10"}});
        this.rollback();
        statement.execute("insert into t0 values 1");
        statement.execute("alter table t0 add column id int generated by default as identity");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select id from t0"), "1");
        statement.execute("insert into t0(c1) values 5,6,7");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t0 where c1 > 1 order by c1"), new String[][]{{"5", "2"}, {"6", "3"}, {"7", "4"}});
        this.rollback();
        this.assertCompileError("42XA9", "alter table t0 add column id generated always as identity");
        statement.execute("insert into t0 values 1,2,3,4");
        AlterTableTest.assertStatementError(EXHAUSTED_IDENTITY_COLUMN, statement, "alter table t0 add column id smallint generated always as identity (start with 30000, increment by 1000)");
        this.rollback();
        statement.execute("insert into t0 values 1,2,3");
        statement.execute("alter table t0 add column id smallint generated always as identity (start with 30000, increment by 1000)");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t0 order by id"), new String[][]{{"1", "30000"}, {"2", "31000"}, {"3", "32000"}});
        AlterTableTest.assertStatementError(EXHAUSTED_IDENTITY_COLUMN, statement, "insert into t0(c1) values 4");
        this.rollback();
        statement.execute("alter table t0 add column id int generated always as identity");
        statement.execute("insert into t0(c1) values 1");
        statement.execute("alter table t0 drop column id");
        resultSet = statement.executeQuery("select * from t0");
        JDBC.assertColumnNames(resultSet, "C1");
        JDBC.assertSingleValueResultSet(resultSet, "1");
        this.rollback();
        statement.execute("alter table t0 add column id int generated always as identity");
        statement.execute("alter table t0 drop column id");
        statement.execute("drop table t0");
        this.rollback();
        statement.execute("alter table t0_1 add column id int primary key generated always as identity");
        this.rollback();
    }

    public void testDropObjects() throws Exception {
        Statement statement = this.createStatement();
        this.createTestObjects(statement);
        statement.executeUpdate("create table tab1 (c1 int, c2 int not null constraint tab1pk primary key, c3 double, c4 int)");
        statement.executeUpdate("create index i11 on tab1 (c1)");
        statement.executeUpdate("create unique index i12 on tab1 (c1)");
        statement.executeUpdate("create index i13 on tab1 (c3, c1, c4)");
        statement.executeUpdate("create unique index i14 on tab1 (c3, c1)");
        statement.executeUpdate("insert into tab1 values (6, 5, 4.5, 90)");
        statement.executeUpdate("insert into tab1 values (10, 3, 8.9, -5)");
        statement.executeUpdate("insert into tab1 values (100, 15, 4.5, 9)");
        statement.executeUpdate("insert into tab1 values (2, 8, 4.4, 8)");
        statement.executeUpdate("insert into tab1 values (11, 9, 2.5, 88)");
        statement.executeUpdate("insert into tab1 values(null,10, 3.5, 99)");
        statement.executeUpdate("create view vw1 (col_sum, col_diff) as select c1+c4, c1-c4 from tab1");
        statement.executeUpdate("create view vw2 (c1) as select c3 from tab1");
        statement.executeUpdate("create table tab2 (c1 int not null unique, c2 double, c3 int, c4 int not null constraint c4_PK primary key, c5 int, constraint t2ck check (c2+c3<100.0))");
        statement.executeUpdate("create table tab3 (c1 int, c2 int, c3 int, c4 int,constraint t3fk foreign key (c2) references tab2(c1), constraint t3ck check (c2-c3<80))");
        statement.executeUpdate("create view vw3 (c1, c2) as select c5, tab3.c4 from tab2, tab3 where tab3.c1 > 0");
        statement.executeUpdate(" create view vw4 (c1) as select c4 from tab3 where c2 > 8");
        statement.executeUpdate("create table tab4 (c1 int, c2 int, c3 int, c4 int)");
        statement.executeUpdate("create table tab5 (c1 int)");
        statement.executeUpdate("insert into tab4 values (1,2,3,4)");
        statement.executeUpdate("create trigger tr1 after update of c2, c3, c4 on tab4 for each row insert into tab5 values (1)");
        statement.executeUpdate("create trigger tr2 after update of c3, c4 on tab4 for each row insert into tab5 values (2)");
        statement.executeUpdate("drop trigger tr1");
        ResultSet resultSet = statement.executeQuery("select * from tab5");
        JDBC.assertColumnNames(resultSet, "C1");
        JDBC.assertDrainResults(resultSet, 0);
        AlterTableTest.assertUpdateCount(statement, 1, "update tab4 set c3 = 33");
        AlterTableTest.assertUpdateCount(statement, 1, " update tab4 set c4 = 44");
        resultSet = statement.executeQuery("select * from tab5");
        JDBC.assertColumnNames(resultSet, "C1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"2"}, {"2"}});
        statement.executeUpdate("drop trigger tr2");
        AlterTableTest.assertUpdateCount(statement, 1, "update tab4 set c4 = 444");
        resultSet = statement.executeQuery("select * from tab2");
        String[] stringArray = new String[]{"C1", "C2", "C3", "C4", "C5"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        statement.executeUpdate("drop view vw2");
        statement.executeUpdate("create view vw2 (c1) as select c3 from tab1");
        statement.executeUpdate("drop view vw1");
        AlterTableTest.assertStatementError("42X05", statement, "select * from vw1");
        statement.executeUpdate("create index i13 on tab1 (c3, c1, c4)");
        this.checkWarning(statement, "01504");
        statement.executeUpdate("create unique index i14 on tab1 (c3, c1)");
        this.checkWarning(statement, "01504");
        statement.executeUpdate("create unique index i12 on tab1 (c1)");
        this.checkWarning(statement, "01504");
        resultSet = statement.executeQuery("select c2, c3, c4 from tab1 order by c3");
        stringArray = new String[]{"C2", "C3", "C4"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"9", "2.5", "88"}, {"10", "3.5", "99"}, {"8", "4.4", "8"}, {"15", "4.5", "9"}, {"5", "4.5", "90"}, {"3", "8.9", "-5"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop index i12");
        statement.executeUpdate("drop index i13");
        statement.executeUpdate("drop index i14");
        statement.executeUpdate("insert into tab1 (c2, c3, c4) values (22, 8.9, 5)");
        statement.executeUpdate("insert into tab1 (c2, c3, c4) values (11, 4.5, 67)");
        resultSet = statement.executeQuery("select c2 from tab1");
        stringArray = new String[]{"C2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"3"}, {"5"}, {"8"}, {"9"}, {"10"}, {"11"}, {"15"}, {"22"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("alter table tab1 add column c5 double");
        statement.executeUpdate("drop view vw2");
        statement.executeUpdate(" create view vw2 (c1) as select c5 from tab1 where c2 > 5");
        statement.executeUpdate("drop view vw2");
        statement.executeUpdate("alter table tab1 drop constraint tab1pk");
        resultSet = statement.executeQuery("select c4 from tab1 order by 1");
        objectArray = new String[][]{{"-5"}, {"5"}, {"8"}, {"9"}, {"67"}, {"88"}, {"90"}, {"99"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("create index i13 on tab1 (c3, c1, c4)");
        statement.executeUpdate("alter table tab2 drop constraint t2ck");
        statement.executeUpdate("alter table tab3 drop constraint t3fk");
        statement.executeUpdate("alter table tab2 drop constraint c4_PK");
        statement.executeUpdate("insert into tab3 values (1,2,3,4)");
        statement.executeUpdate("drop view vw3");
        statement.executeUpdate("insert into tab3 (c1, c2, c3) values (81, 1, 2)");
        statement.executeUpdate("insert into tab3 (c1, c2, c3) values (81, 2, 2)");
        statement.executeUpdate("alter table tab3 drop constraint t3ck");
        statement.executeUpdate("drop view vw4");
        statement.executeUpdate("insert into tab3 (c2, c3) values (-82, 9)");
        statement.executeUpdate(" create view vw4 (c1) as select c3 from tab3 where c3+5>c4");
        statement.executeUpdate("drop view vw4");
        this.rollback();
        statement.executeUpdate("create table tt1(a int, b int not null constraint tt1uc unique)");
        statement.executeUpdate(" create table reftt1(a int constraint reftt1rc references tt1(b))");
        resultSet = statement.executeQuery("select count(*) from sys.sysconglomerates c, sys.systables t where t.tableid = c.tableid and t.tablename = 'REFTT1'");
        JDBC.assertSingleValueResultSet(resultSet, "2");
        statement.executeUpdate("alter table reftt1 drop constraint reftt1rc");
        statement.executeUpdate("alter table tt1 drop constraint tt1uc");
        resultSet = statement.executeQuery("select count(*) from sys.sysconglomerates c, sys.systables t where t.tableid = c.tableid and t.tablename = 'REFTT1'");
        JDBC.assertSingleValueResultSet(resultSet, "1");
        this.rollback();
    }

    public void testAddConstraint() throws Exception {
        Statement statement = this.createStatement();
        this.createTestObjects(statement);
        statement.executeUpdate("alter table t0 add column c3 int");
        AlterTableTest.assertStatementError("42831", statement, " alter table t0 add constraint cons1 primary key(c3)");
        AlterTableTest.assertStatementError("42831", statement, " alter table t0 add primary key(c3)");
        AlterTableTest.assertStatementError("42X14", statement, "alter table t4 add constraint t4pk primary key(\"c1\")");
        AlterTableTest.assertStatementError("42X14", statement, " alter table t4 add constraint t4uq unique(\"c1\")");
        AlterTableTest.assertStatementError("42X14", statement, " alter table t4 add constraint t4fk foreign key (\"c1\") references t0");
        AlterTableTest.assertStatementError("42X04", statement, " alter table t4 add constraint t4ck check (\"c1\" <> 4)");
        AlterTableTest.assertStatementError(DUPLICATE_KEY, statement, "alter table t4 add primary key(c1)");
        statement.executeUpdate("alter table t0_1 add column c2 int not null constraint p2 primary key default 0");
        statement.executeUpdate("insert into t0_1 values (1, 1)");
        AlterTableTest.assertStatementError(DUPLICATE_KEY, statement, "insert into t0_1 values (1, 1)");
        ResultSet resultSet = statement.executeQuery("select * from t0_1");
        JDBC.assertColumnNames(resultSet, "C1", "C2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "1"}});
        statement.executeUpdate("alter table t0_1 add column c3 int check(c3 != 3)");
        statement.executeUpdate("insert into t0_1 values (1, 2, 1)");
        AlterTableTest.assertStatementError("23513", statement, "insert into t0_1 values (1, 3, 3)");
        statement.executeUpdate("insert into t0_1 values (1, 4, 1)");
        resultSet = statement.executeQuery("select c1,c3 from t0_1");
        JDBC.assertUnorderedResultSet(resultSet, new String[][]{{"1", null}, {"1", "1"}, {"1", "1"}});
        statement.executeUpdate("alter table t0_1 add column c4 int");
        statement.executeUpdate("delete from t0_1");
        statement.executeUpdate("insert into t0_1 values (1, 5,1,1)");
        statement.executeUpdate("insert into t0_1 values (2, 6,1,2)");
        statement.executeUpdate(" alter table t0_1 add constraint ck1 check(c4 = c1)");
        resultSet = statement.executeQuery("select c1,c4 from t0_1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "1"}, {"2", "2"}});
        AlterTableTest.assertStatementError("23513", statement, "insert into t0_1(c1,c4) values (1, 3)");
        statement.executeUpdate("drop table t0_1");
        statement.executeUpdate("create table t0_1 (c1 int)");
        statement.executeUpdate("alter table t0_1 add column c2 int");
        statement.executeUpdate("insert into t0_1 values (1, 1)");
        statement.executeUpdate("insert into t0_1 values (2, 2)");
        statement.executeUpdate("insert into t0_1 values (2, 2)");
        statement.executeUpdate("insert into t0_1 values (666, 2)");
        statement.executeUpdate("insert into t0_1 values (2, 2)");
        statement.executeUpdate("insert into t0_1 values (3, 3)");
        statement.executeUpdate("insert into t0_1 values (666, 3)");
        statement.executeUpdate("insert into t0_1 values (666, 3)");
        statement.executeUpdate("insert into t0_1 values (3, 3)");
        AlterTableTest.assertStatementError("X0Y59", statement, " alter table t0_1 add constraint ck1 check(c2 = c1)");
        statement.executeUpdate("insert into t0_1 values (1, 3)");
        resultSet = statement.executeQuery(" select * from t0_1");
        String[] stringArray = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1", "1"}, {"2", "2"}, {"2", "2"}, {"666", "2"}, {"2", "2"}, {"3", "3"}, {"666", "3"}, {"666", "3"}, {"3", "3"}, {"1", "3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("create table t0_4(c1 int)");
        statement.executeUpdate("alter table t0_4 add column c2 int not null constraint p2 primary key default 0");
        statement.executeUpdate("alter table t0_4 add check(c2 = c1)");
        statement.executeUpdate("insert into t0_4 values (1, 1)");
        AlterTableTest.assertStatementError("23513", statement, "insert into t0_4 values (1, 2)");
        AlterTableTest.assertStatementError(DUPLICATE_KEY, statement, "insert into t0_4 values (1, 1)");
        AlterTableTest.assertStatementError("23513", statement, "insert into t0_4 values (2, 1)");
        statement.executeUpdate("insert into t0_4 values (2, 2)");
        resultSet = statement.executeQuery("select * from t0_4");
        JDBC.assertColumnNames(resultSet, "C1", "C2");
        JDBC.assertUnorderedResultSet(resultSet, new String[][]{{"1", "1"}, {"2", "2"}});
        statement.executeUpdate("drop table t0_4");
        statement.executeUpdate("alter table t3 add column c3 int");
        statement.executeUpdate("alter table t3 add unique(c3)");
        statement.executeUpdate("alter table t0_2 add column c2 int not null unique default 0");
        statement.executeUpdate("insert into t0_2 values (1, default)");
        statement.executeUpdate("insert into t0_2 values (1, 1)");
        AlterTableTest.assertUpdateCount(statement, 1, " delete from t1_1");
        statement.executeUpdate("alter table t1_1 add column c2 int not null unique default 0");
        statement.executeUpdate("insert into t1_1 values (1, 2)");
        AlterTableTest.assertStatementError(DUPLICATE_KEY, statement, " insert into t1_1 values (1, 2)");
        statement.executeUpdate("insert into t1_1 values (1, 1)");
        statement.executeUpdate("alter table t3 add unique(c1)");
        this.assertCompileError("42Y55", "alter table xxx add check(c2 = 1)");
        statement.executeUpdate("create table xxx(c1 int, c2 int)");
        PreparedStatement preparedStatement = this.prepareStatement("alter table xxx add check(c2 = 1)");
        AlterTableTest.assertUpdateCount(preparedStatement, 0);
        statement.executeUpdate("drop table xxx");
        statement.executeUpdate("create table xxx(c1 int)");
        AlterTableTest.assertStatementError("42X04", preparedStatement);
        statement.executeUpdate("alter table xxx add column c2 int");
        AlterTableTest.assertUpdateCount(preparedStatement, 0);
        statement.executeUpdate("drop table xxx");
        resultSet = statement.executeQuery("select tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE('TEST_DBO', tablename) from sys.systables where tabletype = 'T'");
        stringArray = new String[]{"TABLENAME", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"T0", "1"}, {"T0_1", "1"}, {"T0_2", "1"}, {"T0_3", "1"}, {"T1", "1"}, {"T1_1", "1"}, {"T2", "1"}, {"T3", "1"}, {"T4", "1"}};
        JDBC.assertUnorderedResultSet(resultSet, objectArray, true);
    }

    public void testDropConstraint() throws Exception {
        Statement statement = this.createStatement();
        this.createTestObjects(statement);
        AlterTableTest.assertStatementError("42X86", statement, "alter table t0 drop constraint notexists");
        AlterTableTest.assertStatementError("42X86", statement, "alter table t1 drop constraint p1");
        AlterTableTest.assertStatementError("42831", statement, "alter table t0_1 add constraint p2 primary key(c1)");
        AlterTableTest.assertStatementError("42X86", statement, " alter table t0_1 drop constraint p2");
        statement.executeUpdate("alter table t0_1 add column c2 int not null constraint p2 primary key default 0");
        AlterTableTest.assertUpdateCount(statement, 0, "delete from t0_1");
        statement.executeUpdate("alter table t0_1 drop constraint p2");
        statement.executeUpdate("alter table t0_1 add constraint p2 primary key(c2)");
        statement.executeUpdate("alter table t0_1 drop constraint p2");
        statement.executeUpdate("alter table t0_1 add constraint p2 primary key(c2)");
        statement.executeUpdate("insert into t0_1 values (1,1)");
        AlterTableTest.assertStatementError(DUPLICATE_KEY, statement, "insert into t0_1 values (1,1)");
        ResultSet resultSet = statement.executeQuery("select tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE('TEST_DBO', tablename) from sys.systables where tabletype = 'T' and tablename = 'T0_1'");
        String[] stringArray = new String[]{"TABLENAME", "2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"T0_1", "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        PreparedStatement preparedStatement = this.prepareStatement("alter table t0_1 drop constraint p2");
        AlterTableTest.assertUpdateCount(preparedStatement, 0);
        statement.executeUpdate("drop table t0_1");
        statement.executeUpdate(" create table t0_1 (c1 int, c2 int not null constraint p2 primary key)");
        AlterTableTest.assertUpdateCount(preparedStatement, 0);
        resultSet = statement.executeQuery("select tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE('SYS', tablename) from sys.systables where tabletype = 'S' and tablename != 'SYSDUMMY1' order by tablename");
        objectArray = new String[][]{{"SYSALIASES", "1"}, {"SYSCHECKS", "1"}, {"SYSCOLPERMS", "1"}, {"SYSCOLUMNS", "1"}, {"SYSCONGLOMERATES", "1"}, {"SYSCONSTRAINTS", "1"}, {"SYSDEPENDS", "1"}, {"SYSFILES", "1"}, {"SYSFOREIGNKEYS", "1"}, {"SYSKEYS", "1"}, {"SYSPERMS", "1"}, {"SYSROLES", "1"}, {"SYSROUTINEPERMS", "1"}, {"SYSSCHEMAS", "1"}, {"SYSSEQUENCES", "1"}, {"SYSSTATEMENTS", "1"}, {"SYSSTATISTICS", "1"}, {"SYSTABLEPERMS", "1"}, {"SYSTABLES", "1"}, {"SYSTRIGGERS", "1"}, {"SYSUSERS", "1"}, {"SYSVIEWS", "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE('TEST_DBO', tablename) from sys.systables where tabletype = 'T'");
        objectArray = new String[][]{{"T0", "1"}, {"T0_2", "1"}, {"T0_3", "1"}, {"T1", "1"}, {"T1_1", "1"}, {"T2", "1"}, {"T3", "1"}, {"T4", "1"}, {"T0_1", "1"}};
        JDBC.assertUnorderedResultSet(resultSet, objectArray, true);
        statement.executeUpdate("create table b793 (pn1 int not null constraint named_primary primary key, pn2 int constraint named_pn2 check (pn2 > 3))");
        statement.executeUpdate("alter table b793 drop constraint named_primary");
        statement.executeUpdate("drop table b793");
        statement.executeUpdate("drop table t1");
        statement.executeUpdate(" create table t1(a int not null constraint t1_pri primary key)");
        statement.executeUpdate(" create table reft1(a int constraint t1_ref references t1(a))");
        resultSet = statement.executeQuery("select count(*) from sys.sysconglomerates c, sys.systables t where c.tableid = t.tableid and t.tablename = 'REFT1'");
        JDBC.assertSingleValueResultSet(resultSet, "2");
        statement.executeUpdate("alter table reft1 drop constraint t1_ref");
        statement.executeUpdate("alter table t1 drop constraint t1_pri");
        resultSet = statement.executeQuery("select count(*) from sys.sysconglomerates c, sys.systables t where c.tableid = t.tableid and t.tablename = 'REFT1'");
        JDBC.assertSingleValueResultSet(resultSet, "1");
        statement.executeUpdate("drop table reft1");
        statement.executeUpdate("drop view v2");
        statement.executeUpdate("drop view v1");
        statement.executeUpdate("drop table t0");
        statement.executeUpdate("drop table t0_1");
        statement.executeUpdate("drop table t0_2");
        statement.executeUpdate("drop table t0_3");
        statement.executeUpdate("drop table t1");
        statement.executeUpdate("drop table t1_1");
        statement.executeUpdate("drop table t3");
        statement.executeUpdate("drop table t4");
    }

    public void testWithSchema() throws Exception {
        Statement statement = this.createStatement();
        this.createTestObjects(statement);
        statement.executeUpdate("create schema newschema");
        AlterTableTest.assertStatementError("42Y55", statement, "drop table x");
        statement.executeUpdate("create table x (x int not null, y int not null)");
        statement.executeUpdate("alter table x add constraint NEWCONS primary key (x)");
        ResultSet resultSet = statement.executeQuery("select schemaname, constraintname from sys.sysconstraints c, sys.sysschemas s where s.schemaid = c.schemaid order by 1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"TEST_DBO", "P1"}, {"TEST_DBO", "NEWCONS"}});
        AlterTableTest.assertStatementError(DUPLICATE_KEY, statement, " insert into x values (1,1),(1,1)");
        statement.executeUpdate(" alter table x drop constraint TEST_DBO.newcons");
        statement.executeUpdate(" alter table x add constraint newcons primary key (x)");
        resultSet = statement.executeQuery("select schemaname, constraintname from sys.sysconstraints c, sys.sysschemas s where s.schemaid = c.schemaid order by 1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"TEST_DBO", "P1"}, {"TEST_DBO", "NEWCONS"}});
        AlterTableTest.assertStatementError("42Y07", statement, "alter table x drop constraint badschema.newcons");
        AlterTableTest.assertStatementError("42X86", statement, "alter table x drop constraint newschema.newcons");
        statement.executeUpdate("alter table x drop constraint TEST_DBO.newcons");
        AlterTableTest.assertStatementError("42X85", statement, "alter table x add constraint badschema.newcons primary key (x)");
        statement.executeUpdate("drop table x");
        statement.executeUpdate("create table x (x int not null, y int not null)");
        statement.executeUpdate("alter table x add constraint con check (x > 1)");
        AlterTableTest.assertStatementError("42X85", statement, " alter table x add constraint newschema.con check (x > 1)");
        resultSet = statement.executeQuery(" select schemaname, constraintname from sys.sysconstraints c, sys.sysschemas s where s.schemaid = c.schemaid order by 1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"TEST_DBO", "P1"}, {"TEST_DBO", "CON"}});
        statement.executeUpdate("set schema emptyschema");
        AlterTableTest.assertStatementError("42X86", statement, "alter table TEST_DBO.x drop constraint emptyschema.con");
        resultSet = statement.executeQuery(" select schemaname, constraintname from sys.sysconstraints c, sys.sysschemas s where s.schemaid = c.schemaid order by 1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"TEST_DBO", "P1"}, {"TEST_DBO", "CON"}});
        statement.executeUpdate(" set schema newschema");
        statement.executeUpdate("alter table TEST_DBO.x add constraint con2 check (x > 1)");
        resultSet = statement.executeQuery("select schemaname, constraintname from sys.sysconstraints c, sys.sysschemas s where s.schemaid = c.schemaid order by 1,2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"TEST_DBO", "CON"}, {"TEST_DBO", "CON2"}, {"TEST_DBO", "P1"}});
        statement.executeUpdate("drop table TEST_DBO.x");
        statement.executeUpdate("drop schema newschema restrict");
    }

    public void testTemporaryTable() throws Exception {
        Statement statement = this.createStatement();
        this.createTestObjects(statement);
        AlterTableTest.assertUpdateCount(statement, 0, "declare global temporary table session.t1 (c11 int) not logged");
        AlterTableTest.assertUpdateCount(statement, 0, " declare global temporary table session.t2 (c21 int) on commit delete rows not logged");
        AlterTableTest.assertUpdateCount(statement, 0, " declare global temporary table session.t3 (c31 int) on commit preserve rows not logged");
        statement.executeUpdate("drop table session.t1");
        statement.executeUpdate("drop table session.t2");
        statement.executeUpdate("drop table session.t3");
        AlterTableTest.assertStatementError("42Y55", statement, "drop table session.t1");
        statement.executeUpdate("drop table t1");
        statement.executeUpdate("create table t1(c1 int, c2 int not null primary key)");
        statement.executeUpdate("insert into t1 values (1, 1)");
        AlterTableTest.assertStatementError(DUPLICATE_KEY, statement, "insert into t1 values (1, 1)");
        statement.executeUpdate("alter table t1 drop primary key");
        statement.executeUpdate("insert into t1 values (1, 1)");
        ResultSet resultSet = statement.executeQuery("select * from t1");
        String[] stringArray = new String[]{"C1", "C2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1", "1"}, {"1", "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        AlterTableTest.assertStatementError("42X86", statement, " alter table t1 drop primary key");
        AlterTableTest.assertStatementError("42X86", statement, " alter table t1 drop constraint emptyschema.C1");
        AlterTableTest.assertStatementError("42Y07", statement, " alter table t1 drop constraint nosuchschema.C2");
        AlterTableTest.assertStatementError("42X85", statement, " alter table t1 add constraint emptyschema.C1_PLUS_C2 check ((c1 + c2) < 100)");
        statement.executeUpdate(" alter table t1 add constraint C1_PLUS_C2 check ((c1 + c2) < 100)");
        PreparedStatement preparedStatement = this.prepareStatement("alter table t1 drop constraint C1_PLUS_C2");
        statement.executeUpdate(" alter table TEST_DBO.t1 drop constraint TEST_DBO.C1_PLUS_C2");
        AlterTableTest.assertStatementError("42X86", preparedStatement);
        statement.executeUpdate(" drop table t1");
        statement.executeUpdate("create table LOGGED(c11 int)");
        statement.executeUpdate("drop table LOGGED");
        statement.executeUpdate("create table logged(logged int)");
        statement.executeUpdate("drop table logged");
        AlterTableTest.assertUpdateCount(statement, 0, " declare global temporary table session.logged(logged int) on commit delete rows not logged");
    }

    public void testRenameAutoincrementColumn() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("set schema app");
        statement.executeUpdate("create table d4693(a int generated always as identity, b int)");
        this.vetSequenceState("D4693", "INTEGER NOT NULL", 1L, 1L, 1L);
        statement.executeUpdate("insert into d4693 (b) values (1)");
        statement.executeUpdate("rename column d4693.a to a2");
        this.vetSequenceState("D4693", "INTEGER NOT NULL", 2L, 1L, 1L);
        statement.executeUpdate("insert into d4693 (b) values (2)");
        JDBC.assertFullResultSet(statement.executeQuery("select a2, b from d4693 order by a2"), new String[][]{{"1", "1"}, {"2", "2"}});
        statement.executeUpdate("drop table d4693");
        String[] stringArray = new String[]{"autoinc int generated always as identity (start with 100)", "autoinc1 int generated always as identity (increment by 100)", "autoinc2 int generated always as identity (start with 101, increment by 100)", "a11 int generated always as identity (start with  0, increment by -1)", "a21 int generated always as identity (start with  +0, increment by -1)", "a31 int generated always as identity (start with  -1, increment by -1)", "a41 int generated always as identity (start with  -11, increment by +100)"};
        String[] stringArray2 = new String[]{"AUTOINC", "AUTOINC1", "AUTOINC2", "A11", "A21", "A31", "A41"};
        String[] stringArray3 = new String[]{"100", "1", "101", "0", "0", "-1", "-11"};
        String[] stringArray4 = new String[]{"100", "1", "101", "0", "0", "-1", "-11"};
        String[] stringArray5 = new String[]{"1", "100", "100", "-1", "-1", "-1", "100"};
        for (int i = 0; i < stringArray.length; ++i) {
            statement.executeUpdate("create table d4693 (" + stringArray[i] + ")");
            this.checkValStartInc(statement, stringArray2[i], stringArray3[i], stringArray4[i], stringArray5[i]);
            statement.executeUpdate("rename column d4693." + stringArray2[i] + " to " + stringArray2[i] + "2");
            this.checkValStartInc(statement, stringArray2[i] + "2", stringArray3[i], stringArray4[i], stringArray5[i]);
            statement.executeUpdate("drop table d4693");
        }
    }

    private void vetSequenceState(String string, String string2, long l, long l2, long l3) throws Exception {
        Connection connection = this.getConnection();
        String string3 = IdentitySequenceTest.getIdentitySequenceName(connection, string);
        ResultSet resultSet = connection.prepareStatement("select s.sequenceDatatype, s.startValue, s.increment\nfrom sys.syssequences s\nwhere sequenceName = '" + string3 + "'").executeQuery();
        String[][] stringArray = new String[][]{{string2, Long.toString(l2), Long.toString(l3)}};
        JDBC.assertFullResultSet(resultSet, stringArray);
        resultSet = connection.prepareStatement("values syscs_util.syscs_peek_at_identity( 'APP', '" + string.toUpperCase() + "' )").executeQuery();
        stringArray = new String[][]{{Long.toString(l)}};
        JDBC.assertFullResultSet(resultSet, stringArray);
    }

    private void checkValStartInc(Statement statement, String string, String string2, String string3, String string4) throws Exception {
        JDBC.assertFullResultSet(statement.executeQuery("select autoincrementvalue,autoincrementstart,autoincrementinc from sys.syscolumns where columnname = '" + string + "' and       referenceid in (select tableid              from sys.systables where tablename = 'D4693')"), new String[][]{{string2, string3, string4}});
    }

    private void testAlterColumnNullability(Statement statement, boolean bl) throws SQLException {
        int n;
        String string = bl ? "SET NOT NULL" : "NOT NULL";
        String string2 = bl ? "DROP NOT NULL" : "NULL";
        statement.executeUpdate("create table atmcn_1 (a integer, b integer not null)");
        AlterTableTest.assertStatementError("23502", statement, "insert into atmcn_1 (a) values (1)");
        statement.executeUpdate("insert into atmcn_1 values (1,1)");
        ResultSet resultSet = statement.executeQuery("select * from atmcn_1");
        String[] stringArray = new String[]{"A", "B"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1", "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("alter table atmcn_1 alter column a " + string);
        AlterTableTest.assertStatementError("23502", statement, "insert into atmcn_1 (b) values (2)");
        statement.executeUpdate("insert into atmcn_1 values (2,2)");
        resultSet = statement.executeQuery("select * from atmcn_1");
        stringArray = new String[]{"A", "B"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1"}, {"2", "2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("alter table atmcn_1 alter column b " + string2);
        statement.executeUpdate("insert into atmcn_1 (a) values (1)");
        resultSet = statement.executeQuery("select * from atmcn_1");
        stringArray = new String[]{"A", "B"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1"}, {"2", "2"}, {"1", null}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        AlterTableTest.assertStatementError("X0Y80", statement, "alter table atmcn_1 alter column b " + string);
        statement.executeUpdate("create table atmcn_2 (a integer not null primary key, b integer not null)");
        AlterTableTest.assertStatementError("42Z20", statement, " alter table atmcn_2 alter column a " + string2);
        statement.executeUpdate(" create table atmcn_3 (a integer not null, b integer not null)");
        statement.executeUpdate(" alter table atmcn_3 add constraint atmcn_3_pk primary key(a, b)");
        AlterTableTest.assertStatementError("42Z20", statement, " alter table atmcn_3 alter column b " + string2);
        statement.executeUpdate("create table atmcn_4 (a integer not null, b integer)");
        statement.executeUpdate("alter table atmcn_4 alter a " + string2);
        statement.executeUpdate("create table atmcn_5 (a integer not null, b integer not null unique)");
        statement.executeUpdate("alter table atmcn_5 alter column b " + string2);
        statement.execute("create table atmcn_6 (a integer not null, b integer)");
        for (n = 0; n < 2; ++n) {
            statement.execute("alter table atmcn_6 alter column a " + string);
            statement.execute("alter table atmcn_6 alter column b " + string2);
            resultSet = statement.executeQuery("select * from atmcn_6");
            JDBC.assertNullability(resultSet, new boolean[]{false, true});
            JDBC.assertEmpty(resultSet);
        }
        for (n = 0; n < 2; ++n) {
            statement.execute("alter table atmcn_6 alter column a " + string2);
            statement.execute("alter table atmcn_6 alter column b " + string);
            resultSet = statement.executeQuery("select * from atmcn_6");
            JDBC.assertNullability(resultSet, new boolean[]{true, false});
            JDBC.assertEmpty(resultSet);
        }
        this.assertCompileError("42X01", "alter table t alter column c set null");
        this.assertCompileError("42X01", "alter table t alter column c drop null");
        this.rollback();
    }

    public void testAlterColumn() throws Exception {
        int n;
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        this.createTestObjects(statement);
        this.testAlterColumnNullability(statement, true);
        this.testAlterColumnNullability(statement, false);
        statement.executeUpdate("create table atmod_1 (a integer, b varchar(10))");
        statement.executeUpdate("insert into atmod_1 values (1, 'one')");
        statement.executeUpdate("alter table atmod_1 alter column a default -1");
        statement.executeUpdate("insert into atmod_1 values (default, 'minus one')");
        statement.executeUpdate("insert into atmod_1 (b) values ('b')");
        ResultSet resultSet = statement.executeQuery("select * from atmod_1");
        JDBC.assertColumnNames(resultSet, "A", "B");
        Object[][] objectArray = new String[][]{{"1", "one"}, {"-1", "minus one"}, {"-1", "b"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("alter table atmod_1 alter a default 42");
        statement.executeUpdate("insert into atmod_1 values(3, 'three')");
        statement.executeUpdate("insert into atmod_1 values (default, 'forty two')");
        resultSet = statement.executeQuery("select * from atmod_1");
        JDBC.assertColumnNames(resultSet, "A", "B");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "one"}, {"-1", "minus one"}, {"-1", "b"}, {"3", "three"}, {"42", "forty two"}});
        statement.executeUpdate("create table renc_1 (a int, b varchar(10), c timestamp, d double)");
        AlterTableTest.assertStatementError("42Y55", statement, "rename column renc_no_such.a to b");
        AlterTableTest.assertStatementError("42X14", statement, "rename column renc_1.no_such to e");
        AlterTableTest.assertStatementError("X0Y32", statement, "rename column renc_1.a to c");
        AlterTableTest.assertStatementError("X0Y32", statement, "rename column renc_1.b to b");
        AlterTableTest.assertStatementError("42X01", statement, "rename column renc_1.a to select");
        AlterTableTest.assertStatementError("42X62", statement, "rename column sys.sysconglomerates.isindex to is_an_index");
        statement.executeUpdate("create view renc_vw_1 (v1, v2) as select b, d from renc_1");
        AlterTableTest.assertStatementError("42Y62", statement, " rename column renc_vw_1.v2 to v3");
        statement.executeUpdate("create index renc_idx_1 on renc_1 (c, d)");
        AlterTableTest.assertStatementError("42Y55", statement, " rename column renc_idx_1.d to d_new");
        AlterTableTest.assertStatementError("42Y55", statement, "rename column renc_1 to b");
        AlterTableTest.assertStatementError("42X01", statement, "rename column renc_1 rename a to b");
        AlterTableTest.assertStatementError("42X01", statement, "rename column renc_1.a");
        AlterTableTest.assertStatementError("42X01", statement, "rename column renc_1.a b");
        AlterTableTest.assertStatementError("42X01", statement, "rename column renc_1.a to");
        AlterTableTest.assertStatementError("42X01", statement, "rename column renc_1.a to b, c");
        AlterTableTest.assertStatementError("42X01", statement, " rename column renc_1.a to b and c to d");
        statement.executeUpdate("create table renc_2(c1 int not null constraint renc_2_p1 primary key)");
        statement.executeUpdate("rename column renc_2.c1 to c2");
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        resultSet = databaseMetaData.getColumns(null, null, "RENC_2", "C2");
        AlterTableTest.assertTrue((boolean)resultSet.next());
        AlterTableTest.assertEquals((String)"C2", (String)resultSet.getString("COLUMN_NAME"));
        AlterTableTest.assertEquals((String)"INTEGER", (String)resultSet.getString("TYPE_NAME"));
        AlterTableTest.assertEquals((String)"0", (String)resultSet.getString("DECIMAL_DIGITS"));
        AlterTableTest.assertEquals((String)"10", (String)resultSet.getString("NUM_PREC_RADIX"));
        AlterTableTest.assertEquals((String)"10", (String)resultSet.getString("COLUMN_SIZE"));
        AlterTableTest.assertEquals(null, (String)resultSet.getString("COLUMN_DEF"));
        AlterTableTest.assertEquals(null, (String)resultSet.getString("CHAR_OCTET_LENGTH"));
        AlterTableTest.assertEquals((String)"NO", (String)resultSet.getString("IS_NULLABLE"));
        AlterTableTest.assertFalse((boolean)resultSet.next());
        if (AlterTableTest.usingEmbedded()) {
            databaseMetaData = this.getConnection().getMetaData();
            resultSet = databaseMetaData.getIndexInfo(null, null, "RENC_2", false, false);
            AlterTableTest.assertTrue((boolean)resultSet.next());
            AlterTableTest.assertEquals((String)"RENC_2", (String)resultSet.getString("TABLE_NAME"));
            AlterTableTest.assertEquals((String)"C2", (String)resultSet.getString("COLUMN_NAME"));
            AlterTableTest.assertEquals((String)"false", (String)resultSet.getString("NON_UNIQUE"));
            AlterTableTest.assertEquals((String)"3", (String)resultSet.getString("TYPE"));
            AlterTableTest.assertEquals((String)"A", (String)resultSet.getString("ASC_OR_DESC"));
            AlterTableTest.assertEquals(null, (String)resultSet.getString("CARDINALITY"));
            AlterTableTest.assertEquals(null, (String)resultSet.getString("PAGES"));
            AlterTableTest.assertFalse((boolean)resultSet.next());
        }
        resultSet = statement.executeQuery(" select c.constraintname, c.type from sys.sysconstraints c, sys.systables t where t.tableid = c.tableid and t.tablename = 'RENC_2'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"RENC_2_P1", "P"}});
        statement.executeUpdate(" create table renc_3 (a integer not null, b integer not null, c int, constraint renc_3_pk primary key(a, b))");
        statement.executeUpdate("rename column renc_3.b to newbie");
        databaseMetaData = this.getConnection().getMetaData();
        resultSet = databaseMetaData.getColumns(null, null, "RENC_3", "NEWBIE");
        AlterTableTest.assertTrue((boolean)resultSet.next());
        AlterTableTest.assertEquals((String)"NEWBIE", (String)resultSet.getString("COLUMN_NAME"));
        AlterTableTest.assertEquals((String)"INTEGER", (String)resultSet.getString("TYPE_NAME"));
        AlterTableTest.assertEquals((String)"0", (String)resultSet.getString("DECIMAL_DIGITS"));
        AlterTableTest.assertEquals((String)"10", (String)resultSet.getString("NUM_PREC_RADIX"));
        AlterTableTest.assertEquals((String)"10", (String)resultSet.getString("COLUMN_SIZE"));
        AlterTableTest.assertEquals(null, (String)resultSet.getString("COLUMN_DEF"));
        AlterTableTest.assertEquals(null, (String)resultSet.getString("CHAR_OCTET_LENGTH"));
        AlterTableTest.assertEquals((String)"NO", (String)resultSet.getString("IS_NULLABLE"));
        AlterTableTest.assertFalse((boolean)resultSet.next());
        if (AlterTableTest.usingEmbedded()) {
            databaseMetaData = this.getConnection().getMetaData();
            resultSet = databaseMetaData.getIndexInfo(null, null, "RENC_3", false, false);
            AlterTableTest.assertTrue((boolean)resultSet.next());
            AlterTableTest.assertEquals((String)"RENC_3", (String)resultSet.getString("TABLE_NAME"));
            AlterTableTest.assertEquals((String)"A", (String)resultSet.getString("COLUMN_NAME"));
            AlterTableTest.assertEquals((String)"false", (String)resultSet.getString("NON_UNIQUE"));
            AlterTableTest.assertEquals((String)"3", (String)resultSet.getString("TYPE"));
            AlterTableTest.assertEquals((String)"A", (String)resultSet.getString("ASC_OR_DESC"));
            AlterTableTest.assertEquals(null, (String)resultSet.getString("CARDINALITY"));
            AlterTableTest.assertEquals(null, (String)resultSet.getString("PAGES"));
            AlterTableTest.assertTrue((boolean)resultSet.next());
            AlterTableTest.assertEquals((String)"RENC_3", (String)resultSet.getString("TABLE_NAME"));
            AlterTableTest.assertEquals((String)"NEWBIE", (String)resultSet.getString("COLUMN_NAME"));
            AlterTableTest.assertEquals((String)"false", (String)resultSet.getString("NON_UNIQUE"));
            AlterTableTest.assertEquals((String)"3", (String)resultSet.getString("TYPE"));
            AlterTableTest.assertEquals((String)"A", (String)resultSet.getString("ASC_OR_DESC"));
            AlterTableTest.assertEquals(null, (String)resultSet.getString("CARDINALITY"));
            AlterTableTest.assertEquals(null, (String)resultSet.getString("PAGES"));
            AlterTableTest.assertFalse((boolean)resultSet.next());
        }
        resultSet = statement.executeQuery(" select c.constraintname, c.type from sys.sysconstraints c, sys.systables t where t.tableid = c.tableid and t.tablename = 'RENC_3'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"RENC_3_PK", "P"}});
        statement.executeUpdate(" create table renc_4 (c1 int not null unique, c2 double, c3 int, c4 int not null constraint renc_4_c4_PK primary key, c5 int, c6 int, constraint renc_4_t2ck check (c2+c3<100.0))");
        statement.executeUpdate(" create table renc_5 (c1 int, c2 int, c3 int, c4 int, c5 int not null, c6 int, constraint renc_5_t3fk foreign key (c2) references renc_4(c4), constraint renc_5_unq unique(c5), constraint renc_5_t3ck check (c2-c3<80))");
        statement.executeUpdate("rename column renc_4.c1 to unq_c1");
        if (AlterTableTest.usingEmbedded()) {
            databaseMetaData = this.getConnection().getMetaData();
            resultSet = databaseMetaData.getIndexInfo(null, null, "RENC_4", false, false);
            AlterTableTest.assertTrue((boolean)resultSet.next());
            AlterTableTest.assertEquals((String)"RENC_4", (String)resultSet.getString("TABLE_NAME"));
            AlterTableTest.assertEquals((String)"UNQ_C1", (String)resultSet.getString("COLUMN_NAME"));
            AlterTableTest.assertEquals((String)"false", (String)resultSet.getString("NON_UNIQUE"));
            AlterTableTest.assertEquals((String)"3", (String)resultSet.getString("TYPE"));
            AlterTableTest.assertEquals((String)"A", (String)resultSet.getString("ASC_OR_DESC"));
            AlterTableTest.assertEquals(null, (String)resultSet.getString("CARDINALITY"));
            AlterTableTest.assertEquals(null, (String)resultSet.getString("PAGES"));
            AlterTableTest.assertTrue((boolean)resultSet.next());
            AlterTableTest.assertEquals((String)"RENC_4", (String)resultSet.getString("TABLE_NAME"));
            AlterTableTest.assertEquals((String)"C4", (String)resultSet.getString("COLUMN_NAME"));
            AlterTableTest.assertEquals((String)"false", (String)resultSet.getString("NON_UNIQUE"));
            AlterTableTest.assertEquals((String)"3", (String)resultSet.getString("TYPE"));
            AlterTableTest.assertEquals((String)"A", (String)resultSet.getString("ASC_OR_DESC"));
            AlterTableTest.assertEquals(null, (String)resultSet.getString("CARDINALITY"));
            AlterTableTest.assertEquals(null, (String)resultSet.getString("PAGES"));
            AlterTableTest.assertFalse((boolean)resultSet.next());
        }
        statement.executeUpdate("rename column renc_5.c5 to unq_c5");
        if (AlterTableTest.usingEmbedded()) {
            databaseMetaData = this.getConnection().getMetaData();
            resultSet = databaseMetaData.getIndexInfo(null, null, "RENC_5", false, false);
            AlterTableTest.assertTrue((boolean)resultSet.next());
            AlterTableTest.assertEquals((String)"RENC_5", (String)resultSet.getString("TABLE_NAME"));
            AlterTableTest.assertEquals((String)"UNQ_C5", (String)resultSet.getString("COLUMN_NAME"));
            AlterTableTest.assertEquals((String)"false", (String)resultSet.getString("NON_UNIQUE"));
            AlterTableTest.assertEquals((String)"3", (String)resultSet.getString("TYPE"));
            AlterTableTest.assertEquals((String)"A", (String)resultSet.getString("ASC_OR_DESC"));
            AlterTableTest.assertEquals(null, (String)resultSet.getString("CARDINALITY"));
            AlterTableTest.assertEquals(null, (String)resultSet.getString("PAGES"));
            AlterTableTest.assertTrue((boolean)resultSet.next());
            AlterTableTest.assertEquals((String)"RENC_5", (String)resultSet.getString("TABLE_NAME"));
            AlterTableTest.assertEquals((String)"C2", (String)resultSet.getString("COLUMN_NAME"));
            AlterTableTest.assertEquals((String)"true", (String)resultSet.getString("NON_UNIQUE"));
            AlterTableTest.assertEquals((String)"3", (String)resultSet.getString("TYPE"));
            AlterTableTest.assertEquals((String)"A", (String)resultSet.getString("ASC_OR_DESC"));
            AlterTableTest.assertEquals(null, (String)resultSet.getString("CARDINALITY"));
            AlterTableTest.assertEquals(null, (String)resultSet.getString("PAGES"));
            AlterTableTest.assertFalse((boolean)resultSet.next());
        }
        AlterTableTest.assertStatementError("42Z97", statement, "rename column renc_4.c2 to some_other_name");
        statement.executeUpdate("create trigger renc_5_tr1 after update of c2, c3, c6 on renc_4 for each row mode db2sql insert into renc_5 (unq_c5, c6) values (1, 2)");
        AlterTableTest.assertStatementError("X0Y25", statement, "rename column renc_4.c6 to some_name");
        AlterTableTest.assertStatementError("X0Y25", statement, "rename column renc_5.c6 to new_name");
        statement.executeUpdate("insert into renc_4 values(1, 2, 3, 4, 5, 6)");
        statement.executeUpdate("update renc_4 set c6 = 92");
        resultSet = statement.executeQuery("select * from renc_5");
        JDBC.assertColumnNames(resultSet, "C1", "C2", "C3", "C4", "UNQ_C5", "C6");
        JDBC.assertFullResultSet(resultSet, new String[][]{{null, null, null, null, "1", "2"}});
        statement.executeUpdate("create table renc_6 (a int, b int, c int)");
        statement.executeUpdate("grant select (a, b) on renc_6 to eranda");
        resultSet = statement.executeQuery(" select p.grantee,p.type, p.columns from sys.syscolperms p, sys.systables t where t.tableid=p.tableid and t.tablename='RENC_6'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"ERANDA", "s", "{0, 1}"}});
        statement.executeUpdate("rename column renc_6.b to bb_gun");
        resultSet = statement.executeQuery(" select p.grantee,p.type, p.columns from sys.syscolperms p, sys.systables t where t.tableid=p.tableid and t.tablename='RENC_6'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"ERANDA", "s", "{0, 1}"}});
        PreparedStatement preparedStatement = this.prepareStatement("select * from renc_6");
        ResultSet resultSet2 = preparedStatement.executeQuery();
        if (AlterTableTest.usingEmbedded()) {
            AlterTableTest.assertStatementError("X0X95", statement, " rename column renc_6.bb_gun to water_pistol");
        }
        resultSet2.close();
        preparedStatement.close();
        this.setAutoCommit(false);
        PreparedStatement preparedStatement2 = this.prepareStatement("select * from renc_6 where a = ?");
        resultSet = statement.executeQuery("values (30)");
        resultSet.next();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            preparedStatement2.setObject(i, resultSet.getObject(i));
        }
        resultSet = preparedStatement2.executeQuery();
        String[] stringArray = new String[]{"A", "BB_GUN", "C"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        statement.executeUpdate(" rename column renc_6.a to abcdef");
        resultSet = statement.executeQuery("values (30)");
        resultSet.next();
        resultSetMetaData = resultSet.getMetaData();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            preparedStatement2.setObject(i, resultSet.getObject(i));
        }
        AlterTableTest.assertStatementError("42X04", preparedStatement2);
        this.setAutoCommit(true);
        statement.executeUpdate("create table renc_7 (c1 varchar(50), c2 int)");
        statement.executeUpdate("create synonym renc_7_syn for renc_7");
        statement.executeUpdate("insert into renc_7 values ('one', 1)");
        AlterTableTest.assertStatementError("42Y55", statement, " rename column renc_7_syn.c2 to c2_syn");
        statement.executeUpdate("rename column renc_7.c1 to c1_renamed");
        resultSet = statement.executeQuery("select c1_renamed from renc_7_syn");
        stringArray = new String[]{"C1_RENAMED"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"one"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("create schema renc_schema_1");
        statement.executeUpdate("create schema renc_schema_2");
        statement.executeUpdate("set schema renc_schema_2");
        statement.executeUpdate("create table renc_8 (a int, b int, c int)");
        statement.executeUpdate("set schema renc_schema_1");
        AlterTableTest.assertStatementError("42Y55", statement, "rename column renc_8.b to bbb");
        statement.executeUpdate("rename column renc_schema_2.renc_8.b to b2");
        this.setAutoCommit(false);
        statement.executeUpdate("create table derby_3823_t1 (c11 int, c12 varchar(5))");
        PreparedStatement preparedStatement3 = this.prepareStatement("insert into derby_3823_t1 values(?,'aaaaa')");
        for (n = 0; n < 1000; ++n) {
            preparedStatement3.setInt(1, n);
            preparedStatement3.executeUpdate();
        }
        this.commit();
        resultSet = statement.executeQuery("select * from derby_3823_t1");
        for (n = 0; n < 100; ++n) {
            resultSet.next();
        }
        resultSetMetaData = resultSet.getMetaData();
        AlterTableTest.assertEquals((int)5, (int)resultSetMetaData.getColumnDisplaySize(2));
        Statement statement2 = this.createStatement();
        AlterTableTest.assertStatementError("22001", statement2, "insert into derby_3823_t1 values(99,'12345678')");
        if (AlterTableTest.usingEmbedded()) {
            AlterTableTest.assertStatementError("X0X95", statement2, "alter table derby_3823_t1 alter column c12 set data type varchar(8)");
        } else {
            statement2.execute("alter table derby_3823_t1 alter column c12 set data type varchar(8)");
            resultSetMetaData = resultSet.getMetaData();
            AlterTableTest.assertEquals((int)5, (int)resultSetMetaData.getColumnDisplaySize(2));
            statement2.executeUpdate("insert into derby_3823_t1 values(99,'12345678')");
        }
    }

    public void testAlterTableAndSysdepends() throws Exception {
        Statement statement = this.createStatement();
        this.createTableAndInsertData(statement, "Derby5120_tab", "C11", "C12");
        this.createTableAndInsertData(statement, "Derby5120_tab_bkup1", "C111", "C112");
        this.createTableAndInsertData(statement, "Derby5120_tab_bkup2", "C211", "C212");
        int n = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate(" create trigger Derby5120_tr1 after update of c11 on Derby5120_tab referencing  old_table as old for each statement insert into Derby5120_tab_bkup1 select * from old");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)(n + 7), (int)this.numberOfRowsInSysdepends(statement));
        statement.executeUpdate(" create trigger Derby5120_tr2 after update of c11 on Derby5120_tab referencing  old as oldrow for each row insert into  Derby5120_tab_bkup2(c211) values (oldrow.c11)");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)(n + 14), (int)this.numberOfRowsInSysdepends(statement));
        statement.executeUpdate("update Derby5120_tab set c11=2");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)(n + 14), (int)this.numberOfRowsInSysdepends(statement));
        statement.executeUpdate("alter table Derby5120_tab add column c113 int");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)(n + 14), (int)this.numberOfRowsInSysdepends(statement));
        AlterTableTest.assertStatementError("42802", statement, " update Derby5120_tab set c11=2");
        statement.executeUpdate("drop trigger Derby5120_tr1");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS will be less", (int)(n + 7), (int)this.numberOfRowsInSysdepends(statement));
        statement.executeUpdate("update Derby5120_tab set c11=2");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)(n + 7), (int)this.numberOfRowsInSysdepends(statement));
    }

    public void testTriggersAndSynonyms() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table atdcSynonymTab_1 (c11 integer, c12 integer)");
        statement.executeUpdate("create table atdcSynonymTab_2 (c21 integer, c22 integer)");
        statement.executeUpdate("CREATE SYNONYM synonymTab2 FOR atdcSynonymTab_2");
        statement.executeUpdate("create trigger syn_tr1t1 after update of c11 on atdcSynonymTab_1 for each row mode db2sql insert into atdcSynonymTab_2(c21, c22) values(9,9)");
        JDBC.assertEmpty(statement.executeQuery(" select * from atdcSynonymTab_1"));
        JDBC.assertEmpty(statement.executeQuery(" select * from synonymTab2"));
        statement.executeUpdate(" insert into atdcSynonymTab_1 values(11,12)");
        statement.executeUpdate(" update atdcSynonymTab_1 set c11=99");
        JDBC.assertFullResultSet(statement.executeQuery("select * from synonymTab2"), new String[][]{{"9", "9"}});
        statement.executeUpdate(" delete from atdcSynonymTab_1");
        statement.executeUpdate(" delete from synonymTab2");
        AlterTableTest.assertStatementError("X0Y25", statement, " alter table atdcSynonymTab_2 drop column c21 restrict");
        JDBC.assertEmpty(statement.executeQuery(" select * from atdcSynonymTab_1"));
        JDBC.assertEmpty(statement.executeQuery(" select * from synonymTab2"));
        statement.executeUpdate(" insert into atdcSynonymTab_1 values(11,12)");
        statement.executeUpdate(" update atdcSynonymTab_1 set c11=99");
        JDBC.assertFullResultSet(statement.executeQuery("select * from synonymTab2"), new String[][]{{"9", "9"}});
        statement.executeUpdate(" delete from atdcSynonymTab_1");
        statement.executeUpdate(" delete from synonymTab2");
        statement.executeUpdate(" alter table atdcSynonymTab_2 drop column c21");
        JDBC.assertEmpty(statement.executeQuery(" select * from atdcSynonymTab_1"));
        JDBC.assertEmpty(statement.executeQuery(" select * from synonymTab2"));
        statement.executeUpdate(" insert into atdcSynonymTab_1 values(11,12)");
        statement.executeUpdate(" update atdcSynonymTab_1 set c11=99");
        JDBC.assertEmpty(statement.executeQuery(" select * from synonymTab2"));
    }

    public void testDropColumnTriggerDependency() throws Exception {
        Statement statement = this.createStatement();
        this.createTestObjects(statement);
        statement.executeUpdate("create table atdctd_1 (c11 integer, c12 integer)");
        statement.executeUpdate("create table atdctd_2 (c21 integer, c22 integer)");
        statement.executeUpdate("create table atdctd_3 (c31 integer, c32 integer)");
        statement.executeUpdate("create trigger tr1t1 after update of c11 on atdctd_1 for each row mode db2sql insert into atdctd_3(c31, c32) values(9,9)");
        statement.executeUpdate("create trigger tr1t2 after insert on atdctd_2 for each row mode db2sql insert into atdctd_3(c31, c32) select c11, c12 from atdctd_1");
        statement.executeUpdate("create trigger tr2t2 after insert on atdctd_2 for each row mode db2sql insert into atdctd_3(c31) select c11 from atdctd_1");
        JDBC.assertEmpty(statement.executeQuery(" select * from atdctd_3"));
        statement.executeUpdate(" insert into atdctd_1 values(11,12)");
        statement.executeUpdate(" update atdctd_1 set c11=99");
        JDBC.assertFullResultSet(statement.executeQuery("select * from atdctd_3"), new String[][]{{"9", "9"}});
        statement.executeUpdate(" insert into atdctd_2 values(21,22)");
        JDBC.assertFullResultSet(statement.executeQuery("select * from atdctd_3 order by c32"), new String[][]{{"9", "9"}, {"99", "12"}, {"99", null}});
        statement.executeUpdate(" delete from atdctd_3");
        statement.executeUpdate(" delete from atdctd_1");
        statement.executeUpdate(" delete from atdctd_2");
        AlterTableTest.assertStatementError("X0Y25", statement, " alter table atdctd_1 drop column c11 restrict");
        JDBC.assertEmpty(statement.executeQuery(" select * from atdctd_3"));
        statement.executeUpdate(" insert into atdctd_1 values(11,12)");
        statement.executeUpdate(" update atdctd_1 set c11=99");
        JDBC.assertFullResultSet(statement.executeQuery("select * from atdctd_3"), new String[][]{{"9", "9"}});
        statement.executeUpdate(" insert into atdctd_2 values(21,22)");
        JDBC.assertFullResultSet(statement.executeQuery("select * from atdctd_3 order by c32"), new String[][]{{"9", "9"}, {"99", "12"}, {"99", null}});
        statement.executeUpdate(" delete from atdctd_3");
        statement.executeUpdate(" delete from atdctd_1");
        statement.executeUpdate(" delete from atdctd_2");
        statement.executeUpdate(" alter table atdctd_1 drop column c11");
        JDBC.assertEmpty(statement.executeQuery(" select * from atdctd_3"));
        statement.executeUpdate(" insert into atdctd_1 values(12)");
        statement.executeUpdate(" update atdctd_1 set c12=99");
        JDBC.assertEmpty(statement.executeQuery(" select * from atdctd_3"));
        statement.executeUpdate(" insert into atdctd_2 values(21,22)");
        JDBC.assertEmpty(statement.executeQuery(" select * from atdctd_3"));
    }

    public void testDropColumn() throws Exception {
        Statement statement = this.createStatement();
        this.createTestObjects(statement);
        statement.executeUpdate("create table atdc_0 (a integer)");
        statement.executeUpdate("create table atdc_1 (a integer, b integer)");
        statement.executeUpdate("insert into atdc_1 values (1, 1)");
        JDBC.assertFullResultSet(statement.executeQuery(" select * from atdc_1"), new String[][]{{"1", "1"}});
        ResultSet resultSet = statement.executeQuery(" select columnname,columnnumber,columndatatype from sys.syscolumns where referenceid in (select tableid from sys.systables where tablename = 'ATDC_1')");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"A", "1", "INTEGER"}, {"B", "2", "INTEGER"}});
        statement.executeUpdate("alter table atdc_1 drop column b");
        resultSet = statement.executeQuery("select * from atdc_1");
        JDBC.assertColumnNames(resultSet, "A");
        JDBC.assertSingleValueResultSet(resultSet, "1");
        resultSet = statement.executeQuery(" select columnname,columnnumber,columndatatype from sys.syscolumns where referenceid in (select tableid from sys.systables where tablename = 'ATDC_1')");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"A", "1", "INTEGER"}});
        statement.executeUpdate("alter table atdc_1 add column b varchar (20)");
        statement.executeUpdate("insert into atdc_1 values (1, 'new val')");
        statement.executeUpdate("insert into atdc_1 (a, b) values (2, 'two val')");
        resultSet = statement.executeQuery("select * from atdc_1");
        JDBC.assertColumnNames(resultSet, "A", "B");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", null}, {"1", "new val"}, {"2", "two val"}});
        resultSet = statement.executeQuery(" select columnname,columnnumber,columndatatype from sys.syscolumns where referenceid in (select tableid from sys.systables where tablename = 'ATDC_1')");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"A", "1", "INTEGER"}, {"B", "2", "VARCHAR(20)"}});
        statement.executeUpdate("alter table atdc_1 add column c integer");
        statement.executeUpdate("insert into atdc_1 values (3, null, 3)");
        resultSet = statement.executeQuery("select * from atdc_1");
        JDBC.assertColumnNames(resultSet, "A", "B", "C");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", null, null}, {"1", "new val", null}, {"2", "two val", null}, {"3", null, "3"}});
        statement.executeUpdate("alter table atdc_1 drop b");
        resultSet = statement.executeQuery("select * from atdc_1");
        JDBC.assertColumnNames(resultSet, "A", "C");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", null}, {"1", null}, {"2", null}, {"3", "3"}});
        resultSet = statement.executeQuery(" select columnname,columnnumber,columndatatype from sys.syscolumns where referenceid in (select tableid from sys.systables where tablename = 'ATDC_1')");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"A", "1", "INTEGER"}, {"C", "2", "INTEGER"}});
        statement.executeUpdate("create table atdc_1_01 (a int, b int, c int not null primary key)");
        statement.executeUpdate("alter table atdc_1_01 drop column c cascade");
        if (AlterTableTest.usingEmbedded()) {
            this.checkWarning(statement, "01500");
        }
        statement.executeUpdate(" create table atdc_1_02 (a int not null primary key, b int)");
        statement.executeUpdate(" create table atdc_1_03 (a03 int, constraint a03_fk foreign key (a03) references atdc_1_02(a))");
        statement.executeUpdate(" alter table atdc_1_02 drop column a cascade");
        if (AlterTableTest.usingEmbedded()) {
            this.checkWarning(statement, "01500");
        }
        statement.executeUpdate("alter table atdc_1 add constraint atdc_constraint_1 check (a > 0)");
        resultSet = statement.executeQuery(" select CONSTRAINTNAME,TYPE,STATE,REFERENCECOUNT from sys.sysconstraints where tableid in (select tableid from sys.systables where tablename = 'ATDC_1')");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"ATDC_CONSTRAINT_1", "C", "E", "0"}});
        resultSet = statement.executeQuery(" select sc.CHECKDEFINITION,sc.REFERENCEDCOLUMNS from sys.syschecks sc,sys.sysconstraints con,  sys.systables st where sc.constraintid = con.constraintid and con.tableid = st.tableid and st.tablename = 'ATDC_1'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"(a > 0)", "(1)"}});
        AlterTableTest.assertStatementError("X0Y25", statement, " alter table atdc_1 drop column a restrict");
        statement.executeUpdate("alter table atdc_1 drop column a cascade");
        this.checkWarning(statement, "01500");
        resultSet = statement.executeQuery(" select * from sys.sysconstraints where tableid in (select tableid from sys.systables where tablename = 'ATDC_1')");
        JDBC.assertDrainResults(resultSet, 0);
        statement.executeUpdate("create table atdc_1_constraints (a int not null primary key, b int not null, c int constraint atdc_1_c_chk check (c is not null), d int not null unique, e int, f int, constraint atdc_1_e_fk foreign key (e) references atdc_1_constraints(a))");
        AlterTableTest.assertStatementError("X0Y25", statement, " alter table atdc_1_constraints drop column a restrict");
        statement.executeUpdate(" alter table atdc_1_constraints drop column b restrict");
        AlterTableTest.assertStatementError("X0Y25", statement, " alter table atdc_1_constraints drop column c restrict");
        AlterTableTest.assertStatementError("X0Y25", statement, " alter table atdc_1_constraints drop column d restrict");
        AlterTableTest.assertStatementError("X0Y25", statement, " alter table atdc_1_constraints drop column e restrict");
        statement.executeUpdate("alter table atdc_1_constraints drop column a cascade");
        this.checkWarning(statement, "01500");
        statement.executeUpdate(" alter table atdc_1_constraints drop column c cascade");
        this.checkWarning(statement, "01500");
        statement.executeUpdate(" alter table atdc_1_constraints drop column d cascade");
        this.checkWarning(statement, "01500");
        statement.executeUpdate(" alter table atdc_1_constraints drop column e cascade");
        AlterTableTest.assertStatementError("42Y55", statement, "alter table atdc_nosuch drop column a");
        statement.executeUpdate("create table atdc_2 (a integer)");
        AlterTableTest.assertStatementError("42X14", statement, "alter table atdc_2 drop column b");
        AlterTableTest.assertStatementError("42X14", statement, "alter table atdc_2 drop b");
        AlterTableTest.assertStatementError("42X01", statement, "alter table atdc_2 drop column 'a'");
        AlterTableTest.assertStatementError("42X01", statement, "alter table atdc_2 drop column column");
        AlterTableTest.assertStatementError("42X01", statement, "alter table atdc_2 drop column");
        AlterTableTest.assertStatementError("42X01", statement, " alter table atdc_2 drop column constraint");
        AlterTableTest.assertStatementError("42X01", statement, " alter table atdc_2 drop column primary");
        AlterTableTest.assertStatementError("42X01", statement, " alter table atdc_2 drop column foreign");
        AlterTableTest.assertStatementError("42X01", statement, " alter table atdc_2 drop column check");
        statement.executeUpdate("create table atdc_3 (a integer)");
        statement.executeUpdate("create index atdc_3_idx_1 on atdc_3 (a)");
        AlterTableTest.assertStatementError("X0Y25", statement, "alter table atdc_3 drop column a restrict");
        statement.executeUpdate("drop index atdc_3_idx_1");
        statement.executeUpdate("create table atdc_4 (a int, b int, c int, d int, e int)");
        statement.executeUpdate("insert into atdc_4 values (1,2,3,4,5)");
        statement.executeUpdate("create index atdc_4_idx_1 on atdc_4 (a)");
        statement.executeUpdate("create index atdc_4_idx_2 on atdc_4 (b, c, d)");
        statement.executeUpdate("create index atdc_4_idx_3 on atdc_4 (c, a)");
        resultSet = statement.executeQuery(" select conglomeratename,isindex from sys.sysconglomerates where tableid in (select tableid from sys.systables where tablename = 'ATDC_4') and isindex='true'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"ATDC_4_IDX_1", "true"}, {"ATDC_4_IDX_2", "true"}, {"ATDC_4_IDX_3", "true"}});
        statement.executeUpdate("alter table atdc_4 drop column a restrict");
        resultSet = statement.executeQuery(" select conglomeratename,isindex from sys.sysconglomerates where tableid in (select tableid from sys.systables where tablename = 'ATDC_4') and isindex='true'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"ATDC_4_IDX_2", "true"}, {"ATDC_4_IDX_3", "true"}});
        statement.executeUpdate("alter table atdc_4 drop column c restrict");
        AlterTableTest.assertStatementError("42X04", statement, "select * from atdc_4 where c = 3");
        resultSet = statement.executeQuery(" select count(*) from sys.sysconglomerates where conglomeratename='ATDC_4_IDX_2'");
        JDBC.assertSingleValueResultSet(resultSet, "1");
        resultSet = statement.executeQuery(" select conglomeratename, isindex from sys.sysconglomerates where conglomeratename like 'ATDC_4%'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"ATDC_4_IDX_2", "true"}});
        statement.executeUpdate("drop index atdc_4_idx_2");
        statement.executeUpdate("create table atdc_5 (a int, b int)");
        statement.executeUpdate(" create view atdc_vw_1 (vw_b) as select b from atdc_5");
        AlterTableTest.assertStatementError("X0Y23", statement, " alter table atdc_5 drop column b restrict");
        resultSet = statement.executeQuery("select * from atdc_vw_1");
        String[] stringArray = new String[]{"VW_B"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertDrainResults(resultSet, 0);
        statement.executeUpdate("alter table atdc_5 drop column b cascade");
        this.checkWarning(statement, "01501");
        AlterTableTest.assertStatementError("42X05", statement, "select * from atdc_vw_1");
        statement.executeUpdate("create table atdc_5a (a int, b int, c int)");
        statement.executeUpdate(" create view atdc_vw_5a_1 (vw_5a_b, vw_5a_c) as select b,c from atdc_5a");
        statement.executeUpdate(" create view atdc_vw_5a_2 (vw_5a_c_2) as select vw_5a_c from atdc_vw_5a_1");
        statement.executeUpdate("alter table atdc_5a drop column b cascade");
        this.checkWarning(statement, "01501");
        AlterTableTest.assertStatementError("42X05", statement, "select * from atdc_vw_5a_1");
        AlterTableTest.assertStatementError("42X05", statement, "select * from atdc_vw_5a_2");
        this.createTableAndInsertData(statement, "ATDC_6", "A", "B");
        int n = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate(" create trigger atdc_6_trigger_1 after update of b on atdc_6 for each row values current_date");
        int n2 = this.numberOfRowsInSysdepends(statement);
        AlterTableTest.assertStatementError("X0Y25", statement, " alter table atdc_6 drop column b restrict");
        this.triggersExist(statement, new String[][]{{"ATDC_6_TRIGGER_1"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(statement), (int)n2);
        statement.executeUpdate("alter table atdc_6 drop column b cascade");
        this.checkWarning(statement, "01502");
        JDBC.assertEmpty(statement.executeQuery(" select triggername from sys.systriggers where triggername='ATDC_6_TRIGGER_1'"));
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(statement), (int)n);
        statement.executeUpdate("drop table ATDC_6");
        this.createTableAndInsertData(statement, "ATDC_11", "A", "B");
        n = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate(" create trigger atdc_11_trigger_1 after update of b on atdc_11 for each row select a,b from atdc_11");
        n2 = this.numberOfRowsInSysdepends(statement);
        AlterTableTest.assertStatementError("X0Y25", statement, " alter table atdc_11 drop column b restrict");
        this.triggersExist(statement, new String[][]{{"ATDC_11_TRIGGER_1"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(statement), (int)n2);
        statement.executeUpdate("alter table atdc_11 drop column b cascade");
        this.checkWarning(statement, "01502");
        JDBC.assertEmpty(statement.executeQuery(" select triggername from sys.systriggers where triggername='ATDC_11_TRIGGER_1'"));
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(statement), (int)n);
        statement.executeUpdate("drop table ATDC_11");
        this.createTableAndInsertData(statement, "ATDC_12", "A", "B");
        n = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate(" create trigger atdc_12_trigger_1 after update of a on atdc_12 for each row select a,b from atdc_12");
        statement.executeUpdate(" create trigger atdc_12_trigger_2  after update of a on atdc_12 REFERENCING NEW AS newt OLD AS oldt  for each row select oldt.b from atdc_12");
        n2 = this.numberOfRowsInSysdepends(statement);
        AlterTableTest.assertStatementError("X0Y25", statement, "alter table atdc_12 drop column b restrict");
        this.triggersExist(statement, new String[][]{{"ATDC_12_TRIGGER_1"}, {"ATDC_12_TRIGGER_2"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(statement), (int)n2);
        statement.executeUpdate("alter table atdc_12 drop column b");
        this.checkWarning(statement, "01502");
        JDBC.assertEmpty(statement.executeQuery(" select triggername from sys.systriggers where triggername in ('ATDC_12_TRIGGER_1', 'ATDC_12_TRIGGER_2')"));
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(statement), (int)n);
        statement.executeUpdate("drop table ATDC_12");
        this.createTableAndInsertData(statement, "ATDC_13", "A", "B");
        n = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate(" create trigger atdc_13_trigger_1 after update on atdc_13 for each row select a,b from atdc_13");
        statement.executeUpdate(" create trigger atdc_13_trigger_2 after insert on atdc_13 for each row select a,b from atdc_13");
        statement.executeUpdate(" create trigger atdc_13_trigger_3 after delete on atdc_13 for each row select a,b from atdc_13");
        statement.executeUpdate(" create trigger atdc_13_trigger_4 after update on atdc_13  REFERENCING NEW AS newt OLD AS oldt  for each row select oldt.b, newt.b from atdc_13");
        statement.executeUpdate(" create trigger atdc_13_trigger_5 after insert on atdc_13  REFERENCING NEW AS newt  for each row select newt.b from atdc_13");
        statement.executeUpdate(" create trigger atdc_13_trigger_6 after delete on atdc_13  REFERENCING OLD AS oldt  for each row select oldt.b from atdc_13");
        n2 = this.numberOfRowsInSysdepends(statement);
        AlterTableTest.assertStatementError("X0Y25", statement, "alter table atdc_13 drop column b restrict");
        this.triggersExist(statement, new String[][]{{"ATDC_13_TRIGGER_1"}, {"ATDC_13_TRIGGER_2"}, {"ATDC_13_TRIGGER_3"}, {"ATDC_13_TRIGGER_4"}, {"ATDC_13_TRIGGER_5"}, {"ATDC_13_TRIGGER_6"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(statement), (int)n2);
        statement.executeUpdate("alter table atdc_13 drop column b");
        this.checkWarning(statement, "01502");
        JDBC.assertEmpty(statement.executeQuery(" select triggername from sys.systriggers where triggername in ('ATDC_13_TRIGGER_1', 'ATDC_13_TRIGGER_2', 'ATDC_13_TRIGGER_3','ATDC_13_TRIGGER_4', 'ATDC_13_TRIGGER_5','ATDC_13_TRIGGER_6')"));
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(statement), (int)n);
        statement.executeUpdate("drop table ATDC_13");
        statement.executeUpdate("create table atdc_16_tab1 (a1 integer, b1 integer, c1 integer)");
        statement.executeUpdate("create table atdc_16_tab2 (a2 integer, b2 integer, c2 integer)");
        statement.executeUpdate("insert into atdc_16_tab1 values(1,11,111)");
        statement.executeUpdate("insert into atdc_16_tab2 values(1,11,111)");
        resultSet = statement.executeQuery(" select * from atdc_16_tab1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "11", "111"}});
        resultSet = statement.executeQuery(" select * from atdc_16_tab2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "11", "111"}});
        n = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate(" create trigger atdc_16_trigger_1  after update of b1 on atdc_16_tab1 REFERENCING NEW AS newt for each row  update atdc_16_tab2 set c2 = newt.c1");
        n2 = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate("update atdc_16_tab1 set b1=22,c1=222");
        resultSet = statement.executeQuery(" select * from atdc_16_tab1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "22", "222"}});
        resultSet = statement.executeQuery(" select * from atdc_16_tab2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "11", "222"}});
        statement.executeUpdate("alter table atdc_16_tab1 drop column a1 restrict");
        statement.executeUpdate("update atdc_16_tab1 set b1=33, c1=333");
        resultSet = statement.executeQuery(" select * from atdc_16_tab1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"33", "333"}});
        resultSet = statement.executeQuery(" select * from atdc_16_tab2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "11", "333"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(statement), (int)n2);
        statement.executeUpdate("drop table ATDC_16_TAB1");
        statement.executeUpdate("drop table ATDC_16_TAB2");
        this.createTableAndInsertData(statement, "ATDC_14_TAB1", "A1", "B1");
        this.createTableAndInsertData(statement, "ATDC_14_TAB2", "A2", "B2");
        n = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate(" create trigger atdc_14_trigger_1 after update on atdc_14_tab1 REFERENCING NEW AS newt for each row update atdc_14_tab2 set a2 = newt.a1");
        n2 = this.numberOfRowsInSysdepends(statement);
        AlterTableTest.assertStatementError("X0Y25", statement, "alter table atdc_14_tab2 drop column a2 restrict");
        this.triggersExist(statement, new String[][]{{"ATDC_14_TRIGGER_1"}});
        statement.executeUpdate("alter table atdc_14_tab2 drop column a2");
        this.checkWarning(statement, "01502");
        JDBC.assertEmpty(statement.executeQuery(" select triggername from sys.systriggers where triggername in ('ATDC_14_TRIGGER_1')"));
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(statement), (int)n);
        statement.executeUpdate("drop table ATDC_14_TAB1");
        statement.executeUpdate("drop table ATDC_14_TAB2");
        this.createTableAndInsertData(statement, "ATDC_13_TAB1", "C11", "C12");
        this.createTableAndInsertData(statement, "ATDC_13_TAB1_BACKUP", "C11", "C12");
        this.createTableAndInsertData(statement, "ATDC_13_TAB2", "C21", "C22");
        this.createTableAndInsertData(statement, "ATDC_13_TAB3", "C31", "C32");
        n = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate(" create trigger ATDC_13_TAB1_trigger_1 after update on ATDC_13_TAB1 for each row INSERT INTO ATDC_13_TAB1_BACKUP  SELECT C31, C32 from ATDC_13_TAB3");
        statement.executeUpdate(" create trigger ATDC_13_TAB1_trigger_2 after update on ATDC_13_TAB1 for each row INSERT INTO ATDC_13_TAB1_BACKUP  SELECT * from ATDC_13_TAB3");
        int n3 = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate(" create trigger ATDC_13_TAB1_trigger_3 after update on ATDC_13_TAB1 for each row INSERT INTO ATDC_13_TAB1_BACKUP VALUES(1,1)");
        int n4 = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate(" create trigger ATDC_13_TAB1_trigger_4 after update on ATDC_13_TAB1 for each row INSERT INTO ATDC_13_TAB1_BACKUP(C11)  SELECT C21 from ATDC_13_TAB2");
        int n5 = this.numberOfRowsInSysdepends(statement);
        n2 = this.numberOfRowsInSysdepends(statement);
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(statement), (int)n2);
        statement.executeUpdate("update ATDC_13_TAB1 set c12=11");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(statement), (int)n2);
        resultSet = statement.executeQuery("select * from ATDC_13_TAB1_BACKUP ORDER BY C11, C12");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "1"}, {"1", "11"}, {"1", "11"}, {"1", "11"}, {"1", null}});
        statement.executeUpdate("delete from ATDC_13_TAB1_BACKUP");
        AlterTableTest.assertStatementError("X0Y25", statement, "alter table ATDC_13_TAB2 drop column c21 restrict");
        this.triggersExist(statement, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}, {"ATDC_13_TAB1_TRIGGER_3"}, {"ATDC_13_TAB1_TRIGGER_4"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(statement), (int)n2);
        statement.executeUpdate("drop table ATDC_13_TAB1");
        statement.executeUpdate("drop table ATDC_13_TAB2");
        statement.executeUpdate("drop table ATDC_13_TAB3");
        statement.executeUpdate("drop table ATDC_13_TAB1_BACKUP");
        this.createTableAndInsertData(statement, "ATDC_13_TAB1", "C11", "C12");
        this.createTableAndInsertData(statement, "ATDC_13_TAB1_BACKUP", "C11", "C12");
        this.createTableAndInsertData(statement, "ATDC_13_TAB2", "C21", "C22");
        this.createTableAndInsertData(statement, "ATDC_13_TAB3", "C31", "C32");
        n = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate(" create trigger ATDC_13_TAB1_trigger_1 after update on ATDC_13_TAB1 for each row INSERT INTO ATDC_13_TAB1_BACKUP  SELECT C31, C32 from ATDC_13_TAB3");
        statement.executeUpdate(" create trigger ATDC_13_TAB1_trigger_2 after update on ATDC_13_TAB1 for each row INSERT INTO ATDC_13_TAB1_BACKUP  SELECT * from ATDC_13_TAB3");
        n3 = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate(" create trigger ATDC_13_TAB1_trigger_3 after update on ATDC_13_TAB1 for each row INSERT INTO ATDC_13_TAB1_BACKUP VALUES(1,1)");
        int n6 = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate(" create trigger ATDC_13_TAB1_trigger_4 after update on ATDC_13_TAB1 for each row INSERT INTO ATDC_13_TAB1_BACKUP(C11)  SELECT C21 from ATDC_13_TAB2");
        int n7 = this.numberOfRowsInSysdepends(statement);
        n2 = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate("update ATDC_13_TAB1 set c12=11");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(statement), (int)n2);
        resultSet = statement.executeQuery("select * from ATDC_13_TAB1_BACKUP ORDER BY C11, C12");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "1"}, {"1", "11"}, {"1", "11"}, {"1", "11"}, {"1", null}});
        statement.executeUpdate("delete from ATDC_13_TAB1_BACKUP");
        AlterTableTest.assertStatementError("X0Y25", statement, "alter table ATDC_13_TAB2 drop column c21 restrict");
        this.triggersExist(statement, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}, {"ATDC_13_TAB1_TRIGGER_3"}, {"ATDC_13_TAB1_TRIGGER_4"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(statement), (int)n2);
        statement.executeUpdate("alter table ATDC_13_TAB2 drop column c21");
        this.checkWarning(statement, "01502");
        this.triggersExist(statement, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}, {"ATDC_13_TAB1_TRIGGER_3"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(statement), (int)n6);
        statement.executeUpdate("alter table ATDC_13_TAB2 add column c21 int");
        AlterTableTest.assertStatementError("X0Y25", statement, "alter table ATDC_13_TAB1_BACKUP drop column c11 restrict");
        this.triggersExist(statement, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}, {"ATDC_13_TAB1_TRIGGER_3"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(statement), (int)n6);
        statement.executeUpdate("alter table ATDC_13_TAB1_BACKUP drop column c11");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(statement), (int)n);
        statement.executeUpdate("alter table ATDC_13_TAB1_BACKUP add column c11 int");
        n = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate(" create trigger ATDC_13_TAB1_trigger_1 after update on ATDC_13_TAB1 for each row UPDATE ATDC_13_TAB1_BACKUP SET C11=123 WHERE C12>1");
        int n8 = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate(" create trigger ATDC_13_TAB1_trigger_2 after update on ATDC_13_TAB1 for each row UPDATE ATDC_13_TAB2 SET C21=123");
        n3 = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate(" create trigger ATDC_13_TAB1_trigger_3 after update on ATDC_13_TAB1 for each row UPDATE ATDC_13_TAB3 SET C31=123 WHERE C32 IN (values(1))");
        n6 = this.numberOfRowsInSysdepends(statement);
        n2 = this.numberOfRowsInSysdepends(statement);
        AlterTableTest.assertStatementError("X0Y25", statement, "alter table ATDC_13_TAB3 drop column c31 restrict");
        this.triggersExist(statement, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}, {"ATDC_13_TAB1_TRIGGER_3"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(statement), (int)n2);
        statement.executeUpdate("alter table ATDC_13_TAB3 drop column c31");
        this.triggersExist(statement, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(statement), (int)n3);
        statement.executeUpdate("alter table ATDC_13_TAB3 add column c31 int");
        AlterTableTest.assertStatementError("X0Y25", statement, "alter table ATDC_13_TAB2 drop column c21 restrict");
        this.triggersExist(statement, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(statement), (int)n3);
        statement.executeUpdate("alter table ATDC_13_TAB2 drop column c21");
        this.triggersExist(statement, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(statement), (int)n8);
        AlterTableTest.assertStatementError("X0Y25", statement, "alter table ATDC_13_TAB1_BACKUP drop column c12 restrict");
        this.triggersExist(statement, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(statement), (int)n8);
        statement.executeUpdate("alter table ATDC_13_TAB1_BACKUP drop column c12");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(statement), (int)n);
        statement.executeUpdate("alter table ATDC_13_TAB1_BACKUP add column c12 int");
        n = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate(" create trigger ATDC_13_TAB1_trigger_1 after update on ATDC_13_TAB1 for each row DELETE FROM ATDC_13_TAB1_BACKUP WHERE C12>1");
        n8 = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate(" create trigger ATDC_13_TAB1_trigger_2 after update on ATDC_13_TAB1 for each row DELETE FROM ATDC_13_TAB3 WHERE C32 IN (values(1))");
        n3 = this.numberOfRowsInSysdepends(statement);
        n2 = this.numberOfRowsInSysdepends(statement);
        AlterTableTest.assertStatementError("X0Y25", statement, "alter table ATDC_13_TAB3 drop column c32 restrict");
        this.triggersExist(statement, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(statement), (int)n2);
        statement.executeUpdate("alter table ATDC_13_TAB3 drop column c32");
        this.triggersExist(statement, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(statement), (int)n8);
        AlterTableTest.assertStatementError("X0Y25", statement, "alter table ATDC_13_TAB1_BACKUP drop column c12 restrict");
        this.triggersExist(statement, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(statement), (int)n8);
        statement.executeUpdate("alter table ATDC_13_TAB1_BACKUP drop column c12");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(statement), (int)n);
        statement.executeUpdate("drop table ATDC_13_TAB1");
        statement.executeUpdate("drop table ATDC_13_TAB1_BACKUP");
        statement.executeUpdate("drop table ATDC_13_TAB2");
        statement.executeUpdate("drop table ATDC_13_TAB3");
        this.createTableAndInsertData(statement, "ATDC_13_TAB1", "C11", "C12");
        this.createTableAndInsertData(statement, "ATDC_13_TAB2", "C11", "C12");
        this.createTableAndInsertData(statement, "ATDC_13_TAB3", "C11", "C12");
        statement.executeUpdate("create view ATDC_13_VIEW1 as select c11 from ATDC_13_TAB2");
        statement.executeUpdate("create view ATDC_13_VIEW3 as select * from ATDC_13_TAB2");
        statement.executeUpdate("create view ATDC_13_VIEW2 as select c12 from ATDC_13_TAB3 where c12>0");
        n = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate(" create trigger ATDC_13_TAB1_trigger_1 after update on ATDC_13_TAB1 for each row SELECT * from ATDC_13_VIEW1 WHERE C11>0");
        n8 = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate(" create trigger ATDC_13_TAB1_trigger_2 after update on ATDC_13_TAB1 for each row SELECT * from ATDC_13_VIEW3");
        n3 = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate(" create trigger ATDC_13_TAB1_trigger_3 after update on ATDC_13_TAB1 for each row SELECT * from ATDC_13_VIEW2 ");
        n6 = this.numberOfRowsInSysdepends(statement);
        n2 = this.numberOfRowsInSysdepends(statement);
        AlterTableTest.assertStatementError("X0Y23", statement, "alter table ATDC_13_TAB3 drop column c12 restrict");
        this.triggersExist(statement, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}, {"ATDC_13_TAB1_TRIGGER_3"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(statement), (int)n2);
        statement.executeUpdate("alter table ATDC_13_TAB3 drop column c12");
        this.triggersExist(statement, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(statement), (int)(n3 - 1));
        AlterTableTest.assertStatementError("X0Y23", statement, "alter table ATDC_13_TAB2 drop column c11 restrict");
        this.triggersExist(statement, new String[][]{{"ATDC_13_TAB1_TRIGGER_1"}, {"ATDC_13_TAB1_TRIGGER_2"}});
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(statement), (int)(n3 - 1));
        statement.executeUpdate("alter table ATDC_13_TAB2 drop column c11");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should reduce", (int)this.numberOfRowsInSysdepends(statement), (int)(n - 3));
        statement.executeUpdate("drop table ATDC_13_TAB1");
        statement.executeUpdate("drop table ATDC_13_TAB2");
        statement.executeUpdate("drop table ATDC_13_TAB3");
        this.createTableAndInsertData(statement, "ATDC_15_TAB1", "A1", "B1");
        this.createTableAndInsertData(statement, "ATDC_15_TAB2", "A2", "B2");
        n = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate(" create trigger atdc_15_trigger_1 after update on atdc_15_tab1 REFERENCING NEW AS newt for each row update atdc_15_tab2 set b2 = newt.b1");
        n2 = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate("update atdc_15_tab1 set b1=22");
        resultSet = statement.executeQuery(" select * from atdc_15_tab1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "22"}});
        resultSet = statement.executeQuery(" select * from atdc_15_tab2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "22"}});
        statement.executeUpdate("alter table atdc_15_tab1 drop column a1 restrict");
        Assert.assertEquals((String)"# of rows in SYS.SYSDEPENDS should not change", (int)this.numberOfRowsInSysdepends(statement), (int)n2);
        statement.executeUpdate("update atdc_15_tab1 set b1=33");
        resultSet = statement.executeQuery(" select * from atdc_15_tab1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"33"}});
        resultSet = statement.executeQuery(" select * from atdc_15_tab2");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1", "33"}});
        statement.executeUpdate("drop table ATDC_15_TAB1");
        statement.executeUpdate("drop table ATDC_15_TAB2");
        statement.executeUpdate(" create table atdc_7 (a int, b int, c int, primary key (a))");
        AlterTableTest.assertStatementError("X0Y25", statement, " alter table atdc_7 drop column a restrict");
        statement.executeUpdate(" alter table atdc_7 drop column a cascade");
        this.checkWarning(statement, "01500");
        statement.executeUpdate(" create table atdc_8 (a int, b int, c int, primary key (b, c))");
        AlterTableTest.assertStatementError("X0Y25", statement, " alter table atdc_8 drop column c restrict");
        statement.executeUpdate("alter table atdc_8 drop column c cascade");
        this.checkWarning(statement, "01500");
        statement.executeUpdate("create table atdc_9 (a int not null, b int)");
        statement.executeUpdate("alter table atdc_9 drop column a restrict");
        statement.executeUpdate("create table atdc_10 (a int, b int, c int)");
        statement.executeUpdate("grant select(a, b, c) on atdc_10 to bryan");
        resultSet = statement.executeQuery(" select GRANTEE,GRANTOR,TYPE,COLUMNS from sys.syscolperms");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"BRYAN", "TEST_DBO", "s", "{0, 1, 2}"}});
        statement.executeUpdate("alter table atdc_10 drop column b restrict");
        resultSet = statement.executeQuery(" select GRANTEE,GRANTOR,TYPE,COLUMNS from sys.syscolperms");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"BRYAN", "TEST_DBO", "s", "{0, 1}"}});
        AlterTableTest.assertStatementError("42X14", statement, " alter table atdc_10 drop column b cascade");
        resultSet = statement.executeQuery(" select GRANTEE,GRANTOR,TYPE,COLUMNS from sys.syscolperms");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"BRYAN", "TEST_DBO", "s", "{0, 1}"}});
        AlterTableTest.assertStatementError("42Y55", statement, "drop table d1909");
        statement.executeUpdate("create table d1909 (a int, b int, c int)");
        statement.executeUpdate("grant select (a) on d1909 to user1");
        statement.executeUpdate("grant select (a,b) on d1909 to user2");
        statement.executeUpdate("grant update(c) on d1909 to super_user");
        resultSet = statement.executeQuery(" select c.grantee, c.type, c.columns from sys.syscolperms c, sys.systables t where c.tableid = t.tableid and t.tablename='D1909'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"USER1", "s", "{0}"}, {"USER2", "s", "{0, 1}"}, {"SUPER_USER", "u", "{2}"}});
        statement.executeUpdate("alter table d1909 drop column a");
        resultSet = statement.executeQuery(" select c.grantee, c.type, c.columns from sys.syscolperms c, sys.systables t where c.tableid = t.tableid and t.tablename='D1909'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"USER1", "s", "{}"}, {"USER2", "s", "{0}"}, {"SUPER_USER", "u", "{1}"}});
        statement.executeUpdate("grant update(b) on d1909 to user1");
        statement.executeUpdate("grant select(c) on d1909 to user1");
        statement.executeUpdate("grant select(c) on d1909 to user2");
        resultSet = statement.executeQuery(" select c.grantee, c.type, c.columns from sys.syscolperms c, sys.systables t where c.tableid = t.tableid and t.tablename='D1909'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"USER1", "s", "{1}"}, {"USER2", "s", "{0, 1}"}, {"SUPER_USER", "u", "{1}"}, {"USER1", "u", "{0}"}});
    }

    private void createTableAndInsertData(Statement statement, String string, String string2, String string3) throws SQLException {
        statement.execute("CREATE TABLE " + string + " (" + string2 + " int, " + string3 + " int) ");
        statement.execute("INSERT INTO " + string + " VALUES (1,11)");
    }

    private int numberOfRowsInSysdepends(Statement statement) throws SQLException {
        ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM SYS.SYSDEPENDS");
        resultSet.next();
        return resultSet.getInt(1);
    }

    private void triggersExist(Statement statement, String[][] stringArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("select triggername from sys.systriggers where triggername in (");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("'" + stringArray[i][0] + "'");
            if (i + 1 >= stringArray.length) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
        JDBC.assertFullResultSet(resultSet, stringArray);
    }

    public void testJira3175() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("set schema app");
        statement.executeUpdate("create table d3175 (x varchar(12), y varchar(12), id int primary key generated by default as identity)");
        ResultSet resultSet = statement.executeQuery(" select COLUMNNAME, COLUMNNUMBER, COLUMNDATATYPE,  COLUMNDEFAULT, AUTOINCREMENTVALUE, AUTOINCREMENTSTART,  AUTOINCREMENTINC,  TABLENAME, TABLETYPE, LOCKGRANULARITY  from sys.syscolumns c,sys.systables t where c.referenceid = t.tableid and t.tablename='D3175'");
        JDBC.assertUnorderedResultSet(resultSet, new String[][]{{"X", "1", "VARCHAR(12)", null, null, null, null, "D3175", "T", "R"}, {"Y", "2", "VARCHAR(12)", null, null, null, null, "D3175", "T", "R"}, {"ID", "3", "INTEGER NOT NULL", "GENERATED_BY_DEFAULT", "1", "1", "1", "D3175", "T", "R"}});
        statement.executeUpdate("insert into d3175(x) values 'b'");
        statement.executeUpdate("alter table d3175 drop column y");
        statement.executeUpdate("insert into d3175(x) values 'a'");
        this.vetSequenceState("D3175", "INTEGER NOT NULL", 3L, 1L, 1L);
    }

    public void testJira3177() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table d3177_SchemaVersion (version INTEGER NOT NULL)");
        statement.executeUpdate("insert into d3177_SchemaVersion (version) values (0)");
        statement.executeUpdate(" create table d3177_BinaryData ( id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), CRC32 BIGINT NOT NULL , data BLOB NOT NULL , CONSTRAINT d3177_BinaryData_id_pk PRIMARY KEY(id) )");
        statement.executeUpdate(" create table d3177_MailServers ( id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), port INTEGER NOT NULL , username varchar(80) NOT NULL , protocol varchar(80) NOT NULL , SSLProtocol varchar(10), emailAddress varchar(80) NOT NULL , server varchar(80) NOT NULL , password varchar(80) NOT NULL , CONSTRAINT d3177_MailServers_id_pk PRIMARY KEY(id) )");
        statement.executeUpdate(" create table d3177_Mailboxes ( id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), port INTEGER NOT NULL , folder varchar(80) NOT NULL , username varchar(80) NOT NULL , SSLProtocol varchar(10), hostname varchar(80) NOT NULL , storeType varchar(80) NOT NULL , password varchar(80) NOT NULL , timeout INTEGER NOT NULL , MailServerID INTEGER NOT NULL , CONSTRAINT d3177_Mailboxes_id_pk PRIMARY KEY(id) )");
        statement.executeUpdate(" create table d3177_MESSAGES ( Message_From varchar(1000), Message_Cc varchar(1000), Message_Subject varchar(1000), Message_ID varchar(256) NOT NULL , Message_Bcc varchar(1000), Message_Date TIMESTAMP, Content_Type varchar(256), MailboxID INTEGER NOT NULL , Search_Text CLOB NOT NULL , id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), Message_To varchar(1000), Display_Text CLOB NOT NULL , Message_Data_ID INTEGER NOT NULL , CONSTRAINT d3177_MESSAGES_id_pk PRIMARY KEY(id) )");
        ResultSet resultSet = statement.executeQuery(" select COLUMNNAME, COLUMNNUMBER, COLUMNDATATYPE,  COLUMNDEFAULT, AUTOINCREMENTVALUE, AUTOINCREMENTSTART,  AUTOINCREMENTINC,  TABLENAME, TABLETYPE, LOCKGRANULARITY  from sys.syscolumns c,sys.systables t where c.referenceid = t.tableid and c.columnname='ID' and t.tablename='D3177_MESSAGES'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"ID", "10", "INTEGER NOT NULL", null, "1", "1", "1", "D3177_MESSAGES", "T", "R"}});
        statement.executeUpdate(" create table D3177_ATTACHMENTS ( id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), Inline INTEGER, CRC32 BIGINT NOT NULL , Attachment_Name varchar(256) NOT NULL , Attachment_File varchar(512) NOT NULL , Message_ID INTEGER NOT NULL , Content_Type varchar(256) NOT NULL , CONSTRAINT D3177_ATTACHMENTS_id_pk PRIMARY KEY(id) )");
        statement.executeUpdate(" alter table D3177_ATTACHMENTS ADD CONSTRAINT ATTACHMENTS_Message_ID_MESSAGES_ID FOREIGN KEY ( Message_ID ) REFERENCES D3177_MESSAGES ( ID )");
        statement.executeUpdate(" alter table D3177_MESSAGES ADD CONSTRAINT MESSAGES_MailboxID_Mailboxes_ID FOREIGN KEY ( MailboxID ) REFERENCES d3177_Mailboxes ( ID )");
        statement.executeUpdate(" alter table D3177_MESSAGES ADD CONSTRAINT MESSAGES_Message_Data_ID_d3177_BinaryData_ID FOREIGN KEY ( Message_Data_ID ) REFERENCES d3177_BinaryData ( ID )");
        statement.executeUpdate(" alter table d3177_Mailboxes ADD CONSTRAINT Mailboxes_MailServerID_MailServers_ID FOREIGN KEY ( MailServerID ) REFERENCES d3177_MailServers ( ID )");
        AlterTableTest.assertUpdateCount(statement, 1, "update d3177_SchemaVersion set version=1");
        statement.executeUpdate(" alter table D3177_MESSAGES alter Message_To SET DATA TYPE varchar(10000)");
        statement.executeUpdate(" alter table D3177_MESSAGES alter Message_From SET DATA TYPE varchar(10000)");
        statement.executeUpdate(" alter table D3177_MESSAGES alter Message_Cc SET DATA TYPE varchar(10000)");
        statement.executeUpdate(" alter table D3177_MESSAGES alter Message_Bcc SET DATA TYPE varchar(10000)");
        resultSet = statement.executeQuery(" select COLUMNNAME, COLUMNNUMBER, COLUMNDATATYPE,  COLUMNDEFAULT, AUTOINCREMENTVALUE, AUTOINCREMENTSTART,  AUTOINCREMENTINC,  TABLENAME, TABLETYPE, LOCKGRANULARITY  from sys.syscolumns c,sys.systables t where c.referenceid = t.tableid and c.columnname='ID' and t.tablename='D3177_MESSAGES'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"ID", "10", "INTEGER NOT NULL", null, "1", "1", "1", "D3177_MESSAGES", "T", "R"}});
        AlterTableTest.assertUpdateCount(statement, 1, "update d3177_SchemaVersion set version=2");
        statement.executeUpdate(" create table D3177_MailStatistics ( id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), ProcessedCount INTEGER DEFAULT 0 NOT NULL , HourOfDay INTEGER NOT NULL , LastModified TIMESTAMP NOT NULL , RejectedMailCount INTEGER DEFAULT 0 NOT NULL , DayOfWeek INTEGER NOT NULL , CONSTRAINT D3177_MailStatistics_id_pk PRIMARY KEY(id) )");
        statement.executeUpdate(" CREATE INDEX D3177_MailStatistics_HourOfDay_idx ON D3177_MailStatistics(HourOfDay)");
        statement.executeUpdate(" CREATE INDEX D3177_MailStatistics_DayOfWeek_idx ON D3177_MailStatistics(DayOfWeek)");
        statement.executeUpdate(" alter table D3177_MESSAGES alter CONTENT_TYPE SET DATA TYPE varchar(256)");
        AlterTableTest.assertUpdateCount(statement, 1, "update d3177_SchemaVersion set version=3");
        statement.executeUpdate(" alter table D3177_messages alter column Message_ID NULL");
        statement.executeUpdate(" CREATE INDEX D3177_MESSAGES_Message_ID_idx ON D3177_MESSAGES(Message_ID)");
        AlterTableTest.assertUpdateCount(statement, 1, "update d3177_SchemaVersion set version=4");
        statement.executeUpdate("alter table D3177_MESSAGES add filename varchar(256)");
        statement.executeUpdate("alter table D3177_MESSAGES add CRC32 BIGINT");
        JDBC.assertEmpty(statement.executeQuery("select id,crc32,data from d3177_BinaryData"));
        resultSet = statement.executeQuery(" select COLUMNNAME, COLUMNNUMBER, COLUMNDATATYPE,  COLUMNDEFAULT, AUTOINCREMENTVALUE, AUTOINCREMENTSTART,  AUTOINCREMENTINC,  TABLENAME, TABLETYPE, LOCKGRANULARITY  from sys.syscolumns c,sys.systables t where c.referenceid = t.tableid and c.columnname='ID' and t.tablename='D3177_MESSAGES'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"ID", "10", "INTEGER NOT NULL", null, "1", "1", "1", "D3177_MESSAGES", "T", "R"}});
        statement.executeUpdate(" alter table D3177_messages alter column filename NOT NULL");
        statement.executeUpdate(" alter table D3177_messages alter column crc32 NOT NULL");
        statement.executeUpdate(" alter table D3177_messages alter column mailboxid NULL");
        AlterTableTest.assertStatementError("42X86", statement, " ALTER TABLE D3177_MESSAGES DROP CONSTRAINT MESSAGES_message_data_id_BinaryData_id");
        statement.executeUpdate(" alter table D3177_messages drop column message_data_id");
        this.checkWarning(statement, "01500");
        statement.executeUpdate("drop table d3177_BinaryData");
        AlterTableTest.assertUpdateCount(statement, 1, "update d3177_SchemaVersion set version=6");
        statement.executeUpdate(" create table D3177_EmailAddresses ( id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), address varchar(256) NOT NULL , CONSTRAINT D3177_EmailAddresses_id_pk PRIMARY KEY(id), CONSTRAINT D3177_EmailAddresses_address_uq UNIQUE(address) )");
        statement.executeUpdate(" CREATE UNIQUE INDEX D3177_EmailAddresses_address_idx ON D3177_EmailAddresses(address)");
        this.checkWarning(statement, "01504");
        statement.executeUpdate(" create table D3177_EmailAddressesToMessages ( MessageID INTEGER NOT NULL , EmailAddressID INTEGER NOT NULL )");
        statement.executeUpdate(" alter table D3177_EmailAddressesToMessages ADD CONSTRAINT EmailAddressesToMessages_MessageID_Messages_ID FOREIGN KEY ( MessageID ) REFERENCES D3177_Messages ( ID )");
        statement.executeUpdate(" alter table D3177_EmailAddressesToMessages ADD CONSTRAINT EmailAddressesToMessages_EmailAddressID_EmailAddresses_ID FOREIGN KEY ( EmailAddressID ) REFERENCES D3177_EmailAddresses ( ID )");
        statement.executeUpdate(" create table AuthenticationServers ( id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), port INTEGER NOT NULL , protocol varchar(20) NOT NULL , hostname varchar(40) NOT NULL , CONSTRAINT AuthenticationServers_id_pk PRIMARY KEY(id) )");
        statement.executeUpdate(" alter table d3177_Mailboxes add AuthenticationServerID INTEGER");
        JDBC.assertEmpty(statement.executeQuery("select id,filename from D3177_messages"));
        statement.executeUpdate("alter table D3177_MESSAGES drop column message_to");
        statement.executeUpdate("alter table D3177_MESSAGES drop column message_cc");
        statement.executeUpdate("alter table D3177_MESSAGES drop column message_from");
        resultSet = statement.executeQuery(" select COLUMNNAME, COLUMNNUMBER, COLUMNDATATYPE,  COLUMNDEFAULT, AUTOINCREMENTVALUE, AUTOINCREMENTSTART,  AUTOINCREMENTINC,  TABLENAME, TABLETYPE, LOCKGRANULARITY  from sys.syscolumns c,sys.systables t where c.referenceid = t.tableid and c.columnname='ID' and t.tablename='D3177_MESSAGES'");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"ID", "8", "INTEGER NOT NULL", null, "1", "1", "1", "D3177_MESSAGES", "T", "R"}});
        AlterTableTest.assertUpdateCount(statement, 1, "update d3177_SchemaVersion set version=7");
    }

    public void testJira2371() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t2371 ( a varchar(10))");
        statement.executeUpdate("alter table t2371 alter column a default 'my val'");
        statement.executeUpdate("insert into t2371 (a) values ('hi')");
        statement.executeUpdate("insert into t2371 (a) values (default)");
        statement.executeUpdate("alter table t2371 alter column a default 'another'");
        statement.executeUpdate("insert into t2371 (a) values (default)");
        JDBC.assertFullResultSet(statement.executeQuery("select A from t2371"), new String[][]{{"hi"}, {"my val"}, {"another"}});
    }

    public void testJira3355() throws Exception {
        Statement statement = this.createStatement();
        this.createTestObjects(statement);
        statement.executeUpdate("create table d3355 ( c1 varchar(10), \"c2\" varchar(10), c3 varchar(10))");
        statement.executeUpdate(" create table \"d3355_a\" ( c1 varchar(10), \"c2\" varchar(10), c3 varchar(10))");
        statement.executeUpdate(" create table d3355_qt_col (\"\"\"c\"\"4\" int, \"\"\"\"\"C5\" int, \"c 6\" int)");
        statement.executeUpdate(" create table \"d3355_qt_\"\"tab\" ( c4 int, c5 int, c6 int)");
        statement.executeUpdate("insert into d3355 values ('a', 'b', 'c')");
        statement.executeUpdate("insert into \"d3355_a\" values ('d', 'e', 'f')");
        statement.executeUpdate("insert into d3355_qt_col values (4, 5, 6)");
        statement.executeUpdate("insert into \"d3355_qt_\"\"tab\" values (4, 5, 6)");
        statement.executeUpdate("alter table d3355 alter column c1 not null");
        statement.executeUpdate("alter table d3355 alter column \"c2\" not null");
        statement.executeUpdate("alter table d3355 alter column \"C3\" not null");
        statement.executeUpdate("alter table \"d3355_a\" alter column c1 not null");
        statement.executeUpdate("alter table \"d3355_a\" alter column \"c2\" not null");
        statement.executeUpdate("alter table \"d3355_a\" alter column \"C3\" not null");
        statement.executeUpdate(" alter table d3355_qt_col alter column \"\"\"\"\"C5\" not null");
        statement.executeUpdate(" alter table d3355_qt_col alter column \"c 6\" not null");
        statement.executeUpdate(" alter table \"d3355_qt_\"\"tab\" alter column c5 not null");
        AlterTableTest.assertStatementError("42X14", statement, "alter table d3355 alter column \"c1\" not null");
        AlterTableTest.assertStatementError("42X14", statement, " alter table d3355 alter column c2 not null");
        AlterTableTest.assertStatementError("42Y55", statement, " alter table d3355_a alter column c1 not null");
        AlterTableTest.assertStatementError("42X14", statement, " alter table \"d3355_a\" alter column \"c1\" not null");
    }

    public void testJira4256() throws SQLException {
        Statement statement = this.createStatement();
        this.createTestObjects(statement);
        int n = 1;
        int n2 = 15360;
        statement.executeUpdate("create table clob_tab(c1 int,clob_col clob(10K))");
        this.commit();
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO clob_tab values (?,?)");
        TestInputStream testInputStream = new TestInputStream(n2, n);
        preparedStatement.setInt(1, n);
        preparedStatement.setAsciiStream(2, (InputStream)testInputStream, n2);
        AlterTableTest.assertStatementError("XJ001", preparedStatement);
        preparedStatement.close();
        this.rollback();
        statement.executeUpdate("ALTER TABLE clob_tab ALTER COLUMN clob_col SET DATA TYPE clob(20K)");
        preparedStatement = this.prepareStatement("INSERT INTO clob_tab values (?,?)");
        testInputStream = new TestInputStream(n2, n);
        preparedStatement.setInt(1, n);
        preparedStatement.setAsciiStream(2, (InputStream)testInputStream, n2);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        statement.executeUpdate("CREATE TABLE blob_tab ( C1 INTEGER,blob_col BLOB(10K) NOT NULL)");
        this.commit();
        preparedStatement = this.prepareStatement("INSERT INTO blob_tab values (?,?)");
        testInputStream = new TestInputStream(n2, n);
        preparedStatement.setInt(1, n);
        preparedStatement.setBinaryStream(2, (InputStream)testInputStream, n2);
        AlterTableTest.assertStatementError("22001", preparedStatement);
        preparedStatement.close();
        this.rollback();
        statement.executeUpdate("ALTER TABLE blob_tab ALTER COLUMN blob_col SET DATA TYPE blob(20K)");
        preparedStatement = this.prepareStatement("INSERT INTO blob_tab values (?,?)");
        testInputStream = new TestInputStream(n2, n);
        preparedStatement.setInt(1, n);
        preparedStatement.setBinaryStream(2, (InputStream)testInputStream, n2);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        this.rollback();
    }

    public void testDerby5157_addColumnWithDefaultValue() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create schema \"\"\"\"");
        statement.execute("create table \"\"\"\".\"\"\"\" (x int)");
        statement.execute("alter table \"\"\"\".\"\"\"\" add column \"\"\"\" int default 42");
    }

    public void testDerby5157_changeIncrement() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create schema \"\"\"\"");
        statement.execute("create table \"\"\"\".\"\"\"\"(\"\"\"\" int generated always as identity)");
        statement.execute("alter table \"\"\"\".\"\"\"\" alter column \"\"\"\" set increment by 2");
    }

    public void test_5679() throws Exception {
        Statement statement = this.createStatement();
        String[][] stringArray = new String[][]{{"before", null, "before"}};
        String[][] stringArray2 = new String[][]{{"after", "after", "after"}};
        statement.execute("create table t_5679(name1 varchar(10))");
        statement.execute("insert into t_5679(name1) values('before')");
        statement.execute("alter table t_5679 add column str1 varchar(10)");
        statement.execute("alter table t_5679 add column str2 varchar(10)");
        statement.execute("update t_5679 set str2 = 'before'");
        ResultSet resultSet = statement.executeQuery("select * from t_5679");
        JDBC.assertFullResultSet(resultSet, stringArray);
        this.setAutoCommit(false);
        statement.execute("update t_5679 set name1='after', str1='after', str2='after'");
        resultSet = statement.executeQuery("select * from t_5679");
        JDBC.assertFullResultSet(resultSet, stringArray2);
        this.rollback();
        this.setAutoCommit(true);
        resultSet = statement.executeQuery("select * from t_5679");
        JDBC.assertFullResultSet(resultSet, stringArray);
        statement.execute("drop table t_5679");
    }

    public void test_5679_manyColumns() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("create table t_5679_1( keyCol int )");
        statement.execute("insert into t_5679_1( keyCol ) values( 1 )");
        for (int i = 1; i < 100; ++i) {
            statement.execute("alter table t_5679_1 add column a_" + i + " int");
        }
        statement.execute("update t_5679_1 set a_50 = 50");
        String[] stringArray = new String[100];
        stringArray[0] = "1";
        stringArray[50] = "50";
        String[][] stringArray2 = new String[][]{stringArray};
        String[] stringArray3 = new String[100];
        stringArray3[0] = "1";
        stringArray3[49] = "490";
        stringArray3[50] = "500";
        stringArray3[51] = "510";
        String[][] stringArray4 = new String[][]{stringArray3};
        ResultSet resultSet = statement.executeQuery("select * from t_5679_1");
        JDBC.assertFullResultSet(resultSet, stringArray2);
        this.setAutoCommit(false);
        statement.execute("update t_5679_1 set a_49 = 490, a_50 = 500, a_51 = 510");
        resultSet = statement.executeQuery("select * from t_5679_1");
        JDBC.assertFullResultSet(resultSet, stringArray4);
        this.rollback();
        this.setAutoCommit(true);
        resultSet = statement.executeQuery("select * from t_5679_1");
        JDBC.assertFullResultSet(resultSet, stringArray2);
        statement.execute("drop table t_5679_1");
    }

    public void test_5679_longRows() throws Exception {
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = connection.prepareStatement("values syscs_util.syscs_get_database_property( 'derby.storage.pageSize' )");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        AlterTableTest.assertNull((Object)resultSet.getString(1));
        resultSet.close();
        preparedStatement.close();
        byte[] byArray = this.makeBytes(0, 1050);
        byte[] byArray2 = this.makeBytes(1, 1050);
        byte[] byArray3 = this.makeBytes(2, 1050);
        byte[] byArray4 = this.makeBytes(4, 1050);
        connection.prepareStatement("create table t_5679_2( a_0 varchar( 1050 ) for bit data, a_1 varchar( 1050 ) for bit data, a_2 varchar( 1050 ) for bit data)").execute();
        preparedStatement = connection.prepareStatement("insert into t_5679_2( a_0, a_1, a_2 ) values ( ?, ?, ? )");
        preparedStatement.setBytes(1, byArray);
        preparedStatement.setBytes(2, byArray2);
        preparedStatement.setBytes(3, byArray3);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        connection.prepareStatement("alter table t_5679_2 add column a_3 varchar( 500 ) for bit data").execute();
        connection.prepareStatement("alter table t_5679_2 add column a_4 varchar( 1050 ) for bit data").execute();
        AlterTableTest.assertTrue((boolean)true);
        AlterTableTest.assertTrue((boolean)true);
        preparedStatement = connection.prepareStatement("update t_5679_2 set a_4 = ?");
        preparedStatement.setBytes(1, byArray4);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        byte[] byArray5 = this.makeBytes(100, 1050);
        byte[] byArray6 = this.makeBytes(101, 1050);
        byte[] byArray7 = this.makeBytes(102, 1050);
        byte[] byArray8 = this.makeBytes(103, 500);
        byte[] byArray9 = this.makeBytes(104, 1050);
        byte[][] byArrayArray = new byte[][]{byArray, byArray2, byArray3, null, byArray4};
        byte[][] byArrayArray2 = new byte[][]{byArray5, byArray6, byArray7, byArray8, byArray9};
        this.vetBytes_5679(connection, byArrayArray);
        connection.setAutoCommit(false);
        preparedStatement = connection.prepareStatement("update t_5679_2 set a_0 = ?, a_1 = ?, a_2 = ?, a_3 = ?, a_4 = ?");
        preparedStatement.setBytes(1, byArray5);
        preparedStatement.setBytes(2, byArray6);
        preparedStatement.setBytes(3, byArray7);
        preparedStatement.setBytes(4, byArray8);
        preparedStatement.setBytes(5, byArray9);
        preparedStatement.executeUpdate();
        this.vetBytes_5679(connection, byArrayArray2);
        this.rollback();
        connection.setAutoCommit(true);
        this.vetBytes_5679(connection, byArrayArray);
        connection.prepareStatement("drop table t_5679_2").execute();
    }

    private byte[] makeBytes(int n, int n2) {
        byte[] byArray = new byte[n2];
        Arrays.fill(byArray, (byte)n);
        return byArray;
    }

    private void vetBytes_5679(Connection connection, byte[][] byArray) throws Exception {
        PreparedStatement preparedStatement = connection.prepareStatement("select * from t_5679_2");
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        for (int i = 0; i < byArray.length; ++i) {
            this.assertBytes(byArray[i], resultSet.getBytes(i + 1));
        }
        resultSet.close();
        preparedStatement.close();
    }

    private void assertBytes(byte[] byArray, byte[] byArray2) throws Exception {
        if (byArray == null) {
            AlterTableTest.assertNull((Object)byArray2);
            return;
        }
        AlterTableTest.assertNotNull((Object)byArray2);
        AlterTableTest.assertEquals((int)byArray.length, (int)byArray2.length);
        for (int i = 0; i < byArray.length; ++i) {
            AlterTableTest.assertEquals((byte)byArray[i], (byte)byArray2[i]);
        }
    }

    public void test_6882() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create table t_6882\n(\n  a int generated always as identity,\n  b int\n)\n");
        this.goodStatement(connection, "create table s_6882\n(\n  a int generated by default as identity,\n  b int\n)\n");
        this.goodStatement(connection, "create table u_6882\n(\n  a int,\n  b int\n)\n");
        this.assertCompileError(CANNOT_ALTER_NON_IDENTITY_COLUMN, "alter table u_6882 alter column a set generated by default");
        this.assertCompileError(CANNOT_ALTER_NON_IDENTITY_COLUMN, "alter table u_6882 alter column a set generated always");
        this.goodStatement(connection, "insert into t_6882(b) values (100)");
        this.goodStatement(connection, "insert into s_6882(b) values (100)");
        this.assertCompileError(CANNOT_MODIFY_ALWAYS_IDENTITY_COLUMN, "insert into t_6882(a, b) values (-1, -100)");
        this.goodStatement(connection, "insert into s_6882(a, b) values (-1, -100)");
        this.assertResults(connection, "select * from t_6882 order by a", new String[][]{{"1", "100"}}, false);
        this.assertResults(connection, "select * from s_6882 order by a", new String[][]{{"-1", "-100"}, {"1", "100"}}, false);
        this.goodStatement(connection, "alter table t_6882 alter column a set generated by default");
        this.goodStatement(connection, "alter table s_6882 alter column a set generated always");
        this.goodStatement(connection, "insert into t_6882(a, b) values (-2, -200)");
        this.assertCompileError(CANNOT_MODIFY_ALWAYS_IDENTITY_COLUMN, "insert into s_6882(a, b) values (-2, -200)");
        this.goodStatement(connection, "insert into t_6882(b) values (200)");
        this.goodStatement(connection, "insert into s_6882(b) values (200)");
        this.assertResults(connection, "select * from t_6882 order by a", new String[][]{{"-2", "-200"}, {"1", "100"}, {"2", "200"}}, false);
        this.assertResults(connection, "select * from s_6882 order by a", new String[][]{{"-1", "-100"}, {"1", "100"}, {"2", "200"}}, false);
        this.goodStatement(connection, "alter table t_6882 alter column a set generated always");
        this.goodStatement(connection, "alter table s_6882 alter column a set generated by default");
        this.assertCompileError(CANNOT_MODIFY_ALWAYS_IDENTITY_COLUMN, "insert into t_6882(a, b) values (-3, -300)");
        this.goodStatement(connection, "insert into s_6882(a, b) values (-3, -300)");
        this.goodStatement(connection, "insert into t_6882(b) values (300)");
        this.goodStatement(connection, "insert into s_6882(b) values (300)");
        this.assertResults(connection, "select * from t_6882 order by a", new String[][]{{"-2", "-200"}, {"1", "100"}, {"2", "200"}, {"3", "300"}}, false);
        this.assertResults(connection, "select * from s_6882 order by a", new String[][]{{"-3", "-300"}, {"-1", "-100"}, {"1", "100"}, {"2", "200"}, {"3", "300"}}, false);
        this.goodStatement(connection, "drop table u_6882");
        this.goodStatement(connection, "drop table s_6882");
        this.goodStatement(connection, "drop table t_6882");
    }

    public void test_6882_import() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create table source_6882\n(\n  a int generated always as identity primary key,\n  b int\n)\n");
        this.goodStatement(connection, "create table target_6882\n(\n  a int generated always as identity primary key,\n  b int\n)\n");
        this.goodStatement(connection, "insert into source_6882(b) values (100), (200), (300)");
        this.assertCompileError(CANNOT_MODIFY_ALWAYS_IDENTITY_COLUMN, "insert into target_6882 select * from source_6882");
        this.goodStatement(connection, "alter table target_6882 alter column a set generated by default");
        this.goodStatement(connection, "insert into target_6882 select * from source_6882");
        this.goodStatement(connection, "alter table target_6882 alter column a set generated always");
        try (PreparedStatement preparedStatement = connection.prepareStatement("insert into target_6882(b) values (400)");){
            AlterTableTest.assertPreparedStatementError(DUPLICATE_KEY, preparedStatement);
        }
        this.goodStatement(connection, "alter table target_6882 alter column a restart with 4");
        this.goodStatement(connection, "insert into target_6882(b) values (400)");
        this.assertResults(connection, "select * from target_6882 order by a", new String[][]{{"1", "100"}, {"2", "200"}, {"3", "300"}, {"4", "400"}}, false);
        this.goodStatement(connection, "drop table target_6882");
        this.goodStatement(connection, "drop table source_6882");
    }

    public void test_6961_setCycle() throws Exception {
        Connection connection = this.getConnection();
        this.vet_6961_cycling(connection, "t_nc_smallint_asc", "(\n  a smallint generated always as identity (start with 32766 no cycle),\n  b int\n)\n", new String[][]{{"32766", "1"}, {"32767", "2"}, {"-32768", "3"}});
        this.vet_6961_cycling(connection, "t_nc_smallint_desc", "(\n  a smallint generated always as identity (start with -32767 increment by -1 no cycle),\n  b int\n)\n", new String[][]{{"-32767", "1"}, {"-32768", "2"}, {"32767", "3"}});
        this.vet_6961_cycling(connection, "t_nc_int_asc", "(\n  a int generated always as identity (start with 2147483646 no cycle),\n  b int\n)\n", new String[][]{{"2147483646", "1"}, {"2147483647", "2"}, {"-2147483648", "3"}});
        this.vet_6961_cycling(connection, "t_nc_int_desc", "(\n  a int generated always as identity (start with -2147483647 increment by -1 no cycle),\n  b int\n)\n", new String[][]{{"-2147483647", "1"}, {"-2147483648", "2"}, {"2147483647", "3"}});
        this.vet_6961_cycling(connection, "t_nc_bigint_asc", "(\n  a bigint generated always as identity (start with 9223372036854775806 no cycle),\n  b int\n)\n", new String[][]{{"9223372036854775806", "1"}, {"9223372036854775807", "2"}, {"-9223372036854775808", "3"}});
        this.vet_6961_cycling(connection, "t_nc_bigint_desc", "(\n  a bigint generated always as identity (start with -9223372036854775807 increment by -1 no cycle),\n  b int\n)\n", new String[][]{{"-9223372036854775807", "1"}, {"-9223372036854775808", "2"}, {"9223372036854775807", "3"}});
    }

    private void vet_6961_cycling(Connection connection, String string, String string2, String[][] stringArray) throws Exception {
        this.goodStatement(connection, "create table " + string + " " + string2);
        this.goodStatement(connection, "insert into " + string + "(b) values (1)");
        this.goodStatement(connection, "insert into " + string + "(b) values (2)");
        String string3 = "insert into " + string + "(b) values (3)";
        try (PreparedStatement preparedStatement = connection.prepareStatement(string3);){
            AlterTableTest.assertPreparedStatementError(EXHAUSTED_IDENTITY_COLUMN, preparedStatement);
        }
        this.goodStatement(connection, "alter table " + string + " alter column a set cycle");
        this.goodStatement(connection, string3);
        this.assertResults(connection, "select * from " + string + " order by b", stringArray, false);
    }

    public void test_6961_setNoCycle() throws Exception {
        Connection connection = this.getConnection();
        this.vet_6961_noCycling(connection, "t_c_smallint_asc", "(\n  a smallint generated always as identity (start with 32766 cycle),\n  b int\n)\n", new String[][]{{"32766", "1"}, {"32767", "2"}});
        this.vet_6961_noCycling(connection, "t_c_smallint_desc", "(\n  a smallint generated always as identity (start with -32767 increment by -1 cycle),\n  b int\n)\n", new String[][]{{"-32767", "1"}, {"-32768", "2"}});
        this.vet_6961_noCycling(connection, "t_c_int_asc", "(\n  a int generated always as identity (start with 2147483646 cycle),\n  b int\n)\n", new String[][]{{"2147483646", "1"}, {"2147483647", "2"}});
        this.vet_6961_noCycling(connection, "t_c_int_desc", "(\n  a int generated always as identity (start with -2147483647 increment by -1 cycle),\n  b int\n)\n", new String[][]{{"-2147483647", "1"}, {"-2147483648", "2"}});
        this.vet_6961_noCycling(connection, "t_c_bigint_asc", "(\n  a bigint generated always as identity (start with 9223372036854775806 cycle),\n  b int\n)\n", new String[][]{{"9223372036854775806", "1"}, {"9223372036854775807", "2"}});
        this.vet_6961_noCycling(connection, "t_c_bigint_desc", "(\n  a bigint generated always as identity (start with -9223372036854775807 increment by -1 cycle),\n  b int\n)\n", new String[][]{{"-9223372036854775807", "1"}, {"-9223372036854775808", "2"}});
    }

    private void vet_6961_noCycling(Connection connection, String string, String string2, String[][] stringArray) throws Exception {
        this.goodStatement(connection, "create table " + string + " " + string2);
        this.goodStatement(connection, "insert into " + string + "(b) values (1)");
        this.goodStatement(connection, "insert into " + string + "(b) values (2)");
        this.goodStatement(connection, "alter table " + string + " alter column a set no cycle");
        String string3 = "insert into " + string + "(b) values (3)";
        try (PreparedStatement preparedStatement = connection.prepareStatement(string3);){
            AlterTableTest.assertPreparedStatementError(EXHAUSTED_IDENTITY_COLUMN, preparedStatement);
        }
        this.assertResults(connection, "select * from " + string + " order by b", stringArray, false);
    }

    public void test_6961_rollback() throws Exception {
        Connection connection = this.getConnection();
        boolean bl = connection.getAutoCommit();
        connection.setAutoCommit(false);
        this.goodStatement(connection, "create table t_c_6961_rollback\n(a int generated always as identity (start with 2147483646 cycle), b int)");
        connection.commit();
        this.goodStatement(connection, "insert into t_c_6961_rollback(b) values (1)");
        this.goodStatement(connection, "insert into t_c_6961_rollback(b) values (2)");
        connection.commit();
        this.goodStatement(connection, "alter table t_c_6961_rollback alter column a set no cycle");
        connection.rollback();
        this.goodStatement(connection, "insert into t_c_6961_rollback(b) values (3)");
        this.assertResults(connection, "select * from t_c_6961_rollback order by b", new String[][]{{"2147483646", "1"}, {"2147483647", "2"}, {"-2147483648", "3"}}, false);
        connection.commit();
        connection.setAutoCommit(bl);
    }
}

