/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.functionTests.harness.CurrentTime;
import org.apache.derbyTesting.functionTests.harness.GenerateReport;
import org.apache.derbyTesting.functionTests.harness.JavaVersionHolder;
import org.apache.derbyTesting.functionTests.harness.RunList;
import org.apache.derbyTesting.functionTests.harness.RunTest;
import org.apache.derbyTesting.functionTests.harness.SpecialFlags;
import org.apache.derbyTesting.functionTests.harness.SysInfoLog;

public class RunSuite {
    static final boolean verbose = true;
    static String suites;
    static Vector<String> suitesToRun;
    static String jvmName;
    static String javaCmd;
    static String jvmflags;
    static String javaVersion;
    static String classpath;
    static String classpathServer;
    static String testJavaFlags;
    static String testSpecialProps;
    static String userdir;
    static String framework;
    static String runwithibmjvm;
    static String excludeJCC;
    static boolean useprocess;
    static boolean skipsed;
    static String systemdiff;
    static String topSuiteName;
    static String outputdir;
    static String outcopy;
    static String canondir;
    static String bootcp;
    static String serverJvm;
    static String hostName;
    static String testEncoding;
    static String ijdefaultResourcePackage;
    static String debug;
    static String timeout;
    static String shutdownurl;
    static String reportstderr;
    static Properties suiteProperties;
    static Properties specialProperties;
    static PrintWriter pwOut;
    static File outDir;
    static File runDir;
    static File outFile;

    public static void main(String[] stringArray) throws Exception {
        Object object;
        String string;
        String string2;
        if (System.getProperty("java.vm.name") != null && System.getProperty("java.vm.name").equals("J9")) {
            javaCmd = "j9";
            string2 = System.getProperty("java.home");
        }
        if ((string2 = System.getProperty("com.ibm.oti.configuration")) != null) {
            if (string2.equals("foun10")) {
                jvmName = "j9_foundation";
            } else if (string2.equals("foun11")) {
                jvmName = "j9_foundation11";
            } else if (string2.equals("max")) {
                jvmName = "j9_13";
            } else if (string2.equals("dee")) {
                jvmName = "j9dee15";
            }
        }
        if ((string = stringArray[0]) == null) {
            System.out.println("No suite name argument.");
            System.exit(1);
        }
        topSuiteName = string;
        System.out.println("Top suite: " + string);
        suitesToRun = new Vector();
        suiteProperties = RunSuite.getSuiteProperties(string, true);
        RunSuite.getSystemProperties();
        specialProperties = SpecialFlags.getSpecialProperties(suiteProperties);
        RunSuite.setOutput(string);
        String string3 = CurrentTime.getTime();
        pwOut.println("******* Start Suite: " + string + " " + string3 + " *******");
        if (useprocess) {
            object = new SysInfoLog();
            ((SysInfoLog)object).exec(jvmName, javaCmd, classpath, framework, pwOut, useprocess);
        }
        RunSuite.getSuitesList(string, true);
        object = CurrentTime.getTime();
        pwOut.println("******* End Suite: " + string + " " + (String)object + " *******");
        pwOut.close();
        String string4 = System.getProperty("genrep");
        boolean bl = true;
        if (string4 != null) {
            bl = "true".equalsIgnoreCase(string4);
        }
        if (bl) {
            String[] stringArray2 = new String[]{stringArray[0], jvmName, javaCmd, classpath, framework, useprocess ? "true" : "false"};
            GenerateReport.main(stringArray2);
        }
    }

    static void getSuitesList(String string, boolean bl) throws Exception, ClassNotFoundException, IOException {
        if (suites == null || suites.length() == 0) {
            System.out.println("Suite to run: " + string + ":" + string);
            suitesToRun.addElement(string + ":" + string);
            System.out.println("Now do RunList");
            RunList runList = new RunList(suitesToRun, runDir, outDir, pwOut, suiteProperties, specialProperties, string);
            suitesToRun.removeAllElements();
        } else {
            bl = false;
            StringTokenizer stringTokenizer = new StringTokenizer(suites);
            String string2 = "";
            while (stringTokenizer.hasMoreTokens()) {
                Object object;
                string2 = stringTokenizer.nextToken();
                Properties properties = RunSuite.getSuiteProperties(string2, bl);
                if (properties.getProperty("suites") == null || string2.equals(string)) {
                    suitesToRun.addElement(string + ":" + string2);
                    System.out.println("Now do RunList");
                    object = new RunList(suitesToRun, runDir, outDir, pwOut, suiteProperties, specialProperties, string);
                    suitesToRun.removeAllElements();
                    continue;
                }
                object = properties.getProperty("suites");
                RunSuite.BuildSuitesVector(string2, (String)object);
                System.out.println("Now do RunList");
                RunList runList = new RunList(suitesToRun, runDir, outDir, pwOut, suiteProperties, specialProperties, string2);
                suitesToRun.removeAllElements();
            }
        }
    }

    static void BuildSuitesVector(String string, String string2) throws ClassNotFoundException, IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (string3.equals(string)) {
                suitesToRun.addElement(string + ":" + string3);
                continue;
            }
            Properties properties = RunSuite.getSuiteProperties(string3, false);
            if (properties.getProperty("suites") == null) {
                suitesToRun.addElement(string + ":" + string3);
                continue;
            }
            String string4 = properties.getProperty("suites");
            RunSuite.BuildSuitesVector(string3, string4);
        }
    }

    static Properties getSuiteProperties(String string, boolean bl) throws ClassNotFoundException, IOException {
        String string2 = "suites/" + string + ".properties";
        userdir = System.getProperty("user.dir");
        InputStream inputStream = RunTest.loadTestResource(string2);
        if (inputStream == null) {
            string2 = userdir + "/" + string + ".properties";
            inputStream = RunTest.loadTestResource(string2);
        }
        Properties properties = new Properties();
        if (inputStream == null) {
            return properties;
        }
        properties.load(inputStream);
        if (bl) {
            String string3 = jvmName;
            jvmName = properties.getProperty("jvm");
            javaVersion = jvmName == null || jvmName.length() == 0 ? System.getProperty("java.specification.version") : jvmName;
            String string4 = System.getProperty("java.vm.name").equals("J9") ? System.getProperty("java.vm.version") : javaVersion;
            JavaVersionHolder javaVersionHolder = new JavaVersionHolder(string4);
            String string5 = javaVersionHolder.getMajorVersion();
            String string6 = javaVersionHolder.getMinorVersion();
            int n = javaVersionHolder.getMinorNumber();
            int n2 = javaVersionHolder.getMajorNumber();
            jvmName = n < 2 && n2 < 2 ? "currentjvm" : "jdk" + string5 + string6;
            if (string3 != null) {
                jvmName = string3;
            }
            javaCmd = properties.getProperty("javaCmd");
            jvmflags = properties.getProperty("jvmflags");
            testJavaFlags = properties.getProperty("testJavaFlags");
            testSpecialProps = properties.getProperty("testSpecialProps");
            classpath = properties.getProperty("classpath");
            classpathServer = properties.getProperty("classpathServer");
            framework = properties.getProperty("framework");
            String string7 = properties.getProperty("useprocess");
            useprocess = string7 != null ? !(string7 = string7.toLowerCase()).equals("false") : true;
            String string8 = properties.getProperty("skipsed");
            skipsed = string8 != null ? (string8 = string8.toLowerCase()).equals("true") : false;
            outputdir = properties.getProperty("outputdir");
            canondir = properties.getProperty("canondir");
            bootcp = properties.getProperty("bootcp");
            hostName = properties.getProperty("hostName");
            serverJvm = properties.getProperty("serverJvm");
            systemdiff = properties.getProperty("systemdiff");
            ijdefaultResourcePackage = properties.getProperty("ij.defaultResourcePackage");
            outcopy = properties.getProperty("outcopy");
            debug = properties.getProperty("verbose");
            reportstderr = properties.getProperty("reportstderr");
            timeout = properties.getProperty("timeout");
            shutdownurl = properties.getProperty("shutdownurl");
            testEncoding = properties.getProperty("derbyTesting.encoding");
        }
        suites = properties.getProperty("suites");
        return properties;
    }

    private static void getSystemProperties() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        String string10;
        String string11;
        String string12;
        String string13;
        String string14;
        String string15;
        String string16;
        String string17;
        String string18;
        String string19;
        String string20;
        String string21;
        String string22;
        String string23;
        String string24;
        String string25;
        String string26;
        String string27;
        String string28;
        String string29;
        String string30;
        String string31;
        String string32;
        String string33;
        boolean bl = JVMInfo.isModuleAware();
        Properties properties = System.getProperties();
        String string34 = properties.getProperty("ij.searchClassPath");
        if (string34 != null) {
            suiteProperties.put("ij.searchClassPath", string34);
        }
        if ((string33 = properties.getProperty("framework")) != null && !string33.equals("embedded")) {
            framework = string33;
            suiteProperties.put("framework", framework);
        }
        if ((string32 = properties.getProperty("jvm")) != null) {
            suiteProperties.put("jversion", string32);
        }
        String string35 = properties.getProperty("javaCmd");
        if (System.getProperty("java.vm.name") != null && System.getProperty("java.vm.name").equals("J9")) {
            string35 = "j9";
        }
        if (string35 != null) {
            javaCmd = string35;
            suiteProperties.put("javaCmd", javaCmd);
        }
        String string36 = properties.getProperty("jvmflags");
        if (jvmflags != null && jvmflags.length() > 0) {
            if (string36 != null && string36.length() > 0) {
                suiteProperties.put("jvmflags", jvmflags + "^" + string36);
            } else {
                suiteProperties.put("jvmflags", jvmflags);
            }
        } else if (string36 != null && string36.length() > 0) {
            suiteProperties.put("jvmflags", string36);
        }
        String string37 = properties.getProperty("testJavaFlags");
        if (string37 != null) {
            testJavaFlags = testJavaFlags == null || testJavaFlags.length() == 0 ? string37 : testJavaFlags + "^" + string37;
            suiteProperties.put("testJavaFlags", testJavaFlags);
        }
        if ((string31 = properties.getProperty("testSpecialProps")) != null) {
            testSpecialProps = testSpecialProps == null || testSpecialProps.length() == 0 ? string31 : testSpecialProps + "^" + string31;
            suiteProperties.put("testSpecialProps", testSpecialProps);
        }
        String string38 = string30 = bl ? JVMInfo.getSystemModulePath() : properties.getProperty("classpath");
        if (string30 != null) {
            classpath = string30;
            suiteProperties.put("classpath", classpath);
        }
        if ((string29 = properties.getProperty("classpathServer")) != null && !string29.startsWith("${")) {
            classpathServer = string29;
            suiteProperties.put("classpathServer", string29);
        }
        if ((string28 = properties.getProperty("usesystem")) != null) {
            suiteProperties.put("usesystem", string28);
        }
        if ((string27 = properties.getProperty("jarfile")) != null) {
            suiteProperties.put("jarfile", string27);
        }
        if ((string26 = properties.getProperty("upgradetest")) != null) {
            suiteProperties.put("upgradetest", string26);
        }
        if ((string25 = properties.getProperty("replication")) != null) {
            suiteProperties.put("replication", string25);
        }
        if ((string24 = properties.getProperty("encryption")) != null) {
            suiteProperties.put("encryption", string24);
        }
        if ((string23 = properties.getProperty("testEncryptionAlgorithm")) != null) {
            suiteProperties.put("testEncryptionAlgorithm", string23);
        }
        if ((string22 = properties.getProperty("jdk12test")) != null) {
            suiteProperties.put("jdk12test", string22);
        }
        if ((string21 = properties.getProperty("jdk12exttest")) != null) {
            suiteProperties.put("jdk12exttest", string21);
        }
        if ((string20 = properties.getProperty("runwithibmjvm")) != null) {
            suiteProperties.put("runwithibmjvm", string20);
        }
        if ((string19 = properties.getProperty("excludeJCC")) != null) {
            suiteProperties.put("excludeJCC", string19);
        }
        if ((string18 = properties.getProperty("keepfiles")) != null) {
            suiteProperties.put("keepfiles", string18);
        }
        if ((string17 = properties.getProperty("outputdir")) != null) {
            outputdir = string17;
            suiteProperties.put("outputdir", outputdir);
        }
        if ((string16 = properties.getProperty("canondir")) != null) {
            canondir = string16;
            suiteProperties.put("canondir", canondir);
        }
        if ((string15 = properties.getProperty("bootcp")) != null) {
            bootcp = string15;
            suiteProperties.put("bootcp", bootcp);
        }
        if ((string14 = properties.getProperty("hostName")) != null) {
            suiteProperties.put("hostName", string14);
        }
        if ((string13 = properties.getProperty("serverJvm")) != null) {
            suiteProperties.put("serverJvm", string13);
        }
        if ((string12 = properties.getProperty("derbyTesting.encoding")) != null) {
            suiteProperties.put("derbyTesting.encoding", string12);
        }
        if ((string11 = properties.getProperty("derbyTesting.jar.path")) != null) {
            suiteProperties.put("derbyTesting.jar.path", string11);
        }
        if ((string10 = properties.getProperty("testoutname")) != null) {
            suiteProperties.put("testoutname", string10);
        }
        if ((string9 = properties.getProperty("mtestdir")) != null) {
            suiteProperties.put("mtestdir", string9);
        }
        if ((string8 = properties.getProperty("useprocess")) != null && (string8 = string8.toLowerCase()).equals("false")) {
            useprocess = false;
            suiteProperties.put("useprocess", string8);
        }
        if ((string7 = properties.getProperty("skipsed")) != null && (string7 = string7.toLowerCase()).equals("true")) {
            skipsed = true;
            suiteProperties.put("skipsed", string7);
        }
        if ((string6 = properties.getProperty("systemdiff")) != null && (string6 = string6.toLowerCase()).equals("true")) {
            suiteProperties.put("systemdiff", "true");
        }
        if ((string5 = properties.getProperty("ij.defaultResourcePackage")) != null) {
            suiteProperties.put("ij.defaultResourcePackage", string5);
        }
        if ((string4 = properties.getProperty("outcopy")) != null) {
            suiteProperties.put("outcopy", string4);
        }
        if ((string3 = properties.getProperty("suitename")) != null) {
            suiteProperties.put("suitename", string3);
        } else {
            suiteProperties.put("suitename", topSuiteName);
        }
        String string39 = properties.getProperty("verbose");
        if (string39 != null) {
            suiteProperties.put("verbose", string39);
        }
        if ((string2 = properties.getProperty("reportstderr")) != null) {
            suiteProperties.put("reportstderr", string2);
        }
        if ((string = properties.getProperty("timeout")) != null) {
            suiteProperties.put("timeout", string);
        }
    }

    private static void setOutput(String string) throws ClassNotFoundException, FileNotFoundException, IOException {
        File file;
        File file2;
        boolean bl = false;
        File file3 = outputdir == null || outputdir.length() == 0 ? new File(new File(userdir).getCanonicalPath()) : new File(new File(outputdir).getCanonicalPath());
        outDir = file3;
        outDir.mkdir();
        runDir = new File(new File(userdir).getCanonicalPath());
        suiteProperties.put("outputdir", outDir.getCanonicalPath());
        outFile = new File(outDir, string + ".sum");
        if (outFile.exists()) {
            bl = outFile.delete();
        }
        if ((file2 = new File(outDir, string + ".pass")).exists()) {
            bl = file2.delete();
        }
        if ((file = new File(outDir, string + ".fail")).exists()) {
            bl = file.delete();
        }
        pwOut = new PrintWriter((Writer)new BufferedWriter(new FileWriter(outFile.getPath()), 4096), true);
    }

    static {
        jvmName = "";
        javaCmd = "java";
        jvmflags = "";
        testJavaFlags = "";
        testSpecialProps = "";
        useprocess = true;
        skipsed = false;
        systemdiff = "false";
        topSuiteName = "";
        outcopy = "false";
        pwOut = null;
    }
}

