/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.math.BigInteger;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ArithmeticTest
extends BaseJDBCTestCase {
    private static final String BIGINT = "bigint";
    private static final String DECIMAL = "decimal(31,0)";

    public ArithmeticTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(ArithmeticTest.class);
    }

    public void testTypes() throws SQLException {
        String[] stringArray = new String[]{"smallint_r", "t", "bigint_r", "decimal_r"};
        String[] stringArray2 = new String[]{"smallint", "int", BIGINT, DECIMAL};
        BigInteger[][] bigIntegerArrayArray = new BigInteger[][]{{BigInteger.valueOf(-32768L), BigInteger.valueOf(32767L)}, {BigInteger.valueOf(Integer.MIN_VALUE), BigInteger.valueOf(Integer.MAX_VALUE)}, {BigInteger.valueOf(Long.MIN_VALUE), BigInteger.valueOf(Long.MAX_VALUE)}, {new BigInteger("-9999999999999999999999999999999", 10), new BigInteger("9999999999999999999999999999999", 10)}};
        for (int i = 0; i < stringArray2.length; ++i) {
            this.doBasically(stringArray[i], stringArray2[i]);
            this.doOverflow(stringArray[i], stringArray2[i], bigIntegerArrayArray[i][0], bigIntegerArrayArray[i][1]);
            this.dropTable(stringArray[i]);
        }
    }

    private void doBasically(String string, String string2) throws SQLException {
        String string3 = "create table " + string + "(i " + string2 + ", j " + string2 + ")";
        Statement statement = this.createStatement();
        statement.addBatch(string3);
        string3 = "insert into " + string + " values (null, null)";
        statement.addBatch(string3);
        string3 = "insert into " + string + " values (0, 100)";
        statement.addBatch(string3);
        string3 = "insert into " + string + " values (1, 101)";
        statement.addBatch(string3);
        string3 = "insert into " + string + " values (-2, -102)";
        statement.addBatch(string3);
        statement.executeBatch();
        string3 = "select * from " + string;
        String[][] stringArray = new String[][]{{null, null}, {"0", "100"}, {"1", "101"}, {"-2", "-102"}};
        JDBC.assertFullResultSet(statement.executeQuery(string3), stringArray);
        string3 = "select i + j from " + string;
        stringArray = new String[][]{{null}, {"100"}, {"102"}, {"-104"}};
        JDBC.assertFullResultSet(statement.executeQuery(string3), stringArray);
        string3 = "select i, i + 10 + 20, j, j + 100 + 200 from " + string;
        stringArray = new String[][]{{null, null, null, null}, {"0", "30", "100", "400"}, {"1", "31", "101", "401"}, {"-2", "28", "-102", "198"}};
        JDBC.assertFullResultSet(statement.executeQuery(string3), stringArray);
        string3 = "select i - j, j - i from " + string;
        stringArray = new String[][]{{null, null}, {"-100", "100"}, {"-100", "100"}, {"100", "-100"}};
        JDBC.assertFullResultSet(statement.executeQuery(string3), stringArray);
        string3 = "select i, i - 10 - 20, 20 - 10 - i, j, j - 100 - 200, 200 - 100 - j from " + string;
        stringArray = new String[][]{{null, null, null, null, null, null}, {"0", "-30", "10", "100", "-200", "0"}, {"1", "-29", "9", "101", "-199", "-1"}, {"-2", "-32", "12", "-102", "-402", "202"}};
        JDBC.assertFullResultSet(statement.executeQuery(string3), stringArray);
        string3 = "select i, j, i * j, j * i from " + string;
        stringArray = new String[][]{{null, null, null, null}, {"0", "100", "0", "0"}, {"1", "101", "101", "101"}, {"-2", "-102", "204", "204"}};
        JDBC.assertFullResultSet(statement.executeQuery(string3), stringArray);
        string3 = "select i, j, i * 10 * -20, j * 100 * -200 from " + string;
        stringArray = new String[][]{{null, null, null, null}, {"0", "100", "0", "-2000000"}, {"1", "101", "-200", "-2020000"}, {"-2", "-102", "400", "2040000"}};
        JDBC.assertFullResultSet(statement.executeQuery(string3), stringArray);
        string3 = "select -i, -j, -(i * 10 * -20), -(j * 100 * -200) from " + string;
        stringArray = new String[][]{{null, null, null, null}, {"0", "-100", "0", "2000000"}, {"-1", "-101", "200", "2020000"}, {"2", "102", "-400", "-2040000"}};
        JDBC.assertFullResultSet(statement.executeQuery(string3), stringArray);
        string3 = "select +i, +j, +(+i * +10 * -20), +(+j * +100 * -200) from " + string;
        stringArray = new String[][]{{null, null, null, null}, {"0", "100", "0", "-2000000"}, {"1", "101", "-200", "-2020000"}, {"-2", "-102", "400", "2040000"}};
        JDBC.assertFullResultSet(statement.executeQuery(string3), stringArray);
        string3 = "select i, j, i / j, 10 / j, j / 10 from " + string;
        stringArray = new String[][]{{null, null, null, null, null}, {"0", "100", "0", "0", "10"}, {"1", "101", "0", "0", "10"}, {"-2", "-102", "0", "0", "-10"}};
        if (string2.equals(DECIMAL)) {
            stringArray[1][3] = "0.100000000000000000000";
            stringArray[2][3] = "0.099009900990099009900";
            stringArray[3][3] = "-0.098039215686274509803";
        }
        JDBC.assertFullResultSet(statement.executeQuery(string3), stringArray);
        string3 = "select j / i from " + string;
        ArithmeticTest.assertStatementError("22012", statement, string3);
        string3 = "select (j - 1) / (i + 4), 20 / 5 / 4, 20 / 4 / 5 from " + string;
        stringArray = new String[][]{{null, "1", "1"}, {"24", "1", "1"}, {"20", "1", "1"}, {"-51", "1", "1"}};
        JDBC.assertFullResultSet(statement.executeQuery(string3), stringArray);
        string3 = "select j, j / (0 - j), (0 - j) / j, (0 - j) / (0 - j) from " + string;
        stringArray = new String[][]{{null, null, null, null}, {"100", "-1", "-1", "1"}, {"101", "-1", "-1", "1"}, {"-102", "-1", "-1", "1"}};
        JDBC.assertFullResultSet(statement.executeQuery(string3), stringArray);
        string3 = "select i, i + 10, i - (10 - 20), i - 10, i - (20 - 10) from " + string;
        stringArray = new String[][]{{null, null, null, null, null}, {"0", "10", "10", "-10", "-10"}, {"1", "11", "11", "-9", "-9"}, {"-2", "8", "8", "-12", "-12"}};
        JDBC.assertFullResultSet(statement.executeQuery(string3), stringArray);
        string3 = "select  'The next 2 columns should agree', 2 + 3 * 4 + 5, 2 + (3 * 4) + 5 from " + string;
        stringArray = new String[][]{{"The next 2 columns should agree", "19", "19"}, {"The next 2 columns should agree", "19", "19"}, {"The next 2 columns should agree", "19", "19"}, {"The next 2 columns should agree", "19", "19"}};
        JDBC.assertFullResultSet(statement.executeQuery(string3), stringArray);
        string3 = "select 'The next column should be 45', (2 + 3) * (4 + 5) from " + string;
        stringArray = new String[][]{{"The next column should be 45", "45"}, {"The next column should be 45", "45"}, {"The next column should be 45", "45"}, {"The next column should be 45", "45"}};
        JDBC.assertFullResultSet(statement.executeQuery(string3), stringArray);
    }

    private void doOverflow(String string, String string2, BigInteger bigInteger, BigInteger bigInteger2) throws SQLException {
        this.dropTable(string);
        String string3 = "create table " + string + " (i " + string2 + ", j " + string2 + ")";
        Statement statement = this.createStatement();
        statement.executeUpdate(string3);
        long l = 1L;
        string3 = "insert into " + string + " values (" + l + "," + bigInteger2 + ")";
        ArithmeticTest.assertUpdateCount(statement, 1, string3);
        string3 = "select i + j from " + string;
        ArithmeticTest.assertStatementError("22003", statement, string3);
        string3 = "select i - j - j from " + string;
        ArithmeticTest.assertStatementError("22003", statement, string3);
        string3 = "select j + j from " + string;
        ArithmeticTest.assertStatementError("22003", statement, string3);
        string3 = "select j * j from " + string;
        ArithmeticTest.assertStatementError("22003", statement, string3);
        string3 = "insert into " + string + " values (" + bigInteger + ", 0)";
        ArithmeticTest.assertUpdateCount(statement, 1, string3);
        boolean bl = bigInteger.negate().compareTo(bigInteger2) > 0;
        string3 = "select -i from " + string;
        if (bl) {
            ArithmeticTest.assertStatementError("22003", statement, string3);
        } else {
            JDBC.assertFullResultSet(statement.executeQuery(string3), new String[][]{{"-1"}, {bigInteger.negate().toString()}});
        }
        string3 = "select -j from " + string;
        JDBC.assertFullResultSet(statement.executeQuery(string3), new String[][]{{bigInteger2.negate().toString()}, {"0"}});
        string3 = "select j / 2 * 2 from " + string;
        JDBC.assertFullResultSet(statement.executeQuery(string3), new String[][]{{bigInteger2.subtract(BigInteger.ONE).toString()}, {"0"}});
        if (string2.equals(BIGINT) || string2.equals(DECIMAL)) {
            string3 = "select 2 * (" + bigInteger2 + " / 2 + 1) from " + string;
            ArithmeticTest.assertStatementError("22003", statement, string3);
            string3 = "select -2 * (" + bigInteger2 + " / 2 + 2) from " + string;
            ArithmeticTest.assertStatementError("22003", statement, string3);
            string3 = "select 2 * ((-" + bigInteger2 + " - 1) / 2 - 1) from " + string;
            ArithmeticTest.assertStatementError("22003", statement, string3);
            string3 = "select -2 * ((-" + bigInteger2 + " - 1) / 2 - 1) from " + string;
            ArithmeticTest.assertStatementError("22003", statement, string3);
            boolean bl2 = !bigInteger.testBit(0);
            string3 = "select i / 2 * 2 - 1 from " + string;
            if (bl2) {
                ArithmeticTest.assertStatementError("22003", statement, string3);
            } else {
                JDBC.assertFullResultSet(statement.executeQuery(string3), new String[][]{{"-1"}, {bigInteger.toString()}});
            }
            string3 = "select i / 2 * 2 - 2 from " + string;
            ArithmeticTest.assertStatementError("22003", statement, string3);
        }
    }

    private void doMixedTypeImpl(String string, String string2, BigInteger bigInteger) throws SQLException {
        String string3 = "create table " + string + " (y " + string2 + ")";
        Statement statement = this.createStatement();
        statement.executeUpdate(string3);
        BigInteger bigInteger2 = BigInteger.valueOf(2L);
        string3 = "insert into " + string + " values (" + bigInteger2 + ")";
        ArithmeticTest.assertEquals((int)1, (int)statement.executeUpdate(string3));
        string3 = "select " + bigInteger + " + y from " + string;
        JDBC.assertSingleValueResultSet(statement.executeQuery(string3), bigInteger.add(bigInteger2).toString());
        string3 = "select y + " + bigInteger + " from " + string;
        JDBC.assertSingleValueResultSet(statement.executeQuery(string3), bigInteger2.add(bigInteger).toString());
        string3 = "select y - " + bigInteger + " from " + string;
        JDBC.assertSingleValueResultSet(statement.executeQuery(string3), bigInteger2.subtract(bigInteger).toString());
        string3 = "select " + bigInteger + " - y from " + string;
        JDBC.assertSingleValueResultSet(statement.executeQuery(string3), bigInteger.subtract(bigInteger2).toString());
        string3 = "select " + bigInteger + " * y from " + string;
        JDBC.assertSingleValueResultSet(statement.executeQuery(string3), bigInteger.multiply(bigInteger2).toString());
        string3 = "select y * " + bigInteger + " from " + string;
        JDBC.assertSingleValueResultSet(statement.executeQuery(string3), bigInteger2.multiply(bigInteger).toString());
        string3 = "select " + bigInteger + " / y from " + string;
        String string4 = string2.equals(DECIMAL) ? ".000000000000" : "";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string3), bigInteger.divide(bigInteger2) + string4);
        string3 = "select y / " + bigInteger + " from " + string;
        JDBC.assertSingleValueResultSet(statement.executeQuery(string3), bigInteger2.divide(bigInteger).toString());
        statement.close();
    }

    public void testMixedType() throws SQLException {
        String[] stringArray = new String[]{"smallint", BIGINT, DECIMAL};
        String[] stringArray2 = new String[]{"smallint_r", "bigint_r", "decimal_r"};
        BigInteger[] bigIntegerArray = new BigInteger[]{BigInteger.valueOf(65535L), BigInteger.valueOf(Integer.MAX_VALUE), BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE)};
        for (int i = 0; i < stringArray.length; ++i) {
            this.doMixedTypeImpl(stringArray2[i], stringArray[i], bigIntegerArray[i]);
            this.dropTable(stringArray2[i]);
        }
    }

    public void testWrongType() throws SQLException {
        String string = "create table s (x char(10), y char(10))";
        Statement statement = this.createStatement();
        statement.executeUpdate(string);
        statement.close();
        string = "select x + y from s";
        this.assertCompileError("42Y95", string);
        string = "select x - y from s";
        this.assertCompileError("42Y95", string);
        string = "select x * y from s";
        this.assertCompileError("42Y95", string);
        string = "select x / y from s";
        this.assertCompileError("42Y95", string);
        string = "select -x from s";
        this.assertCompileError("42X37", string);
        this.dropTable("s");
    }

    public void testNumericDataType() throws SQLException {
        String string = "create table u (c1 int, c2 char(10))";
        Statement statement = this.createStatement();
        statement.addBatch(string);
        string = "insert into u (c2) values 'asdf'";
        statement.addBatch(string);
        string = "insert into u (c1) values null";
        statement.addBatch(string);
        string = "insert into u (c1) values 1";
        statement.addBatch(string);
        string = "insert into u (c1) values null";
        statement.addBatch(string);
        string = "insert into u (c1) values 2";
        statement.addBatch(string);
        statement.executeBatch();
        string = "select * from u";
        String[][] stringArray = new String[][]{{null, "asdf"}, {null, null}, {"1", null}, {null, null}, {"2", null}};
        JDBC.assertFullResultSet(statement.executeQuery(string), stringArray);
        string = "select c1 + c1 from u";
        stringArray = new String[][]{{null}, {null}, {"2"}, {null}, {"4"}};
        JDBC.assertFullResultSet(statement.executeQuery(string), stringArray);
        string = "select c1 / c1 from u";
        stringArray = new String[][]{{null}, {null}, {"1"}, {null}, {"1"}};
        JDBC.assertFullResultSet(statement.executeQuery(string), stringArray);
        string = "select c1 + c2 from u";
        ArithmeticTest.assertStatementError("22018", statement, string);
        statement.close();
        this.dropTable("u");
    }

    public void testPrecedenceAndAssociativity() throws SQLException {
        String string = "create table r (x int)";
        Statement statement = this.createStatement();
        statement.executeUpdate(string);
        string = "insert into r values (1)";
        ArithmeticTest.assertEquals((int)1, (int)statement.executeUpdate(string));
        string = "select 2 + 3 * 4 from r";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "14");
        string = "select (2 + 3) * 4 from r";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "20");
        string = "select 3 * 4 + 2 from r";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "14");
        string = "select 3 * (4 + 2) from r";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "18");
        string = "select 2 - 3 * 4 from r";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "-10");
        string = "select (2 - 3) * 4 from r";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "-4");
        string = "select  3 * 4 - 2 from r";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "10");
        string = "select 3 * (4 - 2) from r";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "6");
        string = "select 4 + 3 / 2 from r";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "5");
        string = "select (4 + 3) / 2 from r";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "3");
        string = "select 3 / 2 + 4 from r";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "5");
        string = "select 3 / (2 + 4) from r";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "0");
        string = "select 4 - 3 / 2 from r";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "3");
        string = "select (4 - 3) / 2 from r";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "0");
        string = "select 1 + 2147483647 - 2 from r";
        ArithmeticTest.assertStatementError("22003", statement, string);
        string = "select 1 + (2147483647 - 2) from r";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "2147483646");
        string = "select 4 * 3 / 2 from r";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "6");
        string = "select 4 * (3 / 2) from r";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "4");
        string = "select -1 + 2 from r";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "1");
        string = "select -(1 + 2) from r";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "-3");
        string = "select -1 - 2 from r";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "-3");
        string = "select -(1 - 2) from r";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "1");
        string = "select -1073741824 * 2 from r";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "-2147483648");
        string = "select -(1073741824 * 2) from r";
        ArithmeticTest.assertStatementError("22003", statement, string);
        string = "select -2147483648 / 2 from r";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "-1073741824");
        this.dropTable("r");
    }
}

