/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest;
import org.apache.derbyTesting.functionTests.tests.memorydb.MemoryDbManager;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LuceneInMemoryTest
extends GeneratedColumnsHelper {
    private static final String LOAD_TOOL = "call syscs_util.syscs_register_tool( 'luceneSupport', true )";
    private static final String UNLOAD_TOOL = "call syscs_util.syscs_register_tool( 'luceneSupport', false )";
    private static final String INDEX_POEMS = "call LuceneSupport.createIndex( 'app', 'poems', 'poemText', 'org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getEnglishAnalyzer' )";
    private static final String DROP_POEMS_INDEX = "call LuceneSupport.dropIndex( 'app', 'poems', 'poemText' )";
    private static final MemoryDbManager dbm = MemoryDbManager.getSharedInstance();

    public LuceneInMemoryTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("LuceneInMemoryTest");
        Test test = TestConfiguration.embeddedSuite(LuceneInMemoryTest.class);
        baseTestSuite.addTest(test);
        return baseTestSuite;
    }

    @Override
    public void tearDown() throws Exception {
        dbm.cleanUp();
        super.tearDown();
    }

    public void test_001_basic() throws Exception {
        Connection connection = dbm.createDatabase("luceneMemDB");
        LuceneCoarseAuthorizationTest.createSchema(connection);
        this.goodStatement(connection, LOAD_TOOL);
        this.goodStatement(connection, INDEX_POEMS);
        String string = "select p.originalAuthor, i.score\nfrom poems p, table ( poems__poemText( 'star', 1000, null ) ) i\nwhere p.poemID = i.poemID and p.versionStamp = i.versionStamp\norder by i.score desc\n";
        String[][] stringArray = new String[][]{{"Walt Whitman", "0.26756266"}, {"Lord Byron", "0.22933942"}, {"John Milton", "0.22933942"}};
        this.assertResults(connection, string, stringArray, false);
        String string2 = "select schemaName, tableName, columnName, indexDescriptorMaker from table( LuceneSupport.listIndexes() ) l";
        String[][] stringArray2 = new String[][]{{"APP", "POEMS", "POEMTEXT", "org.apache.derbyTesting.functionTests.tests.lang.LuceneCoarseAuthorizationTest.getEnglishAnalyzer"}};
        this.assertResults(connection, string2, stringArray2, false);
        this.goodStatement(connection, DROP_POEMS_INDEX);
        this.goodStatement(connection, UNLOAD_TOOL);
        LuceneCoarseAuthorizationTest.dropSchema(connection);
    }
}

