/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Enumeration;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;

public class NullableUniqueConstraintTest
extends BaseJDBCTestCase {
    public NullableUniqueConstraintTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("NullableUniqueConstraintTest");
        baseTestSuite.addTest(TestConfiguration.defaultSuite(NullableUniqueConstraintTest.class));
        return baseTestSuite;
    }

    protected void setUp() throws Exception {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table constraintest (val1 varchar (20), val2 varchar (20), val3 varchar (20), val4 varchar (20))");
    }

    @Override
    protected void tearDown() throws Exception {
        Connection connection = this.getConnection();
        connection.commit();
        Statement statement = connection.createStatement();
        statement.executeUpdate("drop table constraintest");
        statement.close();
        connection.commit();
        super.tearDown();
    }

    public void testSingleKeyPartUniqueConstraint() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("alter table constraintest add constraint u_con unique (val1)");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into constraintest (val1, val2) values (?, ?)");
        preparedStatement.setString(1, "test");
        preparedStatement.setString(2, "should pass");
        preparedStatement.execute();
        try {
            preparedStatement.setString(1, "test");
            preparedStatement.setString(2, "should fail");
            preparedStatement.execute();
            NullableUniqueConstraintTest.fail((String)"duplicate key inserted expected '23505'");
        }
        catch (SQLException sQLException) {
            NullableUniqueConstraintTest.assertSQLState("inserting duplicate", "23505", sQLException);
        }
        preparedStatement.setNull(1, 12);
        preparedStatement.setString(2, "should pass");
        preparedStatement.execute();
        preparedStatement.setNull(1, 12);
        preparedStatement.setString(2, "should pass");
        preparedStatement.execute();
        ResultSet resultSet = statement.executeQuery("select count (*) from constraintest where val1 is null");
        resultSet.next();
        NullableUniqueConstraintTest.assertEquals((String)"expected 2 rows", (int)2, (int)resultSet.getInt(1));
        statement.execute("alter table constraintest drop constraint u_con");
        statement.execute("delete from constraintest where val1 is null");
        connection.commit();
        preparedStatement.setString(1, "test");
        preparedStatement.setString(2, "removeit");
        preparedStatement.execute();
        try {
            statement.executeUpdate("alter table constraintest add constraint u_con unique (val1)");
            NullableUniqueConstraintTest.fail((String)"create unique constraint with duplicate key in table should fail");
        }
        catch (SQLException sQLException) {
            NullableUniqueConstraintTest.assertSQLState("creating unique constraint when duplicate keys are present  duplicate", "23505", sQLException);
        }
        statement.execute("delete from constraintest where val2 = 'removeit'");
        statement.executeUpdate("alter table constraintest add constraint u_con unique (val1)");
        connection.commit();
        statement.close();
        preparedStatement.close();
    }

    public void testDerby4677CompressTable() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("CREATE TABLE TABLE1(NAME1 INT UNIQUE, name2 int unique not null, name3 int primary key)");
        statement.execute("call syscs_util.syscs_compress_table('APP','TABLE1',1)");
        statement.executeUpdate("INSERT INTO TABLE1 VALUES(1,11,111)");
        NullableUniqueConstraintTest.assertStatementError("23505", statement, "INSERT INTO TABLE1 VALUES(1,22,222)");
        NullableUniqueConstraintTest.assertStatementError("23505", statement, "INSERT INTO TABLE1 VALUES(3,11,333)");
        NullableUniqueConstraintTest.assertStatementError("23505", statement, "INSERT INTO TABLE1 VALUES(4,44,111)");
        statement.executeUpdate("DROP TABLE TABLE1");
    }

    public void testMultipartKeyUniqueConstraint() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("alter table constraintest add constraint u_con unique (val1, val2, val3)");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into constraintest (val1, val2, val3, val4) values (?, ?, ?, ?)");
        preparedStatement.setString(1, "part1");
        preparedStatement.setString(2, "part2");
        preparedStatement.setString(3, "part3");
        preparedStatement.setString(4, "should pass");
        preparedStatement.execute();
        try {
            preparedStatement.setString(1, "part1");
            preparedStatement.setString(2, "part2");
            preparedStatement.setString(3, "part3");
            preparedStatement.setString(4, "should fail");
            preparedStatement.execute();
            NullableUniqueConstraintTest.fail((String)"duplicate key inserted expected '23505'");
        }
        catch (SQLException sQLException) {
            NullableUniqueConstraintTest.assertSQLState("inserting duplicate", "23505", sQLException);
        }
        preparedStatement.setNull(1, 12);
        preparedStatement.setString(2, "part2");
        preparedStatement.setString(3, "part3");
        preparedStatement.setString(4, "should pass");
        preparedStatement.execute();
        preparedStatement.setNull(1, 12);
        preparedStatement.setString(2, "part2");
        preparedStatement.setString(3, "part3");
        preparedStatement.setString(4, "should pass");
        preparedStatement.execute();
        preparedStatement.setString(1, "part1");
        preparedStatement.setNull(2, 12);
        preparedStatement.setString(3, "part3");
        preparedStatement.setString(4, "should pass");
        preparedStatement.execute();
        ResultSet resultSet = statement.executeQuery("select count (*) from constraintest where val1 is null");
        resultSet.next();
        NullableUniqueConstraintTest.assertEquals((String)"expected 2 rows", (int)2, (int)resultSet.getInt(1));
        statement.execute("alter table constraintest drop constraint u_con");
        connection.commit();
        preparedStatement.setString(1, "part1");
        preparedStatement.setString(2, "part2");
        preparedStatement.setString(3, "part3");
        preparedStatement.setString(4, "removeit");
        preparedStatement.execute();
        try {
            statement.executeUpdate("alter table constraintest add constraint u_con unique (val1, val2, val3)");
            NullableUniqueConstraintTest.fail((String)"create unique constraint with duplicate key in table should fail");
        }
        catch (SQLException sQLException) {
            NullableUniqueConstraintTest.assertSQLState("creating unique constraint when duplicate keys are present  duplicate", "23505", sQLException);
        }
        statement.execute("delete from constraintest where val4 = 'removeit'");
        statement.executeUpdate("alter table constraintest add constraint u_con unique (val1, val2, val3)");
        connection.commit();
        statement.close();
        preparedStatement.close();
    }

    public void testWithDeletedKey() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("alter table constraintest add constraint u_con unique (val1, val2, val3)");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into constraintest (val1, val2, val3, val4) values (?, ?, ?, ?)");
        preparedStatement.setString(1, "part1");
        preparedStatement.setString(2, "part2");
        preparedStatement.setString(3, "part3");
        preparedStatement.setString(4, "should pass");
        preparedStatement.execute();
        connection.setAutoCommit(false);
        statement.executeUpdate("delete from constraintest where val1 = 'part1' and val2 = 'part2' and val3 = 'part3'");
        preparedStatement.setString(1, "part1");
        preparedStatement.setString(2, "part2");
        preparedStatement.setString(3, "part3");
        preparedStatement.setString(4, "should pass");
        preparedStatement.execute();
        statement.close();
        preparedStatement.close();
        connection.commit();
    }

    public void testDistinctQuery() throws SQLException {
        int n;
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("alter table constraintest add constraint u_con unique (val1)");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into constraintest (val1) values (?)");
        for (n = 0; n < 5; ++n) {
            preparedStatement.setNull(1, 12);
            preparedStatement.executeUpdate();
        }
        for (n = 0; n < 5; ++n) {
            preparedStatement.setString(1, String.valueOf(n));
            preparedStatement.executeUpdate();
        }
        ResultSet resultSet = statement.executeQuery("select count (*) from constraintest");
        resultSet.next();
        NullableUniqueConstraintTest.assertEquals((int)10, (int)resultSet.getInt(1));
        resultSet.close();
        resultSet = statement.executeQuery("select count (distinct (val1)) from constraintest");
        resultSet.next();
        NullableUniqueConstraintTest.assertEquals((int)5, (int)resultSet.getInt(1));
        resultSet.close();
    }

    public void testNullOrdering() throws SQLException {
        int n;
        int n2;
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("alter table constraintest add constraint u_con unique (val1)");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into constraintest (val1) values (?)");
        for (n2 = 0; n2 < 5; ++n2) {
            preparedStatement.setNull(1, 12);
            preparedStatement.executeUpdate();
        }
        for (n2 = 0; n2 < 5; ++n2) {
            preparedStatement.setString(1, String.valueOf(n2));
            preparedStatement.executeUpdate();
        }
        ResultSet resultSet = statement.executeQuery("select val1 from constraintest order by val1 nulls last");
        for (n = 0; n < 5; ++n) {
            resultSet.next();
            NullableUniqueConstraintTest.assertEquals((String)String.valueOf(n), (String)resultSet.getString(1));
        }
        for (n = 0; n < 5; ++n) {
            resultSet.next();
            NullableUniqueConstraintTest.assertEquals(null, (String)resultSet.getString(1));
        }
        resultSet.close();
        resultSet = statement.executeQuery("select val1 from constraintest order by val1 nulls first");
        for (n = 0; n < 5; ++n) {
            resultSet.next();
            NullableUniqueConstraintTest.assertEquals(null, (String)resultSet.getString(1));
        }
        for (n = 0; n < 5; ++n) {
            resultSet.next();
            NullableUniqueConstraintTest.assertEquals((String)String.valueOf(n), (String)resultSet.getString(1));
        }
        resultSet.close();
    }

    public void testComparisonAcrossPages() throws SQLException {
        int n;
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("alter table constraintest add constraint u_con unique (val1)");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into constraintest (val1, val2) values (?, ?)");
        for (n = 0; n < 500; ++n) {
            preparedStatement.setString(1, "" + n);
            preparedStatement.setString(2, "" + n);
            preparedStatement.execute();
        }
        for (n = 0; n < 500; ++n) {
            preparedStatement.setString(1, "" + n);
            preparedStatement.setString(2, "" + n);
            try {
                preparedStatement.execute();
                NullableUniqueConstraintTest.fail((String)"duplicate key inserted expected '23505'");
                continue;
            }
            catch (SQLException sQLException) {
                NullableUniqueConstraintTest.assertSQLState("inserting duplicate", "23505", sQLException);
            }
        }
        connection.setAutoCommit(false);
        NullableUniqueConstraintTest.assertEquals((int)499, (int)statement.executeUpdate("delete from constraintest where val1 != '0'"));
        Savepoint savepoint = connection.setSavepoint("deleted");
        preparedStatement.setString(1, "0");
        preparedStatement.setString(2, "test");
        try {
            preparedStatement.execute();
            NullableUniqueConstraintTest.fail((String)"managed to insert a duplicate");
        }
        catch (SQLException sQLException) {
            NullableUniqueConstraintTest.assertSQLState("inserting duplicate", "23505", sQLException);
        }
        connection.rollback(savepoint);
        preparedStatement.setString(1, "250");
        preparedStatement.setString(2, "test");
        preparedStatement.execute();
        connection.rollback(savepoint);
        preparedStatement.setString(1, "499");
        preparedStatement.setString(2, "test");
        preparedStatement.execute();
        ResultSet resultSet = statement.executeQuery("select count (*) from constraintest");
        resultSet.next();
        NullableUniqueConstraintTest.assertEquals((int)2, (int)resultSet.getInt(1));
        connection.rollback();
        preparedStatement.close();
        statement.close();
        preparedStatement.close();
    }

    public void testDefferedInsert() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("alter table constraintest add constraint u_con unique (val1, val2)");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into constraintest (val1, val2) values (?, ?)");
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                preparedStatement.setString(1, String.valueOf(i));
                preparedStatement.setString(2, String.valueOf(j));
                preparedStatement.executeUpdate();
            }
        }
        NullableUniqueConstraintTest.assertEquals((String)"updating 25 records", (int)25, (int)statement.executeUpdate("update constraintest set val1 = val2, val2 = val1"));
    }

    public void testMixedInsertDelete() throws SQLException {
        this.createStatement().execute("alter table constraintest add constraint uc unique (val1)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into constraintest(val1) values ?");
        PreparedStatement preparedStatement2 = this.prepareStatement("delete from constraintest");
        for (int i = 0; i < 100; ++i) {
            for (int j = 0; j < 1000; ++j) {
                preparedStatement.setInt(1, j);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            NullableUniqueConstraintTest.assertEquals((int)1000, (int)preparedStatement2.executeUpdate());
        }
    }

    public void testDeletedDuplicateHidesDuplicateOnRightSide() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("alter table constraintest add constraint c unique(val1)");
        statement.execute("insert into constraintest(val1) values '1','2','3'");
        statement.execute("delete from constraintest where val1 = '2'");
        statement.execute("update constraintest set val1 = '2' where val1 = '3'");
        NullableUniqueConstraintTest.assertStatementError("23505", statement, "update constraintest set val1 = '2' where val1 = '1'");
    }

    public void testDeletedDuplicateHidesDuplicateOnLeftSide() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("alter table constraintest add constraint c unique(val1)");
        statement.execute("insert into constraintest(val1) values '1','2','3'");
        statement.execute("delete from constraintest where val1 = '2'");
        statement.execute("update constraintest set val1 = '2' where val1 = '1'");
        NullableUniqueConstraintTest.assertStatementError("23505", statement, "update constraintest set val1 = '2' where val1 = '3'");
    }

    public void testInsertDeleteContinuouslySameValue() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table d4081(x int unique)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into d4081 values 0");
        PreparedStatement preparedStatement2 = this.prepareStatement("delete from d4081");
        for (int i = 0; i < 500; ++i) {
            preparedStatement.execute();
            preparedStatement2.execute();
        }
        this.assertTableRowCount("D4081", 0);
    }

    public static void main(String[] stringArray) {
        TestResult testResult = new TestResult();
        Test test = NullableUniqueConstraintTest.suite();
        test.run(testResult);
        System.out.println(testResult.errorCount());
        Enumeration enumeration = testResult.failures();
        while (enumeration.hasMoreElements()) {
            ((TestFailure)enumeration.nextElement()).thrownException().printStackTrace();
        }
        System.out.println(testResult.failureCount());
    }
}

