/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.awt.geom.Point2D;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.XMLObj;
import org.apache.fop.fo.flow.AbstractGraphics;
import org.xml.sax.Locator;

public class InstreamForeignObject
extends AbstractGraphics {
    private Point2D intrinsicDimensions;

    public InstreamForeignObject(FONode parent) {
        super(parent);
    }

    protected void startOfNode() throws FOPException {
        this.checkId(this.getId());
    }

    protected void endOfNode() throws FOPException {
        if (this.childNodes == null || this.childNodes.size() != 1) {
            this.missingChildElementError("one (1) non-XSL namespace child");
        }
        this.getFOEventHandler().foreignObject(this);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(nsURI)) {
            this.invalidChildError(loc, nsURI, localName);
        } else if (this.childNodes != null) {
            this.tooManyNodesError(loc, "child element");
        }
    }

    public String getLocalName() {
        return "instream-foreign-object";
    }

    public int getNameId() {
        return 17;
    }

    private void prepareIntrinsicSize() {
        if (this.intrinsicDimensions == null) {
            XMLObj child = (XMLObj)this.childNodes.get(0);
            Point2D.Float csize = new Point2D.Float(-1.0f, -1.0f);
            this.intrinsicDimensions = child.getDimension(csize);
            if (this.intrinsicDimensions == null) {
                this.getLogger().error((Object)"Intrinsic dimensions of  instream-foreign-object could not be determined");
            }
        }
    }

    public int getIntrinsicWidth() {
        this.prepareIntrinsicSize();
        if (this.intrinsicDimensions != null) {
            return (int)(this.intrinsicDimensions.getX() * 1000.0);
        }
        return 0;
    }

    public int getIntrinsicHeight() {
        this.prepareIntrinsicSize();
        if (this.intrinsicDimensions != null) {
            return (int)(this.intrinsicDimensions.getY() * 1000.0);
        }
        return 0;
    }

    protected void addChildNode(FONode child) throws FOPException {
        super.addChildNode(child);
    }

    public XMLObj getChildXMLObj() {
        return (XMLObj)this.childNodes.get(0);
    }
}

